/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.lightsail.LightsailAsyncClient;
import software.amazon.awssdk.services.lightsail.LightsailServiceClientConfiguration;
import software.amazon.awssdk.services.lightsail.internal.LightsailServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.lightsail.model.AccessDeniedException;
import software.amazon.awssdk.services.lightsail.model.AccountSetupInProgressException;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.AttachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.AttachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest;
import software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse;
import software.amazon.awssdk.services.lightsail.model.CreateBucketRequest;
import software.amazon.awssdk.services.lightsail.model.CreateBucketResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContactMethodResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainResponse;
import software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContactMethodResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerImageResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.DetachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DetachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse;
import software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest;
import software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCostEstimateRequest;
import software.amazon.awssdk.services.lightsail.model.GetCostEstimateResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDisksRequest;
import software.amazon.awssdk.services.lightsail.model.GetDisksResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainsResponse;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRegionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRegionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse;
import software.amazon.awssdk.services.lightsail.model.GetSetupHistoryRequest;
import software.amazon.awssdk.services.lightsail.model.GetSetupHistoryResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.InvalidInputException;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse;
import software.amazon.awssdk.services.lightsail.model.LightsailException;
import software.amazon.awssdk.services.lightsail.model.NotFoundException;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.OperationFailureException;
import software.amazon.awssdk.services.lightsail.model.PeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.PeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.PutAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.PutAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest;
import software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest;
import software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse;
import software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest;
import software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationResponse;
import software.amazon.awssdk.services.lightsail.model.ServiceException;
import software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest;
import software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketResponse;
import software.amazon.awssdk.services.lightsail.model.SetupInstanceHttpsRequest;
import software.amazon.awssdk.services.lightsail.model.SetupInstanceHttpsResponse;
import software.amazon.awssdk.services.lightsail.model.StartGuiSessionRequest;
import software.amazon.awssdk.services.lightsail.model.StartGuiSessionResponse;
import software.amazon.awssdk.services.lightsail.model.StartInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StartInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.StopGuiSessionRequest;
import software.amazon.awssdk.services.lightsail.model.StopGuiSessionResponse;
import software.amazon.awssdk.services.lightsail.model.StopInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StopInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.TagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.TagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.TestAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.TestAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.UnauthenticatedException;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.UntagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.UntagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachCertificateToDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachInstancesToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateBucketAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateCloudFormationStackRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContactMethodRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceDeploymentRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceRegistryLoginRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateGuiSessionAccessDetailsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteAutoSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteBucketAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContactMethodRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContainerImageRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKnownHostKeysRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachCertificateFromDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DisableAddOnRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.EnableAddOnRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ExportSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetAlarmsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetAutoSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketAccessKeysRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCertificatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCloudFormationStackRecordsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContactMethodsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerApiMetadataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerImagesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerLogRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServiceDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServiceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServicePowersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServicesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCostEstimateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDisksRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionLatestCacheResetRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetExportSnapshotRecordsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerTlsCertificatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerTlsPoliciesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseEventsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseLogEventsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseLogStreamsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseMasterUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseParametersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabasesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetSetupHistoryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RegisterContainerImageRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ResetDistributionCacheRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SendContactMethodVerificationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SetIpAddressTypeRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SetResourceAccessForBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SetupInstanceHttpsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartGuiSessionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopGuiSessionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.TestAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateBucketBundleRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDistributionBundleRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateInstanceMetadataOptionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateLoadBalancerAttributeRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateRelationalDatabaseParametersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultLightsailAsyncClient
implements LightsailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLightsailAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLightsailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AllocateStaticIpResponse> allocateStaticIp(AllocateStaticIpRequest allocateStaticIpRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)allocateStaticIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, allocateStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AllocateStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AllocateStaticIpResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AllocateStaticIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AllocateStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)allocateStaticIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$allocateStaticIp$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$allocateStaticIp$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachCertificateToDistributionResponse> attachCertificateToDistribution(AttachCertificateToDistributionRequest attachCertificateToDistributionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachCertificateToDistributionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, attachCertificateToDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachCertificateToDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachCertificateToDistributionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachCertificateToDistribution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AttachCertificateToDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachCertificateToDistributionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$attachCertificateToDistribution$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$attachCertificateToDistribution$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachDiskResponse> attachDisk(AttachDiskRequest attachDiskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachDiskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, attachDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachDiskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachDisk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AttachDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachDiskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$attachDisk$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$attachDisk$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachInstancesToLoadBalancerResponse> attachInstancesToLoadBalancer(AttachInstancesToLoadBalancerRequest attachInstancesToLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachInstancesToLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, attachInstancesToLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachInstancesToLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachInstancesToLoadBalancerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachInstancesToLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AttachInstancesToLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachInstancesToLoadBalancerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$attachInstancesToLoadBalancer$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$attachInstancesToLoadBalancer$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachLoadBalancerTlsCertificateResponse> attachLoadBalancerTlsCertificate(AttachLoadBalancerTlsCertificateRequest attachLoadBalancerTlsCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachLoadBalancerTlsCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, attachLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachLoadBalancerTlsCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachLoadBalancerTlsCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerTlsCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AttachLoadBalancerTlsCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachLoadBalancerTlsCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$attachLoadBalancerTlsCertificate$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$attachLoadBalancerTlsCertificate$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachStaticIpResponse> attachStaticIp(AttachStaticIpRequest attachStaticIpRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachStaticIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, attachStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachStaticIpResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachStaticIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AttachStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachStaticIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$attachStaticIp$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$attachStaticIp$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CloseInstancePublicPortsResponse> closeInstancePublicPorts(CloseInstancePublicPortsRequest closeInstancePublicPortsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)closeInstancePublicPortsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, closeInstancePublicPortsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CloseInstancePublicPorts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CloseInstancePublicPortsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CloseInstancePublicPorts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CloseInstancePublicPortsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)closeInstancePublicPortsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$closeInstancePublicPorts$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$closeInstancePublicPorts$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copySnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, copySnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopySnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopySnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopySnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CopySnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)copySnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$copySnapshot$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$copySnapshot$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBucketResponse> createBucket(CreateBucketRequest createBucketRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBucket");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBucketResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBucketRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createBucket$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createBucket$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBucketAccessKeyResponse> createBucketAccessKey(CreateBucketAccessKeyRequest createBucketAccessKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBucketAccessKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createBucketAccessKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBucketAccessKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBucketAccessKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucketAccessKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateBucketAccessKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBucketAccessKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createBucketAccessKey$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createBucketAccessKey$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCertificateResponse> createCertificate(CreateCertificateRequest createCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createCertificate$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createCertificate$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCloudFormationStackResponse> createCloudFormationStack(CreateCloudFormationStackRequest createCloudFormationStackRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCloudFormationStackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createCloudFormationStackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCloudFormationStack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCloudFormationStackResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCloudFormationStack").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCloudFormationStackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCloudFormationStackRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createCloudFormationStack$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createCloudFormationStack$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateContactMethodResponse> createContactMethod(CreateContactMethodRequest createContactMethodRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createContactMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createContactMethodRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContactMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContactMethodResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContactMethod").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateContactMethodRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createContactMethodRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createContactMethod$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createContactMethod$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateContainerServiceResponse> createContainerService(CreateContainerServiceRequest createContainerServiceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createContainerServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createContainerServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContainerService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContainerServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContainerService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateContainerServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createContainerServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createContainerService$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createContainerService$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateContainerServiceDeploymentResponse> createContainerServiceDeployment(CreateContainerServiceDeploymentRequest createContainerServiceDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createContainerServiceDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createContainerServiceDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContainerServiceDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContainerServiceDeploymentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContainerServiceDeployment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateContainerServiceDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createContainerServiceDeploymentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createContainerServiceDeployment$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createContainerServiceDeployment$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateContainerServiceRegistryLoginResponse> createContainerServiceRegistryLogin(CreateContainerServiceRegistryLoginRequest createContainerServiceRegistryLoginRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createContainerServiceRegistryLoginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createContainerServiceRegistryLoginRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContainerServiceRegistryLogin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContainerServiceRegistryLoginResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContainerServiceRegistryLogin").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateContainerServiceRegistryLoginRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createContainerServiceRegistryLoginRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createContainerServiceRegistryLogin$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createContainerServiceRegistryLogin$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDiskResponse> createDisk(CreateDiskRequest createDiskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDiskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDiskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDisk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDiskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDisk$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDisk$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDiskFromSnapshotResponse> createDiskFromSnapshot(CreateDiskFromSnapshotRequest createDiskFromSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDiskFromSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createDiskFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDiskFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDiskFromSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDiskFromSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDiskFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDiskFromSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDiskFromSnapshot$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDiskFromSnapshot$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDiskSnapshotResponse> createDiskSnapshot(CreateDiskSnapshotRequest createDiskSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDiskSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createDiskSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDiskSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDiskSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDiskSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDiskSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDiskSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDiskSnapshot$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDiskSnapshot$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDistributionResponse> createDistribution(CreateDistributionRequest createDistributionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDistributionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDistributionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistribution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDistributionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDistribution$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDistribution$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDomain$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDomain$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDomainEntryResponse> createDomainEntry(CreateDomainEntryRequest createDomainEntryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDomainEntryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createDomainEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomainEntry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainEntryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomainEntry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDomainEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDomainEntryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDomainEntry$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDomainEntry$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateGuiSessionAccessDetailsResponse> createGUISessionAccessDetails(CreateGuiSessionAccessDetailsRequest createGuiSessionAccessDetailsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGuiSessionAccessDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createGuiSessionAccessDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGUISessionAccessDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGuiSessionAccessDetailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGUISessionAccessDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateGuiSessionAccessDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createGuiSessionAccessDetailsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createGUISessionAccessDetails$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createGUISessionAccessDetails$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInstanceSnapshotResponse> createInstanceSnapshot(CreateInstanceSnapshotRequest createInstanceSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInstanceSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createInstanceSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInstanceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstanceSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstanceSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateInstanceSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createInstanceSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createInstanceSnapshot$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createInstanceSnapshot$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInstancesResponse> createInstances(CreateInstancesRequest createInstancesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createInstances$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createInstances$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInstancesFromSnapshotResponse> createInstancesFromSnapshot(CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInstancesFromSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createInstancesFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInstancesFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstancesFromSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstancesFromSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateInstancesFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createInstancesFromSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createInstancesFromSnapshot$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createInstancesFromSnapshot$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKeyPairResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createKeyPair$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createKeyPair$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLoadBalancerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLoadBalancerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createLoadBalancer$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createLoadBalancer$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerTlsCertificateResponse> createLoadBalancerTlsCertificate(CreateLoadBalancerTlsCertificateRequest createLoadBalancerTlsCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLoadBalancerTlsCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancerTlsCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLoadBalancerTlsCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerTlsCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLoadBalancerTlsCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLoadBalancerTlsCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createLoadBalancerTlsCertificate$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createLoadBalancerTlsCertificate$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRelationalDatabaseResponse> createRelationalDatabase(CreateRelationalDatabaseRequest createRelationalDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRelationalDatabaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createRelationalDatabase$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createRelationalDatabase$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRelationalDatabaseFromSnapshotResponse> createRelationalDatabaseFromSnapshot(CreateRelationalDatabaseFromSnapshotRequest createRelationalDatabaseFromSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRelationalDatabaseFromSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createRelationalDatabaseFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRelationalDatabaseFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRelationalDatabaseFromSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRelationalDatabaseFromSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRelationalDatabaseFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRelationalDatabaseFromSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createRelationalDatabaseFromSnapshot$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createRelationalDatabaseFromSnapshot$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRelationalDatabaseSnapshotResponse> createRelationalDatabaseSnapshot(CreateRelationalDatabaseSnapshotRequest createRelationalDatabaseSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRelationalDatabaseSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, createRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRelationalDatabaseSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRelationalDatabaseSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRelationalDatabaseSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRelationalDatabaseSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRelationalDatabaseSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createRelationalDatabaseSnapshot$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createRelationalDatabaseSnapshot$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAlarmResponse> deleteAlarm(DeleteAlarmRequest deleteAlarmRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAlarmResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAlarmRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteAlarm$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteAlarm$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAutoSnapshotResponse> deleteAutoSnapshot(DeleteAutoSnapshotRequest deleteAutoSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAutoSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAutoSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAutoSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAutoSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAutoSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAutoSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAutoSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteAutoSnapshot$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteAutoSnapshot$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketResponse> deleteBucket(DeleteBucketRequest deleteBucketRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucket");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBucketResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBucketRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteBucket$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteBucket$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketAccessKeyResponse> deleteBucketAccessKey(DeleteBucketAccessKeyRequest deleteBucketAccessKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBucketAccessKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteBucketAccessKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketAccessKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBucketAccessKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketAccessKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBucketAccessKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBucketAccessKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteBucketAccessKey$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteBucketAccessKey$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteCertificate$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteCertificate$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteContactMethodResponse> deleteContactMethod(DeleteContactMethodRequest deleteContactMethodRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteContactMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteContactMethodRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContactMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContactMethodResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContactMethod").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteContactMethodRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteContactMethodRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteContactMethod$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteContactMethod$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteContainerImageResponse> deleteContainerImage(DeleteContainerImageRequest deleteContainerImageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteContainerImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteContainerImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContainerImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContainerImageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContainerImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteContainerImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteContainerImageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteContainerImage$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteContainerImage$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteContainerServiceResponse> deleteContainerService(DeleteContainerServiceRequest deleteContainerServiceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteContainerServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteContainerServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContainerService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContainerServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContainerService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteContainerServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteContainerServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteContainerService$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteContainerService$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDiskResponse> deleteDisk(DeleteDiskRequest deleteDiskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDiskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDiskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDisk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDiskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteDisk$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteDisk$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDiskSnapshotResponse> deleteDiskSnapshot(DeleteDiskSnapshotRequest deleteDiskSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDiskSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDiskSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDiskSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDiskSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDiskSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDiskSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDiskSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteDiskSnapshot$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteDiskSnapshot$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDistributionResponse> deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDistributionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDistributionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDistribution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDistributionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteDistribution$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteDistribution$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteDomain$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteDomain$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDomainEntryResponse> deleteDomainEntry(DeleteDomainEntryRequest deleteDomainEntryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDomainEntryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDomainEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomainEntry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainEntryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomainEntry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDomainEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDomainEntryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteDomainEntry$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteDomainEntry$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteInstance$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteInstance$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteInstanceSnapshotResponse> deleteInstanceSnapshot(DeleteInstanceSnapshotRequest deleteInstanceSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInstanceSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteInstanceSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInstanceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInstanceSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInstanceSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteInstanceSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteInstanceSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteInstanceSnapshot$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteInstanceSnapshot$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKeyPairResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteKeyPair$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteKeyPair$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteKnownHostKeysResponse> deleteKnownHostKeys(DeleteKnownHostKeysRequest deleteKnownHostKeysRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteKnownHostKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteKnownHostKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKnownHostKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKnownHostKeysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKnownHostKeys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteKnownHostKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteKnownHostKeysRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteKnownHostKeys$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteKnownHostKeys$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLoadBalancerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLoadBalancerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteLoadBalancer$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteLoadBalancer$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerTlsCertificateResponse> deleteLoadBalancerTlsCertificate(DeleteLoadBalancerTlsCertificateRequest deleteLoadBalancerTlsCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLoadBalancerTlsCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancerTlsCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLoadBalancerTlsCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerTlsCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLoadBalancerTlsCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLoadBalancerTlsCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteLoadBalancerTlsCertificate$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteLoadBalancerTlsCertificate$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRelationalDatabaseResponse> deleteRelationalDatabase(DeleteRelationalDatabaseRequest deleteRelationalDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRelationalDatabaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteRelationalDatabase$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteRelationalDatabase$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRelationalDatabaseSnapshotResponse> deleteRelationalDatabaseSnapshot(DeleteRelationalDatabaseSnapshotRequest deleteRelationalDatabaseSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRelationalDatabaseSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRelationalDatabaseSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRelationalDatabaseSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRelationalDatabaseSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRelationalDatabaseSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRelationalDatabaseSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteRelationalDatabaseSnapshot$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteRelationalDatabaseSnapshot$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachCertificateFromDistributionResponse> detachCertificateFromDistribution(DetachCertificateFromDistributionRequest detachCertificateFromDistributionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachCertificateFromDistributionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, detachCertificateFromDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachCertificateFromDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachCertificateFromDistributionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachCertificateFromDistribution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetachCertificateFromDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachCertificateFromDistributionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$detachCertificateFromDistribution$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$detachCertificateFromDistribution$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachDiskResponse> detachDisk(DetachDiskRequest detachDiskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachDiskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, detachDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachDiskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachDisk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetachDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachDiskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$detachDisk$218(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$detachDisk$219((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachInstancesFromLoadBalancerResponse> detachInstancesFromLoadBalancer(DetachInstancesFromLoadBalancerRequest detachInstancesFromLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachInstancesFromLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, detachInstancesFromLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachInstancesFromLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachInstancesFromLoadBalancerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachInstancesFromLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetachInstancesFromLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachInstancesFromLoadBalancerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$detachInstancesFromLoadBalancer$222(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$detachInstancesFromLoadBalancer$223((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachStaticIpResponse> detachStaticIp(DetachStaticIpRequest detachStaticIpRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachStaticIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, detachStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachStaticIpResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachStaticIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetachStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachStaticIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$detachStaticIp$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$detachStaticIp$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableAddOnResponse> disableAddOn(DisableAddOnRequest disableAddOnRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableAddOnRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, disableAddOnRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableAddOn");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableAddOnResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAddOn").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableAddOnRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableAddOnRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$disableAddOn$230(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$disableAddOn$231((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DownloadDefaultKeyPairResponse> downloadDefaultKeyPair(DownloadDefaultKeyPairRequest downloadDefaultKeyPairRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)downloadDefaultKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, downloadDefaultKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DownloadDefaultKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DownloadDefaultKeyPairResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DownloadDefaultKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DownloadDefaultKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)downloadDefaultKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$downloadDefaultKeyPair$234(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$downloadDefaultKeyPair$235((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableAddOnResponse> enableAddOn(EnableAddOnRequest enableAddOnRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableAddOnRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, enableAddOnRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableAddOn");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableAddOnResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAddOn").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableAddOnRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableAddOnRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$enableAddOn$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$enableAddOn$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExportSnapshotResponse> exportSnapshot(ExportSnapshotRequest exportSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)exportSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, exportSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ExportSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)exportSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$exportSnapshot$242(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$exportSnapshot$243((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetActiveNamesResponse> getActiveNames(GetActiveNamesRequest getActiveNamesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getActiveNamesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getActiveNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetActiveNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetActiveNamesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetActiveNames").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetActiveNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getActiveNamesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getActiveNames$246(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getActiveNames$247((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAlarmsResponse> getAlarms(GetAlarmsRequest getAlarmsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAlarmsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getAlarmsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAlarms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAlarmsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAlarms").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAlarmsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAlarmsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getAlarms$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getAlarms$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAutoSnapshotsResponse> getAutoSnapshots(GetAutoSnapshotsRequest getAutoSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAutoSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getAutoSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAutoSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAutoSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAutoSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAutoSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAutoSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getAutoSnapshots$254(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getAutoSnapshots$255((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBlueprintsResponse> getBlueprints(GetBlueprintsRequest getBlueprintsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBlueprintsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getBlueprintsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBlueprints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlueprintsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlueprints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBlueprintsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBlueprintsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBlueprints$258(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBlueprints$259((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketAccessKeysResponse> getBucketAccessKeys(GetBucketAccessKeysRequest getBucketAccessKeysRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketAccessKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getBucketAccessKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketAccessKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketAccessKeysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAccessKeys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBucketAccessKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBucketAccessKeysRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBucketAccessKeys$262(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBucketAccessKeys$263((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketBundlesResponse> getBucketBundles(GetBucketBundlesRequest getBucketBundlesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketBundlesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getBucketBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketBundlesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketBundles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBucketBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBucketBundlesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBucketBundles$266(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBucketBundles$267((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketMetricDataResponse> getBucketMetricData(GetBucketMetricDataRequest getBucketMetricDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getBucketMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketMetricDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBucketMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBucketMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBucketMetricData$270(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBucketMetricData$271((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketsResponse> getBuckets(GetBucketsRequest getBucketsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getBucketsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBuckets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBuckets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBucketsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBucketsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBuckets$274(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBuckets$275((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBundlesResponse> getBundles(GetBundlesRequest getBundlesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBundlesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBundlesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBundles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBundlesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBundles$278(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBundles$279((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCertificatesResponse> getCertificates(GetCertificatesRequest getCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCertificatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCertificatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getCertificates$282(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getCertificates$283((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCloudFormationStackRecordsResponse> getCloudFormationStackRecords(GetCloudFormationStackRecordsRequest getCloudFormationStackRecordsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCloudFormationStackRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getCloudFormationStackRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudFormationStackRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCloudFormationStackRecordsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFormationStackRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCloudFormationStackRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCloudFormationStackRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getCloudFormationStackRecords$286(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getCloudFormationStackRecords$287((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContactMethodsResponse> getContactMethods(GetContactMethodsRequest getContactMethodsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContactMethodsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getContactMethodsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContactMethods");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContactMethodsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContactMethods").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetContactMethodsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContactMethodsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContactMethods$290(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContactMethods$291((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerApiMetadataResponse> getContainerAPIMetadata(GetContainerApiMetadataRequest getContainerApiMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerApiMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getContainerApiMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerAPIMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerApiMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerAPIMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetContainerApiMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerApiMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerAPIMetadata$294(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerAPIMetadata$295((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerImagesResponse> getContainerImages(GetContainerImagesRequest getContainerImagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerImagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getContainerImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerImagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerImages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetContainerImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerImagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerImages$298(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerImages$299((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerLogResponse> getContainerLog(GetContainerLogRequest getContainerLogRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerLogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getContainerLogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerLog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerLogResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerLog").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetContainerLogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerLogRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerLog$302(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerLog$303((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerServiceDeploymentsResponse> getContainerServiceDeployments(GetContainerServiceDeploymentsRequest getContainerServiceDeploymentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerServiceDeploymentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getContainerServiceDeploymentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServiceDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServiceDeploymentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServiceDeployments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetContainerServiceDeploymentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerServiceDeploymentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerServiceDeployments$306(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerServiceDeployments$307((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerServiceMetricDataResponse> getContainerServiceMetricData(GetContainerServiceMetricDataRequest getContainerServiceMetricDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerServiceMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getContainerServiceMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServiceMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServiceMetricDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServiceMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetContainerServiceMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerServiceMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerServiceMetricData$310(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerServiceMetricData$311((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerServicePowersResponse> getContainerServicePowers(GetContainerServicePowersRequest getContainerServicePowersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerServicePowersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getContainerServicePowersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServicePowers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServicePowersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServicePowers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetContainerServicePowersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerServicePowersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerServicePowers$314(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerServicePowers$315((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerServicesResponse> getContainerServices(GetContainerServicesRequest getContainerServicesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getContainerServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServicesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetContainerServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerServicesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerServices$318(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerServices$319((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCostEstimateResponse> getCostEstimate(GetCostEstimateRequest getCostEstimateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostEstimateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getCostEstimateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostEstimate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostEstimateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostEstimate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCostEstimateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCostEstimateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getCostEstimate$322(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getCostEstimate$323((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDiskResponse> getDisk(GetDiskRequest getDiskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDiskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDisk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDiskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDisk$326(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDisk$327((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDiskSnapshotResponse> getDiskSnapshot(GetDiskSnapshotRequest getDiskSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDiskSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getDiskSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDiskSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiskSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDiskSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDiskSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDiskSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDiskSnapshot$330(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDiskSnapshot$331((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDiskSnapshotsResponse> getDiskSnapshots(GetDiskSnapshotsRequest getDiskSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDiskSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getDiskSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDiskSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiskSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDiskSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDiskSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDiskSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDiskSnapshots$334(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDiskSnapshots$335((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDisksResponse> getDisks(GetDisksRequest getDisksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDisksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getDisksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDisks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDisksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDisks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDisksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDisksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDisks$338(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDisks$339((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionBundlesResponse> getDistributionBundles(GetDistributionBundlesRequest getDistributionBundlesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDistributionBundlesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getDistributionBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionBundlesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionBundles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDistributionBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionBundlesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDistributionBundles$342(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDistributionBundles$343((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionLatestCacheResetResponse> getDistributionLatestCacheReset(GetDistributionLatestCacheResetRequest getDistributionLatestCacheResetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDistributionLatestCacheResetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getDistributionLatestCacheResetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionLatestCacheReset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionLatestCacheResetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionLatestCacheReset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDistributionLatestCacheResetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionLatestCacheResetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDistributionLatestCacheReset$346(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDistributionLatestCacheReset$347((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionMetricDataResponse> getDistributionMetricData(GetDistributionMetricDataRequest getDistributionMetricDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDistributionMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getDistributionMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionMetricDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDistributionMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDistributionMetricData$350(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDistributionMetricData$351((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionsResponse> getDistributions(GetDistributionsRequest getDistributionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDistributionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getDistributionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDistributionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDistributions$354(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDistributions$355((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDomainResponse> getDomain(GetDomainRequest getDomainRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDomain$358(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDomain$359((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDomainsResponse> getDomains(GetDomainsRequest getDomainsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getDomainsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomains").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDomainsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDomains$362(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDomains$363((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetExportSnapshotRecordsResponse> getExportSnapshotRecords(GetExportSnapshotRecordsRequest getExportSnapshotRecordsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExportSnapshotRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getExportSnapshotRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExportSnapshotRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExportSnapshotRecordsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExportSnapshotRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetExportSnapshotRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getExportSnapshotRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getExportSnapshotRecords$366(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getExportSnapshotRecords$367((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceResponse> getInstance(GetInstanceRequest getInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstance$370(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstance$371((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceAccessDetailsResponse> getInstanceAccessDetails(GetInstanceAccessDetailsRequest getInstanceAccessDetailsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceAccessDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getInstanceAccessDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceAccessDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceAccessDetailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceAccessDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInstanceAccessDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceAccessDetailsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstanceAccessDetails$374(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstanceAccessDetails$375((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceMetricDataResponse> getInstanceMetricData(GetInstanceMetricDataRequest getInstanceMetricDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getInstanceMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceMetricDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInstanceMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstanceMetricData$378(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstanceMetricData$379((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstancePortStatesResponse> getInstancePortStates(GetInstancePortStatesRequest getInstancePortStatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstancePortStatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getInstancePortStatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstancePortStates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstancePortStatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstancePortStates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInstancePortStatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstancePortStatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstancePortStates$382(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstancePortStates$383((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceSnapshotResponse> getInstanceSnapshot(GetInstanceSnapshotRequest getInstanceSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getInstanceSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInstanceSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstanceSnapshot$386(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstanceSnapshot$387((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceSnapshotsResponse> getInstanceSnapshots(GetInstanceSnapshotsRequest getInstanceSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getInstanceSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInstanceSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstanceSnapshots$390(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstanceSnapshots$391((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceStateResponse> getInstanceState(GetInstanceStateRequest getInstanceStateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getInstanceStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceStateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInstanceStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstanceState$394(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstanceState$395((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstancesResponse> getInstances(GetInstancesRequest getInstancesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstances$398(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstances$399((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetKeyPairResponse> getKeyPair(GetKeyPairRequest getKeyPairRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyPairResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getKeyPair$402(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getKeyPair$403((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetKeyPairsResponse> getKeyPairs(GetKeyPairsRequest getKeyPairsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getKeyPairsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getKeyPairsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyPairs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyPairsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyPairs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetKeyPairsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getKeyPairsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getKeyPairs$406(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getKeyPairs$407((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoadBalancerResponse> getLoadBalancer(GetLoadBalancerRequest getLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoadBalancerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getLoadBalancer$410(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getLoadBalancer$411((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoadBalancerMetricDataResponse> getLoadBalancerMetricData(GetLoadBalancerMetricDataRequest getLoadBalancerMetricDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoadBalancerMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getLoadBalancerMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancerMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerMetricDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancerMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLoadBalancerMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoadBalancerMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getLoadBalancerMetricData$414(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getLoadBalancerMetricData$415((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoadBalancerTlsCertificatesResponse> getLoadBalancerTlsCertificates(GetLoadBalancerTlsCertificatesRequest getLoadBalancerTlsCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoadBalancerTlsCertificatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getLoadBalancerTlsCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancerTlsCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerTlsCertificatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancerTlsCertificates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLoadBalancerTlsCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoadBalancerTlsCertificatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getLoadBalancerTlsCertificates$418(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getLoadBalancerTlsCertificates$419((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoadBalancerTlsPoliciesResponse> getLoadBalancerTlsPolicies(GetLoadBalancerTlsPoliciesRequest getLoadBalancerTlsPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoadBalancerTlsPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getLoadBalancerTlsPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancerTlsPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerTlsPoliciesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancerTlsPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLoadBalancerTlsPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoadBalancerTlsPoliciesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getLoadBalancerTlsPolicies$422(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getLoadBalancerTlsPolicies$423((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoadBalancersResponse> getLoadBalancers(GetLoadBalancersRequest getLoadBalancersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoadBalancersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getLoadBalancersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLoadBalancersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoadBalancersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getLoadBalancers$426(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getLoadBalancers$427((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOperationResponse> getOperation(GetOperationRequest getOperationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOperationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetOperationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOperationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getOperation$430(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getOperation$431((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOperationsResponse> getOperations(GetOperationsRequest getOperationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOperationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOperationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getOperations$434(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getOperations$435((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOperationsForResourceResponse> getOperationsForResource(GetOperationsForResourceRequest getOperationsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOperationsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getOperationsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperationsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperationsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetOperationsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOperationsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getOperationsForResource$438(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getOperationsForResource$439((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRegionsResponse> getRegions(GetRegionsRequest getRegionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRegionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRegionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRegions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRegionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRegions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRegionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRegionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRegions$442(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRegions$443((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseResponse> getRelationalDatabase(GetRelationalDatabaseRequest getRelationalDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabase$446(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabase$447((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseBlueprintsResponse> getRelationalDatabaseBlueprints(GetRelationalDatabaseBlueprintsRequest getRelationalDatabaseBlueprintsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseBlueprintsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseBlueprintsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseBlueprints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseBlueprintsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseBlueprints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseBlueprintsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseBlueprintsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseBlueprints$450(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseBlueprints$451((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseBundlesResponse> getRelationalDatabaseBundles(GetRelationalDatabaseBundlesRequest getRelationalDatabaseBundlesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseBundlesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseBundlesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseBundles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseBundlesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseBundles$454(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseBundles$455((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseEventsResponse> getRelationalDatabaseEvents(GetRelationalDatabaseEventsRequest getRelationalDatabaseEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseEvents$458(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseEvents$459((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseLogEventsResponse> getRelationalDatabaseLogEvents(GetRelationalDatabaseLogEventsRequest getRelationalDatabaseLogEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseLogEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseLogEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseLogEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseLogEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseLogEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseLogEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseLogEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseLogEvents$462(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseLogEvents$463((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseLogStreamsResponse> getRelationalDatabaseLogStreams(GetRelationalDatabaseLogStreamsRequest getRelationalDatabaseLogStreamsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseLogStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseLogStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseLogStreams");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseLogStreamsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseLogStreams").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseLogStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseLogStreamsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseLogStreams$466(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseLogStreams$467((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseMasterUserPasswordResponse> getRelationalDatabaseMasterUserPassword(GetRelationalDatabaseMasterUserPasswordRequest getRelationalDatabaseMasterUserPasswordRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseMasterUserPasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseMasterUserPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseMasterUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseMasterUserPasswordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseMasterUserPassword").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseMasterUserPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseMasterUserPasswordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseMasterUserPassword$470(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseMasterUserPassword$471((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseMetricDataResponse> getRelationalDatabaseMetricData(GetRelationalDatabaseMetricDataRequest getRelationalDatabaseMetricDataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseMetricDataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseMetricData$474(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseMetricData$475((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseParametersResponse> getRelationalDatabaseParameters(GetRelationalDatabaseParametersRequest getRelationalDatabaseParametersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseParametersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseParametersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseParameters$478(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseParameters$479((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseSnapshotResponse> getRelationalDatabaseSnapshot(GetRelationalDatabaseSnapshotRequest getRelationalDatabaseSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseSnapshot$482(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseSnapshot$483((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseSnapshotsResponse> getRelationalDatabaseSnapshots(GetRelationalDatabaseSnapshotsRequest getRelationalDatabaseSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabaseSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseSnapshots$486(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseSnapshots$487((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabasesResponse> getRelationalDatabases(GetRelationalDatabasesRequest getRelationalDatabasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRelationalDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabases$490(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabases$491((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSetupHistoryResponse> getSetupHistory(GetSetupHistoryRequest getSetupHistoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSetupHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getSetupHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSetupHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSetupHistoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSetupHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSetupHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSetupHistoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getSetupHistory$494(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getSetupHistory$495((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStaticIpResponse> getStaticIp(GetStaticIpRequest getStaticIpRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getStaticIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStaticIpResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStaticIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStaticIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getStaticIp$498(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getStaticIp$499((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStaticIpsResponse> getStaticIps(GetStaticIpsRequest getStaticIpsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getStaticIpsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, getStaticIpsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStaticIps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStaticIpsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStaticIps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetStaticIpsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStaticIpsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getStaticIps$502(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getStaticIps$503((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportKeyPairResponse> importKeyPair(ImportKeyPairRequest importKeyPairRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, importKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportKeyPairResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$importKeyPair$506(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$importKeyPair$507((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<IsVpcPeeredResponse> isVpcPeered(IsVpcPeeredRequest isVpcPeeredRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)isVpcPeeredRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, isVpcPeeredRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IsVpcPeered");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IsVpcPeeredResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("IsVpcPeered").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new IsVpcPeeredRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)isVpcPeeredRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$isVpcPeered$510(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$isVpcPeered$511((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<OpenInstancePublicPortsResponse> openInstancePublicPorts(OpenInstancePublicPortsRequest openInstancePublicPortsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)openInstancePublicPortsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, openInstancePublicPortsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"OpenInstancePublicPorts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, OpenInstancePublicPortsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("OpenInstancePublicPorts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new OpenInstancePublicPortsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)openInstancePublicPortsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$openInstancePublicPorts$514(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$openInstancePublicPorts$515((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PeerVpcResponse> peerVpc(PeerVpcRequest peerVpcRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)peerVpcRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, peerVpcRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PeerVpc");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PeerVpcResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PeerVpc").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PeerVpcRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)peerVpcRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$peerVpc$518(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$peerVpc$519((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAlarmResponse> putAlarm(PutAlarmRequest putAlarmRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, putAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAlarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAlarmResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAlarmRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$putAlarm$522(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$putAlarm$523((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutInstancePublicPortsResponse> putInstancePublicPorts(PutInstancePublicPortsRequest putInstancePublicPortsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putInstancePublicPortsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, putInstancePublicPortsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutInstancePublicPorts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutInstancePublicPortsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutInstancePublicPorts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutInstancePublicPortsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putInstancePublicPortsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$putInstancePublicPorts$526(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$putInstancePublicPorts$527((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootInstanceResponse> rebootInstance(RebootInstanceRequest rebootInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rebootInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, rebootInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RebootInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rebootInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$rebootInstance$530(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$rebootInstance$531((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootRelationalDatabaseResponse> rebootRelationalDatabase(RebootRelationalDatabaseRequest rebootRelationalDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rebootRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, rebootRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootRelationalDatabaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RebootRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rebootRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$rebootRelationalDatabase$534(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$rebootRelationalDatabase$535((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterContainerImageResponse> registerContainerImage(RegisterContainerImageRequest registerContainerImageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerContainerImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, registerContainerImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterContainerImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterContainerImageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterContainerImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterContainerImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerContainerImageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$registerContainerImage$538(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$registerContainerImage$539((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReleaseStaticIpResponse> releaseStaticIp(ReleaseStaticIpRequest releaseStaticIpRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)releaseStaticIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, releaseStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReleaseStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReleaseStaticIpResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReleaseStaticIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ReleaseStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)releaseStaticIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$releaseStaticIp$542(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$releaseStaticIp$543((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetDistributionCacheResponse> resetDistributionCache(ResetDistributionCacheRequest resetDistributionCacheRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetDistributionCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, resetDistributionCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetDistributionCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetDistributionCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDistributionCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ResetDistributionCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resetDistributionCacheRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$resetDistributionCache$546(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$resetDistributionCache$547((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendContactMethodVerificationResponse> sendContactMethodVerification(SendContactMethodVerificationRequest sendContactMethodVerificationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendContactMethodVerificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, sendContactMethodVerificationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendContactMethodVerification");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendContactMethodVerificationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendContactMethodVerification").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendContactMethodVerificationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendContactMethodVerificationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$sendContactMethodVerification$550(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$sendContactMethodVerification$551((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetIpAddressTypeResponse> setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setIpAddressTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, setIpAddressTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIpAddressType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetIpAddressTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIpAddressType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetIpAddressTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setIpAddressTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$setIpAddressType$554(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$setIpAddressType$555((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetResourceAccessForBucketResponse> setResourceAccessForBucket(SetResourceAccessForBucketRequest setResourceAccessForBucketRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setResourceAccessForBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, setResourceAccessForBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetResourceAccessForBucket");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetResourceAccessForBucketResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetResourceAccessForBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetResourceAccessForBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setResourceAccessForBucketRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$setResourceAccessForBucket$558(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$setResourceAccessForBucket$559((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetupInstanceHttpsResponse> setupInstanceHttps(SetupInstanceHttpsRequest setupInstanceHttpsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setupInstanceHttpsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, setupInstanceHttpsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetupInstanceHttps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetupInstanceHttpsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetupInstanceHttps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetupInstanceHttpsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setupInstanceHttpsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$setupInstanceHttps$562(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$setupInstanceHttps$563((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartGuiSessionResponse> startGUISession(StartGuiSessionRequest startGuiSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startGuiSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, startGuiSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartGUISession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartGuiSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartGUISession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartGuiSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startGuiSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$startGUISession$566(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$startGUISession$567((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartInstanceResponse> startInstance(StartInstanceRequest startInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, startInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$startInstance$570(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$startInstance$571((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartRelationalDatabaseResponse> startRelationalDatabase(StartRelationalDatabaseRequest startRelationalDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, startRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRelationalDatabaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$startRelationalDatabase$574(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$startRelationalDatabase$575((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopGuiSessionResponse> stopGUISession(StopGuiSessionRequest stopGuiSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopGuiSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, stopGuiSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopGUISession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopGuiSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopGUISession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopGuiSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopGuiSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$stopGUISession$578(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$stopGUISession$579((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopInstanceResponse> stopInstance(StopInstanceRequest stopInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, stopInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$stopInstance$582(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$stopInstance$583((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopRelationalDatabaseResponse> stopRelationalDatabase(StopRelationalDatabaseRequest stopRelationalDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, stopRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopRelationalDatabaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$stopRelationalDatabase$586(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$stopRelationalDatabase$587((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$tagResource$590(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$tagResource$591((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestAlarmResponse> testAlarm(TestAlarmRequest testAlarmRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)testAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, testAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestAlarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestAlarmResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TestAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)testAlarmRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$testAlarm$594(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$testAlarm$595((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UnpeerVpcResponse> unpeerVpc(UnpeerVpcRequest unpeerVpcRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unpeerVpcRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, unpeerVpcRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnpeerVpc");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnpeerVpcResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnpeerVpc").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UnpeerVpcRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)unpeerVpcRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$unpeerVpc$598(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$unpeerVpc$599((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$untagResource$602(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$untagResource$603((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBucketResponse> updateBucket(UpdateBucketRequest updateBucketRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, updateBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBucket");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBucketResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBucketRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateBucket$606(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateBucket$607((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBucketBundleResponse> updateBucketBundle(UpdateBucketBundleRequest updateBucketBundleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBucketBundleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, updateBucketBundleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBucketBundle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBucketBundleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBucketBundle").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBucketBundleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBucketBundleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateBucketBundle$610(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateBucketBundle$611((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateContainerServiceResponse> updateContainerService(UpdateContainerServiceRequest updateContainerServiceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContainerServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, updateContainerServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContainerService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContainerServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContainerService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateContainerServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateContainerServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateContainerService$614(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateContainerService$615((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDistributionResponse> updateDistribution(UpdateDistributionRequest updateDistributionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDistributionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, updateDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDistributionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistribution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDistributionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateDistribution$618(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateDistribution$619((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDistributionBundleResponse> updateDistributionBundle(UpdateDistributionBundleRequest updateDistributionBundleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDistributionBundleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, updateDistributionBundleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDistributionBundle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDistributionBundleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistributionBundle").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDistributionBundleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDistributionBundleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateDistributionBundle$622(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateDistributionBundle$623((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDomainEntryResponse> updateDomainEntry(UpdateDomainEntryRequest updateDomainEntryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDomainEntryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, updateDomainEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainEntry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainEntryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainEntry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDomainEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDomainEntryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateDomainEntry$626(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateDomainEntry$627((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateInstanceMetadataOptionsResponse> updateInstanceMetadataOptions(UpdateInstanceMetadataOptionsRequest updateInstanceMetadataOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateInstanceMetadataOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, updateInstanceMetadataOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateInstanceMetadataOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInstanceMetadataOptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInstanceMetadataOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateInstanceMetadataOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateInstanceMetadataOptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateInstanceMetadataOptions$630(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateInstanceMetadataOptions$631((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLoadBalancerAttributeResponse> updateLoadBalancerAttribute(UpdateLoadBalancerAttributeRequest updateLoadBalancerAttributeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLoadBalancerAttributeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, updateLoadBalancerAttributeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLoadBalancerAttribute");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLoadBalancerAttributeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLoadBalancerAttribute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateLoadBalancerAttributeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLoadBalancerAttributeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateLoadBalancerAttribute$634(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateLoadBalancerAttribute$635((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRelationalDatabaseResponse> updateRelationalDatabase(UpdateRelationalDatabaseRequest updateRelationalDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, updateRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRelationalDatabaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateRelationalDatabase$638(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateRelationalDatabase$639((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRelationalDatabaseParametersResponse> updateRelationalDatabaseParameters(UpdateRelationalDatabaseParametersRequest updateRelationalDatabaseParametersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRelationalDatabaseParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(clientConfiguration, updateRelationalDatabaseParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRelationalDatabaseParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRelationalDatabaseParametersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "UnauthenticatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "AccountSetupInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                    }
                    case "OperationFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRelationalDatabaseParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRelationalDatabaseParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRelationalDatabaseParametersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateRelationalDatabaseParameters$642(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateRelationalDatabaseParameters$643((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final LightsailServiceClientConfiguration serviceClientConfiguration() {
        return new LightsailServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "lightsail";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LightsailException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        LightsailServiceClientConfigurationBuilder serviceConfigBuilder = new LightsailServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateRelationalDatabaseParameters$643(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRelationalDatabaseParameters$642(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRelationalDatabaseParametersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRelationalDatabase$639(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRelationalDatabase$638(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLoadBalancerAttribute$635(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLoadBalancerAttribute$634(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLoadBalancerAttributeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateInstanceMetadataOptions$631(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateInstanceMetadataOptions$630(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateInstanceMetadataOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDomainEntry$627(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomainEntry$626(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDomainEntryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDistributionBundle$623(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDistributionBundle$622(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDistributionBundleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDistribution$619(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDistribution$618(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateContainerService$615(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContainerService$614(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateContainerServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBucketBundle$611(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBucketBundle$610(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBucketBundleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBucket$607(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBucket$606(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$603(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$602(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$unpeerVpc$599(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unpeerVpc$598(List metricPublishers, MetricCollector apiCallMetricCollector, UnpeerVpcResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$testAlarm$595(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testAlarm$594(List metricPublishers, MetricCollector apiCallMetricCollector, TestAlarmResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$591(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$590(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopRelationalDatabase$587(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopRelationalDatabase$586(List metricPublishers, MetricCollector apiCallMetricCollector, StopRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopInstance$583(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopInstance$582(List metricPublishers, MetricCollector apiCallMetricCollector, StopInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopGUISession$579(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopGUISession$578(List metricPublishers, MetricCollector apiCallMetricCollector, StopGuiSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startRelationalDatabase$575(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRelationalDatabase$574(List metricPublishers, MetricCollector apiCallMetricCollector, StartRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startInstance$571(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startInstance$570(List metricPublishers, MetricCollector apiCallMetricCollector, StartInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startGUISession$567(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startGUISession$566(List metricPublishers, MetricCollector apiCallMetricCollector, StartGuiSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setupInstanceHttps$563(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setupInstanceHttps$562(List metricPublishers, MetricCollector apiCallMetricCollector, SetupInstanceHttpsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setResourceAccessForBucket$559(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setResourceAccessForBucket$558(List metricPublishers, MetricCollector apiCallMetricCollector, SetResourceAccessForBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setIpAddressType$555(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIpAddressType$554(List metricPublishers, MetricCollector apiCallMetricCollector, SetIpAddressTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendContactMethodVerification$551(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendContactMethodVerification$550(List metricPublishers, MetricCollector apiCallMetricCollector, SendContactMethodVerificationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resetDistributionCache$547(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetDistributionCache$546(List metricPublishers, MetricCollector apiCallMetricCollector, ResetDistributionCacheResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$releaseStaticIp$543(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$releaseStaticIp$542(List metricPublishers, MetricCollector apiCallMetricCollector, ReleaseStaticIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerContainerImage$539(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerContainerImage$538(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterContainerImageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rebootRelationalDatabase$535(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootRelationalDatabase$534(List metricPublishers, MetricCollector apiCallMetricCollector, RebootRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rebootInstance$531(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootInstance$530(List metricPublishers, MetricCollector apiCallMetricCollector, RebootInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putInstancePublicPorts$527(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putInstancePublicPorts$526(List metricPublishers, MetricCollector apiCallMetricCollector, PutInstancePublicPortsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAlarm$523(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAlarm$522(List metricPublishers, MetricCollector apiCallMetricCollector, PutAlarmResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$peerVpc$519(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$peerVpc$518(List metricPublishers, MetricCollector apiCallMetricCollector, PeerVpcResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$openInstancePublicPorts$515(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$openInstancePublicPorts$514(List metricPublishers, MetricCollector apiCallMetricCollector, OpenInstancePublicPortsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$isVpcPeered$511(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$isVpcPeered$510(List metricPublishers, MetricCollector apiCallMetricCollector, IsVpcPeeredResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importKeyPair$507(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importKeyPair$506(List metricPublishers, MetricCollector apiCallMetricCollector, ImportKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getStaticIps$503(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStaticIps$502(List metricPublishers, MetricCollector apiCallMetricCollector, GetStaticIpsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getStaticIp$499(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStaticIp$498(List metricPublishers, MetricCollector apiCallMetricCollector, GetStaticIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSetupHistory$495(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSetupHistory$494(List metricPublishers, MetricCollector apiCallMetricCollector, GetSetupHistoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabases$491(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabases$490(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseSnapshots$487(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseSnapshots$486(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseSnapshot$483(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseSnapshot$482(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseParameters$479(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseParameters$478(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseParametersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseMetricData$475(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseMetricData$474(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseMasterUserPassword$471(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseMasterUserPassword$470(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseMasterUserPasswordResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseLogStreams$467(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseLogStreams$466(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseLogStreamsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseLogEvents$463(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseLogEvents$462(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseLogEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseEvents$459(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseEvents$458(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseBundles$455(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseBundles$454(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseBundlesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseBlueprints$451(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseBlueprints$450(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseBlueprintsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabase$447(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabase$446(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRegions$443(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRegions$442(List metricPublishers, MetricCollector apiCallMetricCollector, GetRegionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOperationsForResource$439(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperationsForResource$438(List metricPublishers, MetricCollector apiCallMetricCollector, GetOperationsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOperations$435(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperations$434(List metricPublishers, MetricCollector apiCallMetricCollector, GetOperationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOperation$431(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperation$430(List metricPublishers, MetricCollector apiCallMetricCollector, GetOperationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoadBalancers$427(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancers$426(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoadBalancersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoadBalancerTlsPolicies$423(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancerTlsPolicies$422(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoadBalancerTlsPoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoadBalancerTlsCertificates$419(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancerTlsCertificates$418(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoadBalancerTlsCertificatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoadBalancerMetricData$415(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancerMetricData$414(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoadBalancerMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoadBalancer$411(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancer$410(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getKeyPairs$407(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyPairs$406(List metricPublishers, MetricCollector apiCallMetricCollector, GetKeyPairsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getKeyPair$403(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyPair$402(List metricPublishers, MetricCollector apiCallMetricCollector, GetKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstances$399(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstances$398(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstanceState$395(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceState$394(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstanceSnapshots$391(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceSnapshots$390(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstanceSnapshot$387(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceSnapshot$386(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstancePortStates$383(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstancePortStates$382(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstancePortStatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstanceMetricData$379(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceMetricData$378(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstanceAccessDetails$375(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceAccessDetails$374(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceAccessDetailsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstance$371(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstance$370(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getExportSnapshotRecords$367(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExportSnapshotRecords$366(List metricPublishers, MetricCollector apiCallMetricCollector, GetExportSnapshotRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDomains$363(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomains$362(List metricPublishers, MetricCollector apiCallMetricCollector, GetDomainsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDomain$359(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomain$358(List metricPublishers, MetricCollector apiCallMetricCollector, GetDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDistributions$355(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributions$354(List metricPublishers, MetricCollector apiCallMetricCollector, GetDistributionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDistributionMetricData$351(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionMetricData$350(List metricPublishers, MetricCollector apiCallMetricCollector, GetDistributionMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDistributionLatestCacheReset$347(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionLatestCacheReset$346(List metricPublishers, MetricCollector apiCallMetricCollector, GetDistributionLatestCacheResetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDistributionBundles$343(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionBundles$342(List metricPublishers, MetricCollector apiCallMetricCollector, GetDistributionBundlesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDisks$339(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDisks$338(List metricPublishers, MetricCollector apiCallMetricCollector, GetDisksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDiskSnapshots$335(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDiskSnapshots$334(List metricPublishers, MetricCollector apiCallMetricCollector, GetDiskSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDiskSnapshot$331(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDiskSnapshot$330(List metricPublishers, MetricCollector apiCallMetricCollector, GetDiskSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDisk$327(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDisk$326(List metricPublishers, MetricCollector apiCallMetricCollector, GetDiskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCostEstimate$323(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostEstimate$322(List metricPublishers, MetricCollector apiCallMetricCollector, GetCostEstimateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerServices$319(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServices$318(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerServicesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerServicePowers$315(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServicePowers$314(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerServicePowersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerServiceMetricData$311(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServiceMetricData$310(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerServiceMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerServiceDeployments$307(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServiceDeployments$306(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerServiceDeploymentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerLog$303(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerLog$302(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerLogResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerImages$299(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerImages$298(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerImagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerAPIMetadata$295(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerAPIMetadata$294(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerApiMetadataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContactMethods$291(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContactMethods$290(List metricPublishers, MetricCollector apiCallMetricCollector, GetContactMethodsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCloudFormationStackRecords$287(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCloudFormationStackRecords$286(List metricPublishers, MetricCollector apiCallMetricCollector, GetCloudFormationStackRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCertificates$283(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificates$282(List metricPublishers, MetricCollector apiCallMetricCollector, GetCertificatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBundles$279(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBundles$278(List metricPublishers, MetricCollector apiCallMetricCollector, GetBundlesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBuckets$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBuckets$274(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBucketMetricData$271(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketMetricData$270(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBucketBundles$267(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketBundles$266(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketBundlesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBucketAccessKeys$263(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketAccessKeys$262(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketAccessKeysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBlueprints$259(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBlueprints$258(List metricPublishers, MetricCollector apiCallMetricCollector, GetBlueprintsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAutoSnapshots$255(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAutoSnapshots$254(List metricPublishers, MetricCollector apiCallMetricCollector, GetAutoSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAlarms$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAlarms$250(List metricPublishers, MetricCollector apiCallMetricCollector, GetAlarmsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getActiveNames$247(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getActiveNames$246(List metricPublishers, MetricCollector apiCallMetricCollector, GetActiveNamesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$exportSnapshot$243(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportSnapshot$242(List metricPublishers, MetricCollector apiCallMetricCollector, ExportSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableAddOn$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableAddOn$238(List metricPublishers, MetricCollector apiCallMetricCollector, EnableAddOnResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$downloadDefaultKeyPair$235(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$downloadDefaultKeyPair$234(List metricPublishers, MetricCollector apiCallMetricCollector, DownloadDefaultKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableAddOn$231(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableAddOn$230(List metricPublishers, MetricCollector apiCallMetricCollector, DisableAddOnResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachStaticIp$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachStaticIp$226(List metricPublishers, MetricCollector apiCallMetricCollector, DetachStaticIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachInstancesFromLoadBalancer$223(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachInstancesFromLoadBalancer$222(List metricPublishers, MetricCollector apiCallMetricCollector, DetachInstancesFromLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachDisk$219(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachDisk$218(List metricPublishers, MetricCollector apiCallMetricCollector, DetachDiskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachCertificateFromDistribution$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachCertificateFromDistribution$214(List metricPublishers, MetricCollector apiCallMetricCollector, DetachCertificateFromDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRelationalDatabaseSnapshot$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRelationalDatabaseSnapshot$210(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRelationalDatabaseSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRelationalDatabase$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRelationalDatabase$206(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLoadBalancerTlsCertificate$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoadBalancerTlsCertificate$202(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLoadBalancerTlsCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLoadBalancer$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoadBalancer$198(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteKnownHostKeys$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKnownHostKeys$194(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteKnownHostKeysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteKeyPair$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKeyPair$190(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteInstanceSnapshot$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInstanceSnapshot$186(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteInstanceSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteInstance$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInstance$182(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDomainEntry$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomainEntry$178(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDomainEntryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDomain$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomain$174(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDistribution$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDistribution$170(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDiskSnapshot$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDiskSnapshot$166(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDiskSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDisk$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDisk$162(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDiskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteContainerService$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContainerService$158(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteContainerServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteContainerImage$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContainerImage$154(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteContainerImageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteContactMethod$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContactMethod$150(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteContactMethodResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCertificate$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCertificate$146(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBucketAccessKey$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketAccessKey$142(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBucketAccessKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBucket$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucket$138(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAutoSnapshot$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAutoSnapshot$134(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAutoSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAlarm$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAlarm$130(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAlarmResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRelationalDatabaseSnapshot$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRelationalDatabaseSnapshot$126(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRelationalDatabaseSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRelationalDatabaseFromSnapshot$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRelationalDatabaseFromSnapshot$122(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRelationalDatabaseFromSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRelationalDatabase$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRelationalDatabase$118(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLoadBalancerTlsCertificate$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLoadBalancerTlsCertificate$114(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLoadBalancerTlsCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLoadBalancer$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLoadBalancer$110(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createKeyPair$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKeyPair$106(List metricPublishers, MetricCollector apiCallMetricCollector, CreateKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createInstancesFromSnapshot$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInstancesFromSnapshot$102(List metricPublishers, MetricCollector apiCallMetricCollector, CreateInstancesFromSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createInstances$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInstances$98(List metricPublishers, MetricCollector apiCallMetricCollector, CreateInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createInstanceSnapshot$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInstanceSnapshot$94(List metricPublishers, MetricCollector apiCallMetricCollector, CreateInstanceSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createGUISessionAccessDetails$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGUISessionAccessDetails$90(List metricPublishers, MetricCollector apiCallMetricCollector, CreateGuiSessionAccessDetailsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDomainEntry$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomainEntry$86(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDomainEntryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDomain$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomain$82(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDistribution$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDistribution$78(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDiskSnapshot$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDiskSnapshot$74(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDiskSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDiskFromSnapshot$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDiskFromSnapshot$70(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDiskFromSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDisk$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDisk$66(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDiskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createContainerServiceRegistryLogin$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContainerServiceRegistryLogin$62(List metricPublishers, MetricCollector apiCallMetricCollector, CreateContainerServiceRegistryLoginResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createContainerServiceDeployment$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContainerServiceDeployment$58(List metricPublishers, MetricCollector apiCallMetricCollector, CreateContainerServiceDeploymentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createContainerService$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContainerService$54(List metricPublishers, MetricCollector apiCallMetricCollector, CreateContainerServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createContactMethod$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContactMethod$50(List metricPublishers, MetricCollector apiCallMetricCollector, CreateContactMethodResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCloudFormationStack$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCloudFormationStack$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCloudFormationStackResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCertificate$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCertificate$42(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBucketAccessKey$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBucketAccessKey$38(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBucketAccessKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBucket$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBucket$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$copySnapshot$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copySnapshot$30(List metricPublishers, MetricCollector apiCallMetricCollector, CopySnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$closeInstancePublicPorts$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$closeInstancePublicPorts$26(List metricPublishers, MetricCollector apiCallMetricCollector, CloseInstancePublicPortsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachStaticIp$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachStaticIp$22(List metricPublishers, MetricCollector apiCallMetricCollector, AttachStaticIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachLoadBalancerTlsCertificate$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachLoadBalancerTlsCertificate$18(List metricPublishers, MetricCollector apiCallMetricCollector, AttachLoadBalancerTlsCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachInstancesToLoadBalancer$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachInstancesToLoadBalancer$14(List metricPublishers, MetricCollector apiCallMetricCollector, AttachInstancesToLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachDisk$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachDisk$10(List metricPublishers, MetricCollector apiCallMetricCollector, AttachDiskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachCertificateToDistribution$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachCertificateToDistribution$6(List metricPublishers, MetricCollector apiCallMetricCollector, AttachCertificateToDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$allocateStaticIp$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$allocateStaticIp$2(List metricPublishers, MetricCollector apiCallMetricCollector, AllocateStaticIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

