/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lightsail.model.Container;
import software.amazon.awssdk.services.lightsail.model.ContainerMapCopier;
import software.amazon.awssdk.services.lightsail.model.EndpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerServiceDeploymentRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerServiceDeploymentRequest> {
    private static final SdkField<Map<String, Container>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("containers").getter(ContainerServiceDeploymentRequest.getter(ContainerServiceDeploymentRequest::containers)).setter(ContainerServiceDeploymentRequest.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Container::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<EndpointRequest> PUBLIC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("publicEndpoint").getter(ContainerServiceDeploymentRequest.getter(ContainerServiceDeploymentRequest::publicEndpoint)).setter(ContainerServiceDeploymentRequest.setter(Builder::publicEndpoint)).constructor(EndpointRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD, PUBLIC_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerServiceDeploymentRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, Container> containers;
    private final EndpointRequest publicEndpoint;

    private ContainerServiceDeploymentRequest(BuilderImpl builder) {
        this.containers = builder.containers;
        this.publicEndpoint = builder.publicEndpoint;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructMap);
    }

    public final Map<String, Container> containers() {
        return this.containers;
    }

    public final EndpointRequest publicEndpoint() {
        return this.publicEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publicEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceDeploymentRequest)) {
            return false;
        }
        ContainerServiceDeploymentRequest other = (ContainerServiceDeploymentRequest)obj;
        return this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && Objects.equals(this.publicEndpoint(), other.publicEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerServiceDeploymentRequest").add("Containers", this.hasContainers() ? this.containers() : null).add("PublicEndpoint", (Object)this.publicEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "publicEndpoint": {
                return Optional.ofNullable(clazz.cast(this.publicEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("containers", CONTAINERS_FIELD);
        map.put("publicEndpoint", PUBLIC_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerServiceDeploymentRequest, T> g) {
        return obj -> g.apply((ContainerServiceDeploymentRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Container> containers = DefaultSdkAutoConstructMap.getInstance();
        private EndpointRequest publicEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServiceDeploymentRequest model) {
            this.containers(model.containers);
            this.publicEndpoint(model.publicEndpoint);
        }

        public final Map<String, Container.Builder> getContainers() {
            Map<String, Container.Builder> result = ContainerMapCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setContainers(Map<String, Container.BuilderImpl> containers) {
            this.containers = ContainerMapCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Map<String, Container> containers) {
            this.containers = ContainerMapCopier.copy(containers);
            return this;
        }

        public final EndpointRequest.Builder getPublicEndpoint() {
            return this.publicEndpoint != null ? this.publicEndpoint.toBuilder() : null;
        }

        public final void setPublicEndpoint(EndpointRequest.BuilderImpl publicEndpoint) {
            this.publicEndpoint = publicEndpoint != null ? publicEndpoint.build() : null;
        }

        @Override
        public final Builder publicEndpoint(EndpointRequest publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
            return this;
        }

        public ContainerServiceDeploymentRequest build() {
            return new ContainerServiceDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerServiceDeploymentRequest> {
        public Builder containers(Map<String, Container> var1);

        public Builder publicEndpoint(EndpointRequest var1);

        default public Builder publicEndpoint(Consumer<EndpointRequest.Builder> publicEndpoint) {
            return this.publicEndpoint((EndpointRequest)((EndpointRequest.Builder)EndpointRequest.builder().applyMutation(publicEndpoint)).build());
        }
    }
}

