/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.lightsail.LightsailClient;
import software.amazon.awssdk.services.lightsail.LightsailServiceClientConfiguration;
import software.amazon.awssdk.services.lightsail.internal.LightsailServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.lightsail.model.AccessDeniedException;
import software.amazon.awssdk.services.lightsail.model.AccountSetupInProgressException;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.AttachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.AttachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest;
import software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse;
import software.amazon.awssdk.services.lightsail.model.CreateBucketRequest;
import software.amazon.awssdk.services.lightsail.model.CreateBucketResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContactMethodResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainResponse;
import software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContactMethodResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerImageResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.DetachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DetachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse;
import software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest;
import software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCostEstimateRequest;
import software.amazon.awssdk.services.lightsail.model.GetCostEstimateResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDisksRequest;
import software.amazon.awssdk.services.lightsail.model.GetDisksResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainsResponse;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRegionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRegionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse;
import software.amazon.awssdk.services.lightsail.model.GetSetupHistoryRequest;
import software.amazon.awssdk.services.lightsail.model.GetSetupHistoryResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.InvalidInputException;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse;
import software.amazon.awssdk.services.lightsail.model.LightsailException;
import software.amazon.awssdk.services.lightsail.model.NotFoundException;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.OperationFailureException;
import software.amazon.awssdk.services.lightsail.model.PeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.PeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.PutAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.PutAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.RegionSetupInProgressException;
import software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest;
import software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest;
import software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse;
import software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest;
import software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationResponse;
import software.amazon.awssdk.services.lightsail.model.ServiceException;
import software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest;
import software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketResponse;
import software.amazon.awssdk.services.lightsail.model.SetupInstanceHttpsRequest;
import software.amazon.awssdk.services.lightsail.model.SetupInstanceHttpsResponse;
import software.amazon.awssdk.services.lightsail.model.StartGuiSessionRequest;
import software.amazon.awssdk.services.lightsail.model.StartGuiSessionResponse;
import software.amazon.awssdk.services.lightsail.model.StartInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StartInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.StopGuiSessionRequest;
import software.amazon.awssdk.services.lightsail.model.StopGuiSessionResponse;
import software.amazon.awssdk.services.lightsail.model.StopInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StopInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.TagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.TagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.TestAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.TestAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.UnauthenticatedException;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.UntagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.UntagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachCertificateToDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachInstancesToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateBucketAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateCloudFormationStackRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContactMethodRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceDeploymentRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceRegistryLoginRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateGuiSessionAccessDetailsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteAutoSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteBucketAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContactMethodRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContainerImageRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKnownHostKeysRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachCertificateFromDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DisableAddOnRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.EnableAddOnRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ExportSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetAlarmsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetAutoSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketAccessKeysRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCertificatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCloudFormationStackRecordsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContactMethodsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerApiMetadataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerImagesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerLogRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServiceDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServiceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServicePowersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServicesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCostEstimateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDisksRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionLatestCacheResetRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetExportSnapshotRecordsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerTlsCertificatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerTlsPoliciesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseEventsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseLogEventsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseLogStreamsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseMasterUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseParametersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabasesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetSetupHistoryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RegisterContainerImageRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ResetDistributionCacheRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SendContactMethodVerificationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SetIpAddressTypeRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SetResourceAccessForBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SetupInstanceHttpsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartGuiSessionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopGuiSessionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.TestAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateBucketBundleRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDistributionBundleRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateInstanceMetadataOptionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateLoadBalancerAttributeRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateRelationalDatabaseParametersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultLightsailClient
implements LightsailClient {
    private static final Logger log = Logger.loggerFor(DefaultLightsailClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLightsailClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Lightsail#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateStaticIpResponse allocateStaticIp(AllocateStaticIpRequest allocateStaticIpRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AllocateStaticIpResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)allocateStaticIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, allocateStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AllocateStaticIp");
            AllocateStaticIpResponse allocateStaticIpResponse = (AllocateStaticIpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AllocateStaticIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)allocateStaticIpRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AllocateStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return allocateStaticIpResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$allocateStaticIp$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachCertificateToDistributionResponse attachCertificateToDistribution(AttachCertificateToDistributionRequest attachCertificateToDistributionRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachCertificateToDistributionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachCertificateToDistributionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, attachCertificateToDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachCertificateToDistribution");
            AttachCertificateToDistributionResponse attachCertificateToDistributionResponse = (AttachCertificateToDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachCertificateToDistribution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachCertificateToDistributionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachCertificateToDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return attachCertificateToDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$attachCertificateToDistribution$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachDiskResponse attachDisk(AttachDiskRequest attachDiskRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachDiskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachDiskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, attachDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachDisk");
            AttachDiskResponse attachDiskResponse = (AttachDiskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachDisk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachDiskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return attachDiskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$attachDisk$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachInstancesToLoadBalancerResponse attachInstancesToLoadBalancer(AttachInstancesToLoadBalancerRequest attachInstancesToLoadBalancerRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachInstancesToLoadBalancerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachInstancesToLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, attachInstancesToLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachInstancesToLoadBalancer");
            AttachInstancesToLoadBalancerResponse attachInstancesToLoadBalancerResponse = (AttachInstancesToLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachInstancesToLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachInstancesToLoadBalancerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachInstancesToLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return attachInstancesToLoadBalancerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$attachInstancesToLoadBalancer$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachLoadBalancerTlsCertificateResponse attachLoadBalancerTlsCertificate(AttachLoadBalancerTlsCertificateRequest attachLoadBalancerTlsCertificateRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachLoadBalancerTlsCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachLoadBalancerTlsCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, attachLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachLoadBalancerTlsCertificate");
            AttachLoadBalancerTlsCertificateResponse attachLoadBalancerTlsCertificateResponse = (AttachLoadBalancerTlsCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerTlsCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachLoadBalancerTlsCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachLoadBalancerTlsCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return attachLoadBalancerTlsCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$attachLoadBalancerTlsCertificate$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachStaticIpResponse attachStaticIp(AttachStaticIpRequest attachStaticIpRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachStaticIpResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachStaticIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, attachStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachStaticIp");
            AttachStaticIpResponse attachStaticIpResponse = (AttachStaticIpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachStaticIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)attachStaticIpRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AttachStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return attachStaticIpResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$attachStaticIp$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseInstancePublicPortsResponse closeInstancePublicPorts(CloseInstancePublicPortsRequest closeInstancePublicPortsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CloseInstancePublicPortsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)closeInstancePublicPortsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, closeInstancePublicPortsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CloseInstancePublicPorts");
            CloseInstancePublicPortsResponse closeInstancePublicPortsResponse = (CloseInstancePublicPortsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CloseInstancePublicPorts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)closeInstancePublicPortsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CloseInstancePublicPortsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return closeInstancePublicPortsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$closeInstancePublicPorts$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopySnapshotResponse copySnapshot(CopySnapshotRequest copySnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopySnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copySnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, copySnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopySnapshot");
            CopySnapshotResponse copySnapshotResponse = (CopySnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopySnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)copySnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopySnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return copySnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$copySnapshot$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBucketResponse createBucket(CreateBucketRequest createBucketRequest) throws AccessDeniedException, InvalidInputException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBucketResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBucket");
            CreateBucketResponse createBucketResponse = (CreateBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBucketRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createBucket$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBucketAccessKeyResponse createBucketAccessKey(CreateBucketAccessKeyRequest createBucketAccessKeyRequest) throws AccessDeniedException, NotFoundException, InvalidInputException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBucketAccessKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBucketAccessKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createBucketAccessKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBucketAccessKey");
            CreateBucketAccessKeyResponse createBucketAccessKeyResponse = (CreateBucketAccessKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucketAccessKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBucketAccessKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBucketAccessKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBucketAccessKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createBucketAccessKey$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCertificateResponse createCertificate(CreateCertificateRequest createCertificateRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCertificate");
            CreateCertificateResponse createCertificateResponse = (CreateCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createCertificate$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCloudFormationStackResponse createCloudFormationStack(CreateCloudFormationStackRequest createCloudFormationStackRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCloudFormationStackResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCloudFormationStackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createCloudFormationStackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCloudFormationStack");
            CreateCloudFormationStackResponse createCloudFormationStackResponse = (CreateCloudFormationStackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCloudFormationStack").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCloudFormationStackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCloudFormationStackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCloudFormationStackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createCloudFormationStack$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateContactMethodResponse createContactMethod(CreateContactMethodRequest createContactMethodRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContactMethodResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createContactMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createContactMethodRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContactMethod");
            CreateContactMethodResponse createContactMethodResponse = (CreateContactMethodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContactMethod").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createContactMethodRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateContactMethodRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createContactMethodResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createContactMethod$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateContainerServiceResponse createContainerService(CreateContainerServiceRequest createContainerServiceRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContainerServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createContainerServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createContainerServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContainerService");
            CreateContainerServiceResponse createContainerServiceResponse = (CreateContainerServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContainerService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createContainerServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateContainerServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createContainerServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createContainerService$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateContainerServiceDeploymentResponse createContainerServiceDeployment(CreateContainerServiceDeploymentRequest createContainerServiceDeploymentRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContainerServiceDeploymentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createContainerServiceDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createContainerServiceDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContainerServiceDeployment");
            CreateContainerServiceDeploymentResponse createContainerServiceDeploymentResponse = (CreateContainerServiceDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContainerServiceDeployment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createContainerServiceDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateContainerServiceDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createContainerServiceDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createContainerServiceDeployment$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateContainerServiceRegistryLoginResponse createContainerServiceRegistryLogin(CreateContainerServiceRegistryLoginRequest createContainerServiceRegistryLoginRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContainerServiceRegistryLoginResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createContainerServiceRegistryLoginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createContainerServiceRegistryLoginRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContainerServiceRegistryLogin");
            CreateContainerServiceRegistryLoginResponse createContainerServiceRegistryLoginResponse = (CreateContainerServiceRegistryLoginResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContainerServiceRegistryLogin").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createContainerServiceRegistryLoginRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateContainerServiceRegistryLoginRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createContainerServiceRegistryLoginResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createContainerServiceRegistryLogin$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDiskResponse createDisk(CreateDiskRequest createDiskRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDiskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDiskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDisk");
            CreateDiskResponse createDiskResponse = (CreateDiskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDisk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDiskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDiskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createDisk$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDiskFromSnapshotResponse createDiskFromSnapshot(CreateDiskFromSnapshotRequest createDiskFromSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDiskFromSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDiskFromSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createDiskFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDiskFromSnapshot");
            CreateDiskFromSnapshotResponse createDiskFromSnapshotResponse = (CreateDiskFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDiskFromSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDiskFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDiskFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDiskFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createDiskFromSnapshot$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDiskSnapshotResponse createDiskSnapshot(CreateDiskSnapshotRequest createDiskSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDiskSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDiskSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createDiskSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDiskSnapshot");
            CreateDiskSnapshotResponse createDiskSnapshotResponse = (CreateDiskSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDiskSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDiskSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDiskSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDiskSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createDiskSnapshot$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDistributionResponse createDistribution(CreateDistributionRequest createDistributionRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDistributionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDistributionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDistribution");
            CreateDistributionResponse createDistributionResponse = (CreateDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistribution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDistributionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createDistribution$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomain");
            CreateDomainResponse createDomainResponse = (CreateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createDomain$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainEntryResponse createDomainEntry(CreateDomainEntryRequest createDomainEntryRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainEntryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDomainEntryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createDomainEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomainEntry");
            CreateDomainEntryResponse createDomainEntryResponse = (CreateDomainEntryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomainEntry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDomainEntryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDomainEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDomainEntryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createDomainEntry$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGuiSessionAccessDetailsResponse createGUISessionAccessDetails(CreateGuiSessionAccessDetailsRequest createGuiSessionAccessDetailsRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGuiSessionAccessDetailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGuiSessionAccessDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createGuiSessionAccessDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGUISessionAccessDetails");
            CreateGuiSessionAccessDetailsResponse createGuiSessionAccessDetailsResponse = (CreateGuiSessionAccessDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGUISessionAccessDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGuiSessionAccessDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGuiSessionAccessDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGuiSessionAccessDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createGUISessionAccessDetails$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInstanceSnapshotResponse createInstanceSnapshot(CreateInstanceSnapshotRequest createInstanceSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstanceSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInstanceSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createInstanceSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInstanceSnapshot");
            CreateInstanceSnapshotResponse createInstanceSnapshotResponse = (CreateInstanceSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstanceSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createInstanceSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateInstanceSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createInstanceSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createInstanceSnapshot$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInstancesResponse createInstances(CreateInstancesRequest createInstancesRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInstances");
            CreateInstancesResponse createInstancesResponse = (CreateInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createInstances$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInstancesFromSnapshotResponse createInstancesFromSnapshot(CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstancesFromSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInstancesFromSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createInstancesFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInstancesFromSnapshot");
            CreateInstancesFromSnapshotResponse createInstancesFromSnapshotResponse = (CreateInstancesFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstancesFromSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createInstancesFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateInstancesFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createInstancesFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createInstancesFromSnapshot$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKeyPairResponse createKeyPair(CreateKeyPairRequest createKeyPairRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKeyPairResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKeyPair");
            CreateKeyPairResponse createKeyPairResponse = (CreateKeyPairResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createKeyPairRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createKeyPairResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createKeyPair$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLoadBalancerResponse createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLoadBalancerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancer");
            CreateLoadBalancerResponse createLoadBalancerResponse = (CreateLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createLoadBalancerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLoadBalancerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createLoadBalancer$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLoadBalancerTlsCertificateResponse createLoadBalancerTlsCertificate(CreateLoadBalancerTlsCertificateRequest createLoadBalancerTlsCertificateRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLoadBalancerTlsCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLoadBalancerTlsCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancerTlsCertificate");
            CreateLoadBalancerTlsCertificateResponse createLoadBalancerTlsCertificateResponse = (CreateLoadBalancerTlsCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerTlsCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createLoadBalancerTlsCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLoadBalancerTlsCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLoadBalancerTlsCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createLoadBalancerTlsCertificate$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRelationalDatabaseResponse createRelationalDatabase(CreateRelationalDatabaseRequest createRelationalDatabaseRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRelationalDatabaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRelationalDatabase");
            CreateRelationalDatabaseResponse createRelationalDatabaseResponse = (CreateRelationalDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createRelationalDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRelationalDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createRelationalDatabase$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRelationalDatabaseFromSnapshotResponse createRelationalDatabaseFromSnapshot(CreateRelationalDatabaseFromSnapshotRequest createRelationalDatabaseFromSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRelationalDatabaseFromSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRelationalDatabaseFromSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createRelationalDatabaseFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRelationalDatabaseFromSnapshot");
            CreateRelationalDatabaseFromSnapshotResponse createRelationalDatabaseFromSnapshotResponse = (CreateRelationalDatabaseFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRelationalDatabaseFromSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createRelationalDatabaseFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRelationalDatabaseFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRelationalDatabaseFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createRelationalDatabaseFromSnapshot$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRelationalDatabaseSnapshotResponse createRelationalDatabaseSnapshot(CreateRelationalDatabaseSnapshotRequest createRelationalDatabaseSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRelationalDatabaseSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRelationalDatabaseSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, createRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRelationalDatabaseSnapshot");
            CreateRelationalDatabaseSnapshotResponse createRelationalDatabaseSnapshotResponse = (CreateRelationalDatabaseSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRelationalDatabaseSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createRelationalDatabaseSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRelationalDatabaseSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRelationalDatabaseSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$createRelationalDatabaseSnapshot$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAlarmResponse deleteAlarm(DeleteAlarmRequest deleteAlarmRequest) throws ServiceException, InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlarm");
            DeleteAlarmResponse deleteAlarmResponse = (DeleteAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteAlarm$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAutoSnapshotResponse deleteAutoSnapshot(DeleteAutoSnapshotRequest deleteAutoSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAutoSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAutoSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteAutoSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAutoSnapshot");
            DeleteAutoSnapshotResponse deleteAutoSnapshotResponse = (DeleteAutoSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAutoSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAutoSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAutoSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAutoSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteAutoSnapshot$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBucketResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucket");
            DeleteBucketResponse deleteBucketResponse = (DeleteBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBucketRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteBucket$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketAccessKeyResponse deleteBucketAccessKey(DeleteBucketAccessKeyRequest deleteBucketAccessKeyRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBucketAccessKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBucketAccessKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteBucketAccessKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketAccessKey");
            DeleteBucketAccessKeyResponse deleteBucketAccessKeyResponse = (DeleteBucketAccessKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketAccessKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBucketAccessKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBucketAccessKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBucketAccessKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteBucketAccessKey$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) throws ServiceException, InvalidInputException, AccessDeniedException, NotFoundException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCertificate");
            DeleteCertificateResponse deleteCertificateResponse = (DeleteCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteCertificate$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteContactMethodResponse deleteContactMethod(DeleteContactMethodRequest deleteContactMethodRequest) throws ServiceException, InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContactMethodResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteContactMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteContactMethodRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContactMethod");
            DeleteContactMethodResponse deleteContactMethodResponse = (DeleteContactMethodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContactMethod").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteContactMethodRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteContactMethodRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteContactMethodResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteContactMethod$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteContainerImageResponse deleteContainerImage(DeleteContainerImageRequest deleteContainerImageRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContainerImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteContainerImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteContainerImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContainerImage");
            DeleteContainerImageResponse deleteContainerImageResponse = (DeleteContainerImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContainerImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteContainerImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteContainerImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteContainerImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteContainerImage$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteContainerServiceResponse deleteContainerService(DeleteContainerServiceRequest deleteContainerServiceRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContainerServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteContainerServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteContainerServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContainerService");
            DeleteContainerServiceResponse deleteContainerServiceResponse = (DeleteContainerServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContainerService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteContainerServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteContainerServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteContainerServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteContainerService$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDiskResponse deleteDisk(DeleteDiskRequest deleteDiskRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDiskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDiskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDisk");
            DeleteDiskResponse deleteDiskResponse = (DeleteDiskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDisk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDiskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDiskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteDisk$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDiskSnapshotResponse deleteDiskSnapshot(DeleteDiskSnapshotRequest deleteDiskSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDiskSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDiskSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteDiskSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDiskSnapshot");
            DeleteDiskSnapshotResponse deleteDiskSnapshotResponse = (DeleteDiskSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDiskSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDiskSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDiskSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDiskSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteDiskSnapshot$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDistributionResponse deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDistributionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDistributionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDistribution");
            DeleteDistributionResponse deleteDistributionResponse = (DeleteDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDistribution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDistributionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteDistribution$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomain");
            DeleteDomainResponse deleteDomainResponse = (DeleteDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteDomain$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainEntryResponse deleteDomainEntry(DeleteDomainEntryRequest deleteDomainEntryRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainEntryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDomainEntryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteDomainEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomainEntry");
            DeleteDomainEntryResponse deleteDomainEntryResponse = (DeleteDomainEntryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomainEntry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDomainEntryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDomainEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDomainEntryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteDomainEntry$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInstanceResponse deleteInstance(DeleteInstanceRequest deleteInstanceRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInstance");
            DeleteInstanceResponse deleteInstanceResponse = (DeleteInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteInstance$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInstanceSnapshotResponse deleteInstanceSnapshot(DeleteInstanceSnapshotRequest deleteInstanceSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInstanceSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInstanceSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteInstanceSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInstanceSnapshot");
            DeleteInstanceSnapshotResponse deleteInstanceSnapshotResponse = (DeleteInstanceSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInstanceSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteInstanceSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInstanceSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInstanceSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteInstanceSnapshot$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteKeyPairResponse deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKeyPairResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKeyPair");
            DeleteKeyPairResponse deleteKeyPairResponse = (DeleteKeyPairResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteKeyPairRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteKeyPairResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteKeyPair$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteKnownHostKeysResponse deleteKnownHostKeys(DeleteKnownHostKeysRequest deleteKnownHostKeysRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKnownHostKeysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteKnownHostKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteKnownHostKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKnownHostKeys");
            DeleteKnownHostKeysResponse deleteKnownHostKeysResponse = (DeleteKnownHostKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKnownHostKeys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteKnownHostKeysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteKnownHostKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteKnownHostKeysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteKnownHostKeys$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLoadBalancerResponse deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLoadBalancerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancer");
            DeleteLoadBalancerResponse deleteLoadBalancerResponse = (DeleteLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteLoadBalancerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLoadBalancerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteLoadBalancer$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLoadBalancerTlsCertificateResponse deleteLoadBalancerTlsCertificate(DeleteLoadBalancerTlsCertificateRequest deleteLoadBalancerTlsCertificateRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLoadBalancerTlsCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLoadBalancerTlsCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancerTlsCertificate");
            DeleteLoadBalancerTlsCertificateResponse deleteLoadBalancerTlsCertificateResponse = (DeleteLoadBalancerTlsCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerTlsCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteLoadBalancerTlsCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLoadBalancerTlsCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLoadBalancerTlsCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteLoadBalancerTlsCertificate$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRelationalDatabaseResponse deleteRelationalDatabase(DeleteRelationalDatabaseRequest deleteRelationalDatabaseRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRelationalDatabaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRelationalDatabase");
            DeleteRelationalDatabaseResponse deleteRelationalDatabaseResponse = (DeleteRelationalDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRelationalDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRelationalDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteRelationalDatabase$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRelationalDatabaseSnapshotResponse deleteRelationalDatabaseSnapshot(DeleteRelationalDatabaseSnapshotRequest deleteRelationalDatabaseSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRelationalDatabaseSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRelationalDatabaseSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, deleteRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRelationalDatabaseSnapshot");
            DeleteRelationalDatabaseSnapshotResponse deleteRelationalDatabaseSnapshotResponse = (DeleteRelationalDatabaseSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRelationalDatabaseSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRelationalDatabaseSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRelationalDatabaseSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRelationalDatabaseSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$deleteRelationalDatabaseSnapshot$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachCertificateFromDistributionResponse detachCertificateFromDistribution(DetachCertificateFromDistributionRequest detachCertificateFromDistributionRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachCertificateFromDistributionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachCertificateFromDistributionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, detachCertificateFromDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachCertificateFromDistribution");
            DetachCertificateFromDistributionResponse detachCertificateFromDistributionResponse = (DetachCertificateFromDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachCertificateFromDistribution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachCertificateFromDistributionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachCertificateFromDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detachCertificateFromDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$detachCertificateFromDistribution$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachDiskResponse detachDisk(DetachDiskRequest detachDiskRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachDiskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachDiskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, detachDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachDisk");
            DetachDiskResponse detachDiskResponse = (DetachDiskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachDisk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachDiskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detachDiskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$detachDisk$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachInstancesFromLoadBalancerResponse detachInstancesFromLoadBalancer(DetachInstancesFromLoadBalancerRequest detachInstancesFromLoadBalancerRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachInstancesFromLoadBalancerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachInstancesFromLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, detachInstancesFromLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachInstancesFromLoadBalancer");
            DetachInstancesFromLoadBalancerResponse detachInstancesFromLoadBalancerResponse = (DetachInstancesFromLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachInstancesFromLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachInstancesFromLoadBalancerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachInstancesFromLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detachInstancesFromLoadBalancerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$detachInstancesFromLoadBalancer$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachStaticIpResponse detachStaticIp(DetachStaticIpRequest detachStaticIpRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachStaticIpResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachStaticIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, detachStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachStaticIp");
            DetachStaticIpResponse detachStaticIpResponse = (DetachStaticIpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachStaticIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detachStaticIpRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetachStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detachStaticIpResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$detachStaticIp$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableAddOnResponse disableAddOn(DisableAddOnRequest disableAddOnRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableAddOnResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableAddOnRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, disableAddOnRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableAddOn");
            DisableAddOnResponse disableAddOnResponse = (DisableAddOnResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAddOn").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableAddOnRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableAddOnRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableAddOnResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$disableAddOn$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadDefaultKeyPairResponse downloadDefaultKeyPair(DownloadDefaultKeyPairRequest downloadDefaultKeyPairRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DownloadDefaultKeyPairResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)downloadDefaultKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, downloadDefaultKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DownloadDefaultKeyPair");
            DownloadDefaultKeyPairResponse downloadDefaultKeyPairResponse = (DownloadDefaultKeyPairResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DownloadDefaultKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)downloadDefaultKeyPairRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DownloadDefaultKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return downloadDefaultKeyPairResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$downloadDefaultKeyPair$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableAddOnResponse enableAddOn(EnableAddOnRequest enableAddOnRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableAddOnResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableAddOnRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, enableAddOnRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableAddOn");
            EnableAddOnResponse enableAddOnResponse = (EnableAddOnResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAddOn").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableAddOnRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableAddOnRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableAddOnResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$enableAddOn$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportSnapshotResponse exportSnapshot(ExportSnapshotRequest exportSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)exportSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, exportSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportSnapshot");
            ExportSnapshotResponse exportSnapshotResponse = (ExportSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)exportSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$exportSnapshot$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetActiveNamesResponse getActiveNames(GetActiveNamesRequest getActiveNamesRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetActiveNamesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getActiveNamesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getActiveNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetActiveNames");
            GetActiveNamesResponse getActiveNamesResponse = (GetActiveNamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetActiveNames").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getActiveNamesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetActiveNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getActiveNamesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getActiveNames$123((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAlarmsResponse getAlarms(GetAlarmsRequest getAlarmsRequest) throws ServiceException, InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAlarmsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAlarmsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getAlarmsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAlarms");
            GetAlarmsResponse getAlarmsResponse = (GetAlarmsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAlarms").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAlarmsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAlarmsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAlarmsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getAlarms$125((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAutoSnapshotsResponse getAutoSnapshots(GetAutoSnapshotsRequest getAutoSnapshotsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAutoSnapshotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAutoSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getAutoSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAutoSnapshots");
            GetAutoSnapshotsResponse getAutoSnapshotsResponse = (GetAutoSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAutoSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAutoSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAutoSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAutoSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getAutoSnapshots$127((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBlueprintsResponse getBlueprints(GetBlueprintsRequest getBlueprintsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlueprintsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBlueprintsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getBlueprintsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBlueprints");
            GetBlueprintsResponse getBlueprintsResponse = (GetBlueprintsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlueprints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBlueprintsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBlueprintsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBlueprintsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getBlueprints$129((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketAccessKeysResponse getBucketAccessKeys(GetBucketAccessKeysRequest getBucketAccessKeysRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketAccessKeysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketAccessKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getBucketAccessKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketAccessKeys");
            GetBucketAccessKeysResponse getBucketAccessKeysResponse = (GetBucketAccessKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAccessKeys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBucketAccessKeysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBucketAccessKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBucketAccessKeysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getBucketAccessKeys$131((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketBundlesResponse getBucketBundles(GetBucketBundlesRequest getBucketBundlesRequest) throws AccessDeniedException, InvalidInputException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketBundlesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketBundlesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getBucketBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketBundles");
            GetBucketBundlesResponse getBucketBundlesResponse = (GetBucketBundlesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketBundles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBucketBundlesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBucketBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBucketBundlesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getBucketBundles$133((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketMetricDataResponse getBucketMetricData(GetBucketMetricDataRequest getBucketMetricDataRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketMetricDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getBucketMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketMetricData");
            GetBucketMetricDataResponse getBucketMetricDataResponse = (GetBucketMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBucketMetricDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBucketMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBucketMetricDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getBucketMetricData$135((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketsResponse getBuckets(GetBucketsRequest getBucketsRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getBucketsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBuckets");
            GetBucketsResponse getBucketsResponse = (GetBucketsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBuckets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBucketsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBucketsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBucketsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getBuckets$137((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBundlesResponse getBundles(GetBundlesRequest getBundlesRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBundlesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBundlesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBundles");
            GetBundlesResponse getBundlesResponse = (GetBundlesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBundles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBundlesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBundlesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getBundles$139((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCertificatesResponse getCertificates(GetCertificatesRequest getCertificatesRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCertificatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificates");
            GetCertificatesResponse getCertificatesResponse = (GetCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCertificatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCertificatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getCertificates$141((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCloudFormationStackRecordsResponse getCloudFormationStackRecords(GetCloudFormationStackRecordsRequest getCloudFormationStackRecordsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCloudFormationStackRecordsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCloudFormationStackRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getCloudFormationStackRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudFormationStackRecords");
            GetCloudFormationStackRecordsResponse getCloudFormationStackRecordsResponse = (GetCloudFormationStackRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFormationStackRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCloudFormationStackRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCloudFormationStackRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCloudFormationStackRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getCloudFormationStackRecords$143((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContactMethodsResponse getContactMethods(GetContactMethodsRequest getContactMethodsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContactMethodsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContactMethodsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getContactMethodsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContactMethods");
            GetContactMethodsResponse getContactMethodsResponse = (GetContactMethodsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContactMethods").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContactMethodsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContactMethodsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContactMethodsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getContactMethods$145((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContainerApiMetadataResponse getContainerAPIMetadata(GetContainerApiMetadataRequest getContainerApiMetadataRequest) throws ServiceException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerApiMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerApiMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getContainerApiMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerAPIMetadata");
            GetContainerApiMetadataResponse getContainerApiMetadataResponse = (GetContainerApiMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerAPIMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContainerApiMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContainerApiMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContainerApiMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getContainerAPIMetadata$147((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContainerImagesResponse getContainerImages(GetContainerImagesRequest getContainerImagesRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerImagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerImagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getContainerImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerImages");
            GetContainerImagesResponse getContainerImagesResponse = (GetContainerImagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerImages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContainerImagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContainerImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContainerImagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getContainerImages$149((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContainerLogResponse getContainerLog(GetContainerLogRequest getContainerLogRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerLogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerLogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getContainerLogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerLog");
            GetContainerLogResponse getContainerLogResponse = (GetContainerLogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerLog").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContainerLogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContainerLogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContainerLogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getContainerLog$151((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContainerServiceDeploymentsResponse getContainerServiceDeployments(GetContainerServiceDeploymentsRequest getContainerServiceDeploymentsRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServiceDeploymentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerServiceDeploymentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getContainerServiceDeploymentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServiceDeployments");
            GetContainerServiceDeploymentsResponse getContainerServiceDeploymentsResponse = (GetContainerServiceDeploymentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServiceDeployments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContainerServiceDeploymentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContainerServiceDeploymentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContainerServiceDeploymentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getContainerServiceDeployments$153((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContainerServiceMetricDataResponse getContainerServiceMetricData(GetContainerServiceMetricDataRequest getContainerServiceMetricDataRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServiceMetricDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerServiceMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getContainerServiceMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServiceMetricData");
            GetContainerServiceMetricDataResponse getContainerServiceMetricDataResponse = (GetContainerServiceMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServiceMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContainerServiceMetricDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContainerServiceMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContainerServiceMetricDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getContainerServiceMetricData$155((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContainerServicePowersResponse getContainerServicePowers(GetContainerServicePowersRequest getContainerServicePowersRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServicePowersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerServicePowersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getContainerServicePowersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServicePowers");
            GetContainerServicePowersResponse getContainerServicePowersResponse = (GetContainerServicePowersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServicePowers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContainerServicePowersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContainerServicePowersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContainerServicePowersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getContainerServicePowers$157((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContainerServicesResponse getContainerServices(GetContainerServicesRequest getContainerServicesRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContainerServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getContainerServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServices");
            GetContainerServicesResponse getContainerServicesResponse = (GetContainerServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContainerServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContainerServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContainerServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getContainerServices$159((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostEstimateResponse getCostEstimate(GetCostEstimateRequest getCostEstimateRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostEstimateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostEstimateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getCostEstimateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostEstimate");
            GetCostEstimateResponse getCostEstimateResponse = (GetCostEstimateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostEstimate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCostEstimateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostEstimateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostEstimateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getCostEstimate$161((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDiskResponse getDisk(GetDiskRequest getDiskRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDiskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDisk");
            GetDiskResponse getDiskResponse = (GetDiskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDisk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDiskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDiskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getDisk$163((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDiskSnapshotResponse getDiskSnapshot(GetDiskSnapshotRequest getDiskSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiskSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDiskSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getDiskSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDiskSnapshot");
            GetDiskSnapshotResponse getDiskSnapshotResponse = (GetDiskSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDiskSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDiskSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDiskSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDiskSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getDiskSnapshot$165((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDiskSnapshotsResponse getDiskSnapshots(GetDiskSnapshotsRequest getDiskSnapshotsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiskSnapshotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDiskSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getDiskSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDiskSnapshots");
            GetDiskSnapshotsResponse getDiskSnapshotsResponse = (GetDiskSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDiskSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDiskSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDiskSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDiskSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getDiskSnapshots$167((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDisksResponse getDisks(GetDisksRequest getDisksRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDisksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDisksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getDisksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDisks");
            GetDisksResponse getDisksResponse = (GetDisksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDisks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDisksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDisksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDisksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getDisks$169((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDistributionBundlesResponse getDistributionBundles(GetDistributionBundlesRequest getDistributionBundlesRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionBundlesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDistributionBundlesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getDistributionBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionBundles");
            GetDistributionBundlesResponse getDistributionBundlesResponse = (GetDistributionBundlesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionBundles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDistributionBundlesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDistributionBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDistributionBundlesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getDistributionBundles$171((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDistributionLatestCacheResetResponse getDistributionLatestCacheReset(GetDistributionLatestCacheResetRequest getDistributionLatestCacheResetRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionLatestCacheResetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDistributionLatestCacheResetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getDistributionLatestCacheResetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionLatestCacheReset");
            GetDistributionLatestCacheResetResponse getDistributionLatestCacheResetResponse = (GetDistributionLatestCacheResetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionLatestCacheReset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDistributionLatestCacheResetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDistributionLatestCacheResetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDistributionLatestCacheResetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getDistributionLatestCacheReset$173((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDistributionMetricDataResponse getDistributionMetricData(GetDistributionMetricDataRequest getDistributionMetricDataRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionMetricDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDistributionMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getDistributionMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionMetricData");
            GetDistributionMetricDataResponse getDistributionMetricDataResponse = (GetDistributionMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDistributionMetricDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDistributionMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDistributionMetricDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getDistributionMetricData$175((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDistributionsResponse getDistributions(GetDistributionsRequest getDistributionsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDistributionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getDistributionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributions");
            GetDistributionsResponse getDistributionsResponse = (GetDistributionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDistributionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDistributionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDistributionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getDistributions$177((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainResponse getDomain(GetDomainRequest getDomainRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomain");
            GetDomainResponse getDomainResponse = (GetDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getDomain$179((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainsResponse getDomains(GetDomainsRequest getDomainsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getDomainsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomains");
            GetDomainsResponse getDomainsResponse = (GetDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomains").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDomainsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getDomains$181((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExportSnapshotRecordsResponse getExportSnapshotRecords(GetExportSnapshotRecordsRequest getExportSnapshotRecordsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExportSnapshotRecordsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExportSnapshotRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getExportSnapshotRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExportSnapshotRecords");
            GetExportSnapshotRecordsResponse getExportSnapshotRecordsResponse = (GetExportSnapshotRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExportSnapshotRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getExportSnapshotRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetExportSnapshotRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getExportSnapshotRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getExportSnapshotRecords$183((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstanceResponse getInstance(GetInstanceRequest getInstanceRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstance");
            GetInstanceResponse getInstanceResponse = (GetInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getInstance$185((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstanceAccessDetailsResponse getInstanceAccessDetails(GetInstanceAccessDetailsRequest getInstanceAccessDetailsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceAccessDetailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceAccessDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getInstanceAccessDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceAccessDetails");
            GetInstanceAccessDetailsResponse getInstanceAccessDetailsResponse = (GetInstanceAccessDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceAccessDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInstanceAccessDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstanceAccessDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstanceAccessDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getInstanceAccessDetails$187((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstanceMetricDataResponse getInstanceMetricData(GetInstanceMetricDataRequest getInstanceMetricDataRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceMetricDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getInstanceMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceMetricData");
            GetInstanceMetricDataResponse getInstanceMetricDataResponse = (GetInstanceMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInstanceMetricDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstanceMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstanceMetricDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getInstanceMetricData$189((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstancePortStatesResponse getInstancePortStates(GetInstancePortStatesRequest getInstancePortStatesRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstancePortStatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstancePortStatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getInstancePortStatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstancePortStates");
            GetInstancePortStatesResponse getInstancePortStatesResponse = (GetInstancePortStatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstancePortStates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInstancePortStatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstancePortStatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstancePortStatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getInstancePortStates$191((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstanceSnapshotResponse getInstanceSnapshot(GetInstanceSnapshotRequest getInstanceSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getInstanceSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceSnapshot");
            GetInstanceSnapshotResponse getInstanceSnapshotResponse = (GetInstanceSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInstanceSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstanceSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstanceSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getInstanceSnapshot$193((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstanceSnapshotsResponse getInstanceSnapshots(GetInstanceSnapshotsRequest getInstanceSnapshotsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceSnapshotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getInstanceSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceSnapshots");
            GetInstanceSnapshotsResponse getInstanceSnapshotsResponse = (GetInstanceSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInstanceSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstanceSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstanceSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getInstanceSnapshots$195((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstanceStateResponse getInstanceState(GetInstanceStateRequest getInstanceStateRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getInstanceStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceState");
            GetInstanceStateResponse getInstanceStateResponse = (GetInstanceStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInstanceStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstanceStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstanceStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getInstanceState$197((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstancesResponse getInstances(GetInstancesRequest getInstancesRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstances");
            GetInstancesResponse getInstancesResponse = (GetInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getInstances$199((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyPairResponse getKeyPair(GetKeyPairRequest getKeyPairRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyPairResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyPair");
            GetKeyPairResponse getKeyPairResponse = (GetKeyPairResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getKeyPairRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKeyPairResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getKeyPair$201((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyPairsResponse getKeyPairs(GetKeyPairsRequest getKeyPairsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyPairsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getKeyPairsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getKeyPairsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyPairs");
            GetKeyPairsResponse getKeyPairsResponse = (GetKeyPairsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyPairs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getKeyPairsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKeyPairsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKeyPairsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getKeyPairs$203((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLoadBalancerResponse getLoadBalancer(GetLoadBalancerRequest getLoadBalancerRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoadBalancerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancer");
            GetLoadBalancerResponse getLoadBalancerResponse = (GetLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLoadBalancerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLoadBalancerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getLoadBalancer$205((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLoadBalancerMetricDataResponse getLoadBalancerMetricData(GetLoadBalancerMetricDataRequest getLoadBalancerMetricDataRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerMetricDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoadBalancerMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getLoadBalancerMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancerMetricData");
            GetLoadBalancerMetricDataResponse getLoadBalancerMetricDataResponse = (GetLoadBalancerMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancerMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLoadBalancerMetricDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLoadBalancerMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLoadBalancerMetricDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getLoadBalancerMetricData$207((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLoadBalancerTlsCertificatesResponse getLoadBalancerTlsCertificates(GetLoadBalancerTlsCertificatesRequest getLoadBalancerTlsCertificatesRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerTlsCertificatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoadBalancerTlsCertificatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getLoadBalancerTlsCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancerTlsCertificates");
            GetLoadBalancerTlsCertificatesResponse getLoadBalancerTlsCertificatesResponse = (GetLoadBalancerTlsCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancerTlsCertificates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLoadBalancerTlsCertificatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLoadBalancerTlsCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLoadBalancerTlsCertificatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getLoadBalancerTlsCertificates$209((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLoadBalancerTlsPoliciesResponse getLoadBalancerTlsPolicies(GetLoadBalancerTlsPoliciesRequest getLoadBalancerTlsPoliciesRequest) throws ServiceException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, InvalidInputException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerTlsPoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoadBalancerTlsPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getLoadBalancerTlsPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancerTlsPolicies");
            GetLoadBalancerTlsPoliciesResponse getLoadBalancerTlsPoliciesResponse = (GetLoadBalancerTlsPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancerTlsPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLoadBalancerTlsPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLoadBalancerTlsPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLoadBalancerTlsPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getLoadBalancerTlsPolicies$211((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLoadBalancersResponse getLoadBalancers(GetLoadBalancersRequest getLoadBalancersRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoadBalancersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getLoadBalancersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancers");
            GetLoadBalancersResponse getLoadBalancersResponse = (GetLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLoadBalancersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLoadBalancersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLoadBalancersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getLoadBalancers$213((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperationResponse getOperation(GetOperationRequest getOperationRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOperationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperation");
            GetOperationResponse getOperationResponse = (GetOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOperationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOperationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOperationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getOperation$215((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperationsResponse getOperations(GetOperationsRequest getOperationsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOperationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperations");
            GetOperationsResponse getOperationsResponse = (GetOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOperationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOperationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getOperations$217((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperationsForResourceResponse getOperationsForResource(GetOperationsForResourceRequest getOperationsForResourceRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOperationsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getOperationsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperationsForResource");
            GetOperationsForResourceResponse getOperationsForResourceResponse = (GetOperationsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperationsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOperationsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOperationsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOperationsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getOperationsForResource$219((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRegionsResponse getRegions(GetRegionsRequest getRegionsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRegionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRegionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRegionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRegions");
            GetRegionsResponse getRegionsResponse = (GetRegionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRegions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRegionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRegionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRegionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRegions$221((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseResponse getRelationalDatabase(GetRelationalDatabaseRequest getRelationalDatabaseRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabase");
            GetRelationalDatabaseResponse getRelationalDatabaseResponse = (GetRelationalDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabase$223((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseBlueprintsResponse getRelationalDatabaseBlueprints(GetRelationalDatabaseBlueprintsRequest getRelationalDatabaseBlueprintsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseBlueprintsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseBlueprintsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseBlueprintsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseBlueprints");
            GetRelationalDatabaseBlueprintsResponse getRelationalDatabaseBlueprintsResponse = (GetRelationalDatabaseBlueprintsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseBlueprints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseBlueprintsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseBlueprintsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseBlueprintsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabaseBlueprints$225((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseBundlesResponse getRelationalDatabaseBundles(GetRelationalDatabaseBundlesRequest getRelationalDatabaseBundlesRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseBundlesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseBundlesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseBundles");
            GetRelationalDatabaseBundlesResponse getRelationalDatabaseBundlesResponse = (GetRelationalDatabaseBundlesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseBundles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseBundlesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseBundlesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabaseBundles$227((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseEventsResponse getRelationalDatabaseEvents(GetRelationalDatabaseEventsRequest getRelationalDatabaseEventsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseEvents");
            GetRelationalDatabaseEventsResponse getRelationalDatabaseEventsResponse = (GetRelationalDatabaseEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabaseEvents$229((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseLogEventsResponse getRelationalDatabaseLogEvents(GetRelationalDatabaseLogEventsRequest getRelationalDatabaseLogEventsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseLogEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseLogEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseLogEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseLogEvents");
            GetRelationalDatabaseLogEventsResponse getRelationalDatabaseLogEventsResponse = (GetRelationalDatabaseLogEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseLogEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseLogEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseLogEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseLogEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabaseLogEvents$231((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseLogStreamsResponse getRelationalDatabaseLogStreams(GetRelationalDatabaseLogStreamsRequest getRelationalDatabaseLogStreamsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseLogStreamsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseLogStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseLogStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseLogStreams");
            GetRelationalDatabaseLogStreamsResponse getRelationalDatabaseLogStreamsResponse = (GetRelationalDatabaseLogStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseLogStreams").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseLogStreamsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseLogStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseLogStreamsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabaseLogStreams$233((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseMasterUserPasswordResponse getRelationalDatabaseMasterUserPassword(GetRelationalDatabaseMasterUserPasswordRequest getRelationalDatabaseMasterUserPasswordRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseMasterUserPasswordResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseMasterUserPasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseMasterUserPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseMasterUserPassword");
            GetRelationalDatabaseMasterUserPasswordResponse getRelationalDatabaseMasterUserPasswordResponse = (GetRelationalDatabaseMasterUserPasswordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseMasterUserPassword").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseMasterUserPasswordRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseMasterUserPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseMasterUserPasswordResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabaseMasterUserPassword$235((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseMetricDataResponse getRelationalDatabaseMetricData(GetRelationalDatabaseMetricDataRequest getRelationalDatabaseMetricDataRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseMetricDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseMetricData");
            GetRelationalDatabaseMetricDataResponse getRelationalDatabaseMetricDataResponse = (GetRelationalDatabaseMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseMetricDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseMetricDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabaseMetricData$237((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseParametersResponse getRelationalDatabaseParameters(GetRelationalDatabaseParametersRequest getRelationalDatabaseParametersRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseParametersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseParameters");
            GetRelationalDatabaseParametersResponse getRelationalDatabaseParametersResponse = (GetRelationalDatabaseParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabaseParameters$239((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseSnapshotResponse getRelationalDatabaseSnapshot(GetRelationalDatabaseSnapshotRequest getRelationalDatabaseSnapshotRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseSnapshot");
            GetRelationalDatabaseSnapshotResponse getRelationalDatabaseSnapshotResponse = (GetRelationalDatabaseSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabaseSnapshot$241((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabaseSnapshotsResponse getRelationalDatabaseSnapshots(GetRelationalDatabaseSnapshotsRequest getRelationalDatabaseSnapshotsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseSnapshotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabaseSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabaseSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseSnapshots");
            GetRelationalDatabaseSnapshotsResponse getRelationalDatabaseSnapshotsResponse = (GetRelationalDatabaseSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabaseSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabaseSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabaseSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabaseSnapshots$243((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRelationalDatabasesResponse getRelationalDatabases(GetRelationalDatabasesRequest getRelationalDatabasesRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRelationalDatabasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getRelationalDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabases");
            GetRelationalDatabasesResponse getRelationalDatabasesResponse = (GetRelationalDatabasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRelationalDatabasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRelationalDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRelationalDatabasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getRelationalDatabases$245((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSetupHistoryResponse getSetupHistory(GetSetupHistoryRequest getSetupHistoryRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSetupHistoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSetupHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getSetupHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSetupHistory");
            GetSetupHistoryResponse getSetupHistoryResponse = (GetSetupHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSetupHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSetupHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSetupHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSetupHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getSetupHistory$247((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStaticIpResponse getStaticIp(GetStaticIpRequest getStaticIpRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStaticIpResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getStaticIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStaticIp");
            GetStaticIpResponse getStaticIpResponse = (GetStaticIpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStaticIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getStaticIpRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getStaticIpResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getStaticIp$249((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStaticIpsResponse getStaticIps(GetStaticIpsRequest getStaticIpsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStaticIpsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getStaticIpsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, getStaticIpsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStaticIps");
            GetStaticIpsResponse getStaticIpsResponse = (GetStaticIpsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStaticIps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getStaticIpsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetStaticIpsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getStaticIpsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$getStaticIps$251((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportKeyPairResponse importKeyPair(ImportKeyPairRequest importKeyPairRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportKeyPairResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, importKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportKeyPair");
            ImportKeyPairResponse importKeyPairResponse = (ImportKeyPairResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importKeyPairRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importKeyPairResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$importKeyPair$253((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IsVpcPeeredResponse isVpcPeered(IsVpcPeeredRequest isVpcPeeredRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IsVpcPeeredResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)isVpcPeeredRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, isVpcPeeredRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IsVpcPeered");
            IsVpcPeeredResponse isVpcPeeredResponse = (IsVpcPeeredResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IsVpcPeered").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)isVpcPeeredRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new IsVpcPeeredRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return isVpcPeeredResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$isVpcPeered$255((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenInstancePublicPortsResponse openInstancePublicPorts(OpenInstancePublicPortsRequest openInstancePublicPortsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, OpenInstancePublicPortsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)openInstancePublicPortsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, openInstancePublicPortsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"OpenInstancePublicPorts");
            OpenInstancePublicPortsResponse openInstancePublicPortsResponse = (OpenInstancePublicPortsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("OpenInstancePublicPorts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)openInstancePublicPortsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new OpenInstancePublicPortsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return openInstancePublicPortsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$openInstancePublicPorts$257((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeerVpcResponse peerVpc(PeerVpcRequest peerVpcRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PeerVpcResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)peerVpcRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, peerVpcRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PeerVpc");
            PeerVpcResponse peerVpcResponse = (PeerVpcResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PeerVpc").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)peerVpcRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PeerVpcRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return peerVpcResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$peerVpc$259((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAlarmResponse putAlarm(PutAlarmRequest putAlarmRequest) throws ServiceException, InvalidInputException, OperationFailureException, AccessDeniedException, UnauthenticatedException, NotFoundException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, putAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAlarm");
            PutAlarmResponse putAlarmResponse = (PutAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$putAlarm$261((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutInstancePublicPortsResponse putInstancePublicPorts(PutInstancePublicPortsRequest putInstancePublicPortsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutInstancePublicPortsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putInstancePublicPortsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, putInstancePublicPortsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutInstancePublicPorts");
            PutInstancePublicPortsResponse putInstancePublicPortsResponse = (PutInstancePublicPortsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutInstancePublicPorts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putInstancePublicPortsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutInstancePublicPortsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putInstancePublicPortsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$putInstancePublicPorts$263((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootInstanceResponse rebootInstance(RebootInstanceRequest rebootInstanceRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rebootInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, rebootInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootInstance");
            RebootInstanceResponse rebootInstanceResponse = (RebootInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rebootInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebootInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rebootInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$rebootInstance$265((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootRelationalDatabaseResponse rebootRelationalDatabase(RebootRelationalDatabaseRequest rebootRelationalDatabaseRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootRelationalDatabaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rebootRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, rebootRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootRelationalDatabase");
            RebootRelationalDatabaseResponse rebootRelationalDatabaseResponse = (RebootRelationalDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rebootRelationalDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebootRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rebootRelationalDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$rebootRelationalDatabase$267((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterContainerImageResponse registerContainerImage(RegisterContainerImageRequest registerContainerImageRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterContainerImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerContainerImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, registerContainerImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterContainerImage");
            RegisterContainerImageResponse registerContainerImageResponse = (RegisterContainerImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterContainerImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerContainerImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterContainerImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerContainerImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$registerContainerImage$269((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleaseStaticIpResponse releaseStaticIp(ReleaseStaticIpRequest releaseStaticIpRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReleaseStaticIpResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)releaseStaticIpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, releaseStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReleaseStaticIp");
            ReleaseStaticIpResponse releaseStaticIpResponse = (ReleaseStaticIpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReleaseStaticIp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)releaseStaticIpRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReleaseStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return releaseStaticIpResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$releaseStaticIp$271((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetDistributionCacheResponse resetDistributionCache(ResetDistributionCacheRequest resetDistributionCacheRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetDistributionCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetDistributionCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, resetDistributionCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetDistributionCache");
            ResetDistributionCacheResponse resetDistributionCacheResponse = (ResetDistributionCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDistributionCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resetDistributionCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetDistributionCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resetDistributionCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$resetDistributionCache$273((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendContactMethodVerificationResponse sendContactMethodVerification(SendContactMethodVerificationRequest sendContactMethodVerificationRequest) throws ServiceException, InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendContactMethodVerificationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendContactMethodVerificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, sendContactMethodVerificationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendContactMethodVerification");
            SendContactMethodVerificationResponse sendContactMethodVerificationResponse = (SendContactMethodVerificationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendContactMethodVerification").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendContactMethodVerificationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendContactMethodVerificationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendContactMethodVerificationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$sendContactMethodVerification$275((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIpAddressTypeResponse setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetIpAddressTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setIpAddressTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, setIpAddressTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIpAddressType");
            SetIpAddressTypeResponse setIpAddressTypeResponse = (SetIpAddressTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIpAddressType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setIpAddressTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetIpAddressTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setIpAddressTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$setIpAddressType$277((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetResourceAccessForBucketResponse setResourceAccessForBucket(SetResourceAccessForBucketRequest setResourceAccessForBucketRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetResourceAccessForBucketResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setResourceAccessForBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, setResourceAccessForBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetResourceAccessForBucket");
            SetResourceAccessForBucketResponse setResourceAccessForBucketResponse = (SetResourceAccessForBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetResourceAccessForBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setResourceAccessForBucketRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetResourceAccessForBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setResourceAccessForBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$setResourceAccessForBucket$279((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetupInstanceHttpsResponse setupInstanceHttps(SetupInstanceHttpsRequest setupInstanceHttpsRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetupInstanceHttpsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setupInstanceHttpsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, setupInstanceHttpsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetupInstanceHttps");
            SetupInstanceHttpsResponse setupInstanceHttpsResponse = (SetupInstanceHttpsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetupInstanceHttps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setupInstanceHttpsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetupInstanceHttpsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setupInstanceHttpsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$setupInstanceHttps$281((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartGuiSessionResponse startGUISession(StartGuiSessionRequest startGuiSessionRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartGuiSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startGuiSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, startGuiSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartGUISession");
            StartGuiSessionResponse startGuiSessionResponse = (StartGuiSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartGUISession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startGuiSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartGuiSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startGuiSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$startGUISession$283((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartInstanceResponse startInstance(StartInstanceRequest startInstanceRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, startInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartInstance");
            StartInstanceResponse startInstanceResponse = (StartInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$startInstance$285((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartRelationalDatabaseResponse startRelationalDatabase(StartRelationalDatabaseRequest startRelationalDatabaseRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRelationalDatabaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, startRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRelationalDatabase");
            StartRelationalDatabaseResponse startRelationalDatabaseResponse = (StartRelationalDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startRelationalDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startRelationalDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$startRelationalDatabase$287((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopGuiSessionResponse stopGUISession(StopGuiSessionRequest stopGuiSessionRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopGuiSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopGuiSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, stopGuiSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopGUISession");
            StopGuiSessionResponse stopGuiSessionResponse = (StopGuiSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopGUISession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopGuiSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopGuiSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopGuiSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$stopGUISession$289((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopInstanceResponse stopInstance(StopInstanceRequest stopInstanceRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, stopInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopInstance");
            StopInstanceResponse stopInstanceResponse = (StopInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$stopInstance$291((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopRelationalDatabaseResponse stopRelationalDatabase(StopRelationalDatabaseRequest stopRelationalDatabaseRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopRelationalDatabaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, stopRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopRelationalDatabase");
            StopRelationalDatabaseResponse stopRelationalDatabaseResponse = (StopRelationalDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopRelationalDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopRelationalDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$stopRelationalDatabase$293((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$tagResource$295((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestAlarmResponse testAlarm(TestAlarmRequest testAlarmRequest) throws ServiceException, InvalidInputException, OperationFailureException, UnauthenticatedException, AccessDeniedException, NotFoundException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)testAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, testAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestAlarm");
            TestAlarmResponse testAlarmResponse = (TestAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)testAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TestAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$testAlarm$297((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnpeerVpcResponse unpeerVpc(UnpeerVpcRequest unpeerVpcRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnpeerVpcResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unpeerVpcRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, unpeerVpcRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnpeerVpc");
            UnpeerVpcResponse unpeerVpcResponse = (UnpeerVpcResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnpeerVpc").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)unpeerVpcRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnpeerVpcRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unpeerVpcResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$unpeerVpc$299((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$untagResource$301((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBucketResponse updateBucket(UpdateBucketRequest updateBucketRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBucketResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, updateBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBucket");
            UpdateBucketResponse updateBucketResponse = (UpdateBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBucketRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$updateBucket$303((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBucketBundleResponse updateBucketBundle(UpdateBucketBundleRequest updateBucketBundleRequest) throws AccessDeniedException, InvalidInputException, NotFoundException, ServiceException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBucketBundleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBucketBundleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, updateBucketBundleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBucketBundle");
            UpdateBucketBundleResponse updateBucketBundleResponse = (UpdateBucketBundleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBucketBundle").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBucketBundleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBucketBundleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBucketBundleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$updateBucketBundle$305((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContainerServiceResponse updateContainerService(UpdateContainerServiceRequest updateContainerServiceRequest) throws ServiceException, InvalidInputException, NotFoundException, AccessDeniedException, UnauthenticatedException, RegionSetupInProgressException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContainerServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContainerServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, updateContainerServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContainerService");
            UpdateContainerServiceResponse updateContainerServiceResponse = (UpdateContainerServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContainerService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateContainerServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateContainerServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateContainerServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$updateContainerService$307((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDistributionResponse updateDistribution(UpdateDistributionRequest updateDistributionRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDistributionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDistributionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, updateDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDistribution");
            UpdateDistributionResponse updateDistributionResponse = (UpdateDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistribution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDistributionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDistributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$updateDistribution$309((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDistributionBundleResponse updateDistributionBundle(UpdateDistributionBundleRequest updateDistributionBundleRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDistributionBundleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDistributionBundleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, updateDistributionBundleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDistributionBundle");
            UpdateDistributionBundleResponse updateDistributionBundleResponse = (UpdateDistributionBundleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistributionBundle").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDistributionBundleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDistributionBundleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDistributionBundleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$updateDistributionBundle$311((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainEntryResponse updateDomainEntry(UpdateDomainEntryRequest updateDomainEntryRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainEntryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDomainEntryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, updateDomainEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainEntry");
            UpdateDomainEntryResponse updateDomainEntryResponse = (UpdateDomainEntryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainEntry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDomainEntryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDomainEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDomainEntryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$updateDomainEntry$313((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateInstanceMetadataOptionsResponse updateInstanceMetadataOptions(UpdateInstanceMetadataOptionsRequest updateInstanceMetadataOptionsRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInstanceMetadataOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateInstanceMetadataOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, updateInstanceMetadataOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateInstanceMetadataOptions");
            UpdateInstanceMetadataOptionsResponse updateInstanceMetadataOptionsResponse = (UpdateInstanceMetadataOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInstanceMetadataOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateInstanceMetadataOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateInstanceMetadataOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateInstanceMetadataOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$updateInstanceMetadataOptions$315((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLoadBalancerAttributeResponse updateLoadBalancerAttribute(UpdateLoadBalancerAttributeRequest updateLoadBalancerAttributeRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLoadBalancerAttributeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLoadBalancerAttributeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, updateLoadBalancerAttributeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLoadBalancerAttribute");
            UpdateLoadBalancerAttributeResponse updateLoadBalancerAttributeResponse = (UpdateLoadBalancerAttributeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLoadBalancerAttribute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateLoadBalancerAttributeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLoadBalancerAttributeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLoadBalancerAttributeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$updateLoadBalancerAttribute$317((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRelationalDatabaseResponse updateRelationalDatabase(UpdateRelationalDatabaseRequest updateRelationalDatabaseRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRelationalDatabaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRelationalDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, updateRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRelationalDatabase");
            UpdateRelationalDatabaseResponse updateRelationalDatabaseResponse = (UpdateRelationalDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRelationalDatabase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateRelationalDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRelationalDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$updateRelationalDatabase$319((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRelationalDatabaseParametersResponse updateRelationalDatabaseParameters(UpdateRelationalDatabaseParametersRequest updateRelationalDatabaseParametersRequest) throws ServiceException, InvalidInputException, NotFoundException, OperationFailureException, AccessDeniedException, AccountSetupInProgressException, RegionSetupInProgressException, UnauthenticatedException, AwsServiceException, SdkClientException, LightsailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRelationalDatabaseParametersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnauthenticatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthenticatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthenticatedException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "AccountSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSetupInProgressException::builder).build());
                }
                case "RegionSetupInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionSetupInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegionSetupInProgressException::builder).build());
                }
                case "OperationFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationFailureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationFailureException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRelationalDatabaseParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLightsailClient.resolveMetricPublishers(clientConfiguration, updateRelationalDatabaseParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRelationalDatabaseParameters");
            UpdateRelationalDatabaseParametersResponse updateRelationalDatabaseParametersResponse = (UpdateRelationalDatabaseParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRelationalDatabaseParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateRelationalDatabaseParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRelationalDatabaseParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRelationalDatabaseParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLightsailClient.lambda$updateRelationalDatabaseParameters$321((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "lightsail";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        LightsailServiceClientConfigurationBuilder serviceConfigBuilder = new LightsailServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LightsailException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final LightsailServiceClientConfiguration serviceClientConfiguration() {
        return new LightsailServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateRelationalDatabaseParameters$321(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRelationalDatabase$319(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLoadBalancerAttribute$317(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateInstanceMetadataOptions$315(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomainEntry$313(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDistributionBundle$311(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDistribution$309(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContainerService$307(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBucketBundle$305(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBucket$303(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$301(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unpeerVpc$299(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testAlarm$297(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$295(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopRelationalDatabase$293(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopInstance$291(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopGUISession$289(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRelationalDatabase$287(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startInstance$285(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startGUISession$283(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setupInstanceHttps$281(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setResourceAccessForBucket$279(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIpAddressType$277(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendContactMethodVerification$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetDistributionCache$273(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$releaseStaticIp$271(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerContainerImage$269(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootRelationalDatabase$267(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootInstance$265(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putInstancePublicPorts$263(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAlarm$261(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$peerVpc$259(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$openInstancePublicPorts$257(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$isVpcPeered$255(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importKeyPair$253(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStaticIps$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStaticIp$249(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSetupHistory$247(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabases$245(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseSnapshots$243(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseSnapshot$241(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseParameters$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseMetricData$237(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseMasterUserPassword$235(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseLogStreams$233(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseLogEvents$231(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseEvents$229(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseBundles$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseBlueprints$225(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabase$223(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRegions$221(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperationsForResource$219(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperations$217(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperation$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancers$213(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancerTlsPolicies$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancerTlsCertificates$209(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancerMetricData$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancer$205(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyPairs$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyPair$201(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstances$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceState$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceSnapshots$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceSnapshot$193(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstancePortStates$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceMetricData$189(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceAccessDetails$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstance$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExportSnapshotRecords$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomains$181(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomain$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributions$177(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionMetricData$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionLatestCacheReset$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionBundles$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDisks$169(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDiskSnapshots$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDiskSnapshot$165(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDisk$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostEstimate$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServices$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServicePowers$157(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServiceMetricData$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServiceDeployments$153(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerLog$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerImages$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerAPIMetadata$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContactMethods$145(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCloudFormationStackRecords$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificates$141(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBundles$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBuckets$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketMetricData$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketBundles$133(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketAccessKeys$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBlueprints$129(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAutoSnapshots$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAlarms$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getActiveNames$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportSnapshot$121(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableAddOn$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$downloadDefaultKeyPair$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableAddOn$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachStaticIp$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachInstancesFromLoadBalancer$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachDisk$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachCertificateFromDistribution$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRelationalDatabaseSnapshot$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRelationalDatabase$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoadBalancerTlsCertificate$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoadBalancer$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKnownHostKeys$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKeyPair$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInstanceSnapshot$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInstance$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomainEntry$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomain$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDistribution$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDiskSnapshot$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDisk$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContainerService$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContainerImage$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContactMethod$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCertificate$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketAccessKey$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucket$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAutoSnapshot$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAlarm$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRelationalDatabaseSnapshot$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRelationalDatabaseFromSnapshot$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRelationalDatabase$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLoadBalancerTlsCertificate$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLoadBalancer$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKeyPair$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInstancesFromSnapshot$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInstances$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInstanceSnapshot$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGUISessionAccessDetails$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomainEntry$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomain$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDistribution$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDiskSnapshot$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDiskFromSnapshot$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDisk$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContainerServiceRegistryLogin$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContainerServiceDeployment$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContainerService$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContactMethod$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCloudFormationStack$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCertificate$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBucketAccessKey$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBucket$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copySnapshot$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$closeInstancePublicPorts$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachStaticIp$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachLoadBalancerTlsCertificate$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachInstancesToLoadBalancer$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachDisk$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachCertificateToDistribution$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$allocateStaticIp$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

