/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CertificateProvider;
import software.amazon.awssdk.services.lightsail.model.SetupDomainNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetupRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SetupRequest> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(SetupRequest.getter(SetupRequest::instanceName)).setter(SetupRequest.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<List<String>> DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("domainNames").getter(SetupRequest.getter(SetupRequest::domainNames)).setter(SetupRequest.setter(Builder::domainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CERTIFICATE_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateProvider").getter(SetupRequest.getter(SetupRequest::certificateProviderAsString)).setter(SetupRequest.setter(Builder::certificateProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD, DOMAIN_NAMES_FIELD, CERTIFICATE_PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetupRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceName;
    private final List<String> domainNames;
    private final String certificateProvider;

    private SetupRequest(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.domainNames = builder.domainNames;
        this.certificateProvider = builder.certificateProvider;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final boolean hasDomainNames() {
        return this.domainNames != null && !(this.domainNames instanceof SdkAutoConstructList);
    }

    public final List<String> domainNames() {
        return this.domainNames;
    }

    public final CertificateProvider certificateProvider() {
        return CertificateProvider.fromValue(this.certificateProvider);
    }

    public final String certificateProviderAsString() {
        return this.certificateProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainNames() ? this.domainNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateProviderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetupRequest)) {
            return false;
        }
        SetupRequest other = (SetupRequest)obj;
        return Objects.equals(this.instanceName(), other.instanceName()) && this.hasDomainNames() == other.hasDomainNames() && Objects.equals(this.domainNames(), other.domainNames()) && Objects.equals(this.certificateProviderAsString(), other.certificateProviderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SetupRequest").add("InstanceName", (Object)this.instanceName()).add("DomainNames", this.hasDomainNames() ? this.domainNames() : null).add("CertificateProvider", (Object)this.certificateProviderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "domainNames": {
                return Optional.ofNullable(clazz.cast(this.domainNames()));
            }
            case "certificateProvider": {
                return Optional.ofNullable(clazz.cast(this.certificateProviderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceName", INSTANCE_NAME_FIELD);
        map.put("domainNames", DOMAIN_NAMES_FIELD);
        map.put("certificateProvider", CERTIFICATE_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetupRequest, T> g) {
        return obj -> g.apply((SetupRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceName;
        private List<String> domainNames = DefaultSdkAutoConstructList.getInstance();
        private String certificateProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(SetupRequest model) {
            this.instanceName(model.instanceName);
            this.domainNames(model.domainNames);
            this.certificateProvider(model.certificateProvider);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final Collection<String> getDomainNames() {
            if (this.domainNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainNames;
        }

        public final void setDomainNames(Collection<String> domainNames) {
            this.domainNames = SetupDomainNameListCopier.copy(domainNames);
        }

        @Override
        public final Builder domainNames(Collection<String> domainNames) {
            this.domainNames = SetupDomainNameListCopier.copy(domainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNames(String ... domainNames) {
            this.domainNames(Arrays.asList(domainNames));
            return this;
        }

        public final String getCertificateProvider() {
            return this.certificateProvider;
        }

        public final void setCertificateProvider(String certificateProvider) {
            this.certificateProvider = certificateProvider;
        }

        @Override
        public final Builder certificateProvider(String certificateProvider) {
            this.certificateProvider = certificateProvider;
            return this;
        }

        @Override
        public final Builder certificateProvider(CertificateProvider certificateProvider) {
            this.certificateProvider(certificateProvider == null ? null : certificateProvider.toString());
            return this;
        }

        public SetupRequest build() {
            return new SetupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SetupRequest> {
        public Builder instanceName(String var1);

        public Builder domainNames(Collection<String> var1);

        public Builder domainNames(String ... var1);

        public Builder certificateProvider(String var1);

        public Builder certificateProvider(CertificateProvider var1);
    }
}

