/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstancePortStatesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetInstancePortStatesResponse.Builder, GetInstancePortStatesResponse> {
    private static final SdkField<List<InstancePortState>> PORT_STATES_FIELD = SdkField
            .<List<InstancePortState>> builder(MarshallingType.LIST)
            .getter(getter(GetInstancePortStatesResponse::portStates))
            .setter(setter(Builder::portStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstancePortState> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstancePortState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_STATES_FIELD));

    private final List<InstancePortState> portStates;

    private GetInstancePortStatesResponse(BuilderImpl builder) {
        super(builder);
        this.portStates = builder.portStates;
    }

    /**
     * <p>
     * Information about the port states resulting from your request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the port states resulting from your request.
     */
    public List<InstancePortState> portStates() {
        return portStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(portStates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancePortStatesResponse)) {
            return false;
        }
        GetInstancePortStatesResponse other = (GetInstancePortStatesResponse) obj;
        return Objects.equals(portStates(), other.portStates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetInstancePortStatesResponse").add("PortStates", portStates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portStates":
            return Optional.ofNullable(clazz.cast(portStates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstancePortStatesResponse, T> g) {
        return obj -> g.apply((GetInstancePortStatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInstancePortStatesResponse> {
        /**
         * <p>
         * Information about the port states resulting from your request.
         * </p>
         * 
         * @param portStates
         *        Information about the port states resulting from your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portStates(Collection<InstancePortState> portStates);

        /**
         * <p>
         * Information about the port states resulting from your request.
         * </p>
         * 
         * @param portStates
         *        Information about the port states resulting from your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portStates(InstancePortState... portStates);

        /**
         * <p>
         * Information about the port states resulting from your request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstancePortState>.Builder} avoiding the
         * need to create one manually via {@link List<InstancePortState>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstancePortState>.Builder#build()} is called immediately
         * and its result is passed to {@link #portStates(List<InstancePortState>)}.
         * 
         * @param portStates
         *        a consumer that will call methods on {@link List<InstancePortState>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portStates(List<InstancePortState>)
         */
        Builder portStates(Consumer<InstancePortState.Builder>... portStates);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<InstancePortState> portStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancePortStatesResponse model) {
            super(model);
            portStates(model.portStates);
        }

        public final Collection<InstancePortState.Builder> getPortStates() {
            return portStates != null ? portStates.stream().map(InstancePortState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portStates(Collection<InstancePortState> portStates) {
            this.portStates = InstancePortStateListCopier.copy(portStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(InstancePortState... portStates) {
            portStates(Arrays.asList(portStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(Consumer<InstancePortState.Builder>... portStates) {
            portStates(Stream.of(portStates).map(c -> InstancePortState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPortStates(Collection<InstancePortState.BuilderImpl> portStates) {
            this.portStates = InstancePortStateListCopier.copyFromBuilder(portStates);
        }

        @Override
        public GetInstancePortStatesResponse build() {
            return new GetInstancePortStatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
