/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabase;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabasesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetRelationalDatabasesResponse> {
    private static final SdkField<List<RelationalDatabase>> RELATIONAL_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetRelationalDatabasesResponse.getter(GetRelationalDatabasesResponse::relationalDatabases)).setter(GetRelationalDatabasesResponse.setter(Builder::relationalDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelationalDatabase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRelationalDatabasesResponse.getter(GetRelationalDatabasesResponse::nextPageToken)).setter(GetRelationalDatabasesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<RelationalDatabase> relationalDatabases;
    private final String nextPageToken;

    private GetRelationalDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.relationalDatabases = builder.relationalDatabases;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<RelationalDatabase> relationalDatabases() {
        return this.relationalDatabases;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabasesResponse)) {
            return false;
        }
        GetRelationalDatabasesResponse other = (GetRelationalDatabasesResponse)((Object)obj);
        return Objects.equals(this.relationalDatabases(), other.relationalDatabases()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetRelationalDatabasesResponse").add("RelationalDatabases", this.relationalDatabases()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabases": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabases()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabasesResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<RelationalDatabase> relationalDatabases = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabasesResponse model) {
            super(model);
            this.relationalDatabases(model.relationalDatabases);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<RelationalDatabase.Builder> getRelationalDatabases() {
            return this.relationalDatabases != null ? (Collection)this.relationalDatabases.stream().map(RelationalDatabase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relationalDatabases(Collection<RelationalDatabase> relationalDatabases) {
            this.relationalDatabases = RelationalDatabaseListCopier.copy(relationalDatabases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabases(RelationalDatabase ... relationalDatabases) {
            this.relationalDatabases(Arrays.asList(relationalDatabases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabases(Consumer<RelationalDatabase.Builder> ... relationalDatabases) {
            this.relationalDatabases(Stream.of(relationalDatabases).map(c -> (RelationalDatabase)((RelationalDatabase.Builder)RelationalDatabase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelationalDatabases(Collection<RelationalDatabase.BuilderImpl> relationalDatabases) {
            this.relationalDatabases = RelationalDatabaseListCopier.copyFromBuilder(relationalDatabases);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetRelationalDatabasesResponse build() {
            return new GetRelationalDatabasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabasesResponse> {
        public Builder relationalDatabases(Collection<RelationalDatabase> var1);

        public Builder relationalDatabases(RelationalDatabase ... var1);

        public Builder relationalDatabases(Consumer<RelationalDatabase.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

