/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the source of an export snapshot record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportSnapshotRecordSourceInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportSnapshotRecordSourceInfo.Builder, ExportSnapshotRecordSourceInfo> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportSnapshotRecordSourceInfo::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ExportSnapshotRecordSourceInfo::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportSnapshotRecordSourceInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportSnapshotRecordSourceInfo::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> FROM_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportSnapshotRecordSourceInfo::fromResourceName)).setter(setter(Builder::fromResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromResourceName").build()).build();

    private static final SdkField<String> FROM_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportSnapshotRecordSourceInfo::fromResourceArn)).setter(setter(Builder::fromResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromResourceArn").build()).build();

    private static final SdkField<InstanceSnapshotInfo> INSTANCE_SNAPSHOT_INFO_FIELD = SdkField
            .<InstanceSnapshotInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExportSnapshotRecordSourceInfo::instanceSnapshotInfo)).setter(setter(Builder::instanceSnapshotInfo))
            .constructor(InstanceSnapshotInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceSnapshotInfo").build())
            .build();

    private static final SdkField<DiskSnapshotInfo> DISK_SNAPSHOT_INFO_FIELD = SdkField
            .<DiskSnapshotInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExportSnapshotRecordSourceInfo::diskSnapshotInfo)).setter(setter(Builder::diskSnapshotInfo))
            .constructor(DiskSnapshotInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSnapshotInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            CREATED_AT_FIELD, NAME_FIELD, ARN_FIELD, FROM_RESOURCE_NAME_FIELD, FROM_RESOURCE_ARN_FIELD,
            INSTANCE_SNAPSHOT_INFO_FIELD, DISK_SNAPSHOT_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final Instant createdAt;

    private final String name;

    private final String arn;

    private final String fromResourceName;

    private final String fromResourceArn;

    private final InstanceSnapshotInfo instanceSnapshotInfo;

    private final DiskSnapshotInfo diskSnapshotInfo;

    private ExportSnapshotRecordSourceInfo(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.name = builder.name;
        this.arn = builder.arn;
        this.fromResourceName = builder.fromResourceName;
        this.fromResourceArn = builder.fromResourceArn;
        this.instanceSnapshotInfo = builder.instanceSnapshotInfo;
        this.diskSnapshotInfo = builder.diskSnapshotInfo;
    }

    /**
     * <p>
     * The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or <code>DiskSnapshot</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ExportSnapshotRecordSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or <code>DiskSnapshot</code>).
     * @see ExportSnapshotRecordSourceType
     */
    public ExportSnapshotRecordSourceType resourceType() {
        return ExportSnapshotRecordSourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or <code>DiskSnapshot</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ExportSnapshotRecordSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or <code>DiskSnapshot</code>).
     * @see ExportSnapshotRecordSourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The date when the source instance or disk snapshot was created.
     * </p>
     * 
     * @return The date when the source instance or disk snapshot was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The name of the source instance or disk snapshot.
     * </p>
     * 
     * @return The name of the source instance or disk snapshot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source instance or disk snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source instance or disk snapshot.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the snapshot's source instance or disk.
     * </p>
     * 
     * @return The name of the snapshot's source instance or disk.
     */
    public String fromResourceName() {
        return fromResourceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot's source instance or disk.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot's source instance or disk.
     */
    public String fromResourceArn() {
        return fromResourceArn;
    }

    /**
     * <p>
     * A list of objects describing an instance snapshot.
     * </p>
     * 
     * @return A list of objects describing an instance snapshot.
     */
    public InstanceSnapshotInfo instanceSnapshotInfo() {
        return instanceSnapshotInfo;
    }

    /**
     * <p>
     * A list of objects describing a disk snapshot.
     * </p>
     * 
     * @return A list of objects describing a disk snapshot.
     */
    public DiskSnapshotInfo diskSnapshotInfo() {
        return diskSnapshotInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(fromResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(fromResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceSnapshotInfo());
        hashCode = 31 * hashCode + Objects.hashCode(diskSnapshotInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSnapshotRecordSourceInfo)) {
            return false;
        }
        ExportSnapshotRecordSourceInfo other = (ExportSnapshotRecordSourceInfo) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(name(), other.name())
                && Objects.equals(arn(), other.arn()) && Objects.equals(fromResourceName(), other.fromResourceName())
                && Objects.equals(fromResourceArn(), other.fromResourceArn())
                && Objects.equals(instanceSnapshotInfo(), other.instanceSnapshotInfo())
                && Objects.equals(diskSnapshotInfo(), other.diskSnapshotInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportSnapshotRecordSourceInfo").add("ResourceType", resourceTypeAsString())
                .add("CreatedAt", createdAt()).add("Name", name()).add("Arn", arn()).add("FromResourceName", fromResourceName())
                .add("FromResourceArn", fromResourceArn()).add("InstanceSnapshotInfo", instanceSnapshotInfo())
                .add("DiskSnapshotInfo", diskSnapshotInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "fromResourceName":
            return Optional.ofNullable(clazz.cast(fromResourceName()));
        case "fromResourceArn":
            return Optional.ofNullable(clazz.cast(fromResourceArn()));
        case "instanceSnapshotInfo":
            return Optional.ofNullable(clazz.cast(instanceSnapshotInfo()));
        case "diskSnapshotInfo":
            return Optional.ofNullable(clazz.cast(diskSnapshotInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportSnapshotRecordSourceInfo, T> g) {
        return obj -> g.apply((ExportSnapshotRecordSourceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportSnapshotRecordSourceInfo> {
        /**
         * <p>
         * The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or <code>DiskSnapshot</code>).
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or <code>DiskSnapshot</code>).
         * @see ExportSnapshotRecordSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportSnapshotRecordSourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or <code>DiskSnapshot</code>).
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or <code>DiskSnapshot</code>).
         * @see ExportSnapshotRecordSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportSnapshotRecordSourceType
         */
        Builder resourceType(ExportSnapshotRecordSourceType resourceType);

        /**
         * <p>
         * The date when the source instance or disk snapshot was created.
         * </p>
         * 
         * @param createdAt
         *        The date when the source instance or disk snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The name of the source instance or disk snapshot.
         * </p>
         * 
         * @param name
         *        The name of the source instance or disk snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source instance or disk snapshot.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the source instance or disk snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the snapshot's source instance or disk.
         * </p>
         * 
         * @param fromResourceName
         *        The name of the snapshot's source instance or disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromResourceName(String fromResourceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot's source instance or disk.
         * </p>
         * 
         * @param fromResourceArn
         *        The Amazon Resource Name (ARN) of the snapshot's source instance or disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromResourceArn(String fromResourceArn);

        /**
         * <p>
         * A list of objects describing an instance snapshot.
         * </p>
         * 
         * @param instanceSnapshotInfo
         *        A list of objects describing an instance snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshotInfo(InstanceSnapshotInfo instanceSnapshotInfo);

        /**
         * <p>
         * A list of objects describing an instance snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceSnapshotInfo.Builder} avoiding the need
         * to create one manually via {@link InstanceSnapshotInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceSnapshotInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceSnapshotInfo(InstanceSnapshotInfo)}.
         * 
         * @param instanceSnapshotInfo
         *        a consumer that will call methods on {@link InstanceSnapshotInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceSnapshotInfo(InstanceSnapshotInfo)
         */
        default Builder instanceSnapshotInfo(Consumer<InstanceSnapshotInfo.Builder> instanceSnapshotInfo) {
            return instanceSnapshotInfo(InstanceSnapshotInfo.builder().applyMutation(instanceSnapshotInfo).build());
        }

        /**
         * <p>
         * A list of objects describing a disk snapshot.
         * </p>
         * 
         * @param diskSnapshotInfo
         *        A list of objects describing a disk snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshotInfo(DiskSnapshotInfo diskSnapshotInfo);

        /**
         * <p>
         * A list of objects describing a disk snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link DiskSnapshotInfo.Builder} avoiding the need to
         * create one manually via {@link DiskSnapshotInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DiskSnapshotInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #diskSnapshotInfo(DiskSnapshotInfo)}.
         * 
         * @param diskSnapshotInfo
         *        a consumer that will call methods on {@link DiskSnapshotInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskSnapshotInfo(DiskSnapshotInfo)
         */
        default Builder diskSnapshotInfo(Consumer<DiskSnapshotInfo.Builder> diskSnapshotInfo) {
            return diskSnapshotInfo(DiskSnapshotInfo.builder().applyMutation(diskSnapshotInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private Instant createdAt;

        private String name;

        private String arn;

        private String fromResourceName;

        private String fromResourceArn;

        private InstanceSnapshotInfo instanceSnapshotInfo;

        private DiskSnapshotInfo diskSnapshotInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSnapshotRecordSourceInfo model) {
            resourceType(model.resourceType);
            createdAt(model.createdAt);
            name(model.name);
            arn(model.arn);
            fromResourceName(model.fromResourceName);
            fromResourceArn(model.fromResourceArn);
            instanceSnapshotInfo(model.instanceSnapshotInfo);
            diskSnapshotInfo(model.diskSnapshotInfo);
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ExportSnapshotRecordSourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getFromResourceName() {
            return fromResourceName;
        }

        @Override
        public final Builder fromResourceName(String fromResourceName) {
            this.fromResourceName = fromResourceName;
            return this;
        }

        public final void setFromResourceName(String fromResourceName) {
            this.fromResourceName = fromResourceName;
        }

        public final String getFromResourceArn() {
            return fromResourceArn;
        }

        @Override
        public final Builder fromResourceArn(String fromResourceArn) {
            this.fromResourceArn = fromResourceArn;
            return this;
        }

        public final void setFromResourceArn(String fromResourceArn) {
            this.fromResourceArn = fromResourceArn;
        }

        public final InstanceSnapshotInfo.Builder getInstanceSnapshotInfo() {
            return instanceSnapshotInfo != null ? instanceSnapshotInfo.toBuilder() : null;
        }

        @Override
        public final Builder instanceSnapshotInfo(InstanceSnapshotInfo instanceSnapshotInfo) {
            this.instanceSnapshotInfo = instanceSnapshotInfo;
            return this;
        }

        public final void setInstanceSnapshotInfo(InstanceSnapshotInfo.BuilderImpl instanceSnapshotInfo) {
            this.instanceSnapshotInfo = instanceSnapshotInfo != null ? instanceSnapshotInfo.build() : null;
        }

        public final DiskSnapshotInfo.Builder getDiskSnapshotInfo() {
            return diskSnapshotInfo != null ? diskSnapshotInfo.toBuilder() : null;
        }

        @Override
        public final Builder diskSnapshotInfo(DiskSnapshotInfo diskSnapshotInfo) {
            this.diskSnapshotInfo = diskSnapshotInfo;
            return this;
        }

        public final void setDiskSnapshotInfo(DiskSnapshotInfo.BuilderImpl diskSnapshotInfo) {
            this.diskSnapshotInfo = diskSnapshotInfo != null ? diskSnapshotInfo.build() : null;
        }

        @Override
        public ExportSnapshotRecordSourceInfo build() {
            return new ExportSnapshotRecordSourceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
