/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStaticIpRequest extends LightsailRequest implements
        ToCopyableBuilder<GetStaticIpRequest.Builder, GetStaticIpRequest> {
    private static final SdkField<String> STATIC_IP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetStaticIpRequest::staticIpName)).setter(setter(Builder::staticIpName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticIpName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_IP_NAME_FIELD));

    private final String staticIpName;

    private GetStaticIpRequest(BuilderImpl builder) {
        super(builder);
        this.staticIpName = builder.staticIpName;
    }

    /**
     * <p>
     * The name of the static IP in Lightsail.
     * </p>
     * 
     * @return The name of the static IP in Lightsail.
     */
    public String staticIpName() {
        return staticIpName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticIpName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStaticIpRequest)) {
            return false;
        }
        GetStaticIpRequest other = (GetStaticIpRequest) obj;
        return Objects.equals(staticIpName(), other.staticIpName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetStaticIpRequest").add("StaticIpName", staticIpName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "staticIpName":
            return Optional.ofNullable(clazz.cast(staticIpName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStaticIpRequest, T> g) {
        return obj -> g.apply((GetStaticIpRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetStaticIpRequest> {
        /**
         * <p>
         * The name of the static IP in Lightsail.
         * </p>
         * 
         * @param staticIpName
         *        The name of the static IP in Lightsail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticIpName(String staticIpName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String staticIpName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStaticIpRequest model) {
            super(model);
            staticIpName(model.staticIpName);
        }

        public final String getStaticIpName() {
            return staticIpName;
        }

        @Override
        public final Builder staticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
            return this;
        }

        public final void setStaticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStaticIpRequest build() {
            return new GetStaticIpRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
