/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the AWS Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Region implements SdkPojo, Serializable, ToCopyableBuilder<Region.Builder, Region> {
    private static final SdkField<String> CONTINENT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Region::continentCode)).setter(setter(Builder::continentCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continentCode").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Region::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Region::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Region::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AvailabilityZone>> builder(MarshallingType.LIST)
            .getter(getter(Region::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AvailabilityZone>> RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AvailabilityZone>> builder(MarshallingType.LIST)
            .getter(getter(Region::relationalDatabaseAvailabilityZones))
            .setter(setter(Builder::relationalDatabaseAvailabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("relationalDatabaseAvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINENT_CODE_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, NAME_FIELD, AVAILABILITY_ZONES_FIELD,
            RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String continentCode;

    private final String description;

    private final String displayName;

    private final String name;

    private final List<AvailabilityZone> availabilityZones;

    private final List<AvailabilityZone> relationalDatabaseAvailabilityZones;

    private Region(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.name = builder.name;
        this.availabilityZones = builder.availabilityZones;
        this.relationalDatabaseAvailabilityZones = builder.relationalDatabaseAvailabilityZones;
    }

    /**
     * <p>
     * The continent code (e.g., <code>NA</code>, meaning North America).
     * </p>
     * 
     * @return The continent code (e.g., <code>NA</code>, meaning North America).
     */
    public String continentCode() {
        return continentCode;
    }

    /**
     * <p>
     * The description of the AWS Region (e.g.,
     * <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>).
     * </p>
     * 
     * @return The description of the AWS Region (e.g.,
     *         <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>).
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The display name (e.g., <code>Ohio</code>).
     * </p>
     * 
     * @return The display name (e.g., <code>Ohio</code>).
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The region name (e.g., <code>us-east-2</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The region name (e.g., <code>us-east-2</code>).
     * @see RegionName
     */
    public RegionName name() {
        return RegionName.fromValue(name);
    }

    /**
     * <p>
     * The region name (e.g., <code>us-east-2</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The region name (e.g., <code>us-east-2</code>).
     * @see RegionName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
     */
    public List<AvailabilityZone> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
     */
    public List<AvailabilityZone> relationalDatabaseAvailabilityZones() {
        return relationalDatabaseAvailabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continentCode());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseAvailabilityZones());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region) obj;
        return Objects.equals(continentCode(), other.continentCode()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(relationalDatabaseAvailabilityZones(), other.relationalDatabaseAvailabilityZones());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Region").add("ContinentCode", continentCode()).add("Description", description())
                .add("DisplayName", displayName()).add("Name", nameAsString()).add("AvailabilityZones", availabilityZones())
                .add("RelationalDatabaseAvailabilityZones", relationalDatabaseAvailabilityZones()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "continentCode":
            return Optional.ofNullable(clazz.cast(continentCode()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "availabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "relationalDatabaseAvailabilityZones":
            return Optional.ofNullable(clazz.cast(relationalDatabaseAvailabilityZones()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Region, T> g) {
        return obj -> g.apply((Region) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Region> {
        /**
         * <p>
         * The continent code (e.g., <code>NA</code>, meaning North America).
         * </p>
         * 
         * @param continentCode
         *        The continent code (e.g., <code>NA</code>, meaning North America).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continentCode(String continentCode);

        /**
         * <p>
         * The description of the AWS Region (e.g.,
         * <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>).
         * </p>
         * 
         * @param description
         *        The description of the AWS Region (e.g.,
         *        <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name (e.g., <code>Ohio</code>).
         * </p>
         * 
         * @param displayName
         *        The display name (e.g., <code>Ohio</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The region name (e.g., <code>us-east-2</code>).
         * </p>
         * 
         * @param name
         *        The region name (e.g., <code>us-east-2</code>).
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder name(String name);

        /**
         * <p>
         * The region name (e.g., <code>us-east-2</code>).
         * </p>
         * 
         * @param name
         *        The region name (e.g., <code>us-east-2</code>).
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder name(RegionName name);

        /**
         * <p>
         * The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<AvailabilityZone> availabilityZones);

        /**
         * <p>
         * The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(AvailabilityZone... availabilityZones);

        /**
         * <p>
         * The Availability Zones. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * This is a convenience that creates an instance of the {@link List<AvailabilityZone>.Builder} avoiding the
         * need to create one manually via {@link List<AvailabilityZone>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AvailabilityZone>.Builder#build()} is called immediately and
         * its result is passed to {@link #availabilityZones(List<AvailabilityZone>)}.
         * 
         * @param availabilityZones
         *        a consumer that will call methods on {@link List<AvailabilityZone>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZones(List<AvailabilityZone>)
         */
        Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones);

        /**
         * <p>
         * The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param relationalDatabaseAvailabilityZones
         *        The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseAvailabilityZones(Collection<AvailabilityZone> relationalDatabaseAvailabilityZones);

        /**
         * <p>
         * The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param relationalDatabaseAvailabilityZones
         *        The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseAvailabilityZones(AvailabilityZone... relationalDatabaseAvailabilityZones);

        /**
         * <p>
         * The Availability Zones for databases. Follows the format <code>us-east-2a</code> (case-sensitive).
         * </p>
         * This is a convenience that creates an instance of the {@link List<AvailabilityZone>.Builder} avoiding the
         * need to create one manually via {@link List<AvailabilityZone>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AvailabilityZone>.Builder#build()} is called immediately and
         * its result is passed to {@link #relationalDatabaseAvailabilityZones(List<AvailabilityZone>)}.
         * 
         * @param relationalDatabaseAvailabilityZones
         *        a consumer that will call methods on {@link List<AvailabilityZone>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalDatabaseAvailabilityZones(List<AvailabilityZone>)
         */
        Builder relationalDatabaseAvailabilityZones(Consumer<AvailabilityZone.Builder>... relationalDatabaseAvailabilityZones);
    }

    static final class BuilderImpl implements Builder {
        private String continentCode;

        private String description;

        private String displayName;

        private String name;

        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<AvailabilityZone> relationalDatabaseAvailabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            continentCode(model.continentCode);
            description(model.description);
            displayName(model.displayName);
            name(model.name);
            availabilityZones(model.availabilityZones);
            relationalDatabaseAvailabilityZones(model.relationalDatabaseAvailabilityZones);
        }

        public final String getContinentCode() {
            return continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getNameAsString() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(RegionName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<AvailabilityZone.Builder> getAvailabilityZones() {
            return availabilityZones != null ? availabilityZones.stream().map(AvailabilityZone::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones) {
            availabilityZones(Stream.of(availabilityZones).map(c -> AvailabilityZone.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copyFromBuilder(availabilityZones);
        }

        public final Collection<AvailabilityZone.Builder> getRelationalDatabaseAvailabilityZones() {
            return relationalDatabaseAvailabilityZones != null ? relationalDatabaseAvailabilityZones.stream()
                    .map(AvailabilityZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relationalDatabaseAvailabilityZones(Collection<AvailabilityZone> relationalDatabaseAvailabilityZones) {
            this.relationalDatabaseAvailabilityZones = AvailabilityZoneListCopier.copy(relationalDatabaseAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseAvailabilityZones(AvailabilityZone... relationalDatabaseAvailabilityZones) {
            relationalDatabaseAvailabilityZones(Arrays.asList(relationalDatabaseAvailabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseAvailabilityZones(
                Consumer<AvailabilityZone.Builder>... relationalDatabaseAvailabilityZones) {
            relationalDatabaseAvailabilityZones(Stream.of(relationalDatabaseAvailabilityZones)
                    .map(c -> AvailabilityZone.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelationalDatabaseAvailabilityZones(
                Collection<AvailabilityZone.BuilderImpl> relationalDatabaseAvailabilityZones) {
            this.relationalDatabaseAvailabilityZones = AvailabilityZoneListCopier
                    .copyFromBuilder(relationalDatabaseAvailabilityZones);
        }

        @Override
        public Region build() {
            return new Region(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
