/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the destination of a record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationInfo implements SdkPojo, Serializable, ToCopyableBuilder<DestinationInfo.Builder, DestinationInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DestinationInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DestinationInfo::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SERVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String service;

    private DestinationInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.service = builder.service;
    }

    /**
     * <p>
     * The ID of the resource created at the destination.
     * </p>
     * 
     * @return The ID of the resource created at the destination.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The destination service of the record.
     * </p>
     * 
     * @return The destination service of the record.
     */
    public String service() {
        return service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationInfo)) {
            return false;
        }
        DestinationInfo other = (DestinationInfo) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(service(), other.service());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DestinationInfo").add("Id", id()).add("Service", service()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationInfo, T> g) {
        return obj -> g.apply((DestinationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationInfo> {
        /**
         * <p>
         * The ID of the resource created at the destination.
         * </p>
         * 
         * @param id
         *        The ID of the resource created at the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The destination service of the record.
         * </p>
         * 
         * @param service
         *        The destination service of the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String service;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationInfo model) {
            id(model.id);
            service(model.service);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getService() {
            return service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public DestinationInfo build() {
            return new DestinationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
