/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PasswordData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PasswordData> {
    private static final SdkField<String> CIPHERTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PasswordData.getter(PasswordData::ciphertext)).setter(PasswordData.setter(Builder::ciphertext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ciphertext").build()}).build();
    private static final SdkField<String> KEY_PAIR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PasswordData.getter(PasswordData::keyPairName)).setter(PasswordData.setter(Builder::keyPairName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIPHERTEXT_FIELD, KEY_PAIR_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ciphertext;
    private final String keyPairName;

    private PasswordData(BuilderImpl builder) {
        this.ciphertext = builder.ciphertext;
        this.keyPairName = builder.keyPairName;
    }

    public String ciphertext() {
        return this.ciphertext;
    }

    public String keyPairName() {
        return this.keyPairName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertext());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordData)) {
            return false;
        }
        PasswordData other = (PasswordData)obj;
        return Objects.equals(this.ciphertext(), other.ciphertext()) && Objects.equals(this.keyPairName(), other.keyPairName());
    }

    public String toString() {
        return ToString.builder((String)"PasswordData").add("Ciphertext", (Object)this.ciphertext()).add("KeyPairName", (Object)this.keyPairName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ciphertext": {
                return Optional.ofNullable(clazz.cast(this.ciphertext()));
            }
            case "keyPairName": {
                return Optional.ofNullable(clazz.cast(this.keyPairName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PasswordData, T> g) {
        return obj -> g.apply((PasswordData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ciphertext;
        private String keyPairName;

        private BuilderImpl() {
        }

        private BuilderImpl(PasswordData model) {
            this.ciphertext(model.ciphertext);
            this.keyPairName(model.keyPairName);
        }

        public final String getCiphertext() {
            return this.ciphertext;
        }

        @Override
        public final Builder ciphertext(String ciphertext) {
            this.ciphertext = ciphertext;
            return this;
        }

        public final void setCiphertext(String ciphertext) {
            this.ciphertext = ciphertext;
        }

        public final String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        public PasswordData build() {
            return new PasswordData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PasswordData> {
        public Builder ciphertext(String var1);

        public Builder keyPairName(String var1);
    }
}

