/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKeyPairsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetKeyPairsResponse.Builder, GetKeyPairsResponse> {
    private static final SdkField<List<KeyPair>> KEY_PAIRS_FIELD = SdkField
            .<List<KeyPair>> builder(MarshallingType.LIST)
            .getter(getter(GetKeyPairsResponse::keyPairs))
            .setter(setter(Builder::keyPairs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetKeyPairsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIRS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<KeyPair> keyPairs;

    private final String nextPageToken;

    private GetKeyPairsResponse(BuilderImpl builder) {
        super(builder);
        this.keyPairs = builder.keyPairs;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the key pairs.
     */
    public List<KeyPair> keyPairs() {
        return keyPairs;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get key pairs request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get key pairs request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyPairs());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyPairsResponse)) {
            return false;
        }
        GetKeyPairsResponse other = (GetKeyPairsResponse) obj;
        return Objects.equals(keyPairs(), other.keyPairs()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetKeyPairsResponse").add("KeyPairs", keyPairs()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyPairs":
            return Optional.ofNullable(clazz.cast(keyPairs()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKeyPairsResponse, T> g) {
        return obj -> g.apply((GetKeyPairsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKeyPairsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the key pairs.
         * </p>
         * 
         * @param keyPairs
         *        An array of key-value pairs containing information about the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(Collection<KeyPair> keyPairs);

        /**
         * <p>
         * An array of key-value pairs containing information about the key pairs.
         * </p>
         * 
         * @param keyPairs
         *        An array of key-value pairs containing information about the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(KeyPair... keyPairs);

        /**
         * <p>
         * An array of key-value pairs containing information about the key pairs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeyPair>.Builder} avoiding the need to
         * create one manually via {@link List<KeyPair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeyPair>.Builder#build()} is called immediately and its
         * result is passed to {@link #keyPairs(List<KeyPair>)}.
         * 
         * @param keyPairs
         *        a consumer that will call methods on {@link List<KeyPair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPairs(List<KeyPair>)
         */
        Builder keyPairs(Consumer<KeyPair.Builder>... keyPairs);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get key pairs request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get key pairs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<KeyPair> keyPairs = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyPairsResponse model) {
            super(model);
            keyPairs(model.keyPairs);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<KeyPair.Builder> getKeyPairs() {
            return keyPairs != null ? keyPairs.stream().map(KeyPair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPairs(Collection<KeyPair> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(KeyPair... keyPairs) {
            keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(Consumer<KeyPair.Builder>... keyPairs) {
            keyPairs(Stream.of(keyPairs).map(c -> KeyPair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPairs(Collection<KeyPair.BuilderImpl> keyPairs) {
            this.keyPairs = KeyPairListCopier.copyFromBuilder(keyPairs);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetKeyPairsResponse build() {
            return new GetKeyPairsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
