/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLoadBalancerMetricDataResponse extends LightsailResponse implements
        ToCopyableBuilder<GetLoadBalancerMetricDataResponse.Builder, GetLoadBalancerMetricDataResponse> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetLoadBalancerMetricDataResponse::metricNameAsString)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<List<MetricDatapoint>> METRIC_DATA_FIELD = SdkField
            .<List<MetricDatapoint>> builder(MarshallingType.LIST)
            .getter(getter(GetLoadBalancerMetricDataResponse::metricData))
            .setter(setter(Builder::metricData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDatapoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDatapoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            METRIC_DATA_FIELD));

    private final String metricName;

    private final List<MetricDatapoint> metricData;

    private GetLoadBalancerMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.metricData = builder.metricData;
    }

    /**
     * <p>
     * The metric about which you are receiving information. Valid values are listed below, along with the most useful
     * <code>statistics</code> to include in your request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that
     * did not establish a session with the load balancer. Possible causes include a mismatch of ciphers or protocols.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate from the
     * load balancer. Client errors are generated when requests are malformed or incomplete. These requests have not
     * been received by the target instance. This count does not include any response codes generated by the target
     * instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate from the
     * load balancer. This count does not include any response codes generated by the target instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
     * balancer until a response from the target instance is received.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
     * balancer had reached its maximum number of connections.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
     * requests with a response generated by a target instance of the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link LoadBalancerMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricNameAsString}.
     * </p>
     * 
     * @return The metric about which you are receiving information. Valid values are listed below, along with the most
     *         useful <code>statistics</code> to include in your request.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
     *         client that did not establish a session with the load balancer. Possible causes include a mismatch of
     *         ciphers or protocols.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *         <code>Maximum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *         <code>Maximum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate
     *         from the load balancer. Client errors are generated when requests are malformed or incomplete. These
     *         requests have not been received by the target instance. This count does not include any response codes
     *         generated by the target instances.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate
     *         from the load balancer. This count does not include any response codes generated by the target instances.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the
     *         load balancer until a response from the target instance is received.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the
     *         load balancer had reached its maximum number of connections.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only
     *         the requests with a response generated by a target instance of the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     * @see LoadBalancerMetricName
     */
    public LoadBalancerMetricName metricName() {
        return LoadBalancerMetricName.fromValue(metricName);
    }

    /**
     * <p>
     * The metric about which you are receiving information. Valid values are listed below, along with the most useful
     * <code>statistics</code> to include in your request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that
     * did not establish a session with the load balancer. Possible causes include a mismatch of ciphers or protocols.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     * <code>Maximum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate from the
     * load balancer. Client errors are generated when requests are malformed or incomplete. These requests have not
     * been received by the target instance. This count does not include any response codes generated by the target
     * instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate from the
     * load balancer. This count does not include any response codes generated by the target instances.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the target
     * instances. This does not include any response codes generated by the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
     * balancer until a response from the target instance is received.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
     * balancer had reached its maximum number of connections.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
     * requests with a response generated by a target instance of the load balancer.
     * </p>
     * <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link LoadBalancerMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricNameAsString}.
     * </p>
     * 
     * @return The metric about which you are receiving information. Valid values are listed below, along with the most
     *         useful <code>statistics</code> to include in your request.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
     *         client that did not establish a session with the load balancer. Possible causes include a mismatch of
     *         ciphers or protocols.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *         <code>Maximum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
     *         <code>Maximum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate
     *         from the load balancer. Client errors are generated when requests are malformed or incomplete. These
     *         requests have not been received by the target instance. This count does not include any response codes
     *         generated by the target instances.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate
     *         from the load balancer. This count does not include any response codes generated by the target instances.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the
     *         target instances. This does not include any response codes generated by the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the
     *         load balancer until a response from the target instance is received.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Average</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the
     *         load balancer had reached its maximum number of connections.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only
     *         the requests with a response generated by a target instance of the load balancer.
     *         </p>
     *         <p>
     *         <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
     *         </p>
     *         </li>
     * @see LoadBalancerMetricName
     */
    public String metricNameAsString() {
        return metricName;
    }

    /**
     * <p>
     * An array of metric datapoint objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of metric datapoint objects.
     */
    public List<MetricDatapoint> metricData() {
        return metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoadBalancerMetricDataResponse)) {
            return false;
        }
        GetLoadBalancerMetricDataResponse other = (GetLoadBalancerMetricDataResponse) obj;
        return Objects.equals(metricNameAsString(), other.metricNameAsString())
                && Objects.equals(metricData(), other.metricData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetLoadBalancerMetricDataResponse").add("MetricName", metricNameAsString())
                .add("MetricData", metricData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "metricData":
            return Optional.ofNullable(clazz.cast(metricData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLoadBalancerMetricDataResponse, T> g) {
        return obj -> g.apply((GetLoadBalancerMetricDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLoadBalancerMetricDataResponse> {
        /**
         * <p>
         * The metric about which you are receiving information. Valid values are listed below, along with the most
         * useful <code>statistics</code> to include in your request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client
         * that did not establish a session with the load balancer. Possible causes include a mismatch of ciphers or
         * protocols.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         * <code>Maximum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         * <code>Maximum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate from
         * the load balancer. Client errors are generated when requests are malformed or incomplete. These requests have
         * not been received by the target instance. This count does not include any response codes generated by the
         * target instances.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate from
         * the load balancer. This count does not include any response codes generated by the target instances.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
         * balancer until a response from the target instance is received.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
         * balancer had reached its maximum number of connections.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
         * requests with a response generated by a target instance of the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricName
         *        The metric about which you are receiving information. Valid values are listed below, along with the
         *        most useful <code>statistics</code> to include in your request.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
         *        client that did not establish a session with the load balancer. Possible causes include a mismatch of
         *        ciphers or protocols.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         *        <code>Maximum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered
         *        unhealthy.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         *        <code>Maximum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate
         *        from the load balancer. Client errors are generated when requests are malformed or incomplete. These
         *        requests have not been received by the target instance. This count does not include any response codes
         *        generated by the target instances.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate
         *        from the load balancer. This count does not include any response codes generated by the target
         *        instances.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that
         *        <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves
         *        the load balancer until a response from the target instance is received.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because
         *        the load balancer had reached its maximum number of connections.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes
         *        only the requests with a response generated by a target instance of the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         * @see LoadBalancerMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerMetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The metric about which you are receiving information. Valid values are listed below, along with the most
         * useful <code>statistics</code> to include in your request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client
         * that did not establish a session with the load balancer. Possible causes include a mismatch of ciphers or
         * protocols.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         * <code>Maximum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         * <code>Maximum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate from
         * the load balancer. Client errors are generated when requests are malformed or incomplete. These requests have
         * not been received by the target instance. This count does not include any response codes generated by the
         * target instances.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate from
         * the load balancer. This count does not include any response codes generated by the target instances.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the target
         * instances. This does not include any response codes generated by the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load
         * balancer until a response from the target instance is received.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load
         * balancer had reached its maximum number of connections.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the
         * requests with a response generated by a target instance of the load balancer.
         * </p>
         * <p>
         * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricName
         *        The metric about which you are receiving information. Valid values are listed below, along with the
         *        most useful <code>statistics</code> to include in your request.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the
         *        client that did not establish a session with the load balancer. Possible causes include a mismatch of
         *        ciphers or protocols.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         *        <code>Maximum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered
         *        unhealthy.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and
         *        <code>Maximum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originate
         *        from the load balancer. Client errors are generated when requests are malformed or incomplete. These
         *        requests have not been received by the target instance. This count does not include any response codes
         *        generated by the target instances.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originate
         *        from the load balancer. This count does not include any response codes generated by the target
         *        instances.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>. Note that
         *        <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP response codes generated by the
         *        target instances. This does not include any response codes generated by the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves
         *        the load balancer until a response from the target instance is received.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Average</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because
         *        the load balancer had reached its maximum number of connections.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes
         *        only the requests with a response generated by a target instance of the load balancer.
         *        </p>
         *        <p>
         *        <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.
         *        </p>
         *        </li>
         * @see LoadBalancerMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerMetricName
         */
        Builder metricName(LoadBalancerMetricName metricName);

        /**
         * <p>
         * An array of metric datapoint objects.
         * </p>
         * 
         * @param metricData
         *        An array of metric datapoint objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(Collection<MetricDatapoint> metricData);

        /**
         * <p>
         * An array of metric datapoint objects.
         * </p>
         * 
         * @param metricData
         *        An array of metric datapoint objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(MetricDatapoint... metricData);

        /**
         * <p>
         * An array of metric datapoint objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricDatapoint>.Builder} avoiding the need
         * to create one manually via {@link List<MetricDatapoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDatapoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #metricData(List<MetricDatapoint>)}.
         * 
         * @param metricData
         *        a consumer that will call methods on {@link List<MetricDatapoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricData(List<MetricDatapoint>)
         */
        Builder metricData(Consumer<MetricDatapoint.Builder>... metricData);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private String metricName;

        private List<MetricDatapoint> metricData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoadBalancerMetricDataResponse model) {
            super(model);
            metricName(model.metricName);
            metricData(model.metricData);
        }

        public final String getMetricNameAsString() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(LoadBalancerMetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<MetricDatapoint.Builder> getMetricData() {
            return metricData != null ? metricData.stream().map(MetricDatapoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatapoint... metricData) {
            metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatapoint.Builder>... metricData) {
            metricData(Stream.of(metricData).map(c -> MetricDatapoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricData(Collection<MetricDatapoint.BuilderImpl> metricData) {
            this.metricData = MetricDatapointListCopier.copyFromBuilder(metricData);
        }

        @Override
        public GetLoadBalancerMetricDataResponse build() {
            return new GetLoadBalancerMetricDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
