/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoadBalancerRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateLoadBalancerRequest.Builder, CreateLoadBalancerRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLoadBalancerRequest::loadBalancerName)).setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()).build();

    private static final SdkField<Integer> INSTANCE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateLoadBalancerRequest::instancePort)).setter(setter(Builder::instancePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instancePort").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLoadBalancerRequest::healthCheckPath)).setter(setter(Builder::healthCheckPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPath").build()).build();

    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLoadBalancerRequest::certificateName)).setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final SdkField<String> CERTIFICATE_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLoadBalancerRequest::certificateDomainName)).setter(setter(Builder::certificateDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateDomainName").build())
            .build();

    private static final SdkField<List<String>> CERTIFICATE_ALTERNATIVE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateLoadBalancerRequest::certificateAlternativeNames))
            .setter(setter(Builder::certificateAlternativeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAlternativeNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateLoadBalancerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            INSTANCE_PORT_FIELD, HEALTH_CHECK_PATH_FIELD, CERTIFICATE_NAME_FIELD, CERTIFICATE_DOMAIN_NAME_FIELD,
            CERTIFICATE_ALTERNATIVE_NAMES_FIELD, TAGS_FIELD));

    private final String loadBalancerName;

    private final Integer instancePort;

    private final String healthCheckPath;

    private final String certificateName;

    private final String certificateDomainName;

    private final List<String> certificateAlternativeNames;

    private final List<Tag> tags;

    private CreateLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.instancePort = builder.instancePort;
        this.healthCheckPath = builder.healthCheckPath;
        this.certificateName = builder.certificateName;
        this.certificateDomainName = builder.certificateDomainName;
        this.certificateAlternativeNames = builder.certificateAlternativeNames;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of your load balancer.
     * </p>
     * 
     * @return The name of your load balancer.
     */
    public String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The instance port where you're creating your load balancer.
     * </p>
     * 
     * @return The instance port where you're creating your load balancer.
     */
    public Integer instancePort() {
        return instancePort;
    }

    /**
     * <p>
     * The path you provided to perform the load balancer health check. If you didn't specify a health check path,
     * Lightsail uses the root path of your website (e.g., <code>"/"</code>).
     * </p>
     * <p>
     * You may want to specify a custom health check path other than the root of your application if your home page
     * loads slowly or has a lot of media or scripting on it.
     * </p>
     * 
     * @return The path you provided to perform the load balancer health check. If you didn't specify a health check
     *         path, Lightsail uses the root path of your website (e.g., <code>"/"</code>).</p>
     *         <p>
     *         You may want to specify a custom health check path other than the root of your application if your home
     *         page loads slowly or has a lot of media or scripting on it.
     */
    public String healthCheckPath() {
        return healthCheckPath;
    }

    /**
     * <p>
     * The name of the SSL/TLS certificate.
     * </p>
     * <p>
     * If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is required (and
     * vice-versa).
     * </p>
     * 
     * @return The name of the SSL/TLS certificate.</p>
     *         <p>
     *         If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is required (and
     *         vice-versa).
     */
    public String certificateName() {
        return certificateName;
    }

    /**
     * <p>
     * The domain name with which your certificate is associated (e.g., <code>example.com</code>).
     * </p>
     * <p>
     * If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is required (and
     * vice-versa).
     * </p>
     * 
     * @return The domain name with which your certificate is associated (e.g., <code>example.com</code>).</p>
     *         <p>
     *         If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is required (and
     *         vice-versa).
     */
    public String certificateDomainName() {
        return certificateDomainName;
    }

    /**
     * <p>
     * The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
     * <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>, <code>blog.example.com</code>
     * ).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
     *         <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
     *         <code>blog.example.com</code>).
     */
    public List<String> certificateAlternativeNames() {
        return certificateAlternativeNames;
    }

    /**
     * <p>
     * The tag keys and optional values to add to the resource during create.
     * </p>
     * <p>
     * To tag a resource after it has been created, see the <code>tag resource</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tag keys and optional values to add to the resource during create.</p>
     *         <p>
     *         To tag a resource after it has been created, see the <code>tag resource</code> operation.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(instancePort());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateAlternativeNames());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(instancePort(), other.instancePort())
                && Objects.equals(healthCheckPath(), other.healthCheckPath())
                && Objects.equals(certificateName(), other.certificateName())
                && Objects.equals(certificateDomainName(), other.certificateDomainName())
                && Objects.equals(certificateAlternativeNames(), other.certificateAlternativeNames())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLoadBalancerRequest").add("LoadBalancerName", loadBalancerName())
                .add("InstancePort", instancePort()).add("HealthCheckPath", healthCheckPath())
                .add("CertificateName", certificateName()).add("CertificateDomainName", certificateDomainName())
                .add("CertificateAlternativeNames", certificateAlternativeNames()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "instancePort":
            return Optional.ofNullable(clazz.cast(instancePort()));
        case "healthCheckPath":
            return Optional.ofNullable(clazz.cast(healthCheckPath()));
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        case "certificateDomainName":
            return Optional.ofNullable(clazz.cast(certificateDomainName()));
        case "certificateAlternativeNames":
            return Optional.ofNullable(clazz.cast(certificateAlternativeNames()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoadBalancerRequest, T> g) {
        return obj -> g.apply((CreateLoadBalancerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLoadBalancerRequest> {
        /**
         * <p>
         * The name of your load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of your load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The instance port where you're creating your load balancer.
         * </p>
         * 
         * @param instancePort
         *        The instance port where you're creating your load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePort(Integer instancePort);

        /**
         * <p>
         * The path you provided to perform the load balancer health check. If you didn't specify a health check path,
         * Lightsail uses the root path of your website (e.g., <code>"/"</code>).
         * </p>
         * <p>
         * You may want to specify a custom health check path other than the root of your application if your home page
         * loads slowly or has a lot of media or scripting on it.
         * </p>
         * 
         * @param healthCheckPath
         *        The path you provided to perform the load balancer health check. If you didn't specify a health check
         *        path, Lightsail uses the root path of your website (e.g., <code>"/"</code>).</p>
         *        <p>
         *        You may want to specify a custom health check path other than the root of your application if your
         *        home page loads slowly or has a lot of media or scripting on it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPath(String healthCheckPath);

        /**
         * <p>
         * The name of the SSL/TLS certificate.
         * </p>
         * <p>
         * If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is required (and
         * vice-versa).
         * </p>
         * 
         * @param certificateName
         *        The name of the SSL/TLS certificate.</p>
         *        <p>
         *        If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is required (and
         *        vice-versa).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        /**
         * <p>
         * The domain name with which your certificate is associated (e.g., <code>example.com</code>).
         * </p>
         * <p>
         * If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is required (and
         * vice-versa).
         * </p>
         * 
         * @param certificateDomainName
         *        The domain name with which your certificate is associated (e.g., <code>example.com</code>).</p>
         *        <p>
         *        If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is required (and
         *        vice-versa).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateDomainName(String certificateDomainName);

        /**
         * <p>
         * The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
         * <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
         * <code>blog.example.com</code>).
         * </p>
         * 
         * @param certificateAlternativeNames
         *        The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
         *        <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
         *        <code>blog.example.com</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAlternativeNames(Collection<String> certificateAlternativeNames);

        /**
         * <p>
         * The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
         * <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
         * <code>blog.example.com</code>).
         * </p>
         * 
         * @param certificateAlternativeNames
         *        The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
         *        <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
         *        <code>blog.example.com</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAlternativeNames(String... certificateAlternativeNames);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * To tag a resource after it has been created, see the <code>tag resource</code> operation.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        To tag a resource after it has been created, see the <code>tag resource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * To tag a resource after it has been created, see the <code>tag resource</code> operation.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        To tag a resource after it has been created, see the <code>tag resource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * To tag a resource after it has been created, see the <code>tag resource</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private Integer instancePort;

        private String healthCheckPath;

        private String certificateName;

        private String certificateDomainName;

        private List<String> certificateAlternativeNames = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            instancePort(model.instancePort);
            healthCheckPath(model.healthCheckPath);
            certificateName(model.certificateName);
            certificateDomainName(model.certificateDomainName);
            certificateAlternativeNames(model.certificateAlternativeNames);
            tags(model.tags);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Integer getInstancePort() {
            return instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        public final String getHealthCheckPath() {
            return healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getCertificateDomainName() {
            return certificateDomainName;
        }

        @Override
        public final Builder certificateDomainName(String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
            return this;
        }

        public final void setCertificateDomainName(String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
        }

        public final Collection<String> getCertificateAlternativeNames() {
            return certificateAlternativeNames;
        }

        @Override
        public final Builder certificateAlternativeNames(Collection<String> certificateAlternativeNames) {
            this.certificateAlternativeNames = DomainNameListCopier.copy(certificateAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAlternativeNames(String... certificateAlternativeNames) {
            certificateAlternativeNames(Arrays.asList(certificateAlternativeNames));
            return this;
        }

        public final void setCertificateAlternativeNames(Collection<String> certificateAlternativeNames) {
            this.certificateAlternativeNames = DomainNameListCopier.copy(certificateAlternativeNames);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerRequest build() {
            return new CreateLoadBalancerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
