/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an export snapshot record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportSnapshotRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportSnapshotRecord.Builder, ExportSnapshotRecord> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportSnapshotRecord::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportSnapshotRecord::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ExportSnapshotRecord::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField
            .<ResourceLocation> builder(MarshallingType.SDK_POJO).getter(getter(ExportSnapshotRecord::location))
            .setter(setter(Builder::location)).constructor(ResourceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportSnapshotRecord::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportSnapshotRecord::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<ExportSnapshotRecordSourceInfo> SOURCE_INFO_FIELD = SdkField
            .<ExportSnapshotRecordSourceInfo> builder(MarshallingType.SDK_POJO).getter(getter(ExportSnapshotRecord::sourceInfo))
            .setter(setter(Builder::sourceInfo)).constructor(ExportSnapshotRecordSourceInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceInfo").build()).build();

    private static final SdkField<DestinationInfo> DESTINATION_INFO_FIELD = SdkField
            .<DestinationInfo> builder(MarshallingType.SDK_POJO).getter(getter(ExportSnapshotRecord::destinationInfo))
            .setter(setter(Builder::destinationInfo)).constructor(DestinationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, STATE_FIELD, SOURCE_INFO_FIELD, DESTINATION_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final String state;

    private final ExportSnapshotRecordSourceInfo sourceInfo;

    private final DestinationInfo destinationInfo;

    private ExportSnapshotRecord(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.state = builder.state;
        this.sourceInfo = builder.sourceInfo;
        this.destinationInfo = builder.destinationInfo;
    }

    /**
     * <p>
     * The export snapshot record name.
     * </p>
     * 
     * @return The export snapshot record name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the export snapshot record.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the export snapshot record.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The date when the export snapshot record was created.
     * </p>
     * 
     * @return The date when the export snapshot record was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The AWS Region and Availability Zone where the export snapshot record is located.
     * </p>
     * 
     * @return The AWS Region and Availability Zone where the export snapshot record is located.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The state of the export snapshot record.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RecordState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the export snapshot record.
     * @see RecordState
     */
    public RecordState state() {
        return RecordState.fromValue(state);
    }

    /**
     * <p>
     * The state of the export snapshot record.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RecordState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the export snapshot record.
     * @see RecordState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * A list of objects describing the source of the export snapshot record.
     * </p>
     * 
     * @return A list of objects describing the source of the export snapshot record.
     */
    public ExportSnapshotRecordSourceInfo sourceInfo() {
        return sourceInfo;
    }

    /**
     * <p>
     * A list of objects describing the destination of the export snapshot record.
     * </p>
     * 
     * @return A list of objects describing the destination of the export snapshot record.
     */
    public DestinationInfo destinationInfo() {
        return destinationInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceInfo());
        hashCode = 31 * hashCode + Objects.hashCode(destinationInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSnapshotRecord)) {
            return false;
        }
        ExportSnapshotRecord other = (ExportSnapshotRecord) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(location(), other.location())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(sourceInfo(), other.sourceInfo())
                && Objects.equals(destinationInfo(), other.destinationInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportSnapshotRecord").add("Name", name()).add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Location", location()).add("ResourceType", resourceTypeAsString()).add("State", stateAsString())
                .add("SourceInfo", sourceInfo()).add("DestinationInfo", destinationInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "sourceInfo":
            return Optional.ofNullable(clazz.cast(sourceInfo()));
        case "destinationInfo":
            return Optional.ofNullable(clazz.cast(destinationInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportSnapshotRecord, T> g) {
        return obj -> g.apply((ExportSnapshotRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportSnapshotRecord> {
        /**
         * <p>
         * The export snapshot record name.
         * </p>
         * 
         * @param name
         *        The export snapshot record name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the export snapshot record.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the export snapshot record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date when the export snapshot record was created.
         * </p>
         * 
         * @param createdAt
         *        The date when the export snapshot record was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The AWS Region and Availability Zone where the export snapshot record is located.
         * </p>
         * 
         * @param location
         *        The AWS Region and Availability Zone where the export snapshot record is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The AWS Region and Availability Zone where the export snapshot record is located.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceLocation.Builder} avoiding the need to
         * create one manually via {@link ResourceLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ResourceLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ResourceLocation)
         */
        default Builder location(Consumer<ResourceLocation.Builder> location) {
            return location(ResourceLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The state of the export snapshot record.
         * </p>
         * 
         * @param state
         *        The state of the export snapshot record.
         * @see RecordState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the export snapshot record.
         * </p>
         * 
         * @param state
         *        The state of the export snapshot record.
         * @see RecordState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordState
         */
        Builder state(RecordState state);

        /**
         * <p>
         * A list of objects describing the source of the export snapshot record.
         * </p>
         * 
         * @param sourceInfo
         *        A list of objects describing the source of the export snapshot record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceInfo(ExportSnapshotRecordSourceInfo sourceInfo);

        /**
         * <p>
         * A list of objects describing the source of the export snapshot record.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportSnapshotRecordSourceInfo.Builder} avoiding
         * the need to create one manually via {@link ExportSnapshotRecordSourceInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportSnapshotRecordSourceInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceInfo(ExportSnapshotRecordSourceInfo)}.
         * 
         * @param sourceInfo
         *        a consumer that will call methods on {@link ExportSnapshotRecordSourceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceInfo(ExportSnapshotRecordSourceInfo)
         */
        default Builder sourceInfo(Consumer<ExportSnapshotRecordSourceInfo.Builder> sourceInfo) {
            return sourceInfo(ExportSnapshotRecordSourceInfo.builder().applyMutation(sourceInfo).build());
        }

        /**
         * <p>
         * A list of objects describing the destination of the export snapshot record.
         * </p>
         * 
         * @param destinationInfo
         *        A list of objects describing the destination of the export snapshot record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationInfo(DestinationInfo destinationInfo);

        /**
         * <p>
         * A list of objects describing the destination of the export snapshot record.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationInfo.Builder} avoiding the need to
         * create one manually via {@link DestinationInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationInfo(DestinationInfo)}.
         * 
         * @param destinationInfo
         *        a consumer that will call methods on {@link DestinationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationInfo(DestinationInfo)
         */
        default Builder destinationInfo(Consumer<DestinationInfo.Builder> destinationInfo) {
            return destinationInfo(DestinationInfo.builder().applyMutation(destinationInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private String state;

        private ExportSnapshotRecordSourceInfo sourceInfo;

        private DestinationInfo destinationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSnapshotRecord model) {
            name(model.name);
            arn(model.arn);
            createdAt(model.createdAt);
            location(model.location);
            resourceType(model.resourceType);
            state(model.state);
            sourceInfo(model.sourceInfo);
            destinationInfo(model.destinationInfo);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RecordState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ExportSnapshotRecordSourceInfo.Builder getSourceInfo() {
            return sourceInfo != null ? sourceInfo.toBuilder() : null;
        }

        @Override
        public final Builder sourceInfo(ExportSnapshotRecordSourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public final void setSourceInfo(ExportSnapshotRecordSourceInfo.BuilderImpl sourceInfo) {
            this.sourceInfo = sourceInfo != null ? sourceInfo.build() : null;
        }

        public final DestinationInfo.Builder getDestinationInfo() {
            return destinationInfo != null ? destinationInfo.toBuilder() : null;
        }

        @Override
        public final Builder destinationInfo(DestinationInfo destinationInfo) {
            this.destinationInfo = destinationInfo;
            return this;
        }

        public final void setDestinationInfo(DestinationInfo.BuilderImpl destinationInfo) {
            this.destinationInfo = destinationInfo != null ? destinationInfo.build() : null;
        }

        @Override
        public ExportSnapshotRecord build() {
            return new ExportSnapshotRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
