/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrackerRequest extends LocationRequest implements
        ToCopyableBuilder<CreateTrackerRequest.Builder, CreateTrackerRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateTrackerRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(CreateTrackerRequest::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlanDataSource").getter(getter(CreateTrackerRequest::pricingPlanDataSource))
            .setter(setter(Builder::pricingPlanDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build())
            .build();

    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(CreateTrackerRequest::trackerName)).setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, TRACKER_NAME_FIELD));

    private final String description;

    private final String pricingPlan;

    private final String pricingPlanDataSource;

    private final String trackerName;

    private CreateTrackerRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.trackerName = builder.trackerName;
    }

    /**
     * <p>
     * An optional description for the tracker resource.
     * </p>
     * 
     * @return An optional description for the tracker resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the pricing plan for your tracker resource.
     * </p>
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies the pricing plan for your tracker resource.</p>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * @see PricingPlan
     */
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * Specifies the pricing plan for your tracker resource.
     * </p>
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies the pricing plan for your tracker resource.</p>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * @see PricingPlan
     */
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * <p>
     * Specifies the plan data source. Required if the Mobile Asset Tracking (MAT) or the Mobile Asset Management (MAM)
     * pricing plan is selected.
     * </p>
     * <p>
     * Billing is determined by the resource usage, the associated pricing plan, and data source that was specified. For
     * more information about each pricing plan option and restrictions, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * Valid Values: <code>Esri</code> | <code>Here</code>
     * </p>
     * 
     * @return Specifies the plan data source. Required if the Mobile Asset Tracking (MAT) or the Mobile Asset
     *         Management (MAM) pricing plan is selected.</p>
     *         <p>
     *         Billing is determined by the resource usage, the associated pricing plan, and data source that was
     *         specified. For more information about each pricing plan option and restrictions, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     *         </p>
     *         <p>
     *         Valid Values: <code>Esri</code> | <code>Here</code>
     */
    public final String pricingPlanDataSource() {
        return pricingPlanDataSource;
    }

    /**
     * <p>
     * The name for the tracker resource.
     * </p>
     * <p>
     * Requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be a unique tracker resource name.
     * </p>
     * </li>
     * <li>
     * <p>
     * No spaces allowed. For example, <code>ExampleTracker</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name for the tracker resource.</p>
     *         <p>
     *         Requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be a unique tracker resource name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No spaces allowed. For example, <code>ExampleTracker</code>.
     *         </p>
     *         </li>
     */
    public final String trackerName() {
        return trackerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrackerRequest)) {
            return false;
        }
        CreateTrackerRequest other = (CreateTrackerRequest) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(pricingPlanDataSource(), other.pricingPlanDataSource())
                && Objects.equals(trackerName(), other.trackerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrackerRequest").add("Description", description())
                .add("PricingPlan", pricingPlanAsString()).add("PricingPlanDataSource", pricingPlanDataSource())
                .add("TrackerName", trackerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "PricingPlanDataSource":
            return Optional.ofNullable(clazz.cast(pricingPlanDataSource()));
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrackerRequest, T> g) {
        return obj -> g.apply((CreateTrackerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrackerRequest> {
        /**
         * <p>
         * An optional description for the tracker resource.
         * </p>
         * 
         * @param description
         *        An optional description for the tracker resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the pricing plan for your tracker resource.
         * </p>
         * <p>
         * For additional details and restrictions on each pricing plan option, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Specifies the pricing plan for your tracker resource.</p>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * Specifies the pricing plan for your tracker resource.
         * </p>
         * <p>
         * For additional details and restrictions on each pricing plan option, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Specifies the pricing plan for your tracker resource.</p>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * Specifies the plan data source. Required if the Mobile Asset Tracking (MAT) or the Mobile Asset Management
         * (MAM) pricing plan is selected.
         * </p>
         * <p>
         * Billing is determined by the resource usage, the associated pricing plan, and data source that was specified.
         * For more information about each pricing plan option and restrictions, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * <p>
         * Valid Values: <code>Esri</code> | <code>Here</code>
         * </p>
         * 
         * @param pricingPlanDataSource
         *        Specifies the plan data source. Required if the Mobile Asset Tracking (MAT) or the Mobile Asset
         *        Management (MAM) pricing plan is selected.</p>
         *        <p>
         *        Billing is determined by the resource usage, the associated pricing plan, and data source that was
         *        specified. For more information about each pricing plan option and restrictions, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         *        </p>
         *        <p>
         *        Valid Values: <code>Esri</code> | <code>Here</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingPlanDataSource(String pricingPlanDataSource);

        /**
         * <p>
         * The name for the tracker resource.
         * </p>
         * <p>
         * Requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be a unique tracker resource name.
         * </p>
         * </li>
         * <li>
         * <p>
         * No spaces allowed. For example, <code>ExampleTracker</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trackerName
         *        The name for the tracker resource.</p>
         *        <p>
         *        Requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be a unique tracker resource name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No spaces allowed. For example, <code>ExampleTracker</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String description;

        private String pricingPlan;

        private String pricingPlanDataSource;

        private String trackerName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrackerRequest model) {
            super(model);
            description(model.description);
            pricingPlan(model.pricingPlan);
            pricingPlanDataSource(model.pricingPlanDataSource);
            trackerName(model.trackerName);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        public final String getPricingPlanDataSource() {
            return pricingPlanDataSource;
        }

        @Override
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        public final String getTrackerName() {
            return trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrackerRequest build() {
            return new CreateTrackerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
