/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPlaceIndexForPositionRequest extends LocationRequest implements
        ToCopyableBuilder<SearchPlaceIndexForPositionRequest.Builder, SearchPlaceIndexForPositionRequest> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(SearchPlaceIndexForPositionRequest::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IndexName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchPlaceIndexForPositionRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(SearchPlaceIndexForPositionRequest::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            MAX_RESULTS_FIELD, POSITION_FIELD));

    private final String indexName;

    private final Integer maxResults;

    private final List<Double> position;

    private SearchPlaceIndexForPositionRequest(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.maxResults = builder.maxResults;
        this.position = builder.position;
    }

    /**
     * <p>
     * The name of the Place index resource you want to use for the search.
     * </p>
     * 
     * @return The name of the Place index resource you want to use for the search.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * An optional paramer. The maximum number of results returned per request.
     * </p>
     * <p>
     * Default value: <code>50</code>
     * </p>
     * 
     * @return An optional paramer. The maximum number of results returned per request. </p>
     *         <p>
     *         Default value: <code>50</code>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns true if the Position property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a coordinate for the query defined by a longitude, and latitude.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The first position is the X coordinate, or longitude.
     * </p>
     * </li>
     * <li>
     * <p>
     * The second position is the Y coordinate, or latitude.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, <code>position=xLongitude&amp;position=yLatitude</code> .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPosition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies a coordinate for the query defined by a longitude, and latitude.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The first position is the X coordinate, or longitude.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The second position is the Y coordinate, or latitude.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, <code>position=xLongitude&amp;position=yLatitude</code> .
     */
    public final List<Double> position() {
        return position;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForPositionRequest)) {
            return false;
        }
        SearchPlaceIndexForPositionRequest other = (SearchPlaceIndexForPositionRequest) obj;
        return Objects.equals(indexName(), other.indexName()) && Objects.equals(maxResults(), other.maxResults())
                && hasPosition() == other.hasPosition() && Objects.equals(position(), other.position());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPlaceIndexForPositionRequest").add("IndexName", indexName())
                .add("MaxResults", maxResults()).add("Position", position() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForPositionRequest, T> g) {
        return obj -> g.apply((SearchPlaceIndexForPositionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchPlaceIndexForPositionRequest> {
        /**
         * <p>
         * The name of the Place index resource you want to use for the search.
         * </p>
         * 
         * @param indexName
         *        The name of the Place index resource you want to use for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * An optional paramer. The maximum number of results returned per request.
         * </p>
         * <p>
         * Default value: <code>50</code>
         * </p>
         * 
         * @param maxResults
         *        An optional paramer. The maximum number of results returned per request. </p>
         *        <p>
         *        Default value: <code>50</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies a coordinate for the query defined by a longitude, and latitude.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The first position is the X coordinate, or longitude.
         * </p>
         * </li>
         * <li>
         * <p>
         * The second position is the Y coordinate, or latitude.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, <code>position=xLongitude&amp;position=yLatitude</code> .
         * </p>
         * 
         * @param position
         *        Specifies a coordinate for the query defined by a longitude, and latitude.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The first position is the X coordinate, or longitude.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The second position is the Y coordinate, or latitude.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, <code>position=xLongitude&amp;position=yLatitude</code> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * Specifies a coordinate for the query defined by a longitude, and latitude.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The first position is the X coordinate, or longitude.
         * </p>
         * </li>
         * <li>
         * <p>
         * The second position is the Y coordinate, or latitude.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, <code>position=xLongitude&amp;position=yLatitude</code> .
         * </p>
         * 
         * @param position
         *        Specifies a coordinate for the query defined by a longitude, and latitude.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The first position is the X coordinate, or longitude.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The second position is the Y coordinate, or latitude.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, <code>position=xLongitude&amp;position=yLatitude</code> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String indexName;

        private Integer maxResults;

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForPositionRequest model) {
            super(model);
            indexName(model.indexName);
            maxResults(model.maxResults);
            position(model.position);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchPlaceIndexForPositionRequest build() {
            return new SearchPlaceIndexForPositionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
