/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DimensionUnit {
    METERS("Meters"),
    FEET("Feet"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DimensionUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DimensionUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DimensionUnit.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DimensionUnit> knownValues() {
        return Stream.of(DimensionUnit.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

