/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BatchPutGeofenceSuccessListCopier {
    static List<BatchPutGeofenceSuccess> copy(Collection<? extends BatchPutGeofenceSuccess> batchPutGeofenceSuccessListParam) {
        List<BatchPutGeofenceSuccess> list;
        if (batchPutGeofenceSuccessListParam == null || batchPutGeofenceSuccessListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchPutGeofenceSuccess> modifiableList = new ArrayList<>();
            batchPutGeofenceSuccessListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchPutGeofenceSuccess> copyFromBuilder(
            Collection<? extends BatchPutGeofenceSuccess.Builder> batchPutGeofenceSuccessListParam) {
        List<BatchPutGeofenceSuccess> list;
        if (batchPutGeofenceSuccessListParam == null || batchPutGeofenceSuccessListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchPutGeofenceSuccess> modifiableList = new ArrayList<>();
            batchPutGeofenceSuccessListParam.forEach(entry -> {
                BatchPutGeofenceSuccess member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchPutGeofenceSuccess.Builder> copyToBuilder(
            Collection<? extends BatchPutGeofenceSuccess> batchPutGeofenceSuccessListParam) {
        List<BatchPutGeofenceSuccess.Builder> list;
        if (batchPutGeofenceSuccessListParam == null || batchPutGeofenceSuccessListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchPutGeofenceSuccess.Builder> modifiableList = new ArrayList<>();
            batchPutGeofenceSuccessListParam.forEach(entry -> {
                BatchPutGeofenceSuccess.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
