/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the geofence geometry details.
 * </p>
 * <note>
 * <p>
 * Amazon Location doesn't currently support polygons with holes, multipolygons, polygons that are wound clockwise, or
 * that cross the antimeridian.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeofenceGeometry implements SdkPojo, Serializable,
        ToCopyableBuilder<GeofenceGeometry.Builder, GeofenceGeometry> {
    private static final SdkField<List<List<List<Double>>>> POLYGON_FIELD = SdkField
            .<List<List<List<Double>>>> builder(MarshallingType.LIST)
            .memberName("Polygon")
            .getter(getter(GeofenceGeometry::polygon))
            .setter(setter(Builder::polygon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polygon").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<List<Double>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<List<Double>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<Double> builder(
                                                                                                            MarshallingType.DOUBLE)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLYGON_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<List<List<Double>>> polygon;

    private GeofenceGeometry(BuilderImpl builder) {
        this.polygon = builder.polygon;
    }

    /**
     * Returns true if the Polygon property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPolygon() {
        return polygon != null && !(polygon instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first and last
     * vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the form:
     * <code>[longitude, latitude]</code>.
     * </p>
     * <p>
     * The first linear ring is an outer ring, describing the polygon's boundary. Subsequent linear rings may be inner
     * or outer rings to describe holes and islands. Outer rings must list their vertices in counter-clockwise order
     * around the ring's center, where the left side is the polygon's exterior. Inner rings must list their vertices in
     * clockwise order, where the left side is the polygon's interior.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolygon()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first and
     *         last vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the form:
     *         <code>[longitude, latitude]</code>. </p>
     *         <p>
     *         The first linear ring is an outer ring, describing the polygon's boundary. Subsequent linear rings may be
     *         inner or outer rings to describe holes and islands. Outer rings must list their vertices in
     *         counter-clockwise order around the ring's center, where the left side is the polygon's exterior. Inner
     *         rings must list their vertices in clockwise order, where the left side is the polygon's interior.
     */
    public final List<List<List<Double>>> polygon() {
        return polygon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPolygon() ? polygon() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeofenceGeometry)) {
            return false;
        }
        GeofenceGeometry other = (GeofenceGeometry) obj;
        return hasPolygon() == other.hasPolygon() && Objects.equals(polygon(), other.polygon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeofenceGeometry").add("Polygon", polygon() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Polygon":
            return Optional.ofNullable(clazz.cast(polygon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeofenceGeometry, T> g) {
        return obj -> g.apply((GeofenceGeometry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeofenceGeometry> {
        /**
         * <p>
         * An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first and last
         * vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the form:
         * <code>[longitude, latitude]</code>.
         * </p>
         * <p>
         * The first linear ring is an outer ring, describing the polygon's boundary. Subsequent linear rings may be
         * inner or outer rings to describe holes and islands. Outer rings must list their vertices in counter-clockwise
         * order around the ring's center, where the left side is the polygon's exterior. Inner rings must list their
         * vertices in clockwise order, where the left side is the polygon's interior.
         * </p>
         * 
         * @param polygon
         *        An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first
         *        and last vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the
         *        form: <code>[longitude, latitude]</code>. </p>
         *        <p>
         *        The first linear ring is an outer ring, describing the polygon's boundary. Subsequent linear rings may
         *        be inner or outer rings to describe holes and islands. Outer rings must list their vertices in
         *        counter-clockwise order around the ring's center, where the left side is the polygon's exterior. Inner
         *        rings must list their vertices in clockwise order, where the left side is the polygon's interior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> polygon);

        /**
         * <p>
         * An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first and last
         * vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the form:
         * <code>[longitude, latitude]</code>.
         * </p>
         * <p>
         * The first linear ring is an outer ring, describing the polygon's boundary. Subsequent linear rings may be
         * inner or outer rings to describe holes and islands. Outer rings must list their vertices in counter-clockwise
         * order around the ring's center, where the left side is the polygon's exterior. Inner rings must list their
         * vertices in clockwise order, where the left side is the polygon's interior.
         * </p>
         * 
         * @param polygon
         *        An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first
         *        and last vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the
         *        form: <code>[longitude, latitude]</code>. </p>
         *        <p>
         *        The first linear ring is an outer ring, describing the polygon's boundary. Subsequent linear rings may
         *        be inner or outer rings to describe holes and islands. Outer rings must list their vertices in
         *        counter-clockwise order around the ring's center, where the left side is the polygon's exterior. Inner
         *        rings must list their vertices in clockwise order, where the left side is the polygon's interior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polygon(Collection<? extends Collection<Double>>... polygon);
    }

    static final class BuilderImpl implements Builder {
        private List<List<List<Double>>> polygon = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeofenceGeometry model) {
            polygon(model.polygon);
        }

        public final Collection<? extends Collection<? extends Collection<Double>>> getPolygon() {
            if (polygon instanceof SdkAutoConstructList) {
                return null;
            }
            return polygon;
        }

        @Override
        public final Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = LinearRingsCopier.copy(polygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Collection<? extends Collection<Double>>... polygon) {
            polygon(Arrays.asList(polygon));
            return this;
        }

        public final void setPolygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = LinearRingsCopier.copy(polygon);
        }

        @Override
        public GeofenceGeometry build() {
            return new GeofenceGeometry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
