/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMapGlyphsRequest extends LocationRequest implements
        ToCopyableBuilder<GetMapGlyphsRequest.Builder, GetMapGlyphsRequest> {
    private static final SdkField<String> FONT_STACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontStack").getter(getter(GetMapGlyphsRequest::fontStack)).setter(setter(Builder::fontStack))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FontStack").build()).build();

    private static final SdkField<String> FONT_UNICODE_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontUnicodeRange").getter(getter(GetMapGlyphsRequest::fontUnicodeRange))
            .setter(setter(Builder::fontUnicodeRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FontUnicodeRange").build()).build();

    private static final SdkField<String> MAP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MapName").getter(getter(GetMapGlyphsRequest::mapName)).setter(setter(Builder::mapName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MapName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_STACK_FIELD,
            FONT_UNICODE_RANGE_FIELD, MAP_NAME_FIELD));

    private final String fontStack;

    private final String fontUnicodeRange;

    private final String mapName;

    private GetMapGlyphsRequest(BuilderImpl builder) {
        super(builder);
        this.fontStack = builder.fontStack;
        this.fontUnicodeRange = builder.fontUnicodeRange;
        this.mapName = builder.mapName;
    }

    /**
     * <p>
     * A comma-separated list of fonts to load glyphs from in order of preference.. For example,
     * <code>Noto Sans, Arial Unicode</code>.
     * </p>
     * 
     * @return A comma-separated list of fonts to load glyphs from in order of preference.. For example,
     *         <code>Noto Sans, Arial Unicode</code>.
     */
    public final String fontStack() {
        return fontStack;
    }

    /**
     * <p>
     * A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example,
     * 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be aligned to multiples
     * of 256.
     * </p>
     * 
     * @return A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For
     *         example, 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be
     *         aligned to multiples of 256.
     */
    public final String fontUnicodeRange() {
        return fontUnicodeRange;
    }

    /**
     * <p>
     * The map resource associated with the glyph ﬁle.
     * </p>
     * 
     * @return The map resource associated with the glyph ﬁle.
     */
    public final String mapName() {
        return mapName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fontStack());
        hashCode = 31 * hashCode + Objects.hashCode(fontUnicodeRange());
        hashCode = 31 * hashCode + Objects.hashCode(mapName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMapGlyphsRequest)) {
            return false;
        }
        GetMapGlyphsRequest other = (GetMapGlyphsRequest) obj;
        return Objects.equals(fontStack(), other.fontStack()) && Objects.equals(fontUnicodeRange(), other.fontUnicodeRange())
                && Objects.equals(mapName(), other.mapName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMapGlyphsRequest").add("FontStack", fontStack()).add("FontUnicodeRange", fontUnicodeRange())
                .add("MapName", mapName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FontStack":
            return Optional.ofNullable(clazz.cast(fontStack()));
        case "FontUnicodeRange":
            return Optional.ofNullable(clazz.cast(fontUnicodeRange()));
        case "MapName":
            return Optional.ofNullable(clazz.cast(mapName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMapGlyphsRequest, T> g) {
        return obj -> g.apply((GetMapGlyphsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMapGlyphsRequest> {
        /**
         * <p>
         * A comma-separated list of fonts to load glyphs from in order of preference.. For example,
         * <code>Noto Sans, Arial Unicode</code>.
         * </p>
         * 
         * @param fontStack
         *        A comma-separated list of fonts to load glyphs from in order of preference.. For example,
         *        <code>Noto Sans, Arial Unicode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontStack(String fontStack);

        /**
         * <p>
         * A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example,
         * 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be aligned to
         * multiples of 256.
         * </p>
         * 
         * @param fontUnicodeRange
         *        A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For
         *        example, 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be
         *        aligned to multiples of 256.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontUnicodeRange(String fontUnicodeRange);

        /**
         * <p>
         * The map resource associated with the glyph ﬁle.
         * </p>
         * 
         * @param mapName
         *        The map resource associated with the glyph ﬁle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapName(String mapName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String fontStack;

        private String fontUnicodeRange;

        private String mapName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMapGlyphsRequest model) {
            super(model);
            fontStack(model.fontStack);
            fontUnicodeRange(model.fontUnicodeRange);
            mapName(model.mapName);
        }

        public final String getFontStack() {
            return fontStack;
        }

        @Override
        public final Builder fontStack(String fontStack) {
            this.fontStack = fontStack;
            return this;
        }

        public final void setFontStack(String fontStack) {
            this.fontStack = fontStack;
        }

        public final String getFontUnicodeRange() {
            return fontUnicodeRange;
        }

        @Override
        public final Builder fontUnicodeRange(String fontUnicodeRange) {
            this.fontUnicodeRange = fontUnicodeRange;
            return this;
        }

        public final void setFontUnicodeRange(String fontUnicodeRange) {
            this.fontUnicodeRange = fontUnicodeRange;
        }

        public final String getMapName() {
            return mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMapGlyphsRequest build() {
            return new GetMapGlyphsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
