/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouteCalculatorRequest extends LocationRequest implements
        ToCopyableBuilder<CreateRouteCalculatorRequest.Builder, CreateRouteCalculatorRequest> {
    private static final SdkField<String> CALCULATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculatorName").getter(getter(CreateRouteCalculatorRequest::calculatorName))
            .setter(setter(Builder::calculatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorName").build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(CreateRouteCalculatorRequest::dataSource))
            .setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateRouteCalculatorRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(CreateRouteCalculatorRequest::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateRouteCalculatorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATOR_NAME_FIELD,
            DATA_SOURCE_FIELD, DESCRIPTION_FIELD, PRICING_PLAN_FIELD, TAGS_FIELD));

    private final String calculatorName;

    private final String dataSource;

    private final String description;

    private final String pricingPlan;

    private final Map<String, String> tags;

    private CreateRouteCalculatorRequest(BuilderImpl builder) {
        super(builder);
        this.calculatorName = builder.calculatorName;
        this.dataSource = builder.dataSource;
        this.description = builder.description;
        this.pricingPlan = builder.pricingPlan;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the route calculator resource.
     * </p>
     * <p>
     * Requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be a unique Route calculator resource name.
     * </p>
     * </li>
     * <li>
     * <p>
     * No spaces allowed. For example, <code>ExampleRouteCalculator</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the route calculator resource. </p>
     *         <p>
     *         Requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be a unique Route calculator resource name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No spaces allowed. For example, <code>ExampleRouteCalculator</code>.
     *         </p>
     *         </li>
     */
    public final String calculatorName() {
        return calculatorName;
    }

    /**
     * <p>
     * Specifies the data provider of traffic and road network data.
     * </p>
     * <note>
     * <p>
     * This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an
     * error.
     * </p>
     * </note>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Esri</code> – For additional information about <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of
     * interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on
     * street networks and traffic coverage</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Here</code> – For additional information about <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>'s coverage in
     * your region of interest, see <a
     * href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car
     * routing coverage</a> and <a
     * href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE
     * truck routing coverage</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional information , see <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a>
     * on the <i>Amazon Location Service Developer Guide</i>.
     * </p>
     * 
     * @return Specifies the data provider of traffic and road network data.</p> <note>
     *         <p>
     *         This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code>
     *         returns an error.
     *         </p>
     *         </note>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Esri</code> – For additional information about <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your
     *         region of interest, see <a
     *         href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street
     *         networks and traffic coverage</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Here</code> – For additional information about <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>'s
     *         coverage in your region of interest, see <a
     *         href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html"
     *         >HERE car routing coverage</a> and <a href=
     *         "https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE
     *         truck routing coverage</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For additional information , see <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data
     *         providers</a> on the <i>Amazon Location Service Developer Guide</i>.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The optional description for the route calculator resource.
     * </p>
     * 
     * @return The optional description for the route calculator resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the pricing plan for your route calculator resource.
     * </p>
     * <p>
     * For additional details and restrictions on each pricing plan option, see <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies the pricing plan for your route calculator resource.</p>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
     * @see PricingPlan
     */
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * Specifies the pricing plan for your route calculator resource.
     * </p>
     * <p>
     * For additional details and restrictions on each pricing plan option, see <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies the pricing plan for your route calculator resource.</p>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
     * @see PricingPlan
     */
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify,
     * search, and filter your resources by labelling them.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Format: <code>"key" : "value"</code>
     * </p>
     * <p>
     * Restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum 50 tags per resource
     * </p>
     * </li>
     * <li>
     * <p>
     * Each resource tag must be unique with a maximum of one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length: 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length: 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage,
     *         identify, search, and filter your resources by labelling them.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Format: <code>"key" : "value"</code>
     *         </p>
     *         <p>
     *         Restrictions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum 50 tags per resource
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each resource tag must be unique with a maximum of one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length: 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length: 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(calculatorName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteCalculatorRequest)) {
            return false;
        }
        CreateRouteCalculatorRequest other = (CreateRouteCalculatorRequest) obj;
        return Objects.equals(calculatorName(), other.calculatorName()) && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(description(), other.description())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRouteCalculatorRequest").add("CalculatorName", calculatorName())
                .add("DataSource", dataSource()).add("Description", description()).add("PricingPlan", pricingPlanAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CalculatorName":
            return Optional.ofNullable(clazz.cast(calculatorName()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteCalculatorRequest, T> g) {
        return obj -> g.apply((CreateRouteCalculatorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRouteCalculatorRequest> {
        /**
         * <p>
         * The name of the route calculator resource.
         * </p>
         * <p>
         * Requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be a unique Route calculator resource name.
         * </p>
         * </li>
         * <li>
         * <p>
         * No spaces allowed. For example, <code>ExampleRouteCalculator</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param calculatorName
         *        The name of the route calculator resource. </p>
         *        <p>
         *        Requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be a unique Route calculator resource name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No spaces allowed. For example, <code>ExampleRouteCalculator</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatorName(String calculatorName);

        /**
         * <p>
         * Specifies the data provider of traffic and road network data.
         * </p>
         * <note>
         * <p>
         * This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code>
         * returns an error.
         * </p>
         * </note>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Esri</code> – For additional information about <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your
         * region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri
         * details on street networks and traffic coverage</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Here</code> – For additional information about <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>'s coverage
         * in your region of interest, see <a
         * href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE
         * car routing coverage</a> and <a
         * href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE
         * truck routing coverage</a>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For additional information , see <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data
         * providers</a> on the <i>Amazon Location Service Developer Guide</i>.
         * </p>
         * 
         * @param dataSource
         *        Specifies the data provider of traffic and road network data.</p> <note>
         *        <p>
         *        This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code>
         *        returns an error.
         *        </p>
         *        </note>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Esri</code> – For additional information about <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in
         *        your region of interest, see <a
         *        href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street
         *        networks and traffic coverage</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Here</code> – For additional information about <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>'s
         *        coverage in your region of interest, see <a href=
         *        "https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE
         *        car routing coverage</a> and <a href=
         *        "https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html"
         *        >HERE truck routing coverage</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For additional information , see <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data
         *        providers</a> on the <i>Amazon Location Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The optional description for the route calculator resource.
         * </p>
         * 
         * @param description
         *        The optional description for the route calculator resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the pricing plan for your route calculator resource.
         * </p>
         * <p>
         * For additional details and restrictions on each pricing plan option, see <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Specifies the pricing plan for your route calculator resource.</p>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * Specifies the pricing plan for your route calculator resource.
         * </p>
         * <p>
         * For additional details and restrictions on each pricing plan option, see <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Specifies the pricing plan for your route calculator resource.</p>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify,
         * search, and filter your resources by labelling them.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Format: <code>"key" : "value"</code>
         * </p>
         * <p>
         * Restrictions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum 50 tags per resource
         * </p>
         * </li>
         * <li>
         * <p>
         * Each resource tag must be unique with a maximum of one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage,
         *        identify, search, and filter your resources by labelling them.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Format: <code>"key" : "value"</code>
         *        </p>
         *        <p>
         *        Restrictions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum 50 tags per resource
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each resource tag must be unique with a maximum of one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String calculatorName;

        private String dataSource;

        private String description;

        private String pricingPlan;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteCalculatorRequest model) {
            super(model);
            calculatorName(model.calculatorName);
            dataSource(model.dataSource);
            description(model.description);
            pricingPlan(model.pricingPlan);
            tags(model.tags);
        }

        public final String getCalculatorName() {
            return calculatorName;
        }

        @Override
        public final Builder calculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        public final void setCalculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
        }

        public final String getDataSource() {
            return dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteCalculatorRequest build() {
            return new CreateRouteCalculatorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
