/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the data storage option chosen for requesting Places.
 * </p>
 * <important>
 * <p>
 * When using Amazon Location Places:
 * </p>
 * <ul>
 * <li>
 * <p>
 * If using HERE Technologies as a data provider, you can't store results for locations in Japan by setting
 * <code>IntendedUse</code> to <code>Storage</code>. parameter.
 * </p>
 * </li>
 * <li>
 * <p>
 * Under the <code>MobileAssetTracking</code> or <code>MobilAssetManagement</code> pricing plan, you can't store results
 * from your place index resources by setting <code>IntendedUse</code> to <code>Storage</code>. This returns a
 * validation exception error.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon
 * Location Service.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceConfiguration.Builder, DataSourceConfiguration> {
    private static final SdkField<String> INTENDED_USE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntendedUse").getter(getter(DataSourceConfiguration::intendedUseAsString))
            .setter(setter(Builder::intendedUse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntendedUse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENDED_USE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String intendedUse;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.intendedUse = builder.intendedUse;
    }

    /**
     * <p>
     * Specifies how the results of an operation will be stored by the caller.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SingleUse</code> specifies that the results won't be stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Storage</code> specifies that the result can be cached or stored in a database.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default value: <code>SingleUse</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intendedUse} will
     * return {@link IntendedUse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intendedUseAsString}.
     * </p>
     * 
     * @return Specifies how the results of an operation will be stored by the caller. </p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SingleUse</code> specifies that the results won't be stored.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Storage</code> specifies that the result can be cached or stored in a database.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default value: <code>SingleUse</code>
     * @see IntendedUse
     */
    public final IntendedUse intendedUse() {
        return IntendedUse.fromValue(intendedUse);
    }

    /**
     * <p>
     * Specifies how the results of an operation will be stored by the caller.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SingleUse</code> specifies that the results won't be stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Storage</code> specifies that the result can be cached or stored in a database.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default value: <code>SingleUse</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intendedUse} will
     * return {@link IntendedUse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intendedUseAsString}.
     * </p>
     * 
     * @return Specifies how the results of an operation will be stored by the caller. </p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SingleUse</code> specifies that the results won't be stored.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Storage</code> specifies that the result can be cached or stored in a database.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default value: <code>SingleUse</code>
     * @see IntendedUse
     */
    public final String intendedUseAsString() {
        return intendedUse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intendedUseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration) obj;
        return Objects.equals(intendedUseAsString(), other.intendedUseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceConfiguration").add("IntendedUse", intendedUseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntendedUse":
            return Optional.ofNullable(clazz.cast(intendedUseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceConfiguration> {
        /**
         * <p>
         * Specifies how the results of an operation will be stored by the caller.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SingleUse</code> specifies that the results won't be stored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Storage</code> specifies that the result can be cached or stored in a database.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default value: <code>SingleUse</code>
         * </p>
         * 
         * @param intendedUse
         *        Specifies how the results of an operation will be stored by the caller. </p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SingleUse</code> specifies that the results won't be stored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Storage</code> specifies that the result can be cached or stored in a database.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default value: <code>SingleUse</code>
         * @see IntendedUse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntendedUse
         */
        Builder intendedUse(String intendedUse);

        /**
         * <p>
         * Specifies how the results of an operation will be stored by the caller.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SingleUse</code> specifies that the results won't be stored.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Storage</code> specifies that the result can be cached or stored in a database.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default value: <code>SingleUse</code>
         * </p>
         * 
         * @param intendedUse
         *        Specifies how the results of an operation will be stored by the caller. </p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SingleUse</code> specifies that the results won't be stored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Storage</code> specifies that the result can be cached or stored in a database.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default value: <code>SingleUse</code>
         * @see IntendedUse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntendedUse
         */
        Builder intendedUse(IntendedUse intendedUse);
    }

    static final class BuilderImpl implements Builder {
        private String intendedUse;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            intendedUse(model.intendedUse);
        }

        public final String getIntendedUse() {
            return intendedUse;
        }

        @Override
        public final Builder intendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        @Override
        public final Builder intendedUse(IntendedUse intendedUse) {
            this.intendedUse(intendedUse == null ? null : intendedUse.toString());
            return this;
        }

        public final void setIntendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
        }

        @Override
        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
