/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrackerRequest extends LocationRequest implements
        ToCopyableBuilder<UpdateTrackerRequest.Builder, UpdateTrackerRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateTrackerRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> POSITION_FILTERING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PositionFiltering").getter(getter(UpdateTrackerRequest::positionFilteringAsString))
            .setter(setter(Builder::positionFiltering))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionFiltering").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(UpdateTrackerRequest::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlanDataSource").getter(getter(UpdateTrackerRequest::pricingPlanDataSource))
            .setter(setter(Builder::pricingPlanDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build())
            .build();

    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(UpdateTrackerRequest::trackerName)).setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            POSITION_FILTERING_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, TRACKER_NAME_FIELD));

    private final String description;

    private final String positionFiltering;

    private final String pricingPlan;

    private final String pricingPlanDataSource;

    private final String trackerName;

    private UpdateTrackerRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.positionFiltering = builder.positionFiltering;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.trackerName = builder.trackerName;
    }

    /**
     * <p>
     * Updates the description for the tracker resource.
     * </p>
     * 
     * @return Updates the description for the tracker resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Updates the position filtering for the tracker resource.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
     * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds
     * is stored for each unique device ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
     * Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This
     * helps control costs by reducing the number of geofence evaluations and historical device positions to paginate
     * through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on
     * a map.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
     * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the
     * second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated
     * against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device
     * trajectories on a map, and can help control costs by reducing the number of geofence evaluations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positionFiltering}
     * will return {@link PositionFiltering#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionFilteringAsString}.
     * </p>
     * 
     * @return Updates the position filtering for the tracker resource.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
     *         every location update is stored. If your update frequency is more often than 30 seconds, only one update
     *         per 30 seconds is stored for each unique device ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
     *         ignored. Location updates within this distance are neither evaluated against linked geofence collections,
     *         nor stored. This helps control costs by reducing the number of geofence evaluations and historical device
     *         positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when
     *         displaying device trajectories on a map.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
     *         are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and
     *         10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are
     *         neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS
     *         noise when displaying device trajectories on a map, and can help control costs by reducing the number of
     *         geofence evaluations.
     *         </p>
     *         </li>
     * @see PositionFiltering
     */
    public final PositionFiltering positionFiltering() {
        return PositionFiltering.fromValue(positionFiltering);
    }

    /**
     * <p>
     * Updates the position filtering for the tracker resource.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
     * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds
     * is stored for each unique device ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
     * Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This
     * helps control costs by reducing the number of geofence evaluations and historical device positions to paginate
     * through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on
     * a map.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
     * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the
     * second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated
     * against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device
     * trajectories on a map, and can help control costs by reducing the number of geofence evaluations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positionFiltering}
     * will return {@link PositionFiltering#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionFilteringAsString}.
     * </p>
     * 
     * @return Updates the position filtering for the tracker resource.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
     *         every location update is stored. If your update frequency is more often than 30 seconds, only one update
     *         per 30 seconds is stored for each unique device ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
     *         ignored. Location updates within this distance are neither evaluated against linked geofence collections,
     *         nor stored. This helps control costs by reducing the number of geofence evaluations and historical device
     *         positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when
     *         displaying device trajectories on a map.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
     *         are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and
     *         10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are
     *         neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS
     *         noise when displaying device trajectories on a map, and can help control costs by reducing the number of
     *         geofence evaluations.
     *         </p>
     *         </li>
     * @see PositionFiltering
     */
    public final String positionFilteringAsString() {
        return positionFiltering;
    }

    /**
     * <p>
     * Updates the pricing plan for the tracker resource.
     * </p>
     * <p>
     * For more information about each pricing plan option restrictions, see <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Updates the pricing plan for the tracker resource.</p>
     *         <p>
     *         For more information about each pricing plan option restrictions, see <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
     * @see PricingPlan
     */
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * Updates the pricing plan for the tracker resource.
     * </p>
     * <p>
     * For more information about each pricing plan option restrictions, see <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Updates the pricing plan for the tracker resource.</p>
     *         <p>
     *         For more information about each pricing plan option restrictions, see <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
     * @see PricingPlan
     */
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * <p>
     * Updates the data provider for the tracker resource.
     * </p>
     * <p>
     * A required value for the following pricing plans: <code>MobileAssetTracking</code>|
     * <code>MobileAssetManagement</code>
     * </p>
     * <p>
     * For more information about <a href="https://aws.amazon.com/location/data-providers/">data providers</a> and <a
     * href="https://aws.amazon.com/location/pricing/">pricing plans</a>, see the Amazon Location Service product page
     * </p>
     * <note>
     * <p>
     * This can only be updated when updating the <code>PricingPlan</code> in the same request.
     * </p>
     * <p>
     * Amazon Location Service uses <code>PricingPlanDataSource</code> to calculate billing for your tracker resource.
     * Your data won't be shared with the data provider, and will remain in your AWS account and Region unless you move
     * it.
     * </p>
     * </note>
     * 
     * @return Updates the data provider for the tracker resource. </p>
     *         <p>
     *         A required value for the following pricing plans: <code>MobileAssetTracking</code>|
     *         <code>MobileAssetManagement</code>
     *         </p>
     *         <p>
     *         For more information about <a href="https://aws.amazon.com/location/data-providers/">data providers</a>
     *         and <a href="https://aws.amazon.com/location/pricing/">pricing plans</a>, see the Amazon Location Service
     *         product page
     *         </p>
     *         <note>
     *         <p>
     *         This can only be updated when updating the <code>PricingPlan</code> in the same request.
     *         </p>
     *         <p>
     *         Amazon Location Service uses <code>PricingPlanDataSource</code> to calculate billing for your tracker
     *         resource. Your data won't be shared with the data provider, and will remain in your AWS account and
     *         Region unless you move it.
     *         </p>
     */
    public final String pricingPlanDataSource() {
        return pricingPlanDataSource;
    }

    /**
     * <p>
     * The name of the tracker resource to update.
     * </p>
     * 
     * @return The name of the tracker resource to update.
     */
    public final String trackerName() {
        return trackerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(positionFilteringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrackerRequest)) {
            return false;
        }
        UpdateTrackerRequest other = (UpdateTrackerRequest) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(positionFilteringAsString(), other.positionFilteringAsString())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(pricingPlanDataSource(), other.pricingPlanDataSource())
                && Objects.equals(trackerName(), other.trackerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrackerRequest").add("Description", description())
                .add("PositionFiltering", positionFilteringAsString()).add("PricingPlan", pricingPlanAsString())
                .add("PricingPlanDataSource", pricingPlanDataSource()).add("TrackerName", trackerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PositionFiltering":
            return Optional.ofNullable(clazz.cast(positionFilteringAsString()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "PricingPlanDataSource":
            return Optional.ofNullable(clazz.cast(pricingPlanDataSource()));
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrackerRequest, T> g) {
        return obj -> g.apply((UpdateTrackerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrackerRequest> {
        /**
         * <p>
         * Updates the description for the tracker resource.
         * </p>
         * 
         * @param description
         *        Updates the description for the tracker resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Updates the position filtering for the tracker resource.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
         * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30
         * seconds is stored for each unique device ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
         * Location updates within this distance are neither evaluated against linked geofence collections, nor stored.
         * This helps control costs by reducing the number of geofence evaluations and historical device positions to
         * paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device
         * trajectories on a map.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
         * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m,
         * the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither
         * evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when
         * displaying device trajectories on a map, and can help control costs by reducing the number of geofence
         * evaluations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param positionFiltering
         *        Updates the position filtering for the tracker resource.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
         *        every location update is stored. If your update frequency is more often than 30 seconds, only one
         *        update per 30 seconds is stored for each unique device ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
         *        ignored. Location updates within this distance are neither evaluated against linked geofence
         *        collections, nor stored. This helps control costs by reducing the number of geofence evaluations and
         *        historical device positions to paginate through. Distance-based filtering can also reduce the effects
         *        of GPS noise when displaying device trajectories on a map.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
         *        are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m
         *        and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location
         *        updates are neither evaluated against linked geofence collections, nor stored. This helps educe the
         *        effects of GPS noise when displaying device trajectories on a map, and can help control costs by
         *        reducing the number of geofence evaluations.
         *        </p>
         *        </li>
         * @see PositionFiltering
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionFiltering
         */
        Builder positionFiltering(String positionFiltering);

        /**
         * <p>
         * Updates the position filtering for the tracker resource.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
         * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30
         * seconds is stored for each unique device ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
         * Location updates within this distance are neither evaluated against linked geofence collections, nor stored.
         * This helps control costs by reducing the number of geofence evaluations and historical device positions to
         * paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device
         * trajectories on a map.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
         * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m,
         * the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither
         * evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when
         * displaying device trajectories on a map, and can help control costs by reducing the number of geofence
         * evaluations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param positionFiltering
         *        Updates the position filtering for the tracker resource.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
         *        every location update is stored. If your update frequency is more often than 30 seconds, only one
         *        update per 30 seconds is stored for each unique device ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
         *        ignored. Location updates within this distance are neither evaluated against linked geofence
         *        collections, nor stored. This helps control costs by reducing the number of geofence evaluations and
         *        historical device positions to paginate through. Distance-based filtering can also reduce the effects
         *        of GPS noise when displaying device trajectories on a map.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
         *        are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m
         *        and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location
         *        updates are neither evaluated against linked geofence collections, nor stored. This helps educe the
         *        effects of GPS noise when displaying device trajectories on a map, and can help control costs by
         *        reducing the number of geofence evaluations.
         *        </p>
         *        </li>
         * @see PositionFiltering
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionFiltering
         */
        Builder positionFiltering(PositionFiltering positionFiltering);

        /**
         * <p>
         * Updates the pricing plan for the tracker resource.
         * </p>
         * <p>
         * For more information about each pricing plan option restrictions, see <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Updates the pricing plan for the tracker resource.</p>
         *        <p>
         *        For more information about each pricing plan option restrictions, see <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * Updates the pricing plan for the tracker resource.
         * </p>
         * <p>
         * For more information about each pricing plan option restrictions, see <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Updates the pricing plan for the tracker resource.</p>
         *        <p>
         *        For more information about each pricing plan option restrictions, see <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * Updates the data provider for the tracker resource.
         * </p>
         * <p>
         * A required value for the following pricing plans: <code>MobileAssetTracking</code>|
         * <code>MobileAssetManagement</code>
         * </p>
         * <p>
         * For more information about <a href="https://aws.amazon.com/location/data-providers/">data providers</a> and
         * <a href="https://aws.amazon.com/location/pricing/">pricing plans</a>, see the Amazon Location Service product
         * page
         * </p>
         * <note>
         * <p>
         * This can only be updated when updating the <code>PricingPlan</code> in the same request.
         * </p>
         * <p>
         * Amazon Location Service uses <code>PricingPlanDataSource</code> to calculate billing for your tracker
         * resource. Your data won't be shared with the data provider, and will remain in your AWS account and Region
         * unless you move it.
         * </p>
         * </note>
         * 
         * @param pricingPlanDataSource
         *        Updates the data provider for the tracker resource. </p>
         *        <p>
         *        A required value for the following pricing plans: <code>MobileAssetTracking</code>|
         *        <code>MobileAssetManagement</code>
         *        </p>
         *        <p>
         *        For more information about <a href="https://aws.amazon.com/location/data-providers/">data
         *        providers</a> and <a href="https://aws.amazon.com/location/pricing/">pricing plans</a>, see the Amazon
         *        Location Service product page
         *        </p>
         *        <note>
         *        <p>
         *        This can only be updated when updating the <code>PricingPlan</code> in the same request.
         *        </p>
         *        <p>
         *        Amazon Location Service uses <code>PricingPlanDataSource</code> to calculate billing for your tracker
         *        resource. Your data won't be shared with the data provider, and will remain in your AWS account and
         *        Region unless you move it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingPlanDataSource(String pricingPlanDataSource);

        /**
         * <p>
         * The name of the tracker resource to update.
         * </p>
         * 
         * @param trackerName
         *        The name of the tracker resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String description;

        private String positionFiltering;

        private String pricingPlan;

        private String pricingPlanDataSource;

        private String trackerName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrackerRequest model) {
            super(model);
            description(model.description);
            positionFiltering(model.positionFiltering);
            pricingPlan(model.pricingPlan);
            pricingPlanDataSource(model.pricingPlanDataSource);
            trackerName(model.trackerName);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPositionFiltering() {
            return positionFiltering;
        }

        public final void setPositionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
        }

        @Override
        @Transient
        public final Builder positionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
            return this;
        }

        @Override
        @Transient
        public final Builder positionFiltering(PositionFiltering positionFiltering) {
            this.positionFiltering(positionFiltering == null ? null : positionFiltering.toString());
            return this;
        }

        public final String getPricingPlan() {
            return pricingPlan;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Transient
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Transient
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final String getPricingPlanDataSource() {
            return pricingPlanDataSource;
        }

        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Transient
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final String getTrackerName() {
            return trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        @Transient
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrackerRequest build() {
            return new UpdateTrackerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
