/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the result of the route calculation. Metadata includes legs and route summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculateRouteResponse extends LocationResponse implements
        ToCopyableBuilder<CalculateRouteResponse.Builder, CalculateRouteResponse> {
    private static final SdkField<List<Leg>> LEGS_FIELD = SdkField
            .<List<Leg>> builder(MarshallingType.LIST)
            .memberName("Legs")
            .getter(getter(CalculateRouteResponse::legs))
            .setter(setter(Builder::legs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Leg> builder(MarshallingType.SDK_POJO)
                                            .constructor(Leg::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CalculateRouteSummary> SUMMARY_FIELD = SdkField
            .<CalculateRouteSummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(CalculateRouteResponse::summary)).setter(setter(Builder::summary))
            .constructor(CalculateRouteSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEGS_FIELD, SUMMARY_FIELD));

    private final List<Leg> legs;

    private final CalculateRouteSummary summary;

    private CalculateRouteResponse(BuilderImpl builder) {
        super(builder);
        this.legs = builder.legs;
        this.summary = builder.summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Legs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLegs() {
        return legs != null && !(legs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains details about each path between a pair of positions included along a route such as:
     * <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>,
     * <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer than the
     * total number of positions in the request.
     * </p>
     * <p>
     * For example, a route with a departure position and destination position returns one leg with the positions <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby
     * road</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>StartPosition</code> is the departure position.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>EndPosition</code> is the destination position.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A route with a waypoint between the departure and destination position returns two legs with the positions
     * snapped to a nearby road:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the waypoint
     * positon.
     * </p>
     * </li>
     * <li>
     * <p>
     * Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the destination
     * position.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLegs} method.
     * </p>
     * 
     * @return Contains details about each path between a pair of positions included along a route such as:
     *         <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>
     *         , <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer
     *         than the total number of positions in the request. </p>
     *         <p>
     *         For example, a route with a departure position and destination position returns one leg with the
     *         positions <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a
     *         nearby road</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>StartPosition</code> is the departure position.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <code>EndPosition</code> is the destination position.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         A route with a waypoint between the departure and destination position returns two legs with the
     *         positions snapped to a nearby road:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the
     *         waypoint positon.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the
     *         destination position.
     *         </p>
     *         </li>
     */
    public final List<Leg> legs() {
        return legs;
    }

    /**
     * <p>
     * Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>,
     * <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.
     * </p>
     * 
     * @return Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>,
     *         <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.
     */
    public final CalculateRouteSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLegs() ? legs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteResponse)) {
            return false;
        }
        CalculateRouteResponse other = (CalculateRouteResponse) obj;
        return hasLegs() == other.hasLegs() && Objects.equals(legs(), other.legs()) && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculateRouteResponse").add("Legs", hasLegs() ? legs() : null).add("Summary", summary())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Legs":
            return Optional.ofNullable(clazz.cast(legs()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteResponse, T> g) {
        return obj -> g.apply((CalculateRouteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, CalculateRouteResponse> {
        /**
         * <p>
         * Contains details about each path between a pair of positions included along a route such as:
         * <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>,
         * <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer than the
         * total number of positions in the request.
         * </p>
         * <p>
         * For example, a route with a departure position and destination position returns one leg with the positions <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a
         * nearby road</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>StartPosition</code> is the departure position.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>EndPosition</code> is the destination position.
         * </p>
         * </li>
         * </ul>
         * <p>
         * A route with a waypoint between the departure and destination position returns two legs with the positions
         * snapped to a nearby road:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the
         * waypoint positon.
         * </p>
         * </li>
         * <li>
         * <p>
         * Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the
         * destination position.
         * </p>
         * </li>
         * </ul>
         * 
         * @param legs
         *        Contains details about each path between a pair of positions included along a route such as:
         *        <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>,
         *        <code>DurationSeconds</code>, <code>Geometry</code>, and <code>Steps</code>. The number of legs
         *        returned corresponds to one fewer than the total number of positions in the request. </p>
         *        <p>
         *        For example, a route with a departure position and destination position returns one leg with the
         *        positions <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to
         *        a nearby road</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>StartPosition</code> is the departure position.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>EndPosition</code> is the destination position.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        A route with a waypoint between the departure and destination position returns two legs with the
         *        positions snapped to a nearby road:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the
         *        waypoint positon.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the
         *        destination position.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legs(Collection<Leg> legs);

        /**
         * <p>
         * Contains details about each path between a pair of positions included along a route such as:
         * <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>,
         * <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer than the
         * total number of positions in the request.
         * </p>
         * <p>
         * For example, a route with a departure position and destination position returns one leg with the positions <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a
         * nearby road</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>StartPosition</code> is the departure position.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>EndPosition</code> is the destination position.
         * </p>
         * </li>
         * </ul>
         * <p>
         * A route with a waypoint between the departure and destination position returns two legs with the positions
         * snapped to a nearby road:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the
         * waypoint positon.
         * </p>
         * </li>
         * <li>
         * <p>
         * Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the
         * destination position.
         * </p>
         * </li>
         * </ul>
         * 
         * @param legs
         *        Contains details about each path between a pair of positions included along a route such as:
         *        <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>,
         *        <code>DurationSeconds</code>, <code>Geometry</code>, and <code>Steps</code>. The number of legs
         *        returned corresponds to one fewer than the total number of positions in the request. </p>
         *        <p>
         *        For example, a route with a departure position and destination position returns one leg with the
         *        positions <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to
         *        a nearby road</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>StartPosition</code> is the departure position.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <code>EndPosition</code> is the destination position.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        A route with a waypoint between the departure and destination position returns two legs with the
         *        positions snapped to a nearby road:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the
         *        waypoint positon.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the
         *        destination position.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legs(Leg... legs);

        /**
         * <p>
         * Contains details about each path between a pair of positions included along a route such as:
         * <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>,
         * <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer than the
         * total number of positions in the request.
         * </p>
         * <p>
         * For example, a route with a departure position and destination position returns one leg with the positions <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a
         * nearby road</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>StartPosition</code> is the departure position.
         * </p>
         * </li>
         * <li>
         * <p>
         * The <code>EndPosition</code> is the destination position.
         * </p>
         * </li>
         * </ul>
         * <p>
         * A route with a waypoint between the departure and destination position returns two legs with the positions
         * snapped to a nearby road:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the
         * waypoint positon.
         * </p>
         * </li>
         * <li>
         * <p>
         * Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the
         * destination position.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Leg>.Builder} avoiding the need to create
         * one manually via {@link List<Leg>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Leg>.Builder#build()} is called immediately and its result
         * is passed to {@link #legs(List<Leg>)}.
         * 
         * @param legs
         *        a consumer that will call methods on {@link List<Leg>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legs(List<Leg>)
         */
        Builder legs(Consumer<Leg.Builder>... legs);

        /**
         * <p>
         * Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>,
         * <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.
         * </p>
         * 
         * @param summary
         *        Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>,
         *        <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(CalculateRouteSummary summary);

        /**
         * <p>
         * Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>,
         * <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link CalculateRouteSummary.Builder} avoiding the need
         * to create one manually via {@link CalculateRouteSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link CalculateRouteSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #summary(CalculateRouteSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link CalculateRouteSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(CalculateRouteSummary)
         */
        default Builder summary(Consumer<CalculateRouteSummary.Builder> summary) {
            return summary(CalculateRouteSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<Leg> legs = DefaultSdkAutoConstructList.getInstance();

        private CalculateRouteSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteResponse model) {
            super(model);
            legs(model.legs);
            summary(model.summary);
        }

        public final List<Leg.Builder> getLegs() {
            List<Leg.Builder> result = LegListCopier.copyToBuilder(this.legs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLegs(Collection<Leg.BuilderImpl> legs) {
            this.legs = LegListCopier.copyFromBuilder(legs);
        }

        @Override
        @Transient
        public final Builder legs(Collection<Leg> legs) {
            this.legs = LegListCopier.copy(legs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder legs(Leg... legs) {
            legs(Arrays.asList(legs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder legs(Consumer<Leg.Builder>... legs) {
            legs(Stream.of(legs).map(c -> Leg.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CalculateRouteSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(CalculateRouteSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        @Transient
        public final Builder summary(CalculateRouteSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public CalculateRouteResponse build() {
            return new CalculateRouteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
