/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePlaceIndexRequest extends LocationRequest implements
        ToCopyableBuilder<UpdatePlaceIndexRequest.Builder, UpdatePlaceIndexRequest> {
    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField
            .<DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataSourceConfiguration")
            .getter(getter(UpdatePlaceIndexRequest::dataSourceConfiguration)).setter(setter(Builder::dataSourceConfiguration))
            .constructor(DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceConfiguration").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdatePlaceIndexRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(UpdatePlaceIndexRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IndexName").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(UpdatePlaceIndexRequest::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_SOURCE_CONFIGURATION_FIELD, DESCRIPTION_FIELD, INDEX_NAME_FIELD, PRICING_PLAN_FIELD));

    private final DataSourceConfiguration dataSourceConfiguration;

    private final String description;

    private final String indexName;

    private final String pricingPlan;

    private UpdatePlaceIndexRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.description = builder.description;
        this.indexName = builder.indexName;
        this.pricingPlan = builder.pricingPlan;
    }

    /**
     * <p>
     * Updates the data storage option for the place index resource.
     * </p>
     * 
     * @return Updates the data storage option for the place index resource.
     */
    public final DataSourceConfiguration dataSourceConfiguration() {
        return dataSourceConfiguration;
    }

    /**
     * <p>
     * Updates the description for the place index resource.
     * </p>
     * 
     * @return Updates the description for the place index resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the place index resource to update.
     * </p>
     * 
     * @return The name of the place index resource to update.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
     */
    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
     */
    @Deprecated
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePlaceIndexRequest)) {
            return false;
        }
        UpdatePlaceIndexRequest other = (UpdatePlaceIndexRequest) obj;
        return Objects.equals(dataSourceConfiguration(), other.dataSourceConfiguration())
                && Objects.equals(description(), other.description()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePlaceIndexRequest").add("DataSourceConfiguration", dataSourceConfiguration())
                .add("Description", description()).add("IndexName", indexName()).add("PricingPlan", pricingPlanAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceConfiguration":
            return Optional.ofNullable(clazz.cast(dataSourceConfiguration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePlaceIndexRequest, T> g) {
        return obj -> g.apply((UpdatePlaceIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePlaceIndexRequest> {
        /**
         * <p>
         * Updates the data storage option for the place index resource.
         * </p>
         * 
         * @param dataSourceConfiguration
         *        Updates the data storage option for the place index resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration);

        /**
         * <p>
         * Updates the data storage option for the place index resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataSourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSourceConfiguration(DataSourceConfiguration)}.
         * 
         * @param dataSourceConfiguration
         *        a consumer that will call methods on {@link DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceConfiguration(DataSourceConfiguration)
         */
        default Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return dataSourceConfiguration(DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration).build());
        }

        /**
         * <p>
         * Updates the description for the place index resource.
         * </p>
         * 
         * @param description
         *        Updates the description for the place index resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the place index resource to update.
         * </p>
         * 
         * @param indexName
         *        The name of the place index resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(PricingPlan pricingPlan);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private DataSourceConfiguration dataSourceConfiguration;

        private String description;

        private String indexName;

        private String pricingPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePlaceIndexRequest model) {
            super(model);
            dataSourceConfiguration(model.dataSourceConfiguration);
            description(model.description);
            indexName(model.indexName);
            pricingPlan(model.pricingPlan);
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return dataSourceConfiguration != null ? dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePlaceIndexRequest build() {
            return new UpdatePlaceIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
