/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPlaceIndexForTextResponse extends LocationResponse implements
        ToCopyableBuilder<SearchPlaceIndexForTextResponse.Builder, SearchPlaceIndexForTextResponse> {
    private static final SdkField<List<SearchForTextResult>> RESULTS_FIELD = SdkField
            .<List<SearchForTextResult>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(SearchPlaceIndexForTextResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchForTextResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchForTextResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SearchPlaceIndexForTextSummary> SUMMARY_FIELD = SdkField
            .<SearchPlaceIndexForTextSummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(SearchPlaceIndexForTextResponse::summary)).setter(setter(Builder::summary))
            .constructor(SearchPlaceIndexForTextSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, SUMMARY_FIELD));

    private final List<SearchForTextResult> results;

    private final SearchPlaceIndexForTextSummary summary;

    private SearchPlaceIndexForTextResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.summary = builder.summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Places matching the input text. Each result contains additional information about the specific point of
     * interest.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return A list of Places matching the input text. Each result contains additional information about the specific
     *         point of interest.
     */
    public final List<SearchForTextResult> results() {
        return results;
    }

    /**
     * <p>
     * Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also
     * includes the <code>DataSource</code> of the place index and the bounding box, <code>ResultBBox</code>, which
     * surrounds the search results.
     * </p>
     * 
     * @return Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>,
     *         <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>,
     *         and <code>Text</code>. Also includes the <code>DataSource</code> of the place index and the bounding box,
     *         <code>ResultBBox</code>, which surrounds the search results.
     */
    public final SearchPlaceIndexForTextSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForTextResponse)) {
            return false;
        }
        SearchPlaceIndexForTextResponse other = (SearchPlaceIndexForTextResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPlaceIndexForTextResponse").add("Results", hasResults() ? results() : null)
                .add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForTextResponse, T> g) {
        return obj -> g.apply((SearchPlaceIndexForTextResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchPlaceIndexForTextResponse> {
        /**
         * <p>
         * A list of Places matching the input text. Each result contains additional information about the specific
         * point of interest.
         * </p>
         * 
         * @param results
         *        A list of Places matching the input text. Each result contains additional information about the
         *        specific point of interest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<SearchForTextResult> results);

        /**
         * <p>
         * A list of Places matching the input text. Each result contains additional information about the specific
         * point of interest.
         * </p>
         * 
         * @param results
         *        A list of Places matching the input text. Each result contains additional information about the
         *        specific point of interest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(SearchForTextResult... results);

        /**
         * <p>
         * A list of Places matching the input text. Each result contains additional information about the specific
         * point of interest.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SearchForTextResult>.Builder}
         * avoiding the need to create one manually via {@link List<SearchForTextResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SearchForTextResult>.Builder#build()} is called immediately
         * and its result is passed to {@link #results(List<SearchForTextResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<SearchForTextResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<SearchForTextResult>)
         */
        Builder results(Consumer<SearchForTextResult.Builder>... results);

        /**
         * <p>
         * Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>,
         * <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and
         * <code>Text</code>. Also includes the <code>DataSource</code> of the place index and the bounding box,
         * <code>ResultBBox</code>, which surrounds the search results.
         * </p>
         * 
         * @param summary
         *        Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>,
         *        <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>,
         *        and <code>Text</code>. Also includes the <code>DataSource</code> of the place index and the bounding
         *        box, <code>ResultBBox</code>, which surrounds the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(SearchPlaceIndexForTextSummary summary);

        /**
         * <p>
         * Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>,
         * <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and
         * <code>Text</code>. Also includes the <code>DataSource</code> of the place index and the bounding box,
         * <code>ResultBBox</code>, which surrounds the search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchPlaceIndexForTextSummary.Builder}
         * avoiding the need to create one manually via {@link SearchPlaceIndexForTextSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link SearchPlaceIndexForTextSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #summary(SearchPlaceIndexForTextSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link SearchPlaceIndexForTextSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(SearchPlaceIndexForTextSummary)
         */
        default Builder summary(Consumer<SearchPlaceIndexForTextSummary.Builder> summary) {
            return summary(SearchPlaceIndexForTextSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<SearchForTextResult> results = DefaultSdkAutoConstructList.getInstance();

        private SearchPlaceIndexForTextSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForTextResponse model) {
            super(model);
            results(model.results);
            summary(model.summary);
        }

        public final List<SearchForTextResult.Builder> getResults() {
            List<SearchForTextResult.Builder> result = SearchForTextResultListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<SearchForTextResult.BuilderImpl> results) {
            this.results = SearchForTextResultListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<SearchForTextResult> results) {
            this.results = SearchForTextResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(SearchForTextResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<SearchForTextResult.Builder>... results) {
            results(Stream.of(results).map(c -> SearchForTextResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SearchPlaceIndexForTextSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(SearchPlaceIndexForTextSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(SearchPlaceIndexForTextSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public SearchPlaceIndexForTextResponse build() {
            return new SearchPlaceIndexForTextResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
