/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains error details for each geofence that failed to delete from the geofence collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteGeofenceError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteGeofenceError.Builder, BatchDeleteGeofenceError> {
    private static final SdkField<BatchItemError> ERROR_FIELD = SdkField.<BatchItemError> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(BatchDeleteGeofenceError::error)).setter(setter(Builder::error))
            .constructor(BatchItemError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeofenceId").getter(getter(BatchDeleteGeofenceError::geofenceId)).setter(setter(Builder::geofenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ERROR_FIELD, GEOFENCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final BatchItemError error;

    private final String geofenceId;

    private BatchDeleteGeofenceError(BuilderImpl builder) {
        this.error = builder.error;
        this.geofenceId = builder.geofenceId;
    }

    /**
     * <p>
     * Contains details associated to the batch error.
     * </p>
     * 
     * @return Contains details associated to the batch error.
     */
    public final BatchItemError error() {
        return error;
    }

    /**
     * <p>
     * The geofence associated with the error message.
     * </p>
     * 
     * @return The geofence associated with the error message.
     */
    public final String geofenceId() {
        return geofenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(geofenceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteGeofenceError)) {
            return false;
        }
        BatchDeleteGeofenceError other = (BatchDeleteGeofenceError) obj;
        return Objects.equals(error(), other.error()) && Objects.equals(geofenceId(), other.geofenceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteGeofenceError").add("Error", error()).add("GeofenceId", geofenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "GeofenceId":
            return Optional.ofNullable(clazz.cast(geofenceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteGeofenceError, T> g) {
        return obj -> g.apply((BatchDeleteGeofenceError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteGeofenceError> {
        /**
         * <p>
         * Contains details associated to the batch error.
         * </p>
         * 
         * @param error
         *        Contains details associated to the batch error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(BatchItemError error);

        /**
         * <p>
         * Contains details associated to the batch error.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchItemError.Builder} avoiding the need
         * to create one manually via {@link BatchItemError#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchItemError.Builder#build()} is called immediately and its
         * result is passed to {@link #error(BatchItemError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link BatchItemError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(BatchItemError)
         */
        default Builder error(Consumer<BatchItemError.Builder> error) {
            return error(BatchItemError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The geofence associated with the error message.
         * </p>
         * 
         * @param geofenceId
         *        The geofence associated with the error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geofenceId(String geofenceId);
    }

    static final class BuilderImpl implements Builder {
        private BatchItemError error;

        private String geofenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteGeofenceError model) {
            error(model.error);
            geofenceId(model.geofenceId);
        }

        public final BatchItemError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(BatchItemError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(BatchItemError error) {
            this.error = error;
            return this;
        }

        public final String getGeofenceId() {
            return geofenceId;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        @Override
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        @Override
        public BatchDeleteGeofenceError build() {
            return new BatchDeleteGeofenceError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
