/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutGeofenceResponse extends LocationResponse implements
        ToCopyableBuilder<BatchPutGeofenceResponse.Builder, BatchPutGeofenceResponse> {
    private static final SdkField<List<BatchPutGeofenceError>> ERRORS_FIELD = SdkField
            .<List<BatchPutGeofenceError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchPutGeofenceResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchPutGeofenceError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchPutGeofenceError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchPutGeofenceSuccess>> SUCCESSES_FIELD = SdkField
            .<List<BatchPutGeofenceSuccess>> builder(MarshallingType.LIST)
            .memberName("Successes")
            .getter(getter(BatchPutGeofenceResponse::successes))
            .setter(setter(Builder::successes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchPutGeofenceSuccess> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchPutGeofenceSuccess::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ERRORS_FIELD, SUCCESSES_FIELD));

    private final List<BatchPutGeofenceError> errors;

    private final List<BatchPutGeofenceSuccess> successes;

    private BatchPutGeofenceResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.successes = builder.successes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains additional error details for each geofence that failed to be stored in a geofence collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Contains additional error details for each geofence that failed to be stored in a geofence collection.
     */
    public final List<BatchPutGeofenceError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccesses() {
        return successes != null && !(successes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains each geofence that was successfully stored in a geofence collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccesses} method.
     * </p>
     * 
     * @return Contains each geofence that was successfully stored in a geofence collection.
     */
    public final List<BatchPutGeofenceSuccess> successes() {
        return successes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccesses() ? successes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutGeofenceResponse)) {
            return false;
        }
        BatchPutGeofenceResponse other = (BatchPutGeofenceResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasSuccesses() == other.hasSuccesses() && Objects.equals(successes(), other.successes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutGeofenceResponse").add("Errors", hasErrors() ? errors() : null)
                .add("Successes", hasSuccesses() ? successes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "Successes":
            return Optional.ofNullable(clazz.cast(successes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutGeofenceResponse, T> g) {
        return obj -> g.apply((BatchPutGeofenceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchPutGeofenceResponse> {
        /**
         * <p>
         * Contains additional error details for each geofence that failed to be stored in a geofence collection.
         * </p>
         * 
         * @param errors
         *        Contains additional error details for each geofence that failed to be stored in a geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchPutGeofenceError> errors);

        /**
         * <p>
         * Contains additional error details for each geofence that failed to be stored in a geofence collection.
         * </p>
         * 
         * @param errors
         *        Contains additional error details for each geofence that failed to be stored in a geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchPutGeofenceError... errors);

        /**
         * <p>
         * Contains additional error details for each geofence that failed to be stored in a geofence collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<BatchPutGeofenceError>.Builder}
         * avoiding the need to create one manually via {@link List<BatchPutGeofenceError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchPutGeofenceError>.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchPutGeofenceError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchPutGeofenceError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchPutGeofenceError>)
         */
        Builder errors(Consumer<BatchPutGeofenceError.Builder>... errors);

        /**
         * <p>
         * Contains each geofence that was successfully stored in a geofence collection.
         * </p>
         * 
         * @param successes
         *        Contains each geofence that was successfully stored in a geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successes(Collection<BatchPutGeofenceSuccess> successes);

        /**
         * <p>
         * Contains each geofence that was successfully stored in a geofence collection.
         * </p>
         * 
         * @param successes
         *        Contains each geofence that was successfully stored in a geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successes(BatchPutGeofenceSuccess... successes);

        /**
         * <p>
         * Contains each geofence that was successfully stored in a geofence collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<BatchPutGeofenceSuccess>.Builder}
         * avoiding the need to create one manually via {@link List<BatchPutGeofenceSuccess>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchPutGeofenceSuccess>.Builder#build()} is called
         * immediately and its result is passed to {@link #successes(List<BatchPutGeofenceSuccess>)}.
         * 
         * @param successes
         *        a consumer that will call methods on {@link List<BatchPutGeofenceSuccess>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successes(List<BatchPutGeofenceSuccess>)
         */
        Builder successes(Consumer<BatchPutGeofenceSuccess.Builder>... successes);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<BatchPutGeofenceError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<BatchPutGeofenceSuccess> successes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutGeofenceResponse model) {
            super(model);
            errors(model.errors);
            successes(model.successes);
        }

        public final List<BatchPutGeofenceError.Builder> getErrors() {
            List<BatchPutGeofenceError.Builder> result = BatchPutGeofenceErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchPutGeofenceError.BuilderImpl> errors) {
            this.errors = BatchPutGeofenceErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchPutGeofenceError> errors) {
            this.errors = BatchPutGeofenceErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchPutGeofenceError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchPutGeofenceError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchPutGeofenceError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchPutGeofenceSuccess.Builder> getSuccesses() {
            List<BatchPutGeofenceSuccess.Builder> result = BatchPutGeofenceSuccessListCopier.copyToBuilder(this.successes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccesses(Collection<BatchPutGeofenceSuccess.BuilderImpl> successes) {
            this.successes = BatchPutGeofenceSuccessListCopier.copyFromBuilder(successes);
        }

        @Override
        public final Builder successes(Collection<BatchPutGeofenceSuccess> successes) {
            this.successes = BatchPutGeofenceSuccessListCopier.copy(successes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successes(BatchPutGeofenceSuccess... successes) {
            successes(Arrays.asList(successes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successes(Consumer<BatchPutGeofenceSuccess.Builder>... successes) {
            successes(Stream.of(successes).map(c -> BatchPutGeofenceSuccess.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchPutGeofenceResponse build() {
            return new BatchPutGeofenceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
