/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the result of the route matrix calculation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculateRouteMatrixResponse extends LocationResponse implements
        ToCopyableBuilder<CalculateRouteMatrixResponse.Builder, CalculateRouteMatrixResponse> {
    private static final SdkField<List<List<RouteMatrixEntry>>> ROUTE_MATRIX_FIELD = SdkField
            .<List<List<RouteMatrixEntry>>> builder(MarshallingType.LIST)
            .memberName("RouteMatrix")
            .getter(getter(CalculateRouteMatrixResponse::routeMatrix))
            .setter(setter(Builder::routeMatrix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteMatrix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<RouteMatrixEntry>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<RouteMatrixEntry> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(RouteMatrixEntry::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<List<Double>>> SNAPPED_DEPARTURE_POSITIONS_FIELD = SdkField
            .<List<List<Double>>> builder(MarshallingType.LIST)
            .memberName("SnappedDeparturePositions")
            .getter(getter(CalculateRouteMatrixResponse::snappedDeparturePositions))
            .setter(setter(Builder::snappedDeparturePositions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedDeparturePositions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<Double>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<List<Double>>> SNAPPED_DESTINATION_POSITIONS_FIELD = SdkField
            .<List<List<Double>>> builder(MarshallingType.LIST)
            .memberName("SnappedDestinationPositions")
            .getter(getter(CalculateRouteMatrixResponse::snappedDestinationPositions))
            .setter(setter(Builder::snappedDestinationPositions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedDestinationPositions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<Double>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<CalculateRouteMatrixSummary> SUMMARY_FIELD = SdkField
            .<CalculateRouteMatrixSummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(CalculateRouteMatrixResponse::summary)).setter(setter(Builder::summary))
            .constructor(CalculateRouteMatrixSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_MATRIX_FIELD,
            SNAPPED_DEPARTURE_POSITIONS_FIELD, SNAPPED_DESTINATION_POSITIONS_FIELD, SUMMARY_FIELD));

    private final List<List<RouteMatrixEntry>> routeMatrix;

    private final List<List<Double>> snappedDeparturePositions;

    private final List<List<Double>> snappedDestinationPositions;

    private final CalculateRouteMatrixSummary summary;

    private CalculateRouteMatrixResponse(BuilderImpl builder) {
        super(builder);
        this.routeMatrix = builder.routeMatrix;
        this.snappedDeparturePositions = builder.snappedDeparturePositions;
        this.snappedDestinationPositions = builder.snappedDestinationPositions;
        this.summary = builder.summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteMatrix property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteMatrix() {
        return routeMatrix != null && !(routeMatrix instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to
     * <code>DestinationPositions</code>. Each row corresponds to one entry in <code>DeparturePositions</code>. Each
     * entry in the row corresponds to the route from that entry in <code>DeparturePositions</code> to an entry in
     * <code>DestinationPositions</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteMatrix} method.
     * </p>
     * 
     * @return The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to
     *         <code>DestinationPositions</code>. Each row corresponds to one entry in <code>DeparturePositions</code>.
     *         Each entry in the row corresponds to the route from that entry in <code>DeparturePositions</code> to an
     *         entry in <code>DestinationPositions</code>.
     */
    public final List<List<RouteMatrixEntry>> routeMatrix() {
        return routeMatrix;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnappedDeparturePositions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSnappedDeparturePositions() {
        return snappedDeparturePositions != null && !(snappedDeparturePositions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest
     * road. For Esri route calculator resources, this returns the list of departure/origin positions used for
     * calculation of the <code>RouteMatrix</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnappedDeparturePositions} method.
     * </p>
     * 
     * @return For routes calculated using an Esri route calculator resource, departure positions are snapped to the
     *         closest road. For Esri route calculator resources, this returns the list of departure/origin positions
     *         used for calculation of the <code>RouteMatrix</code>.
     */
    public final List<List<Double>> snappedDeparturePositions() {
        return snappedDeparturePositions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnappedDestinationPositions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSnappedDestinationPositions() {
        return snappedDestinationPositions != null && !(snappedDestinationPositions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of destination positions for the route matrix used for calculation of the <code>RouteMatrix</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnappedDestinationPositions} method.
     * </p>
     * 
     * @return The list of destination positions for the route matrix used for calculation of the
     *         <code>RouteMatrix</code>.
     */
    public final List<List<Double>> snappedDestinationPositions() {
        return snappedDestinationPositions;
    }

    /**
     * <p>
     * Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>,
     * <code>RouteCount</code> and <code>ErrorCount</code>.
     * </p>
     * 
     * @return Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>,
     *         <code>RouteCount</code> and <code>ErrorCount</code>.
     */
    public final CalculateRouteMatrixSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteMatrix() ? routeMatrix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSnappedDeparturePositions() ? snappedDeparturePositions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSnappedDestinationPositions() ? snappedDestinationPositions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteMatrixResponse)) {
            return false;
        }
        CalculateRouteMatrixResponse other = (CalculateRouteMatrixResponse) obj;
        return hasRouteMatrix() == other.hasRouteMatrix() && Objects.equals(routeMatrix(), other.routeMatrix())
                && hasSnappedDeparturePositions() == other.hasSnappedDeparturePositions()
                && Objects.equals(snappedDeparturePositions(), other.snappedDeparturePositions())
                && hasSnappedDestinationPositions() == other.hasSnappedDestinationPositions()
                && Objects.equals(snappedDestinationPositions(), other.snappedDestinationPositions())
                && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CalculateRouteMatrixResponse")
                .add("RouteMatrix", hasRouteMatrix() ? routeMatrix() : null)
                .add("SnappedDeparturePositions", snappedDeparturePositions() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SnappedDestinationPositions",
                        snappedDestinationPositions() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteMatrix":
            return Optional.ofNullable(clazz.cast(routeMatrix()));
        case "SnappedDeparturePositions":
            return Optional.ofNullable(clazz.cast(snappedDeparturePositions()));
        case "SnappedDestinationPositions":
            return Optional.ofNullable(clazz.cast(snappedDestinationPositions()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteMatrixResponse, T> g) {
        return obj -> g.apply((CalculateRouteMatrixResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, CalculateRouteMatrixResponse> {
        /**
         * <p>
         * The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to
         * <code>DestinationPositions</code>. Each row corresponds to one entry in <code>DeparturePositions</code>. Each
         * entry in the row corresponds to the route from that entry in <code>DeparturePositions</code> to an entry in
         * <code>DestinationPositions</code>.
         * </p>
         * 
         * @param routeMatrix
         *        The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to
         *        <code>DestinationPositions</code>. Each row corresponds to one entry in
         *        <code>DeparturePositions</code>. Each entry in the row corresponds to the route from that entry in
         *        <code>DeparturePositions</code> to an entry in <code>DestinationPositions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeMatrix(Collection<? extends Collection<RouteMatrixEntry>> routeMatrix);

        /**
         * <p>
         * The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to
         * <code>DestinationPositions</code>. Each row corresponds to one entry in <code>DeparturePositions</code>. Each
         * entry in the row corresponds to the route from that entry in <code>DeparturePositions</code> to an entry in
         * <code>DestinationPositions</code>.
         * </p>
         * 
         * @param routeMatrix
         *        The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to
         *        <code>DestinationPositions</code>. Each row corresponds to one entry in
         *        <code>DeparturePositions</code>. Each entry in the row corresponds to the route from that entry in
         *        <code>DeparturePositions</code> to an entry in <code>DestinationPositions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeMatrix(Collection<RouteMatrixEntry>... routeMatrix);

        /**
         * <p>
         * For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest
         * road. For Esri route calculator resources, this returns the list of departure/origin positions used for
         * calculation of the <code>RouteMatrix</code>.
         * </p>
         * 
         * @param snappedDeparturePositions
         *        For routes calculated using an Esri route calculator resource, departure positions are snapped to the
         *        closest road. For Esri route calculator resources, this returns the list of departure/origin positions
         *        used for calculation of the <code>RouteMatrix</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedDeparturePositions(Collection<? extends Collection<Double>> snappedDeparturePositions);

        /**
         * <p>
         * For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest
         * road. For Esri route calculator resources, this returns the list of departure/origin positions used for
         * calculation of the <code>RouteMatrix</code>.
         * </p>
         * 
         * @param snappedDeparturePositions
         *        For routes calculated using an Esri route calculator resource, departure positions are snapped to the
         *        closest road. For Esri route calculator resources, this returns the list of departure/origin positions
         *        used for calculation of the <code>RouteMatrix</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedDeparturePositions(Collection<Double>... snappedDeparturePositions);

        /**
         * <p>
         * The list of destination positions for the route matrix used for calculation of the <code>RouteMatrix</code>.
         * </p>
         * 
         * @param snappedDestinationPositions
         *        The list of destination positions for the route matrix used for calculation of the
         *        <code>RouteMatrix</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedDestinationPositions(Collection<? extends Collection<Double>> snappedDestinationPositions);

        /**
         * <p>
         * The list of destination positions for the route matrix used for calculation of the <code>RouteMatrix</code>.
         * </p>
         * 
         * @param snappedDestinationPositions
         *        The list of destination positions for the route matrix used for calculation of the
         *        <code>RouteMatrix</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedDestinationPositions(Collection<Double>... snappedDestinationPositions);

        /**
         * <p>
         * Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>,
         * <code>RouteCount</code> and <code>ErrorCount</code>.
         * </p>
         * 
         * @param summary
         *        Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>,
         *        <code>RouteCount</code> and <code>ErrorCount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(CalculateRouteMatrixSummary summary);

        /**
         * <p>
         * Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>,
         * <code>RouteCount</code> and <code>ErrorCount</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalculateRouteMatrixSummary.Builder}
         * avoiding the need to create one manually via {@link CalculateRouteMatrixSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link CalculateRouteMatrixSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #summary(CalculateRouteMatrixSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link CalculateRouteMatrixSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(CalculateRouteMatrixSummary)
         */
        default Builder summary(Consumer<CalculateRouteMatrixSummary.Builder> summary) {
            return summary(CalculateRouteMatrixSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<List<RouteMatrixEntry>> routeMatrix = DefaultSdkAutoConstructList.getInstance();

        private List<List<Double>> snappedDeparturePositions = DefaultSdkAutoConstructList.getInstance();

        private List<List<Double>> snappedDestinationPositions = DefaultSdkAutoConstructList.getInstance();

        private CalculateRouteMatrixSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteMatrixResponse model) {
            super(model);
            routeMatrix(model.routeMatrix);
            snappedDeparturePositions(model.snappedDeparturePositions);
            snappedDestinationPositions(model.snappedDestinationPositions);
            summary(model.summary);
        }

        public final List<List<RouteMatrixEntry.Builder>> getRouteMatrix() {
            List<List<RouteMatrixEntry.Builder>> result = RouteMatrixCopier.copyToBuilder(this.routeMatrix);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteMatrix(Collection<? extends Collection<RouteMatrixEntry.BuilderImpl>> routeMatrix) {
            this.routeMatrix = RouteMatrixCopier.copyFromBuilder(routeMatrix);
        }

        @Override
        public final Builder routeMatrix(Collection<? extends Collection<RouteMatrixEntry>> routeMatrix) {
            this.routeMatrix = RouteMatrixCopier.copy(routeMatrix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeMatrix(Collection<RouteMatrixEntry>... routeMatrix) {
            routeMatrix(Arrays.asList(routeMatrix));
            return this;
        }

        public final Collection<? extends Collection<Double>> getSnappedDeparturePositions() {
            if (snappedDeparturePositions instanceof SdkAutoConstructList) {
                return null;
            }
            return snappedDeparturePositions;
        }

        public final void setSnappedDeparturePositions(Collection<? extends Collection<Double>> snappedDeparturePositions) {
            this.snappedDeparturePositions = CalculateRouteMatrixResponseSnappedDeparturePositionsListCopier
                    .copy(snappedDeparturePositions);
        }

        @Override
        public final Builder snappedDeparturePositions(Collection<? extends Collection<Double>> snappedDeparturePositions) {
            this.snappedDeparturePositions = CalculateRouteMatrixResponseSnappedDeparturePositionsListCopier
                    .copy(snappedDeparturePositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedDeparturePositions(Collection<Double>... snappedDeparturePositions) {
            snappedDeparturePositions(Arrays.asList(snappedDeparturePositions));
            return this;
        }

        public final Collection<? extends Collection<Double>> getSnappedDestinationPositions() {
            if (snappedDestinationPositions instanceof SdkAutoConstructList) {
                return null;
            }
            return snappedDestinationPositions;
        }

        public final void setSnappedDestinationPositions(Collection<? extends Collection<Double>> snappedDestinationPositions) {
            this.snappedDestinationPositions = CalculateRouteMatrixResponseSnappedDestinationPositionsListCopier
                    .copy(snappedDestinationPositions);
        }

        @Override
        public final Builder snappedDestinationPositions(Collection<? extends Collection<Double>> snappedDestinationPositions) {
            this.snappedDestinationPositions = CalculateRouteMatrixResponseSnappedDestinationPositionsListCopier
                    .copy(snappedDestinationPositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedDestinationPositions(Collection<Double>... snappedDestinationPositions) {
            snappedDestinationPositions(Arrays.asList(snappedDestinationPositions));
            return this;
        }

        public final CalculateRouteMatrixSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(CalculateRouteMatrixSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(CalculateRouteMatrixSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public CalculateRouteMatrixResponse build() {
            return new CalculateRouteMatrixResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
