/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateTrackerConsumerRequest extends LocationRequest implements
        ToCopyableBuilder<DisassociateTrackerConsumerRequest.Builder, DisassociateTrackerConsumerRequest> {
    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerArn").getter(getter(DisassociateTrackerConsumerRequest::consumerArn))
            .setter(setter(Builder::consumerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConsumerArn").build()).build();

    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(DisassociateTrackerConsumerRequest::trackerName))
            .setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_ARN_FIELD,
            TRACKER_NAME_FIELD));

    private final String consumerArn;

    private final String trackerName;

    private DisassociateTrackerConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.consumerArn = builder.consumerArn;
        this.trackerName = builder.trackerName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource. Used
     * when you need to specify a resource across all AWS.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource.
     *         Used when you need to specify a resource across all AWS. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Format example:
     *         <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code>
     *         </p>
     *         </li>
     */
    public final String consumerArn() {
        return consumerArn;
    }

    /**
     * <p>
     * The name of the tracker resource to be dissociated from the consumer.
     * </p>
     * 
     * @return The name of the tracker resource to be dissociated from the consumer.
     */
    public final String trackerName() {
        return trackerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumerArn());
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateTrackerConsumerRequest)) {
            return false;
        }
        DisassociateTrackerConsumerRequest other = (DisassociateTrackerConsumerRequest) obj;
        return Objects.equals(consumerArn(), other.consumerArn()) && Objects.equals(trackerName(), other.trackerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateTrackerConsumerRequest").add("ConsumerArn", consumerArn())
                .add("TrackerName", trackerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerArn":
            return Optional.ofNullable(clazz.cast(consumerArn()));
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateTrackerConsumerRequest, T> g) {
        return obj -> g.apply((DisassociateTrackerConsumerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateTrackerConsumerRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource.
         * Used when you need to specify a resource across all AWS.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format example:
         * <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param consumerArn
         *        The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker
         *        resource. Used when you need to specify a resource across all AWS. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Format example:
         *        <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerArn(String consumerArn);

        /**
         * <p>
         * The name of the tracker resource to be dissociated from the consumer.
         * </p>
         * 
         * @param trackerName
         *        The name of the tracker resource to be dissociated from the consumer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String consumerArn;

        private String trackerName;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateTrackerConsumerRequest model) {
            super(model);
            consumerArn(model.consumerArn);
            trackerName(model.trackerName);
        }

        public final String getConsumerArn() {
            return consumerArn;
        }

        public final void setConsumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
        }

        @Override
        public final Builder consumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
            return this;
        }

        public final String getTrackerName() {
            return trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateTrackerConsumerRequest build() {
            return new DisassociateTrackerConsumerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
