/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result for the calculated route of one <code>DeparturePosition</code> <code>DestinationPosition</code> pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixEntry.Builder, RouteMatrixEntry> {
    private static final SdkField<Double> DISTANCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Distance").getter(getter(RouteMatrixEntry::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<Double> DURATION_SECONDS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DurationSeconds").getter(getter(RouteMatrixEntry::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()).build();

    private static final SdkField<RouteMatrixEntryError> ERROR_FIELD = SdkField
            .<RouteMatrixEntryError> builder(MarshallingType.SDK_POJO).memberName("Error")
            .getter(getter(RouteMatrixEntry::error)).setter(setter(Builder::error)).constructor(RouteMatrixEntryError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTANCE_FIELD,
            DURATION_SECONDS_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double distance;

    private final Double durationSeconds;

    private final RouteMatrixEntryError error;

    private RouteMatrixEntry(BuilderImpl builder) {
        this.distance = builder.distance;
        this.durationSeconds = builder.durationSeconds;
        this.error = builder.error;
    }

    /**
     * <p>
     * The total distance of travel for the route.
     * </p>
     * 
     * @return The total distance of travel for the route.
     */
    public final Double distance() {
        return distance;
    }

    /**
     * <p>
     * The expected duration of travel for the route.
     * </p>
     * 
     * @return The expected duration of travel for the route.
     */
    public final Double durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and
     * <code>DestinationPosition</code>.
     * </p>
     * 
     * @return An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and
     *         <code>DestinationPosition</code>.
     */
    public final RouteMatrixEntryError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixEntry)) {
            return false;
        }
        RouteMatrixEntry other = (RouteMatrixEntry) obj;
        return Objects.equals(distance(), other.distance()) && Objects.equals(durationSeconds(), other.durationSeconds())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixEntry").add("Distance", distance()).add("DurationSeconds", durationSeconds())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixEntry, T> g) {
        return obj -> g.apply((RouteMatrixEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixEntry> {
        /**
         * <p>
         * The total distance of travel for the route.
         * </p>
         * 
         * @param distance
         *        The total distance of travel for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Double distance);

        /**
         * <p>
         * The expected duration of travel for the route.
         * </p>
         * 
         * @param durationSeconds
         *        The expected duration of travel for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Double durationSeconds);

        /**
         * <p>
         * An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and
         * <code>DestinationPosition</code>.
         * </p>
         * 
         * @param error
         *        An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and
         *        <code>DestinationPosition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(RouteMatrixEntryError error);

        /**
         * <p>
         * An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and
         * <code>DestinationPosition</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteMatrixEntryError.Builder} avoiding
         * the need to create one manually via {@link RouteMatrixEntryError#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteMatrixEntryError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(RouteMatrixEntryError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link RouteMatrixEntryError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(RouteMatrixEntryError)
         */
        default Builder error(Consumer<RouteMatrixEntryError.Builder> error) {
            return error(RouteMatrixEntryError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double distance;

        private Double durationSeconds;

        private RouteMatrixEntryError error;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixEntry model) {
            distance(model.distance);
            durationSeconds(model.durationSeconds);
            error(model.error);
        }

        public final Double getDistance() {
            return distance;
        }

        public final void setDistance(Double distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Double distance) {
            this.distance = distance;
            return this;
        }

        public final Double getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final RouteMatrixEntryError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(RouteMatrixEntryError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(RouteMatrixEntryError error) {
            this.error = error;
            return this;
        }

        @Override
        public RouteMatrixEntry build() {
            return new RouteMatrixEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
