/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the map tile style selected from an available provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MapConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MapConfiguration.Builder, MapConfiguration> {
    private static final SdkField<String> STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Style")
            .getter(getter(MapConfiguration::style)).setter(setter(Builder::style))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Style").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String style;

    private MapConfiguration(BuilderImpl builder) {
        this.style = builder.style;
    }

    /**
     * <p>
     * Specifies the map style selected from an available data provider.
     * </p>
     * <p>
     * Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map styles</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray,
     * neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic
     * content.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter or better
     * satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a detailed vector
     * basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to
     * draw attention to your thematic content.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector basemap with a
     * classic Esri map style.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector basemap for
     * the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style
     * to the World Street Map raster map.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed basemap for
     * the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies map
     * styles</a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VectorHereContrast</code> – The HERE Contrast (Berlin) map style is a high contrast detailed base map of
     * the world that blends 3D and 2D rendering.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VectorHereExplore</code> – A default HERE map style containing a neutral, global map and its features
     * including roads, buildings, landmarks, and water features. It also now includes a fully designed map of Japan.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VectorHereExploreTruck</code> – A global map containing truck restrictions and attributes (e.g. width /
     * height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to support use cases
     * within transport and logistics.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>VectorHereContrast</code> style has been renamed from <code>VectorHereBerlin</code>.
     * <code>VectorHereBerlin</code> has been deprecated, but will continue to work in applications that use it.
     * </p>
     * </note>
     * 
     * @return Specifies the map style selected from an available data provider.</p>
     *         <p>
     *         Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map styles</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a dark
     *         gray, neutral background with minimal colors, labels, and features that's designed to draw attention to
     *         your thematic content.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter or
     *         better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery
     *         worldwide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a detailed
     *         vector basemap with a light gray, neutral background style with minimal colors, labels, and features
     *         that's designed to draw attention to your thematic content.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector basemap
     *         with a classic Esri map style.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector
     *         basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar
     *         in content and style to the World Street Map raster map.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed
     *         basemap for the world symbolized with a custom navigation map style that's designed for use during the
     *         day in mobile devices.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies
     *         map styles</a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VectorHereContrast</code> – The HERE Contrast (Berlin) map style is a high contrast detailed base
     *         map of the world that blends 3D and 2D rendering.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VectorHereExplore</code> – A default HERE map style containing a neutral, global map and its
     *         features including roads, buildings, landmarks, and water features. It also now includes a fully designed
     *         map of Japan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VectorHereExploreTruck</code> – A global map containing truck restrictions and attributes (e.g.
     *         width / height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to support
     *         use cases within transport and logistics.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>VectorHereContrast</code> style has been renamed from <code>VectorHereBerlin</code>.
     *         <code>VectorHereBerlin</code> has been deprecated, but will continue to work in applications that use it.
     *         </p>
     */
    public final String style() {
        return style;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(style());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapConfiguration)) {
            return false;
        }
        MapConfiguration other = (MapConfiguration) obj;
        return Objects.equals(style(), other.style());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MapConfiguration").add("Style", style()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Style":
            return Optional.ofNullable(clazz.cast(style()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MapConfiguration, T> g) {
        return obj -> g.apply((MapConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MapConfiguration> {
        /**
         * <p>
         * Specifies the map style selected from an available data provider.
         * </p>
         * <p>
         * Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map styles</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a dark
         * gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your
         * thematic content.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter or
         * better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery
         * worldwide.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a detailed
         * vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's
         * designed to draw attention to your thematic content.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector basemap with
         * a classic Esri map style.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector basemap
         * for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content
         * and style to the World Street Map raster map.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed basemap
         * for the world symbolized with a custom navigation map style that's designed for use during the day in mobile
         * devices.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies map
         * styles</a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VectorHereContrast</code> – The HERE Contrast (Berlin) map style is a high contrast detailed base map
         * of the world that blends 3D and 2D rendering.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VectorHereExplore</code> – A default HERE map style containing a neutral, global map and its features
         * including roads, buildings, landmarks, and water features. It also now includes a fully designed map of
         * Japan.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VectorHereExploreTruck</code> – A global map containing truck restrictions and attributes (e.g. width /
         * height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to support use cases
         * within transport and logistics.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>VectorHereContrast</code> style has been renamed from <code>VectorHereBerlin</code>.
         * <code>VectorHereBerlin</code> has been deprecated, but will continue to work in applications that use it.
         * </p>
         * </note>
         * 
         * @param style
         *        Specifies the map style selected from an available data provider.</p>
         *        <p>
         *        Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map
         *        styles</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a
         *        dark gray, neutral background with minimal colors, labels, and features that's designed to draw
         *        attention to your thematic content.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter
         *        or better satellite and aerial imagery in many parts of the world and lower resolution satellite
         *        imagery worldwide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a
         *        detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and
         *        features that's designed to draw attention to your thematic content.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector
         *        basemap with a classic Esri map style.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector
         *        basemap for the world symbolized with a classic Esri street map style. The vector tile layer is
         *        similar in content and style to the World Street Map raster map.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed
         *        basemap for the world symbolized with a custom navigation map style that's designed for use during the
         *        day in mobile devices.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies
         *        map styles</a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VectorHereContrast</code> – The HERE Contrast (Berlin) map style is a high contrast detailed
         *        base map of the world that blends 3D and 2D rendering.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VectorHereExplore</code> – A default HERE map style containing a neutral, global map and its
         *        features including roads, buildings, landmarks, and water features. It also now includes a fully
         *        designed map of Japan.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VectorHereExploreTruck</code> – A global map containing truck restrictions and attributes (e.g.
         *        width / height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to
         *        support use cases within transport and logistics.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>VectorHereContrast</code> style has been renamed from <code>VectorHereBerlin</code>.
         *        <code>VectorHereBerlin</code> has been deprecated, but will continue to work in applications that use
         *        it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder style(String style);
    }

    static final class BuilderImpl implements Builder {
        private String style;

        private BuilderImpl() {
        }

        private BuilderImpl(MapConfiguration model) {
            style(model.style);
        }

        public final String getStyle() {
            return style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        @Override
        public MapConfiguration build() {
            return new MapConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
