/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the reverse geocoding request sent using <code>SearchPlaceIndexForPosition</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPlaceIndexForPositionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchPlaceIndexForPositionSummary.Builder, SearchPlaceIndexForPositionSummary> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(SearchPlaceIndexForPositionSummary::dataSource))
            .setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchPlaceIndexForPositionSummary::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(SearchPlaceIndexForPositionSummary::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            MAX_RESULTS_FIELD, POSITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSource;

    private final Integer maxResults;

    private final List<Double> position;

    private SearchPlaceIndexForPositionSummary(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.maxResults = builder.maxResults;
        this.position = builder.position;
    }

    /**
     * <p>
     * The data provider of geospatial data. Indicates one of the available providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Esri
     * </p>
     * </li>
     * <li>
     * <p>
     * HERE
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional details on data providers, see <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location
     * Service data providers</a>.
     * </p>
     * 
     * @return The data provider of geospatial data. Indicates one of the available providers:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Esri
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HERE
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For additional details on data providers, see <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon
     *         Location Service data providers</a>.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * An optional parameter. The maximum number of results returned per request.
     * </p>
     * <p>
     * Default value: <code>50</code>
     * </p>
     * 
     * @return An optional parameter. The maximum number of results returned per request. </p>
     *         <p>
     *         Default value: <code>50</code>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The position given in the reverse geocoding request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return The position given in the reverse geocoding request.
     */
    public final List<Double> position() {
        return position;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForPositionSummary)) {
            return false;
        }
        SearchPlaceIndexForPositionSummary other = (SearchPlaceIndexForPositionSummary) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(maxResults(), other.maxResults())
                && hasPosition() == other.hasPosition() && Objects.equals(position(), other.position());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPlaceIndexForPositionSummary").add("DataSource", dataSource())
                .add("MaxResults", maxResults()).add("Position", position() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForPositionSummary, T> g) {
        return obj -> g.apply((SearchPlaceIndexForPositionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchPlaceIndexForPositionSummary> {
        /**
         * <p>
         * The data provider of geospatial data. Indicates one of the available providers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Esri
         * </p>
         * </li>
         * <li>
         * <p>
         * HERE
         * </p>
         * </li>
         * </ul>
         * <p>
         * For additional details on data providers, see <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location
         * Service data providers</a>.
         * </p>
         * 
         * @param dataSource
         *        The data provider of geospatial data. Indicates one of the available providers:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Esri
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HERE
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For additional details on data providers, see <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon
         *        Location Service data providers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * An optional parameter. The maximum number of results returned per request.
         * </p>
         * <p>
         * Default value: <code>50</code>
         * </p>
         * 
         * @param maxResults
         *        An optional parameter. The maximum number of results returned per request. </p>
         *        <p>
         *        Default value: <code>50</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The position given in the reverse geocoding request.
         * </p>
         * 
         * @param position
         *        The position given in the reverse geocoding request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * The position given in the reverse geocoding request.
         * </p>
         * 
         * @param position
         *        The position given in the reverse geocoding request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);
    }

    static final class BuilderImpl implements Builder {
        private String dataSource;

        private Integer maxResults;

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForPositionSummary model) {
            dataSource(model.dataSource);
            maxResults(model.maxResults);
            position(model.position);
        }

        public final String getDataSource() {
            return dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        @Transient
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        @Transient
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        @Override
        public SearchPlaceIndexForPositionSummary build() {
            return new SearchPlaceIndexForPositionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
