/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the request sent by using <code>SearchPlaceIndexForText</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPlaceIndexForTextSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchPlaceIndexForTextSummary.Builder, SearchPlaceIndexForTextSummary> {
    private static final SdkField<List<Double>> BIAS_POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("BiasPosition")
            .getter(getter(SearchPlaceIndexForTextSummary::biasPosition))
            .setter(setter(Builder::biasPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BiasPosition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(SearchPlaceIndexForTextSummary::dataSource))
            .setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<List<Double>> FILTER_B_BOX_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("FilterBBox")
            .getter(getter(SearchPlaceIndexForTextSummary::filterBBox))
            .setter(setter(Builder::filterBBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterBBox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FILTER_COUNTRIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterCountries")
            .getter(getter(SearchPlaceIndexForTextSummary::filterCountries))
            .setter(setter(Builder::filterCountries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCountries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(SearchPlaceIndexForTextSummary::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchPlaceIndexForTextSummary::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<Double>> RESULT_B_BOX_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("ResultBBox")
            .getter(getter(SearchPlaceIndexForTextSummary::resultBBox))
            .setter(setter(Builder::resultBBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultBBox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(SearchPlaceIndexForTextSummary::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIAS_POSITION_FIELD,
            DATA_SOURCE_FIELD, FILTER_B_BOX_FIELD, FILTER_COUNTRIES_FIELD, LANGUAGE_FIELD, MAX_RESULTS_FIELD, RESULT_B_BOX_FIELD,
            TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Double> biasPosition;

    private final String dataSource;

    private final List<Double> filterBBox;

    private final List<String> filterCountries;

    private final String language;

    private final Integer maxResults;

    private final List<Double> resultBBox;

    private final String text;

    private SearchPlaceIndexForTextSummary(BuilderImpl builder) {
        this.biasPosition = builder.biasPosition;
        this.dataSource = builder.dataSource;
        this.filterBBox = builder.filterBBox;
        this.filterCountries = builder.filterCountries;
        this.language = builder.language;
        this.maxResults = builder.maxResults;
        this.resultBBox = builder.resultBBox;
        this.text = builder.text;
    }

    /**
     * For responses, this returns true if the service returned a value for the BiasPosition property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBiasPosition() {
        return biasPosition != null && !(biasPosition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the coordinates for the optional bias position specified in the request.
     * </p>
     * <p>
     * This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second
     * number represents the Y coordinate, or latitude.
     * </p>
     * <p>
     * For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and
     * latitude <code>49.2847</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBiasPosition} method.
     * </p>
     * 
     * @return Contains the coordinates for the optional bias position specified in the request.</p>
     *         <p>
     *         This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude;
     *         the second number represents the Y coordinate, or latitude.
     *         </p>
     *         <p>
     *         For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude
     *         <code>-123.1174</code> and latitude <code>49.2847</code>.
     */
    public final List<Double> biasPosition() {
        return biasPosition;
    }

    /**
     * <p>
     * The geospatial data provider attached to the place index resource specified in the request. Values can be one of
     * the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Esri
     * </p>
     * </li>
     * <li>
     * <p>
     * Here
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about data providers, see <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location
     * Service data providers</a>.
     * </p>
     * 
     * @return The geospatial data provider attached to the place index resource specified in the request. Values can be
     *         one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Esri
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Here
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about data providers, see <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon
     *         Location Service data providers</a>.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterBBox property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilterBBox() {
        return filterBBox != null && !(filterBBox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the coordinates for the optional bounding box specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterBBox} method.
     * </p>
     * 
     * @return Contains the coordinates for the optional bounding box specified in the request.
     */
    public final List<Double> filterBBox() {
        return filterBBox;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterCountries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterCountries() {
        return filterCountries != null && !(filterCountries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the optional country filter specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterCountries} method.
     * </p>
     * 
     * @return Contains the optional country filter specified in the request.
     */
    public final List<String> filterCountries() {
        return filterCountries;
    }

    /**
     * <p>
     * The preferred language used to return results. Matches the language in the request. The value is a valid <a
     * href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.
     * </p>
     * 
     * @return The preferred language used to return results. Matches the language in the request. The value is a valid
     *         <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for
     *         English.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * Contains the optional result count limit specified in the request.
     * </p>
     * 
     * @return Contains the optional result count limit specified in the request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultBBox property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResultBBox() {
        return resultBBox != null && !(resultBBox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The bounding box that fully contains all search results.
     * </p>
     * <note>
     * <p>
     * If you specified the optional <code>FilterBBox</code> parameter in the request, <code>ResultBBox</code> is
     * contained within <code>FilterBBox</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultBBox} method.
     * </p>
     * 
     * @return The bounding box that fully contains all search results.</p> <note>
     *         <p>
     *         If you specified the optional <code>FilterBBox</code> parameter in the request, <code>ResultBBox</code>
     *         is contained within <code>FilterBBox</code>.
     *         </p>
     */
    public final List<Double> resultBBox() {
        return resultBBox;
    }

    /**
     * <p>
     * The search text specified in the request.
     * </p>
     * 
     * @return The search text specified in the request.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBiasPosition() ? biasPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterBBox() ? filterBBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterCountries() ? filterCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultBBox() ? resultBBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForTextSummary)) {
            return false;
        }
        SearchPlaceIndexForTextSummary other = (SearchPlaceIndexForTextSummary) obj;
        return hasBiasPosition() == other.hasBiasPosition() && Objects.equals(biasPosition(), other.biasPosition())
                && Objects.equals(dataSource(), other.dataSource()) && hasFilterBBox() == other.hasFilterBBox()
                && Objects.equals(filterBBox(), other.filterBBox()) && hasFilterCountries() == other.hasFilterCountries()
                && Objects.equals(filterCountries(), other.filterCountries()) && Objects.equals(language(), other.language())
                && Objects.equals(maxResults(), other.maxResults()) && hasResultBBox() == other.hasResultBBox()
                && Objects.equals(resultBBox(), other.resultBBox()) && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPlaceIndexForTextSummary")
                .add("BiasPosition", biasPosition() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DataSource", dataSource())
                .add("FilterBBox", filterBBox() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FilterCountries", hasFilterCountries() ? filterCountries() : null).add("Language", language())
                .add("MaxResults", maxResults())
                .add("ResultBBox", resultBBox() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BiasPosition":
            return Optional.ofNullable(clazz.cast(biasPosition()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "FilterBBox":
            return Optional.ofNullable(clazz.cast(filterBBox()));
        case "FilterCountries":
            return Optional.ofNullable(clazz.cast(filterCountries()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ResultBBox":
            return Optional.ofNullable(clazz.cast(resultBBox()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForTextSummary, T> g) {
        return obj -> g.apply((SearchPlaceIndexForTextSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchPlaceIndexForTextSummary> {
        /**
         * <p>
         * Contains the coordinates for the optional bias position specified in the request.
         * </p>
         * <p>
         * This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the
         * second number represents the Y coordinate, or latitude.
         * </p>
         * <p>
         * For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code>
         * and latitude <code>49.2847</code>.
         * </p>
         * 
         * @param biasPosition
         *        Contains the coordinates for the optional bias position specified in the request.</p>
         *        <p>
         *        This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude;
         *        the second number represents the Y coordinate, or latitude.
         *        </p>
         *        <p>
         *        For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude
         *        <code>-123.1174</code> and latitude <code>49.2847</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder biasPosition(Collection<Double> biasPosition);

        /**
         * <p>
         * Contains the coordinates for the optional bias position specified in the request.
         * </p>
         * <p>
         * This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the
         * second number represents the Y coordinate, or latitude.
         * </p>
         * <p>
         * For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code>
         * and latitude <code>49.2847</code>.
         * </p>
         * 
         * @param biasPosition
         *        Contains the coordinates for the optional bias position specified in the request.</p>
         *        <p>
         *        This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude;
         *        the second number represents the Y coordinate, or latitude.
         *        </p>
         *        <p>
         *        For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude
         *        <code>-123.1174</code> and latitude <code>49.2847</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder biasPosition(Double... biasPosition);

        /**
         * <p>
         * The geospatial data provider attached to the place index resource specified in the request. Values can be one
         * of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Esri
         * </p>
         * </li>
         * <li>
         * <p>
         * Here
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about data providers, see <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location
         * Service data providers</a>.
         * </p>
         * 
         * @param dataSource
         *        The geospatial data provider attached to the place index resource specified in the request. Values can
         *        be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Esri
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Here
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about data providers, see <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon
         *        Location Service data providers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * Contains the coordinates for the optional bounding box specified in the request.
         * </p>
         * 
         * @param filterBBox
         *        Contains the coordinates for the optional bounding box specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBBox(Collection<Double> filterBBox);

        /**
         * <p>
         * Contains the coordinates for the optional bounding box specified in the request.
         * </p>
         * 
         * @param filterBBox
         *        Contains the coordinates for the optional bounding box specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBBox(Double... filterBBox);

        /**
         * <p>
         * Contains the optional country filter specified in the request.
         * </p>
         * 
         * @param filterCountries
         *        Contains the optional country filter specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCountries(Collection<String> filterCountries);

        /**
         * <p>
         * Contains the optional country filter specified in the request.
         * </p>
         * 
         * @param filterCountries
         *        Contains the optional country filter specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCountries(String... filterCountries);

        /**
         * <p>
         * The preferred language used to return results. Matches the language in the request. The value is a valid <a
         * href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.
         * </p>
         * 
         * @param language
         *        The preferred language used to return results. Matches the language in the request. The value is a
         *        valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example,
         *        <code>en</code> for English.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * Contains the optional result count limit specified in the request.
         * </p>
         * 
         * @param maxResults
         *        Contains the optional result count limit specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The bounding box that fully contains all search results.
         * </p>
         * <note>
         * <p>
         * If you specified the optional <code>FilterBBox</code> parameter in the request, <code>ResultBBox</code> is
         * contained within <code>FilterBBox</code>.
         * </p>
         * </note>
         * 
         * @param resultBBox
         *        The bounding box that fully contains all search results.</p> <note>
         *        <p>
         *        If you specified the optional <code>FilterBBox</code> parameter in the request,
         *        <code>ResultBBox</code> is contained within <code>FilterBBox</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultBBox(Collection<Double> resultBBox);

        /**
         * <p>
         * The bounding box that fully contains all search results.
         * </p>
         * <note>
         * <p>
         * If you specified the optional <code>FilterBBox</code> parameter in the request, <code>ResultBBox</code> is
         * contained within <code>FilterBBox</code>.
         * </p>
         * </note>
         * 
         * @param resultBBox
         *        The bounding box that fully contains all search results.</p> <note>
         *        <p>
         *        If you specified the optional <code>FilterBBox</code> parameter in the request,
         *        <code>ResultBBox</code> is contained within <code>FilterBBox</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultBBox(Double... resultBBox);

        /**
         * <p>
         * The search text specified in the request.
         * </p>
         * 
         * @param text
         *        The search text specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private List<Double> biasPosition = DefaultSdkAutoConstructList.getInstance();

        private String dataSource;

        private List<Double> filterBBox = DefaultSdkAutoConstructList.getInstance();

        private List<String> filterCountries = DefaultSdkAutoConstructList.getInstance();

        private String language;

        private Integer maxResults;

        private List<Double> resultBBox = DefaultSdkAutoConstructList.getInstance();

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForTextSummary model) {
            biasPosition(model.biasPosition);
            dataSource(model.dataSource);
            filterBBox(model.filterBBox);
            filterCountries(model.filterCountries);
            language(model.language);
            maxResults(model.maxResults);
            resultBBox(model.resultBBox);
            text(model.text);
        }

        public final Collection<Double> getBiasPosition() {
            if (biasPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return biasPosition;
        }

        public final void setBiasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
        }

        @Override
        public final Builder biasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder biasPosition(Double... biasPosition) {
            biasPosition(Arrays.asList(biasPosition));
            return this;
        }

        public final String getDataSource() {
            return dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Collection<Double> getFilterBBox() {
            if (filterBBox instanceof SdkAutoConstructList) {
                return null;
            }
            return filterBBox;
        }

        public final void setFilterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
        }

        @Override
        public final Builder filterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBBox(Double... filterBBox) {
            filterBBox(Arrays.asList(filterBBox));
            return this;
        }

        public final Collection<String> getFilterCountries() {
            if (filterCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return filterCountries;
        }

        public final void setFilterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
        }

        @Override
        public final Builder filterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterCountries(String... filterCountries) {
            filterCountries(Arrays.asList(filterCountries));
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<Double> getResultBBox() {
            if (resultBBox instanceof SdkAutoConstructList) {
                return null;
            }
            return resultBBox;
        }

        public final void setResultBBox(Collection<Double> resultBBox) {
            this.resultBBox = BoundingBoxCopier.copy(resultBBox);
        }

        @Override
        public final Builder resultBBox(Collection<Double> resultBBox) {
            this.resultBBox = BoundingBoxCopier.copy(resultBBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultBBox(Double... resultBBox) {
            resultBBox(Arrays.asList(resultBBox));
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public SearchPlaceIndexForTextSummary build() {
            return new SearchPlaceIndexForTextSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
