/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the tracker resource details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteDevicePositionHistoryError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteDevicePositionHistoryError.Builder, BatchDeleteDevicePositionHistoryError> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(BatchDeleteDevicePositionHistoryError::deviceId))
            .setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<BatchItemError> ERROR_FIELD = SdkField.<BatchItemError> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(BatchDeleteDevicePositionHistoryError::error)).setter(setter(Builder::error))
            .constructor(BatchItemError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceId;

    private final BatchItemError error;

    private BatchDeleteDevicePositionHistoryError(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.error = builder.error;
    }

    /**
     * <p>
     * The ID of the device for this position.
     * </p>
     * 
     * @return The ID of the device for this position.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * Returns the value of the Error property for this object.
     * 
     * @return The value of the Error property for this object.
     */
    public final BatchItemError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDevicePositionHistoryError)) {
            return false;
        }
        BatchDeleteDevicePositionHistoryError other = (BatchDeleteDevicePositionHistoryError) obj;
        return Objects.equals(deviceId(), other.deviceId()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteDevicePositionHistoryError").add("DeviceId", deviceId()).add("Error", error())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDevicePositionHistoryError, T> g) {
        return obj -> g.apply((BatchDeleteDevicePositionHistoryError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteDevicePositionHistoryError> {
        /**
         * <p>
         * The ID of the device for this position.
         * </p>
         * 
         * @param deviceId
         *        The ID of the device for this position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * Sets the value of the Error property for this object.
         *
         * @param error
         *        The new value for the Error property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(BatchItemError error);

        /**
         * Sets the value of the Error property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BatchItemError.Builder} avoiding the need
         * to create one manually via {@link BatchItemError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchItemError.Builder#build()} is called immediately and its
         * result is passed to {@link #error(BatchItemError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link BatchItemError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(BatchItemError)
         */
        default Builder error(Consumer<BatchItemError.Builder> error) {
            return error(BatchItemError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deviceId;

        private BatchItemError error;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDevicePositionHistoryError model) {
            deviceId(model.deviceId);
            error(model.error);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final BatchItemError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(BatchItemError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(BatchItemError error) {
            this.error = error;
            return this;
        }

        @Override
        public BatchDeleteDevicePositionHistoryError build() {
            return new BatchDeleteDevicePositionHistoryError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
