/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.location.model.AssociateTrackerConsumerRequest;
import software.amazon.awssdk.services.location.model.AssociateTrackerConsumerResponse;
import software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest;
import software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryResponse;
import software.amazon.awssdk.services.location.model.BatchDeleteGeofenceRequest;
import software.amazon.awssdk.services.location.model.BatchDeleteGeofenceResponse;
import software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesRequest;
import software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesResponse;
import software.amazon.awssdk.services.location.model.BatchGetDevicePositionRequest;
import software.amazon.awssdk.services.location.model.BatchGetDevicePositionResponse;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceRequest;
import software.amazon.awssdk.services.location.model.BatchPutGeofenceResponse;
import software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionRequest;
import software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionResponse;
import software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest;
import software.amazon.awssdk.services.location.model.CalculateRouteMatrixResponse;
import software.amazon.awssdk.services.location.model.CalculateRouteRequest;
import software.amazon.awssdk.services.location.model.CalculateRouteResponse;
import software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.CreateGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.CreateMapRequest;
import software.amazon.awssdk.services.location.model.CreateMapResponse;
import software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.CreatePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.CreateRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.CreateRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.CreateTrackerRequest;
import software.amazon.awssdk.services.location.model.CreateTrackerResponse;
import software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.DeleteMapRequest;
import software.amazon.awssdk.services.location.model.DeleteMapResponse;
import software.amazon.awssdk.services.location.model.DeletePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.DeletePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.DeleteRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.DeleteRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.DeleteTrackerRequest;
import software.amazon.awssdk.services.location.model.DeleteTrackerResponse;
import software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.DescribeMapRequest;
import software.amazon.awssdk.services.location.model.DescribeMapResponse;
import software.amazon.awssdk.services.location.model.DescribePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.DescribePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.DescribeRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.DescribeTrackerRequest;
import software.amazon.awssdk.services.location.model.DescribeTrackerResponse;
import software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerRequest;
import software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerResponse;
import software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest;
import software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse;
import software.amazon.awssdk.services.location.model.GetDevicePositionRequest;
import software.amazon.awssdk.services.location.model.GetDevicePositionResponse;
import software.amazon.awssdk.services.location.model.GetGeofenceRequest;
import software.amazon.awssdk.services.location.model.GetGeofenceResponse;
import software.amazon.awssdk.services.location.model.GetMapGlyphsRequest;
import software.amazon.awssdk.services.location.model.GetMapGlyphsResponse;
import software.amazon.awssdk.services.location.model.GetMapSpritesRequest;
import software.amazon.awssdk.services.location.model.GetMapSpritesResponse;
import software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest;
import software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse;
import software.amazon.awssdk.services.location.model.GetMapTileRequest;
import software.amazon.awssdk.services.location.model.GetMapTileResponse;
import software.amazon.awssdk.services.location.model.GetPlaceRequest;
import software.amazon.awssdk.services.location.model.GetPlaceResponse;
import software.amazon.awssdk.services.location.model.ListDevicePositionsRequest;
import software.amazon.awssdk.services.location.model.ListDevicePositionsResponse;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse;
import software.amazon.awssdk.services.location.model.ListGeofencesRequest;
import software.amazon.awssdk.services.location.model.ListGeofencesResponse;
import software.amazon.awssdk.services.location.model.ListMapsRequest;
import software.amazon.awssdk.services.location.model.ListMapsResponse;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse;
import software.amazon.awssdk.services.location.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.location.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse;
import software.amazon.awssdk.services.location.model.ListTrackersRequest;
import software.amazon.awssdk.services.location.model.ListTrackersResponse;
import software.amazon.awssdk.services.location.model.PutGeofenceRequest;
import software.amazon.awssdk.services.location.model.PutGeofenceResponse;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionResponse;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextRequest;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse;
import software.amazon.awssdk.services.location.model.TagResourceRequest;
import software.amazon.awssdk.services.location.model.TagResourceResponse;
import software.amazon.awssdk.services.location.model.UntagResourceRequest;
import software.amazon.awssdk.services.location.model.UntagResourceResponse;
import software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.UpdateMapRequest;
import software.amazon.awssdk.services.location.model.UpdateMapResponse;
import software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse;
import software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.UpdateRouteCalculatorResponse;
import software.amazon.awssdk.services.location.model.UpdateTrackerRequest;
import software.amazon.awssdk.services.location.model.UpdateTrackerResponse;
import software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryPublisher;
import software.amazon.awssdk.services.location.paginators.ListDevicePositionsPublisher;
import software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsPublisher;
import software.amazon.awssdk.services.location.paginators.ListGeofencesPublisher;
import software.amazon.awssdk.services.location.paginators.ListMapsPublisher;
import software.amazon.awssdk.services.location.paginators.ListPlaceIndexesPublisher;
import software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsPublisher;
import software.amazon.awssdk.services.location.paginators.ListTrackerConsumersPublisher;
import software.amazon.awssdk.services.location.paginators.ListTrackersPublisher;

/**
 * Service client for accessing Amazon Location Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * "Suite of geospatial services including Maps, Places, Routes, Tracking, and Geofencing"
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LocationAsyncClient extends SdkClient {
    String SERVICE_NAME = "geo";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "geo";

    /**
     * Create a {@link LocationAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LocationAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LocationAsyncClient}.
     */
    static LocationAsyncClientBuilder builder() {
        return new DefaultLocationAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to
     * communicate location data to the linked geofence collection.
     * </p>
     * <p>
     * You can associate up to five geofence collections to each tracker resource.
     * </p>
     * <note>
     * <p>
     * Currently not supported — Cross-account configurations, such as creating associations between a tracker resource
     * in one account and a geofence collection in another account.
     * </p>
     * </note>
     *
     * @param associateTrackerConsumerRequest
     * @return A Java Future containing the result of the AssociateTrackerConsumer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ServiceQuotaExceededException The operation was denied because the request would exceed the maximum
     *         <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set
     *         for Amazon Location Service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.AssociateTrackerConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/AssociateTrackerConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTrackerConsumerResponse> associateTrackerConsumer(
            AssociateTrackerConsumerRequest associateTrackerConsumerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to
     * communicate location data to the linked geofence collection.
     * </p>
     * <p>
     * You can associate up to five geofence collections to each tracker resource.
     * </p>
     * <note>
     * <p>
     * Currently not supported — Cross-account configurations, such as creating associations between a tracker resource
     * in one account and a geofence collection in another account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTrackerConsumerRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateTrackerConsumerRequest#builder()}
     * </p>
     *
     * @param associateTrackerConsumerRequest
     *        A {@link Consumer} that will call methods on {@link AssociateTrackerConsumerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateTrackerConsumer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ServiceQuotaExceededException The operation was denied because the request would exceed the maximum
     *         <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set
     *         for Amazon Location Service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.AssociateTrackerConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/AssociateTrackerConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTrackerConsumerResponse> associateTrackerConsumer(
            Consumer<AssociateTrackerConsumerRequest.Builder> associateTrackerConsumerRequest) {
        return associateTrackerConsumer(AssociateTrackerConsumerRequest.builder().applyMutation(associateTrackerConsumerRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the position history of one or more devices from a tracker resource.
     * </p>
     *
     * @param batchDeleteDevicePositionHistoryRequest
     * @return A Java Future containing the result of the BatchDeleteDevicePositionHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchDeleteDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDevicePositionHistoryResponse> batchDeleteDevicePositionHistory(
            BatchDeleteDevicePositionHistoryRequest batchDeleteDevicePositionHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the position history of one or more devices from a tracker resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDevicePositionHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDeleteDevicePositionHistoryRequest#builder()}
     * </p>
     *
     * @param batchDeleteDevicePositionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteDevicePositionHistoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchDeleteDevicePositionHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchDeleteDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDevicePositionHistoryResponse> batchDeleteDevicePositionHistory(
            Consumer<BatchDeleteDevicePositionHistoryRequest.Builder> batchDeleteDevicePositionHistoryRequest) {
        return batchDeleteDevicePositionHistory(BatchDeleteDevicePositionHistoryRequest.builder()
                .applyMutation(batchDeleteDevicePositionHistoryRequest).build());
    }

    /**
     * <p>
     * Deletes a batch of geofences from a geofence collection.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note>
     *
     * @param batchDeleteGeofenceRequest
     * @return A Java Future containing the result of the BatchDeleteGeofence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchDeleteGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteGeofence" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteGeofenceResponse> batchDeleteGeofence(
            BatchDeleteGeofenceRequest batchDeleteGeofenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a batch of geofences from a geofence collection.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteGeofenceRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteGeofenceRequest#builder()}
     * </p>
     *
     * @param batchDeleteGeofenceRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteGeofenceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteGeofence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchDeleteGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteGeofence" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteGeofenceResponse> batchDeleteGeofence(
            Consumer<BatchDeleteGeofenceRequest.Builder> batchDeleteGeofenceRequest) {
        return batchDeleteGeofence(BatchDeleteGeofenceRequest.builder().applyMutation(batchDeleteGeofenceRequest).build());
    }

    /**
     * <p>
     * Evaluates device positions against the geofence geometries from a given geofence collection.
     * </p>
     * <p>
     * This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation
     * determines if the device has entered or exited a geofenced area, and then publishes one of the following events
     * to Amazon EventBridge:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENTER</code> if Amazon Location determines that the tracked device has entered a geofenced area.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXIT</code> if Amazon Location determines that the tracked device has exited a geofenced area.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The last geofence that a device was observed within is tracked for 30 days after the most recent device position
     * update.
     * </p>
     * </note> <note>
     * <p>
     * Geofence evaluation uses the given device position. It does not account for the optional <code>Accuracy</code> of
     * a <code>DevicePositionUpdate</code>.
     * </p>
     * </note> <note>
     * <p>
     * The <code>DeviceID</code> is used as a string to represent the device. You do not need to have a
     * <code>Tracker</code> associated with the <code>DeviceID</code>.
     * </p>
     * </note>
     *
     * @param batchEvaluateGeofencesRequest
     * @return A Java Future containing the result of the BatchEvaluateGeofences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchEvaluateGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchEvaluateGeofences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchEvaluateGeofencesResponse> batchEvaluateGeofences(
            BatchEvaluateGeofencesRequest batchEvaluateGeofencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates device positions against the geofence geometries from a given geofence collection.
     * </p>
     * <p>
     * This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation
     * determines if the device has entered or exited a geofenced area, and then publishes one of the following events
     * to Amazon EventBridge:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENTER</code> if Amazon Location determines that the tracked device has entered a geofenced area.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXIT</code> if Amazon Location determines that the tracked device has exited a geofenced area.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The last geofence that a device was observed within is tracked for 30 days after the most recent device position
     * update.
     * </p>
     * </note> <note>
     * <p>
     * Geofence evaluation uses the given device position. It does not account for the optional <code>Accuracy</code> of
     * a <code>DevicePositionUpdate</code>.
     * </p>
     * </note> <note>
     * <p>
     * The <code>DeviceID</code> is used as a string to represent the device. You do not need to have a
     * <code>Tracker</code> associated with the <code>DeviceID</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchEvaluateGeofencesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchEvaluateGeofencesRequest#builder()}
     * </p>
     *
     * @param batchEvaluateGeofencesRequest
     *        A {@link Consumer} that will call methods on {@link BatchEvaluateGeofencesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchEvaluateGeofences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchEvaluateGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchEvaluateGeofences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchEvaluateGeofencesResponse> batchEvaluateGeofences(
            Consumer<BatchEvaluateGeofencesRequest.Builder> batchEvaluateGeofencesRequest) {
        return batchEvaluateGeofences(BatchEvaluateGeofencesRequest.builder().applyMutation(batchEvaluateGeofencesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the latest device positions for requested devices.
     * </p>
     *
     * @param batchGetDevicePositionRequest
     * @return A Java Future containing the result of the BatchGetDevicePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchGetDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchGetDevicePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDevicePositionResponse> batchGetDevicePosition(
            BatchGetDevicePositionRequest batchGetDevicePositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the latest device positions for requested devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDevicePositionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetDevicePositionRequest#builder()}
     * </p>
     *
     * @param batchGetDevicePositionRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDevicePositionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetDevicePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchGetDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchGetDevicePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDevicePositionResponse> batchGetDevicePosition(
            Consumer<BatchGetDevicePositionRequest.Builder> batchGetDevicePositionRequest) {
        return batchGetDevicePosition(BatchGetDevicePositionRequest.builder().applyMutation(batchGetDevicePositionRequest)
                .build());
    }

    /**
     * <p>
     * A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an
     * existing geofence if a geofence ID is included in the request.
     * </p>
     *
     * @param batchPutGeofenceRequest
     * @return A Java Future containing the result of the BatchPutGeofence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchPutGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchPutGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchPutGeofenceResponse> batchPutGeofence(BatchPutGeofenceRequest batchPutGeofenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an
     * existing geofence if a geofence ID is included in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutGeofenceRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutGeofenceRequest#builder()}
     * </p>
     *
     * @param batchPutGeofenceRequest
     *        A {@link Consumer} that will call methods on {@link BatchPutGeofenceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchPutGeofence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchPutGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchPutGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchPutGeofenceResponse> batchPutGeofence(
            Consumer<BatchPutGeofenceRequest.Builder> batchPutGeofenceRequest) {
        return batchPutGeofence(BatchPutGeofenceRequest.builder().applyMutation(batchPutGeofenceRequest).build());
    }

    /**
     * <p>
     * Uploads position update data for one or more devices to a tracker resource. Amazon Location uses the data when it
     * reports the last known device position and position history. Amazon Location retains location data for 30 days.
     * </p>
     * <note>
     * <p>
     * Position updates are handled based on the <code>PositionFiltering</code> property of the tracker. When
     * <code>PositionFiltering</code> is set to <code>TimeBased</code>, updates are evaluated against linked geofence
     * collections, and location data is stored at a maximum of one position per 30 second interval. If your update
     * frequency is more often than every 30 seconds, only one update per 30 seconds is stored for each unique device
     * ID.
     * </p>
     * <p>
     * When <code>PositionFiltering</code> is set to <code>DistanceBased</code> filtering, location data is stored and
     * evaluated against linked geofence collections only if the device has moved more than 30 m (98.4 ft).
     * </p>
     * <p>
     * When <code>PositionFiltering</code> is set to <code>AccuracyBased</code> filtering, location data is stored and
     * evaluated against linked geofence collections only if the device has moved more than the measured accuracy. For
     * example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update
     * is neither stored or evaluated if the device has moved less than 15 m. If <code>PositionFiltering</code> is set
     * to <code>AccuracyBased</code> filtering, Amazon Location uses the default value <code>{ "Horizontal": 0}</code>
     * when accuracy is not provided on a <code>DevicePositionUpdate</code>.
     * </p>
     * </note>
     *
     * @param batchUpdateDevicePositionRequest
     * @return A Java Future containing the result of the BatchUpdateDevicePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchUpdateDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchUpdateDevicePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateDevicePositionResponse> batchUpdateDevicePosition(
            BatchUpdateDevicePositionRequest batchUpdateDevicePositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads position update data for one or more devices to a tracker resource. Amazon Location uses the data when it
     * reports the last known device position and position history. Amazon Location retains location data for 30 days.
     * </p>
     * <note>
     * <p>
     * Position updates are handled based on the <code>PositionFiltering</code> property of the tracker. When
     * <code>PositionFiltering</code> is set to <code>TimeBased</code>, updates are evaluated against linked geofence
     * collections, and location data is stored at a maximum of one position per 30 second interval. If your update
     * frequency is more often than every 30 seconds, only one update per 30 seconds is stored for each unique device
     * ID.
     * </p>
     * <p>
     * When <code>PositionFiltering</code> is set to <code>DistanceBased</code> filtering, location data is stored and
     * evaluated against linked geofence collections only if the device has moved more than 30 m (98.4 ft).
     * </p>
     * <p>
     * When <code>PositionFiltering</code> is set to <code>AccuracyBased</code> filtering, location data is stored and
     * evaluated against linked geofence collections only if the device has moved more than the measured accuracy. For
     * example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update
     * is neither stored or evaluated if the device has moved less than 15 m. If <code>PositionFiltering</code> is set
     * to <code>AccuracyBased</code> filtering, Amazon Location uses the default value <code>{ "Horizontal": 0}</code>
     * when accuracy is not provided on a <code>DevicePositionUpdate</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateDevicePositionRequest.Builder} avoiding
     * the need to create one manually via {@link BatchUpdateDevicePositionRequest#builder()}
     * </p>
     *
     * @param batchUpdateDevicePositionRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateDevicePositionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdateDevicePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.BatchUpdateDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchUpdateDevicePosition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateDevicePositionResponse> batchUpdateDevicePosition(
            Consumer<BatchUpdateDevicePositionRequest.Builder> batchUpdateDevicePositionRequest) {
        return batchUpdateDevicePosition(BatchUpdateDevicePositionRequest.builder()
                .applyMutation(batchUpdateDevicePositionRequest).build());
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html">Calculates a route</a>
     * given the following required parameters: <code>DeparturePosition</code> and <code>DestinationPosition</code>.
     * Requires that you first <a
     * href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a
     * route calculator resource</a>.
     * </p>
     * <p>
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best
     * traffic conditions when calculating the route.
     * </p>
     * <p>
     * Additional options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html">Specifying a departure
     * time</a> using either <code>DepartureTime</code> or <code>DepartNow</code>. This calculates a route based on
     * predictive traffic data at the given time.
     * </p>
     * <note>
     * <p>
     * You can't specify both <code>DepartureTime</code> and <code>DepartNow</code> in a single request. Specifying both
     * parameters returns a validation error.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html">Specifying a travel
     * mode</a> using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify
     * additional route preferences in <code>CarModeOptions</code> if traveling by <code>Car</code>, or
     * <code>TruckModeOptions</code> if traveling by <code>Truck</code>.
     * </p>
     * <note>
     * <p>
     * If you specify <code>walking</code> for the travel mode and your data provider is Esri, the start and destination
     * must be within 40km.
     * </p>
     * </note></li>
     * </ul>
     *
     * @param calculateRouteRequest
     * @return A Java Future containing the result of the CalculateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CalculateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CalculateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CalculateRouteResponse> calculateRoute(CalculateRouteRequest calculateRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html">Calculates a route</a>
     * given the following required parameters: <code>DeparturePosition</code> and <code>DestinationPosition</code>.
     * Requires that you first <a
     * href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a
     * route calculator resource</a>.
     * </p>
     * <p>
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best
     * traffic conditions when calculating the route.
     * </p>
     * <p>
     * Additional options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html">Specifying a departure
     * time</a> using either <code>DepartureTime</code> or <code>DepartNow</code>. This calculates a route based on
     * predictive traffic data at the given time.
     * </p>
     * <note>
     * <p>
     * You can't specify both <code>DepartureTime</code> and <code>DepartNow</code> in a single request. Specifying both
     * parameters returns a validation error.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html">Specifying a travel
     * mode</a> using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify
     * additional route preferences in <code>CarModeOptions</code> if traveling by <code>Car</code>, or
     * <code>TruckModeOptions</code> if traveling by <code>Truck</code>.
     * </p>
     * <note>
     * <p>
     * If you specify <code>walking</code> for the travel mode and your data provider is Esri, the start and destination
     * must be within 40km.
     * </p>
     * </note></li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CalculateRouteRequest.Builder} avoiding the need to
     * create one manually via {@link CalculateRouteRequest#builder()}
     * </p>
     *
     * @param calculateRouteRequest
     *        A {@link Consumer} that will call methods on {@link CalculateRouteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CalculateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CalculateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CalculateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CalculateRouteResponse> calculateRoute(Consumer<CalculateRouteRequest.Builder> calculateRouteRequest) {
        return calculateRoute(CalculateRouteRequest.builder().applyMutation(calculateRouteRequest).build());
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html"> Calculates a
     * route matrix</a> given the following required parameters: <code>DeparturePositions</code> and
     * <code>DestinationPositions</code>. <code>CalculateRouteMatrix</code> calculates routes and returns the travel
     * time and travel distance from each departure position to each destination position in the request. For example,
     * given departure positions A and B, and destination positions X and Y, <code>CalculateRouteMatrix</code> will
     * return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of
     * results returned (and routes calculated) will be the number of <code>DeparturePositions</code> times the number
     * of <code>DestinationPositions</code>.
     * </p>
     * <note>
     * <p>
     * Your account is charged for each route calculated, not the number of requests.
     * </p>
     * </note>
     * <p>
     * Requires that you first <a
     * href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a
     * route calculator resource</a>.
     * </p>
     * <p>
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best
     * traffic conditions when calculating routes.
     * </p>
     * <p>
     * Additional options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html"> Specifying a departure
     * time</a> using either <code>DepartureTime</code> or <code>DepartNow</code>. This calculates routes based on
     * predictive traffic data at the given time.
     * </p>
     * <note>
     * <p>
     * You can't specify both <code>DepartureTime</code> and <code>DepartNow</code> in a single request. Specifying both
     * parameters returns a validation error.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html">Specifying a travel
     * mode</a> using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify
     * additional route preferences in <code>CarModeOptions</code> if traveling by <code>Car</code>, or
     * <code>TruckModeOptions</code> if traveling by <code>Truck</code>.
     * </p>
     * </li>
     * </ul>
     *
     * @param calculateRouteMatrixRequest
     * @return A Java Future containing the result of the CalculateRouteMatrix operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CalculateRouteMatrix
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CalculateRouteMatrix" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CalculateRouteMatrixResponse> calculateRouteMatrix(
            CalculateRouteMatrixRequest calculateRouteMatrixRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html"> Calculates a
     * route matrix</a> given the following required parameters: <code>DeparturePositions</code> and
     * <code>DestinationPositions</code>. <code>CalculateRouteMatrix</code> calculates routes and returns the travel
     * time and travel distance from each departure position to each destination position in the request. For example,
     * given departure positions A and B, and destination positions X and Y, <code>CalculateRouteMatrix</code> will
     * return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of
     * results returned (and routes calculated) will be the number of <code>DeparturePositions</code> times the number
     * of <code>DestinationPositions</code>.
     * </p>
     * <note>
     * <p>
     * Your account is charged for each route calculated, not the number of requests.
     * </p>
     * </note>
     * <p>
     * Requires that you first <a
     * href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a
     * route calculator resource</a>.
     * </p>
     * <p>
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best
     * traffic conditions when calculating routes.
     * </p>
     * <p>
     * Additional options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html"> Specifying a departure
     * time</a> using either <code>DepartureTime</code> or <code>DepartNow</code>. This calculates routes based on
     * predictive traffic data at the given time.
     * </p>
     * <note>
     * <p>
     * You can't specify both <code>DepartureTime</code> and <code>DepartNow</code> in a single request. Specifying both
     * parameters returns a validation error.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html">Specifying a travel
     * mode</a> using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify
     * additional route preferences in <code>CarModeOptions</code> if traveling by <code>Car</code>, or
     * <code>TruckModeOptions</code> if traveling by <code>Truck</code>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CalculateRouteMatrixRequest.Builder} avoiding the
     * need to create one manually via {@link CalculateRouteMatrixRequest#builder()}
     * </p>
     *
     * @param calculateRouteMatrixRequest
     *        A {@link Consumer} that will call methods on {@link CalculateRouteMatrixRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CalculateRouteMatrix operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CalculateRouteMatrix
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CalculateRouteMatrix" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CalculateRouteMatrixResponse> calculateRouteMatrix(
            Consumer<CalculateRouteMatrixRequest.Builder> calculateRouteMatrixRequest) {
        return calculateRouteMatrix(CalculateRouteMatrixRequest.builder().applyMutation(calculateRouteMatrixRequest).build());
    }

    /**
     * <p>
     * Creates a geofence collection, which manages and stores geofences.
     * </p>
     *
     * @param createGeofenceCollectionRequest
     * @return A Java Future containing the result of the CreateGeofenceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ServiceQuotaExceededException The operation was denied because the request would exceed the maximum
     *         <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set
     *         for Amazon Location Service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CreateGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGeofenceCollectionResponse> createGeofenceCollection(
            CreateGeofenceCollectionRequest createGeofenceCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a geofence collection, which manages and stores geofences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGeofenceCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateGeofenceCollectionRequest#builder()}
     * </p>
     *
     * @param createGeofenceCollectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateGeofenceCollectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGeofenceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ServiceQuotaExceededException The operation was denied because the request would exceed the maximum
     *         <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set
     *         for Amazon Location Service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CreateGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGeofenceCollectionResponse> createGeofenceCollection(
            Consumer<CreateGeofenceCollectionRequest.Builder> createGeofenceCollectionRequest) {
        return createGeofenceCollection(CreateGeofenceCollectionRequest.builder().applyMutation(createGeofenceCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a map resource in your AWS account, which provides map tiles of different styles sourced from global
     * location data providers.
     * </p>
     * <note>
     * <p>
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or
     * employees, you must not use Esri as your geolocation provider. See section 82 of the <a
     * href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.
     * </p>
     * </note>
     *
     * @param createMapRequest
     * @return A Java Future containing the result of the CreateMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ServiceQuotaExceededException The operation was denied because the request would exceed the maximum
     *         <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set
     *         for Amazon Location Service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CreateMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMapResponse> createMap(CreateMapRequest createMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a map resource in your AWS account, which provides map tiles of different styles sourced from global
     * location data providers.
     * </p>
     * <note>
     * <p>
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or
     * employees, you must not use Esri as your geolocation provider. See section 82 of the <a
     * href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMapRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMapRequest#builder()}
     * </p>
     *
     * @param createMapRequest
     *        A {@link Consumer} that will call methods on {@link CreateMapRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ServiceQuotaExceededException The operation was denied because the request would exceed the maximum
     *         <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set
     *         for Amazon Location Service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CreateMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMapResponse> createMap(Consumer<CreateMapRequest.Builder> createMapRequest) {
        return createMap(CreateMapRequest.builder().applyMutation(createMapRequest).build());
    }

    /**
     * <p>
     * Creates a place index resource in your AWS account. Use a place index resource to geocode addresses and other
     * text queries by using the <code>SearchPlaceIndexForText</code> operation, and reverse geocode coordinates by
     * using the <code>SearchPlaceIndexForPosition</code> operation, and enable autosuggestions by using the
     * <code>SearchPlaceIndexForSuggestions</code> operation.
     * </p>
     * <note>
     * <p>
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or
     * employees, you must not use Esri as your geolocation provider. See section 82 of the <a
     * href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.
     * </p>
     * </note>
     *
     * @param createPlaceIndexRequest
     * @return A Java Future containing the result of the CreatePlaceIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ServiceQuotaExceededException The operation was denied because the request would exceed the maximum
     *         <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set
     *         for Amazon Location Service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CreatePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreatePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePlaceIndexResponse> createPlaceIndex(CreatePlaceIndexRequest createPlaceIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a place index resource in your AWS account. Use a place index resource to geocode addresses and other
     * text queries by using the <code>SearchPlaceIndexForText</code> operation, and reverse geocode coordinates by
     * using the <code>SearchPlaceIndexForPosition</code> operation, and enable autosuggestions by using the
     * <code>SearchPlaceIndexForSuggestions</code> operation.
     * </p>
     * <note>
     * <p>
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or
     * employees, you must not use Esri as your geolocation provider. See section 82 of the <a
     * href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlaceIndexRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePlaceIndexRequest#builder()}
     * </p>
     *
     * @param createPlaceIndexRequest
     *        A {@link Consumer} that will call methods on {@link CreatePlaceIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePlaceIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ServiceQuotaExceededException The operation was denied because the request would exceed the maximum
     *         <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set
     *         for Amazon Location Service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CreatePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreatePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePlaceIndexResponse> createPlaceIndex(
            Consumer<CreatePlaceIndexRequest.Builder> createPlaceIndexRequest) {
        return createPlaceIndex(CreatePlaceIndexRequest.builder().applyMutation(createPlaceIndexRequest).build());
    }

    /**
     * <p>
     * Creates a route calculator resource in your AWS account.
     * </p>
     * <p>
     * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A
     * route calculator sources traffic and road network data from your chosen data provider.
     * </p>
     * <note>
     * <p>
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or
     * employees, you must not use Esri as your geolocation provider. See section 82 of the <a
     * href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.
     * </p>
     * </note>
     *
     * @param createRouteCalculatorRequest
     * @return A Java Future containing the result of the CreateRouteCalculator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ServiceQuotaExceededException The operation was denied because the request would exceed the maximum
     *         <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set
     *         for Amazon Location Service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CreateRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRouteCalculatorResponse> createRouteCalculator(
            CreateRouteCalculatorRequest createRouteCalculatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a route calculator resource in your AWS account.
     * </p>
     * <p>
     * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A
     * route calculator sources traffic and road network data from your chosen data provider.
     * </p>
     * <note>
     * <p>
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or
     * employees, you must not use Esri as your geolocation provider. See section 82 of the <a
     * href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteCalculatorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRouteCalculatorRequest#builder()}
     * </p>
     *
     * @param createRouteCalculatorRequest
     *        A {@link Consumer} that will call methods on {@link CreateRouteCalculatorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRouteCalculator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ServiceQuotaExceededException The operation was denied because the request would exceed the maximum
     *         <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set
     *         for Amazon Location Service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CreateRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRouteCalculatorResponse> createRouteCalculator(
            Consumer<CreateRouteCalculatorRequest.Builder> createRouteCalculatorRequest) {
        return createRouteCalculator(CreateRouteCalculatorRequest.builder().applyMutation(createRouteCalculatorRequest).build());
    }

    /**
     * <p>
     * Creates a tracker resource in your AWS account, which lets you retrieve current and historical location of
     * devices.
     * </p>
     *
     * @param createTrackerRequest
     * @return A Java Future containing the result of the CreateTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CreateTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTrackerResponse> createTracker(CreateTrackerRequest createTrackerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a tracker resource in your AWS account, which lets you retrieve current and historical location of
     * devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrackerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTrackerRequest#builder()}
     * </p>
     *
     * @param createTrackerRequest
     *        A {@link Consumer} that will call methods on {@link CreateTrackerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.CreateTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTrackerResponse> createTracker(Consumer<CreateTrackerRequest.Builder> createTrackerRequest) {
        return createTracker(CreateTrackerRequest.builder().applyMutation(createTrackerRequest).build());
    }

    /**
     * <p>
     * Deletes a geofence collection from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource,
     * the devices will no longer be monitored.
     * </p>
     * </note>
     *
     * @param deleteGeofenceCollectionRequest
     * @return A Java Future containing the result of the DeleteGeofenceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DeleteGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGeofenceCollectionResponse> deleteGeofenceCollection(
            DeleteGeofenceCollectionRequest deleteGeofenceCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a geofence collection from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource,
     * the devices will no longer be monitored.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGeofenceCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteGeofenceCollectionRequest#builder()}
     * </p>
     *
     * @param deleteGeofenceCollectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGeofenceCollectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGeofenceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DeleteGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGeofenceCollectionResponse> deleteGeofenceCollection(
            Consumer<DeleteGeofenceCollectionRequest.Builder> deleteGeofenceCollectionRequest) {
        return deleteGeofenceCollection(DeleteGeofenceCollectionRequest.builder().applyMutation(deleteGeofenceCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a map resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the map is being used in an application, the map may not
     * render.
     * </p>
     * </note>
     *
     * @param deleteMapRequest
     * @return A Java Future containing the result of the DeleteMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DeleteMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMapResponse> deleteMap(DeleteMapRequest deleteMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a map resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the map is being used in an application, the map may not
     * render.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMapRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMapRequest#builder()}
     * </p>
     *
     * @param deleteMapRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMapRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DeleteMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMapResponse> deleteMap(Consumer<DeleteMapRequest.Builder> deleteMapRequest) {
        return deleteMap(DeleteMapRequest.builder().applyMutation(deleteMapRequest).build());
    }

    /**
     * <p>
     * Deletes a place index resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note>
     *
     * @param deletePlaceIndexRequest
     * @return A Java Future containing the result of the DeletePlaceIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DeletePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeletePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePlaceIndexResponse> deletePlaceIndex(DeletePlaceIndexRequest deletePlaceIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a place index resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlaceIndexRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePlaceIndexRequest#builder()}
     * </p>
     *
     * @param deletePlaceIndexRequest
     *        A {@link Consumer} that will call methods on {@link DeletePlaceIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePlaceIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DeletePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeletePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePlaceIndexResponse> deletePlaceIndex(
            Consumer<DeletePlaceIndexRequest.Builder> deletePlaceIndexRequest) {
        return deletePlaceIndex(DeletePlaceIndexRequest.builder().applyMutation(deletePlaceIndexRequest).build());
    }

    /**
     * <p>
     * Deletes a route calculator resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note>
     *
     * @param deleteRouteCalculatorRequest
     * @return A Java Future containing the result of the DeleteRouteCalculator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DeleteRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRouteCalculatorResponse> deleteRouteCalculator(
            DeleteRouteCalculatorRequest deleteRouteCalculatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a route calculator resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteCalculatorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRouteCalculatorRequest#builder()}
     * </p>
     *
     * @param deleteRouteCalculatorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRouteCalculatorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRouteCalculator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DeleteRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRouteCalculatorResponse> deleteRouteCalculator(
            Consumer<DeleteRouteCalculatorRequest.Builder> deleteRouteCalculatorRequest) {
        return deleteRouteCalculator(DeleteRouteCalculatorRequest.builder().applyMutation(deleteRouteCalculatorRequest).build());
    }

    /**
     * <p>
     * Deletes a tracker resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error.
     * Make sure that the target resource isn't a dependency for your applications.
     * </p>
     * </note>
     *
     * @param deleteTrackerRequest
     * @return A Java Future containing the result of the DeleteTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DeleteTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTrackerResponse> deleteTracker(DeleteTrackerRequest deleteTrackerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a tracker resource from your AWS account.
     * </p>
     * <note>
     * <p>
     * This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error.
     * Make sure that the target resource isn't a dependency for your applications.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrackerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTrackerRequest#builder()}
     * </p>
     *
     * @param deleteTrackerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTrackerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DeleteTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTrackerResponse> deleteTracker(Consumer<DeleteTrackerRequest.Builder> deleteTrackerRequest) {
        return deleteTracker(DeleteTrackerRequest.builder().applyMutation(deleteTrackerRequest).build());
    }

    /**
     * <p>
     * Retrieves the geofence collection details.
     * </p>
     *
     * @param describeGeofenceCollectionRequest
     * @return A Java Future containing the result of the DescribeGeofenceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DescribeGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGeofenceCollectionResponse> describeGeofenceCollection(
            DescribeGeofenceCollectionRequest describeGeofenceCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the geofence collection details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGeofenceCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGeofenceCollectionRequest#builder()}
     * </p>
     *
     * @param describeGeofenceCollectionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGeofenceCollectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGeofenceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DescribeGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGeofenceCollectionResponse> describeGeofenceCollection(
            Consumer<DescribeGeofenceCollectionRequest.Builder> describeGeofenceCollectionRequest) {
        return describeGeofenceCollection(DescribeGeofenceCollectionRequest.builder()
                .applyMutation(describeGeofenceCollectionRequest).build());
    }

    /**
     * <p>
     * Retrieves the map resource details.
     * </p>
     *
     * @param describeMapRequest
     * @return A Java Future containing the result of the DescribeMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DescribeMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeMapResponse> describeMap(DescribeMapRequest describeMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the map resource details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMapRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeMapRequest#builder()}
     * </p>
     *
     * @param describeMapRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMapRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DescribeMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeMapResponse> describeMap(Consumer<DescribeMapRequest.Builder> describeMapRequest) {
        return describeMap(DescribeMapRequest.builder().applyMutation(describeMapRequest).build());
    }

    /**
     * <p>
     * Retrieves the place index resource details.
     * </p>
     *
     * @param describePlaceIndexRequest
     * @return A Java Future containing the result of the DescribePlaceIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DescribePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribePlaceIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePlaceIndexResponse> describePlaceIndex(DescribePlaceIndexRequest describePlaceIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the place index resource details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePlaceIndexRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePlaceIndexRequest#builder()}
     * </p>
     *
     * @param describePlaceIndexRequest
     *        A {@link Consumer} that will call methods on {@link DescribePlaceIndexRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePlaceIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DescribePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribePlaceIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePlaceIndexResponse> describePlaceIndex(
            Consumer<DescribePlaceIndexRequest.Builder> describePlaceIndexRequest) {
        return describePlaceIndex(DescribePlaceIndexRequest.builder().applyMutation(describePlaceIndexRequest).build());
    }

    /**
     * <p>
     * Retrieves the route calculator resource details.
     * </p>
     *
     * @param describeRouteCalculatorRequest
     * @return A Java Future containing the result of the DescribeRouteCalculator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DescribeRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRouteCalculatorResponse> describeRouteCalculator(
            DescribeRouteCalculatorRequest describeRouteCalculatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the route calculator resource details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRouteCalculatorRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRouteCalculatorRequest#builder()}
     * </p>
     *
     * @param describeRouteCalculatorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRouteCalculatorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRouteCalculator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DescribeRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRouteCalculatorResponse> describeRouteCalculator(
            Consumer<DescribeRouteCalculatorRequest.Builder> describeRouteCalculatorRequest) {
        return describeRouteCalculator(DescribeRouteCalculatorRequest.builder().applyMutation(describeRouteCalculatorRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the tracker resource details.
     * </p>
     *
     * @param describeTrackerRequest
     * @return A Java Future containing the result of the DescribeTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DescribeTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrackerResponse> describeTracker(DescribeTrackerRequest describeTrackerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tracker resource details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrackerRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeTrackerRequest#builder()}
     * </p>
     *
     * @param describeTrackerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTrackerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DescribeTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrackerResponse> describeTracker(
            Consumer<DescribeTrackerRequest.Builder> describeTrackerRequest) {
        return describeTracker(DescribeTrackerRequest.builder().applyMutation(describeTrackerRequest).build());
    }

    /**
     * <p>
     * Removes the association between a tracker resource and a geofence collection.
     * </p>
     * <note>
     * <p>
     * Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be
     * automatically evaluated against geofences.
     * </p>
     * </note>
     *
     * @param disassociateTrackerConsumerRequest
     * @return A Java Future containing the result of the DisassociateTrackerConsumer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DisassociateTrackerConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DisassociateTrackerConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTrackerConsumerResponse> disassociateTrackerConsumer(
            DisassociateTrackerConsumerRequest disassociateTrackerConsumerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between a tracker resource and a geofence collection.
     * </p>
     * <note>
     * <p>
     * Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be
     * automatically evaluated against geofences.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateTrackerConsumerRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateTrackerConsumerRequest#builder()}
     * </p>
     *
     * @param disassociateTrackerConsumerRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateTrackerConsumerRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DisassociateTrackerConsumer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.DisassociateTrackerConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DisassociateTrackerConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTrackerConsumerResponse> disassociateTrackerConsumer(
            Consumer<DisassociateTrackerConsumerRequest.Builder> disassociateTrackerConsumerRequest) {
        return disassociateTrackerConsumer(DisassociateTrackerConsumerRequest.builder()
                .applyMutation(disassociateTrackerConsumerRequest).build());
    }

    /**
     * <p>
     * Retrieves a device's most recent position according to its sample time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note>
     *
     * @param getDevicePositionRequest
     * @return A Java Future containing the result of the GetDevicePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePosition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDevicePositionResponse> getDevicePosition(GetDevicePositionRequest getDevicePositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a device's most recent position according to its sample time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicePositionRequest.Builder} avoiding the need
     * to create one manually via {@link GetDevicePositionRequest#builder()}
     * </p>
     *
     * @param getDevicePositionRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicePositionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDevicePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetDevicePosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePosition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDevicePositionResponse> getDevicePosition(
            Consumer<GetDevicePositionRequest.Builder> getDevicePositionRequest) {
        return getDevicePosition(GetDevicePositionRequest.builder().applyMutation(getDevicePositionRequest).build());
    }

    /**
     * <p>
     * Retrieves the device position history from a tracker resource within a specified range of time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note>
     *
     * @param getDevicePositionHistoryRequest
     * @return A Java Future containing the result of the GetDevicePositionHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDevicePositionHistoryResponse> getDevicePositionHistory(
            GetDevicePositionHistoryRequest getDevicePositionHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the device position history from a tracker resource within a specified range of time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicePositionHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetDevicePositionHistoryRequest#builder()}
     * </p>
     *
     * @param getDevicePositionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicePositionHistoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDevicePositionHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDevicePositionHistoryResponse> getDevicePositionHistory(
            Consumer<GetDevicePositionHistoryRequest.Builder> getDevicePositionHistoryRequest) {
        return getDevicePositionHistory(GetDevicePositionHistoryRequest.builder().applyMutation(getDevicePositionHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the device position history from a tracker resource within a specified range of time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getDevicePositionHistory(software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryPublisher publisher = client.getDevicePositionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryPublisher publisher = client.getDevicePositionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevicePositionHistory(software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getDevicePositionHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDevicePositionHistoryPublisher getDevicePositionHistoryPaginator(
            GetDevicePositionHistoryRequest getDevicePositionHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the device position history from a tracker resource within a specified range of time.
     * </p>
     * <note>
     * <p>
     * Device positions are deleted after 30 days.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getDevicePositionHistory(software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryPublisher publisher = client.getDevicePositionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.GetDevicePositionHistoryPublisher publisher = client.getDevicePositionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevicePositionHistory(software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicePositionHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetDevicePositionHistoryRequest#builder()}
     * </p>
     *
     * @param getDevicePositionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicePositionHistoryRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetDevicePositionHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDevicePositionHistoryPublisher getDevicePositionHistoryPaginator(
            Consumer<GetDevicePositionHistoryRequest.Builder> getDevicePositionHistoryRequest) {
        return getDevicePositionHistoryPaginator(GetDevicePositionHistoryRequest.builder()
                .applyMutation(getDevicePositionHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the geofence details from a geofence collection.
     * </p>
     *
     * @param getGeofenceRequest
     * @return A Java Future containing the result of the GetGeofence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGeofenceResponse> getGeofence(GetGeofenceRequest getGeofenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the geofence details from a geofence collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGeofenceRequest.Builder} avoiding the need to
     * create one manually via {@link GetGeofenceRequest#builder()}
     * </p>
     *
     * @param getGeofenceRequest
     *        A {@link Consumer} that will call methods on {@link GetGeofenceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGeofence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGeofenceResponse> getGeofence(Consumer<GetGeofenceRequest.Builder> getGeofenceRequest) {
        return getGeofence(GetGeofenceRequest.builder().applyMutation(getGeofenceRequest).build());
    }

    /**
     * <p>
     * Retrieves glyphs used to display labels on a map.
     * </p>
     *
     * @param getMapGlyphsRequest
     * @return A Java Future containing the result of the GetMapGlyphs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetMapGlyphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapGlyphs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMapGlyphsResponse> getMapGlyphs(GetMapGlyphsRequest getMapGlyphsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves glyphs used to display labels on a map.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMapGlyphsRequest.Builder} avoiding the need to
     * create one manually via {@link GetMapGlyphsRequest#builder()}
     * </p>
     *
     * @param getMapGlyphsRequest
     *        A {@link Consumer} that will call methods on {@link GetMapGlyphsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMapGlyphs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetMapGlyphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapGlyphs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMapGlyphsResponse> getMapGlyphs(Consumer<GetMapGlyphsRequest.Builder> getMapGlyphsRequest) {
        return getMapGlyphs(GetMapGlyphsRequest.builder().applyMutation(getMapGlyphsRequest).build());
    }

    /**
     * <p>
     * Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON
     * document describing the offsets of individual icons that will be displayed on a rendered map.
     * </p>
     *
     * @param getMapSpritesRequest
     * @return A Java Future containing the result of the GetMapSprites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetMapSprites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapSprites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMapSpritesResponse> getMapSprites(GetMapSpritesRequest getMapSpritesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON
     * document describing the offsets of individual icons that will be displayed on a rendered map.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMapSpritesRequest.Builder} avoiding the need to
     * create one manually via {@link GetMapSpritesRequest#builder()}
     * </p>
     *
     * @param getMapSpritesRequest
     *        A {@link Consumer} that will call methods on {@link GetMapSpritesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMapSprites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetMapSprites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapSprites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMapSpritesResponse> getMapSprites(Consumer<GetMapSpritesRequest.Builder> getMapSpritesRequest) {
        return getMapSprites(GetMapSpritesRequest.builder().applyMutation(getMapSpritesRequest).build());
    }

    /**
     * <p>
     * Retrieves the map style descriptor from a map resource.
     * </p>
     * <p>
     * The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display,
     * what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style
     * Specification.
     * </p>
     *
     * @param getMapStyleDescriptorRequest
     * @return A Java Future containing the result of the GetMapStyleDescriptor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetMapStyleDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapStyleDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMapStyleDescriptorResponse> getMapStyleDescriptor(
            GetMapStyleDescriptorRequest getMapStyleDescriptorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the map style descriptor from a map resource.
     * </p>
     * <p>
     * The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display,
     * what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style
     * Specification.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMapStyleDescriptorRequest.Builder} avoiding the
     * need to create one manually via {@link GetMapStyleDescriptorRequest#builder()}
     * </p>
     *
     * @param getMapStyleDescriptorRequest
     *        A {@link Consumer} that will call methods on {@link GetMapStyleDescriptorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMapStyleDescriptor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetMapStyleDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapStyleDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMapStyleDescriptorResponse> getMapStyleDescriptor(
            Consumer<GetMapStyleDescriptorRequest.Builder> getMapStyleDescriptorRequest) {
        return getMapStyleDescriptor(GetMapStyleDescriptorRequest.builder().applyMutation(getMapStyleDescriptorRequest).build());
    }

    /**
     * <p>
     * Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're
     * addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
     * </p>
     * <p>
     * The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions,
     * so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1,
     * 1/1/0, 1/1/1).
     * </p>
     *
     * @param getMapTileRequest
     * @return A Java Future containing the result of the GetMapTile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetMapTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapTile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMapTileResponse> getMapTile(GetMapTileRequest getMapTileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're
     * addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
     * </p>
     * <p>
     * The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions,
     * so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1,
     * 1/1/0, 1/1/1).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMapTileRequest.Builder} avoiding the need to
     * create one manually via {@link GetMapTileRequest#builder()}
     * </p>
     *
     * @param getMapTileRequest
     *        A {@link Consumer} that will call methods on {@link GetMapTileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMapTile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetMapTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapTile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMapTileResponse> getMapTile(Consumer<GetMapTileRequest.Builder> getMapTileRequest) {
        return getMapTile(GetMapTileRequest.builder().applyMutation(getMapTileRequest).build());
    }

    /**
     * <p>
     * Finds a place by its unique ID. A <code>PlaceId</code> is returned by other search operations.
     * </p>
     * <note>
     * <p>
     * A PlaceId is valid only if all of the following are the same in the original search request and the call to
     * <code>GetPlace</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Customer AWS account
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Region
     * </p>
     * </li>
     * <li>
     * <p>
     * Data provider specified in the place index resource
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param getPlaceRequest
     * @return A Java Future containing the result of the GetPlace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetPlace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetPlace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPlaceResponse> getPlace(GetPlaceRequest getPlaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Finds a place by its unique ID. A <code>PlaceId</code> is returned by other search operations.
     * </p>
     * <note>
     * <p>
     * A PlaceId is valid only if all of the following are the same in the original search request and the call to
     * <code>GetPlace</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Customer AWS account
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Region
     * </p>
     * </li>
     * <li>
     * <p>
     * Data provider specified in the place index resource
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetPlaceRequest#builder()}
     * </p>
     *
     * @param getPlaceRequest
     *        A {@link Consumer} that will call methods on {@link GetPlaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPlace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.GetPlace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetPlace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPlaceResponse> getPlace(Consumer<GetPlaceRequest.Builder> getPlaceRequest) {
        return getPlace(GetPlaceRequest.builder().applyMutation(getPlaceRequest).build());
    }

    /**
     * <p>
     * A batch request to retrieve all device positions.
     * </p>
     *
     * @param listDevicePositionsRequest
     * @return A Java Future containing the result of the ListDevicePositions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListDevicePositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListDevicePositions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDevicePositionsResponse> listDevicePositions(
            ListDevicePositionsRequest listDevicePositionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A batch request to retrieve all device positions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicePositionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDevicePositionsRequest#builder()}
     * </p>
     *
     * @param listDevicePositionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicePositionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDevicePositions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListDevicePositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListDevicePositions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDevicePositionsResponse> listDevicePositions(
            Consumer<ListDevicePositionsRequest.Builder> listDevicePositionsRequest) {
        return listDevicePositions(ListDevicePositionsRequest.builder().applyMutation(listDevicePositionsRequest).build());
    }

    /**
     * <p>
     * A batch request to retrieve all device positions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevicePositions(software.amazon.awssdk.services.location.model.ListDevicePositionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListDevicePositionsPublisher publisher = client.listDevicePositionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListDevicePositionsPublisher publisher = client.listDevicePositionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListDevicePositionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListDevicePositionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicePositions(software.amazon.awssdk.services.location.model.ListDevicePositionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDevicePositionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListDevicePositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListDevicePositions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDevicePositionsPublisher listDevicePositionsPaginator(ListDevicePositionsRequest listDevicePositionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A batch request to retrieve all device positions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevicePositions(software.amazon.awssdk.services.location.model.ListDevicePositionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListDevicePositionsPublisher publisher = client.listDevicePositionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListDevicePositionsPublisher publisher = client.listDevicePositionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListDevicePositionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListDevicePositionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicePositions(software.amazon.awssdk.services.location.model.ListDevicePositionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicePositionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDevicePositionsRequest#builder()}
     * </p>
     *
     * @param listDevicePositionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicePositionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListDevicePositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListDevicePositions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDevicePositionsPublisher listDevicePositionsPaginator(
            Consumer<ListDevicePositionsRequest.Builder> listDevicePositionsRequest) {
        return listDevicePositionsPaginator(ListDevicePositionsRequest.builder().applyMutation(listDevicePositionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists geofence collections in your AWS account.
     * </p>
     *
     * @param listGeofenceCollectionsRequest
     * @return A Java Future containing the result of the ListGeofenceCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListGeofenceCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGeofenceCollectionsResponse> listGeofenceCollections(
            ListGeofenceCollectionsRequest listGeofenceCollectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofence collections in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeofenceCollectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListGeofenceCollectionsRequest#builder()}
     * </p>
     *
     * @param listGeofenceCollectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListGeofenceCollectionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGeofenceCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListGeofenceCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGeofenceCollectionsResponse> listGeofenceCollections(
            Consumer<ListGeofenceCollectionsRequest.Builder> listGeofenceCollectionsRequest) {
        return listGeofenceCollections(ListGeofenceCollectionsRequest.builder().applyMutation(listGeofenceCollectionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists geofence collections in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGeofenceCollections(software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsPublisher publisher = client.listGeofenceCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsPublisher publisher = client.listGeofenceCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeofenceCollections(software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGeofenceCollectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListGeofenceCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeofenceCollectionsPublisher listGeofenceCollectionsPaginator(
            ListGeofenceCollectionsRequest listGeofenceCollectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofence collections in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGeofenceCollections(software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsPublisher publisher = client.listGeofenceCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofenceCollectionsPublisher publisher = client.listGeofenceCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeofenceCollections(software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeofenceCollectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListGeofenceCollectionsRequest#builder()}
     * </p>
     *
     * @param listGeofenceCollectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListGeofenceCollectionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListGeofenceCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeofenceCollectionsPublisher listGeofenceCollectionsPaginator(
            Consumer<ListGeofenceCollectionsRequest.Builder> listGeofenceCollectionsRequest) {
        return listGeofenceCollectionsPaginator(ListGeofenceCollectionsRequest.builder()
                .applyMutation(listGeofenceCollectionsRequest).build());
    }

    /**
     * <p>
     * Lists geofences stored in a given geofence collection.
     * </p>
     *
     * @param listGeofencesRequest
     * @return A Java Future containing the result of the ListGeofences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGeofencesResponse> listGeofences(ListGeofencesRequest listGeofencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofences stored in a given geofence collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeofencesRequest.Builder} avoiding the need to
     * create one manually via {@link ListGeofencesRequest#builder()}
     * </p>
     *
     * @param listGeofencesRequest
     *        A {@link Consumer} that will call methods on {@link ListGeofencesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGeofences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGeofencesResponse> listGeofences(Consumer<ListGeofencesRequest.Builder> listGeofencesRequest) {
        return listGeofences(ListGeofencesRequest.builder().applyMutation(listGeofencesRequest).build());
    }

    /**
     * <p>
     * Lists geofences stored in a given geofence collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGeofences(software.amazon.awssdk.services.location.model.ListGeofencesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofencesPublisher publisher = client.listGeofencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofencesPublisher publisher = client.listGeofencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListGeofencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListGeofencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeofences(software.amazon.awssdk.services.location.model.ListGeofencesRequest)} operation.</b>
     * </p>
     *
     * @param listGeofencesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGeofencesPublisher listGeofencesPaginator(ListGeofencesRequest listGeofencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofences stored in a given geofence collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGeofences(software.amazon.awssdk.services.location.model.ListGeofencesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofencesPublisher publisher = client.listGeofencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListGeofencesPublisher publisher = client.listGeofencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListGeofencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListGeofencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeofences(software.amazon.awssdk.services.location.model.ListGeofencesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeofencesRequest.Builder} avoiding the need to
     * create one manually via {@link ListGeofencesRequest#builder()}
     * </p>
     *
     * @param listGeofencesRequest
     *        A {@link Consumer} that will call methods on {@link ListGeofencesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListGeofences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGeofencesPublisher listGeofencesPaginator(Consumer<ListGeofencesRequest.Builder> listGeofencesRequest) {
        return listGeofencesPaginator(ListGeofencesRequest.builder().applyMutation(listGeofencesRequest).build());
    }

    /**
     * <p>
     * Lists map resources in your AWS account.
     * </p>
     *
     * @param listMapsRequest
     * @return A Java Future containing the result of the ListMaps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMapsResponse> listMaps(ListMapsRequest listMapsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists map resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMapsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMapsRequest#builder()}
     * </p>
     *
     * @param listMapsRequest
     *        A {@link Consumer} that will call methods on {@link ListMapsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMaps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMapsResponse> listMaps(Consumer<ListMapsRequest.Builder> listMapsRequest) {
        return listMaps(ListMapsRequest.builder().applyMutation(listMapsRequest).build());
    }

    /**
     * <p>
     * Lists map resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMaps(software.amazon.awssdk.services.location.model.ListMapsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListMapsPublisher publisher = client.listMapsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListMapsPublisher publisher = client.listMapsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListMapsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListMapsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMaps(software.amazon.awssdk.services.location.model.ListMapsRequest)} operation.</b>
     * </p>
     *
     * @param listMapsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapsPublisher listMapsPaginator(ListMapsRequest listMapsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists map resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMaps(software.amazon.awssdk.services.location.model.ListMapsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListMapsPublisher publisher = client.listMapsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListMapsPublisher publisher = client.listMapsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListMapsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListMapsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMaps(software.amazon.awssdk.services.location.model.ListMapsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMapsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMapsRequest#builder()}
     * </p>
     *
     * @param listMapsRequest
     *        A {@link Consumer} that will call methods on {@link ListMapsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMapsPublisher listMapsPaginator(Consumer<ListMapsRequest.Builder> listMapsRequest) {
        return listMapsPaginator(ListMapsRequest.builder().applyMutation(listMapsRequest).build());
    }

    /**
     * <p>
     * Lists place index resources in your AWS account.
     * </p>
     *
     * @param listPlaceIndexesRequest
     * @return A Java Future containing the result of the ListPlaceIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListPlaceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPlaceIndexesResponse> listPlaceIndexes(ListPlaceIndexesRequest listPlaceIndexesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists place index resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaceIndexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListPlaceIndexesRequest#builder()}
     * </p>
     *
     * @param listPlaceIndexesRequest
     *        A {@link Consumer} that will call methods on {@link ListPlaceIndexesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPlaceIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListPlaceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPlaceIndexesResponse> listPlaceIndexes(
            Consumer<ListPlaceIndexesRequest.Builder> listPlaceIndexesRequest) {
        return listPlaceIndexes(ListPlaceIndexesRequest.builder().applyMutation(listPlaceIndexesRequest).build());
    }

    /**
     * <p>
     * Lists place index resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlaceIndexes(software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListPlaceIndexesPublisher publisher = client.listPlaceIndexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListPlaceIndexesPublisher publisher = client.listPlaceIndexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaceIndexes(software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest)} operation.</b>
     * </p>
     *
     * @param listPlaceIndexesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListPlaceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPlaceIndexesPublisher listPlaceIndexesPaginator(ListPlaceIndexesRequest listPlaceIndexesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists place index resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlaceIndexes(software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListPlaceIndexesPublisher publisher = client.listPlaceIndexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListPlaceIndexesPublisher publisher = client.listPlaceIndexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListPlaceIndexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaceIndexes(software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaceIndexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListPlaceIndexesRequest#builder()}
     * </p>
     *
     * @param listPlaceIndexesRequest
     *        A {@link Consumer} that will call methods on {@link ListPlaceIndexesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListPlaceIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPlaceIndexesPublisher listPlaceIndexesPaginator(Consumer<ListPlaceIndexesRequest.Builder> listPlaceIndexesRequest) {
        return listPlaceIndexesPaginator(ListPlaceIndexesRequest.builder().applyMutation(listPlaceIndexesRequest).build());
    }

    /**
     * <p>
     * Lists route calculator resources in your AWS account.
     * </p>
     *
     * @param listRouteCalculatorsRequest
     * @return A Java Future containing the result of the ListRouteCalculators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListRouteCalculators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListRouteCalculators" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRouteCalculatorsResponse> listRouteCalculators(
            ListRouteCalculatorsRequest listRouteCalculatorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists route calculator resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouteCalculatorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRouteCalculatorsRequest#builder()}
     * </p>
     *
     * @param listRouteCalculatorsRequest
     *        A {@link Consumer} that will call methods on {@link ListRouteCalculatorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRouteCalculators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListRouteCalculators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListRouteCalculators" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRouteCalculatorsResponse> listRouteCalculators(
            Consumer<ListRouteCalculatorsRequest.Builder> listRouteCalculatorsRequest) {
        return listRouteCalculators(ListRouteCalculatorsRequest.builder().applyMutation(listRouteCalculatorsRequest).build());
    }

    /**
     * <p>
     * Lists route calculator resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRouteCalculators(software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsPublisher publisher = client.listRouteCalculatorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsPublisher publisher = client.listRouteCalculatorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouteCalculators(software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRouteCalculatorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListRouteCalculators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListRouteCalculators" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouteCalculatorsPublisher listRouteCalculatorsPaginator(ListRouteCalculatorsRequest listRouteCalculatorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists route calculator resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRouteCalculators(software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsPublisher publisher = client.listRouteCalculatorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListRouteCalculatorsPublisher publisher = client.listRouteCalculatorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouteCalculators(software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouteCalculatorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRouteCalculatorsRequest#builder()}
     * </p>
     *
     * @param listRouteCalculatorsRequest
     *        A {@link Consumer} that will call methods on {@link ListRouteCalculatorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListRouteCalculators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListRouteCalculators" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouteCalculatorsPublisher listRouteCalculatorsPaginator(
            Consumer<ListRouteCalculatorsRequest.Builder> listRouteCalculatorsRequest) {
        return listRouteCalculatorsPaginator(ListRouteCalculatorsRequest.builder().applyMutation(listRouteCalculatorsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified Amazon Location resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified Amazon Location resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists geofence collections currently associated to the given tracker resource.
     * </p>
     *
     * @param listTrackerConsumersRequest
     * @return A Java Future containing the result of the ListTrackerConsumers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListTrackerConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTrackerConsumersResponse> listTrackerConsumers(
            ListTrackerConsumersRequest listTrackerConsumersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofence collections currently associated to the given tracker resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrackerConsumersRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrackerConsumersRequest#builder()}
     * </p>
     *
     * @param listTrackerConsumersRequest
     *        A {@link Consumer} that will call methods on {@link ListTrackerConsumersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTrackerConsumers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListTrackerConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTrackerConsumersResponse> listTrackerConsumers(
            Consumer<ListTrackerConsumersRequest.Builder> listTrackerConsumersRequest) {
        return listTrackerConsumers(ListTrackerConsumersRequest.builder().applyMutation(listTrackerConsumersRequest).build());
    }

    /**
     * <p>
     * Lists geofence collections currently associated to the given tracker resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrackerConsumers(software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackerConsumersPublisher publisher = client.listTrackerConsumersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackerConsumersPublisher publisher = client.listTrackerConsumersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrackerConsumers(software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrackerConsumersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListTrackerConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTrackerConsumersPublisher listTrackerConsumersPaginator(ListTrackerConsumersRequest listTrackerConsumersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists geofence collections currently associated to the given tracker resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrackerConsumers(software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackerConsumersPublisher publisher = client.listTrackerConsumersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackerConsumersPublisher publisher = client.listTrackerConsumersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrackerConsumers(software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrackerConsumersRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrackerConsumersRequest#builder()}
     * </p>
     *
     * @param listTrackerConsumersRequest
     *        A {@link Consumer} that will call methods on {@link ListTrackerConsumersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListTrackerConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTrackerConsumersPublisher listTrackerConsumersPaginator(
            Consumer<ListTrackerConsumersRequest.Builder> listTrackerConsumersRequest) {
        return listTrackerConsumersPaginator(ListTrackerConsumersRequest.builder().applyMutation(listTrackerConsumersRequest)
                .build());
    }

    /**
     * <p>
     * Lists tracker resources in your AWS account.
     * </p>
     *
     * @param listTrackersRequest
     * @return A Java Future containing the result of the ListTrackers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTrackersResponse> listTrackers(ListTrackersRequest listTrackersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tracker resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrackersRequest.Builder} avoiding the need to
     * create one manually via {@link ListTrackersRequest#builder()}
     * </p>
     *
     * @param listTrackersRequest
     *        A {@link Consumer} that will call methods on {@link ListTrackersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTrackers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTrackersResponse> listTrackers(Consumer<ListTrackersRequest.Builder> listTrackersRequest) {
        return listTrackers(ListTrackersRequest.builder().applyMutation(listTrackersRequest).build());
    }

    /**
     * <p>
     * Lists tracker resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTrackers(software.amazon.awssdk.services.location.model.ListTrackersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackersPublisher publisher = client.listTrackersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackersPublisher publisher = client.listTrackersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListTrackersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListTrackersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrackers(software.amazon.awssdk.services.location.model.ListTrackersRequest)} operation.</b>
     * </p>
     *
     * @param listTrackersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrackersPublisher listTrackersPaginator(ListTrackersRequest listTrackersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tracker resources in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTrackers(software.amazon.awssdk.services.location.model.ListTrackersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackersPublisher publisher = client.listTrackersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.location.paginators.ListTrackersPublisher publisher = client.listTrackersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.location.model.ListTrackersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.location.model.ListTrackersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrackers(software.amazon.awssdk.services.location.model.ListTrackersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrackersRequest.Builder} avoiding the need to
     * create one manually via {@link ListTrackersRequest#builder()}
     * </p>
     *
     * @param listTrackersRequest
     *        A {@link Consumer} that will call methods on {@link ListTrackersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.ListTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrackersPublisher listTrackersPaginator(Consumer<ListTrackersRequest.Builder> listTrackersRequest) {
        return listTrackersPaginator(ListTrackersRequest.builder().applyMutation(listTrackersRequest).build());
    }

    /**
     * <p>
     * Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a
     * geofence ID is included in the request.
     * </p>
     *
     * @param putGeofenceRequest
     * @return A Java Future containing the result of the PutGeofence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.PutGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/PutGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutGeofenceResponse> putGeofence(PutGeofenceRequest putGeofenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a
     * geofence ID is included in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutGeofenceRequest.Builder} avoiding the need to
     * create one manually via {@link PutGeofenceRequest#builder()}
     * </p>
     *
     * @param putGeofenceRequest
     *        A {@link Consumer} that will call methods on {@link PutGeofenceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutGeofence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>ConflictException The request was unsuccessful because of a conflict.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.PutGeofence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/PutGeofence" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutGeofenceResponse> putGeofence(Consumer<PutGeofenceRequest.Builder> putGeofenceRequest) {
        return putGeofence(PutGeofenceRequest.builder().applyMutation(putGeofenceRequest).build());
    }

    /**
     * <p>
     * Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of
     * interest near a given position.
     * </p>
     *
     * @param searchPlaceIndexForPositionRequest
     * @return A Java Future containing the result of the SearchPlaceIndexForPosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.SearchPlaceIndexForPosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForPosition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchPlaceIndexForPositionResponse> searchPlaceIndexForPosition(
            SearchPlaceIndexForPositionRequest searchPlaceIndexForPositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of
     * interest near a given position.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchPlaceIndexForPositionRequest.Builder}
     * avoiding the need to create one manually via {@link SearchPlaceIndexForPositionRequest#builder()}
     * </p>
     *
     * @param searchPlaceIndexForPositionRequest
     *        A {@link Consumer} that will call methods on {@link SearchPlaceIndexForPositionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the SearchPlaceIndexForPosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.SearchPlaceIndexForPosition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForPosition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchPlaceIndexForPositionResponse> searchPlaceIndexForPosition(
            Consumer<SearchPlaceIndexForPositionRequest.Builder> searchPlaceIndexForPositionRequest) {
        return searchPlaceIndexForPosition(SearchPlaceIndexForPositionRequest.builder()
                .applyMutation(searchPlaceIndexForPositionRequest).build());
    }

    /**
     * <p>
     * Generates suggestions for addresses and points of interest based on partial or misspelled free-form text. This
     * operation is also known as autocomplete, autosuggest, or fuzzy matching.
     * </p>
     * <p>
     * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a
     * specific position on the globe.
     * </p>
     * <note>
     * <p>
     * You can search for suggested place names near a specified position by using <code>BiasPosition</code>, or filter
     * results within a bounding box by using <code>FilterBBox</code>. These parameters are mutually exclusive; using
     * both <code>BiasPosition</code> and <code>FilterBBox</code> in the same command returns an error.
     * </p>
     * </note>
     *
     * @param searchPlaceIndexForSuggestionsRequest
     * @return A Java Future containing the result of the SearchPlaceIndexForSuggestions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.SearchPlaceIndexForSuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForSuggestions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchPlaceIndexForSuggestionsResponse> searchPlaceIndexForSuggestions(
            SearchPlaceIndexForSuggestionsRequest searchPlaceIndexForSuggestionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates suggestions for addresses and points of interest based on partial or misspelled free-form text. This
     * operation is also known as autocomplete, autosuggest, or fuzzy matching.
     * </p>
     * <p>
     * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a
     * specific position on the globe.
     * </p>
     * <note>
     * <p>
     * You can search for suggested place names near a specified position by using <code>BiasPosition</code>, or filter
     * results within a bounding box by using <code>FilterBBox</code>. These parameters are mutually exclusive; using
     * both <code>BiasPosition</code> and <code>FilterBBox</code> in the same command returns an error.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchPlaceIndexForSuggestionsRequest.Builder}
     * avoiding the need to create one manually via {@link SearchPlaceIndexForSuggestionsRequest#builder()}
     * </p>
     *
     * @param searchPlaceIndexForSuggestionsRequest
     *        A {@link Consumer} that will call methods on {@link SearchPlaceIndexForSuggestionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SearchPlaceIndexForSuggestions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.SearchPlaceIndexForSuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForSuggestions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchPlaceIndexForSuggestionsResponse> searchPlaceIndexForSuggestions(
            Consumer<SearchPlaceIndexForSuggestionsRequest.Builder> searchPlaceIndexForSuggestionsRequest) {
        return searchPlaceIndexForSuggestions(SearchPlaceIndexForSuggestionsRequest.builder()
                .applyMutation(searchPlaceIndexForSuggestionsRequest).build());
    }

    /**
     * <p>
     * Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of
     * interest.
     * </p>
     * <p>
     * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a
     * specific position on the globe.
     * </p>
     * <note>
     * <p>
     * You can search for places near a given position using <code>BiasPosition</code>, or filter results within a
     * bounding box using <code>FilterBBox</code>. Providing both parameters simultaneously returns an error.
     * </p>
     * </note>
     * <p>
     * Search results are returned in order of highest to lowest relevance.
     * </p>
     *
     * @param searchPlaceIndexForTextRequest
     * @return A Java Future containing the result of the SearchPlaceIndexForText operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.SearchPlaceIndexForText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForText"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchPlaceIndexForTextResponse> searchPlaceIndexForText(
            SearchPlaceIndexForTextRequest searchPlaceIndexForTextRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of
     * interest.
     * </p>
     * <p>
     * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a
     * specific position on the globe.
     * </p>
     * <note>
     * <p>
     * You can search for places near a given position using <code>BiasPosition</code>, or filter results within a
     * bounding box using <code>FilterBBox</code>. Providing both parameters simultaneously returns an error.
     * </p>
     * </note>
     * <p>
     * Search results are returned in order of highest to lowest relevance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchPlaceIndexForTextRequest.Builder} avoiding
     * the need to create one manually via {@link SearchPlaceIndexForTextRequest#builder()}
     * </p>
     *
     * @param searchPlaceIndexForTextRequest
     *        A {@link Consumer} that will call methods on {@link SearchPlaceIndexForTextRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchPlaceIndexForText operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.SearchPlaceIndexForText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForText"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchPlaceIndexForTextResponse> searchPlaceIndexForText(
            Consumer<SearchPlaceIndexForTextRequest.Builder> searchPlaceIndexForTextRequest) {
        return searchPlaceIndexForText(SearchPlaceIndexForTextRequest.builder().applyMutation(searchPlaceIndexForTextRequest)
                .build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> operation with an Amazon Location Service resource that already has
     * tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the
     * resource. If you specify a tag key that's already associated with the resource, the new tag value that you
     * specify replaces the previous value for that tag.
     * </p>
     * <p>
     * You can associate up to 50 tags with a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> operation with an Amazon Location Service resource that already has
     * tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the
     * resource. If you specify a tag key that's already associated with the resource, the new tag value that you
     * specify replaces the previous value for that tag.
     * </p>
     * <p>
     * You can associate up to 50 tags with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified Amazon Location resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified Amazon Location resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified properties of a given geofence collection.
     * </p>
     *
     * @param updateGeofenceCollectionRequest
     * @return A Java Future containing the result of the UpdateGeofenceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UpdateGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGeofenceCollectionResponse> updateGeofenceCollection(
            UpdateGeofenceCollectionRequest updateGeofenceCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified properties of a given geofence collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGeofenceCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGeofenceCollectionRequest#builder()}
     * </p>
     *
     * @param updateGeofenceCollectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGeofenceCollectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGeofenceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UpdateGeofenceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateGeofenceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGeofenceCollectionResponse> updateGeofenceCollection(
            Consumer<UpdateGeofenceCollectionRequest.Builder> updateGeofenceCollectionRequest) {
        return updateGeofenceCollection(UpdateGeofenceCollectionRequest.builder().applyMutation(updateGeofenceCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Updates the specified properties of a given map resource.
     * </p>
     *
     * @param updateMapRequest
     * @return A Java Future containing the result of the UpdateMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UpdateMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMapResponse> updateMap(UpdateMapRequest updateMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified properties of a given map resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMapRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMapRequest#builder()}
     * </p>
     *
     * @param updateMapRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMapRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UpdateMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMapResponse> updateMap(Consumer<UpdateMapRequest.Builder> updateMapRequest) {
        return updateMap(UpdateMapRequest.builder().applyMutation(updateMapRequest).build());
    }

    /**
     * <p>
     * Updates the specified properties of a given place index resource.
     * </p>
     *
     * @param updatePlaceIndexRequest
     * @return A Java Future containing the result of the UpdatePlaceIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UpdatePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdatePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePlaceIndexResponse> updatePlaceIndex(UpdatePlaceIndexRequest updatePlaceIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified properties of a given place index resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePlaceIndexRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePlaceIndexRequest#builder()}
     * </p>
     *
     * @param updatePlaceIndexRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePlaceIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdatePlaceIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UpdatePlaceIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdatePlaceIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePlaceIndexResponse> updatePlaceIndex(
            Consumer<UpdatePlaceIndexRequest.Builder> updatePlaceIndexRequest) {
        return updatePlaceIndex(UpdatePlaceIndexRequest.builder().applyMutation(updatePlaceIndexRequest).build());
    }

    /**
     * <p>
     * Updates the specified properties for a given route calculator resource.
     * </p>
     *
     * @param updateRouteCalculatorRequest
     * @return A Java Future containing the result of the UpdateRouteCalculator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UpdateRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRouteCalculatorResponse> updateRouteCalculator(
            UpdateRouteCalculatorRequest updateRouteCalculatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified properties for a given route calculator resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouteCalculatorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRouteCalculatorRequest#builder()}
     * </p>
     *
     * @param updateRouteCalculatorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRouteCalculatorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRouteCalculator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UpdateRouteCalculator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateRouteCalculator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRouteCalculatorResponse> updateRouteCalculator(
            Consumer<UpdateRouteCalculatorRequest.Builder> updateRouteCalculatorRequest) {
        return updateRouteCalculator(UpdateRouteCalculatorRequest.builder().applyMutation(updateRouteCalculatorRequest).build());
    }

    /**
     * <p>
     * Updates the specified properties of a given tracker resource.
     * </p>
     *
     * @param updateTrackerRequest
     * @return A Java Future containing the result of the UpdateTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UpdateTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTrackerResponse> updateTracker(UpdateTrackerRequest updateTrackerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified properties of a given tracker resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrackerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTrackerRequest#builder()}
     * </p>
     *
     * @param updateTrackerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTrackerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request has failed to process because of an unknown server error,
     *         exception, or failure.</li>
     *         <li>ResourceNotFoundException The resource that you've entered was not found in your AWS account.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input failed to meet the constraints specified by the AWS service.</li>
     *         <li>ThrottlingException The request was denied because of request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LocationException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LocationAsyncClient.UpdateTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/UpdateTracker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTrackerResponse> updateTracker(Consumer<UpdateTrackerRequest.Builder> updateTrackerRequest) {
        return updateTracker(UpdateTrackerRequest.builder().applyMutation(updateTrackerRequest).build());
    }
}
