/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPlaceRequest extends LocationRequest implements ToCopyableBuilder<GetPlaceRequest.Builder, GetPlaceRequest> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(GetPlaceRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IndexName").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(GetPlaceRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("language").build()).build();

    private static final SdkField<String> PLACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaceId").getter(getter(GetPlaceRequest::placeId)).setter(setter(Builder::placeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PlaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            LANGUAGE_FIELD, PLACE_ID_FIELD));

    private final String indexName;

    private final String language;

    private final String placeId;

    private GetPlaceRequest(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.language = builder.language;
        this.placeId = builder.placeId;
    }

    /**
     * <p>
     * The name of the place index resource that you want to use for the search.
     * </p>
     * 
     * @return The name of the place index resource that you want to use for the search.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The preferred language used to return results. The value must be a valid <a
     * href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.
     * </p>
     * <p>
     * This setting affects the languages used in the results, but not the results themselves. If no language is
     * specified, or not supported for a particular result, the partner automatically chooses a language for the result.
     * </p>
     * <p>
     * For an example, we'll use the Greek language. You search for a location around Athens, Greece, with the
     * <code>language</code> parameter set to <code>en</code>. The <code>city</code> in the results will most likely be
     * returned as <code>Athens</code>.
     * </p>
     * <p>
     * If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the <code>city</code> in the
     * results will more likely be returned as <code>Αθήνα</code>.
     * </p>
     * <p>
     * If the data provider does not have a value for Greek, the result will be in a language that the provider does
     * support.
     * </p>
     * 
     * @return The preferred language used to return results. The value must be a valid <a
     *         href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for
     *         English.</p>
     *         <p>
     *         This setting affects the languages used in the results, but not the results themselves. If no language is
     *         specified, or not supported for a particular result, the partner automatically chooses a language for the
     *         result.
     *         </p>
     *         <p>
     *         For an example, we'll use the Greek language. You search for a location around Athens, Greece, with the
     *         <code>language</code> parameter set to <code>en</code>. The <code>city</code> in the results will most
     *         likely be returned as <code>Athens</code>.
     *         </p>
     *         <p>
     *         If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the <code>city</code>
     *         in the results will more likely be returned as <code>Αθήνα</code>.
     *         </p>
     *         <p>
     *         If the data provider does not have a value for Greek, the result will be in a language that the provider
     *         does support.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The identifier of the place to find.
     * </p>
     * 
     * @return The identifier of the place to find.
     */
    public final String placeId() {
        return placeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(placeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlaceRequest)) {
            return false;
        }
        GetPlaceRequest other = (GetPlaceRequest) obj;
        return Objects.equals(indexName(), other.indexName()) && Objects.equals(language(), other.language())
                && Objects.equals(placeId(), other.placeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPlaceRequest").add("IndexName", indexName()).add("Language", language())
                .add("PlaceId", placeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "PlaceId":
            return Optional.ofNullable(clazz.cast(placeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPlaceRequest, T> g) {
        return obj -> g.apply((GetPlaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPlaceRequest> {
        /**
         * <p>
         * The name of the place index resource that you want to use for the search.
         * </p>
         * 
         * @param indexName
         *        The name of the place index resource that you want to use for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The preferred language used to return results. The value must be a valid <a
         * href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.
         * </p>
         * <p>
         * This setting affects the languages used in the results, but not the results themselves. If no language is
         * specified, or not supported for a particular result, the partner automatically chooses a language for the
         * result.
         * </p>
         * <p>
         * For an example, we'll use the Greek language. You search for a location around Athens, Greece, with the
         * <code>language</code> parameter set to <code>en</code>. The <code>city</code> in the results will most likely
         * be returned as <code>Athens</code>.
         * </p>
         * <p>
         * If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the <code>city</code> in
         * the results will more likely be returned as <code>Αθήνα</code>.
         * </p>
         * <p>
         * If the data provider does not have a value for Greek, the result will be in a language that the provider does
         * support.
         * </p>
         * 
         * @param language
         *        The preferred language used to return results. The value must be a valid <a
         *        href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for
         *        English.</p>
         *        <p>
         *        This setting affects the languages used in the results, but not the results themselves. If no language
         *        is specified, or not supported for a particular result, the partner automatically chooses a language
         *        for the result.
         *        </p>
         *        <p>
         *        For an example, we'll use the Greek language. You search for a location around Athens, Greece, with
         *        the <code>language</code> parameter set to <code>en</code>. The <code>city</code> in the results will
         *        most likely be returned as <code>Athens</code>.
         *        </p>
         *        <p>
         *        If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the
         *        <code>city</code> in the results will more likely be returned as <code>Αθήνα</code>.
         *        </p>
         *        <p>
         *        If the data provider does not have a value for Greek, the result will be in a language that the
         *        provider does support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The identifier of the place to find.
         * </p>
         * 
         * @param placeId
         *        The identifier of the place to find.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeId(String placeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String indexName;

        private String language;

        private String placeId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlaceRequest model) {
            super(model);
            indexName(model.indexName);
            language(model.language);
            placeId(model.placeId);
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPlaceId() {
            return placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPlaceRequest build() {
            return new GetPlaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
