/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationAsyncClient;
import software.amazon.awssdk.services.location.internal.UserAgentUtils;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse;

public class ListTrackerConsumersPublisher
implements SdkPublisher<ListTrackerConsumersResponse> {
    private final LocationAsyncClient client;
    private final ListTrackerConsumersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrackerConsumersPublisher(LocationAsyncClient client, ListTrackerConsumersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrackerConsumersPublisher(LocationAsyncClient client, ListTrackerConsumersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrackerConsumersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrackerConsumersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> consumerArns() {
        Function<ListTrackerConsumersResponse, Iterator> getIterator = response -> {
            if (response != null && response.consumerArns() != null) {
                return response.consumerArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrackerConsumersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrackerConsumersResponseFetcher
    implements AsyncPageFetcher<ListTrackerConsumersResponse> {
        private ListTrackerConsumersResponseFetcher() {
        }

        public boolean hasNextPage(ListTrackerConsumersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrackerConsumersResponse> nextPage(ListTrackerConsumersResponse previousPage) {
            if (previousPage == null) {
                return ListTrackerConsumersPublisher.this.client.listTrackerConsumers(ListTrackerConsumersPublisher.this.firstRequest);
            }
            return ListTrackerConsumersPublisher.this.client.listTrackerConsumers((ListTrackerConsumersRequest)((Object)ListTrackerConsumersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

