/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.location.DefaultLocationAsyncClient;
import software.amazon.awssdk.services.location.DefaultLocationBaseClientBuilder;
import software.amazon.awssdk.services.location.LocationAsyncClient;
import software.amazon.awssdk.services.location.LocationAsyncClientBuilder;
import software.amazon.awssdk.services.location.LocationServiceClientConfiguration;
import software.amazon.awssdk.services.location.endpoints.LocationEndpointProvider;

@SdkInternalApi
final class DefaultLocationAsyncClientBuilder
extends DefaultLocationBaseClientBuilder<LocationAsyncClientBuilder, LocationAsyncClient>
implements LocationAsyncClientBuilder {
    DefaultLocationAsyncClientBuilder() {
    }

    @Override
    public DefaultLocationAsyncClientBuilder endpointProvider(LocationEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LocationAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultLocationAsyncClientBuilder.validateClientOptions(clientConfiguration);
        LocationServiceClientConfiguration serviceClientConfiguration = LocationServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultLocationAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

