/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGeofenceCollectionResponse extends LocationResponse implements
        ToCopyableBuilder<CreateGeofenceCollectionResponse.Builder, CreateGeofenceCollectionResponse> {
    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionArn").getter(getter(CreateGeofenceCollectionResponse::collectionArn))
            .setter(setter(Builder::collectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionArn").build()).build();

    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionName").getter(getter(CreateGeofenceCollectionResponse::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(CreateGeofenceCollectionResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ARN_FIELD,
            COLLECTION_NAME_FIELD, CREATE_TIME_FIELD));

    private final String collectionArn;

    private final String collectionName;

    private final Instant createTime;

    private CreateGeofenceCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.collectionArn = builder.collectionArn;
        this.collectionName = builder.collectionName;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource
     * across all Amazon Web Services.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a
     *         resource across all Amazon Web Services. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
     *         </p>
     *         </li>
     */
    public final String collectionArn() {
        return collectionArn;
    }

    /**
     * <p>
     * The name for the geofence collection.
     * </p>
     * 
     * @return The name for the geofence collection.
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * <p>
     * The timestamp for when the geofence collection was created in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     * </p>
     * 
     * @return The timestamp for when the geofence collection was created in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     */
    public final Instant createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGeofenceCollectionResponse)) {
            return false;
        }
        CreateGeofenceCollectionResponse other = (CreateGeofenceCollectionResponse) obj;
        return Objects.equals(collectionArn(), other.collectionArn()) && Objects.equals(collectionName(), other.collectionName())
                && Objects.equals(createTime(), other.createTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGeofenceCollectionResponse").add("CollectionArn", collectionArn())
                .add("CollectionName", collectionName()).add("CreateTime", createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionArn":
            return Optional.ofNullable(clazz.cast(collectionArn()));
        case "CollectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGeofenceCollectionResponse, T> g) {
        return obj -> g.apply((CreateGeofenceCollectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGeofenceCollectionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource
         * across all Amazon Web Services.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param collectionArn
         *        The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a
         *        resource across all Amazon Web Services. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Format example:
         *        <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionArn(String collectionArn);

        /**
         * <p>
         * The name for the geofence collection.
         * </p>
         * 
         * @param collectionName
         *        The name for the geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * The timestamp for when the geofence collection was created in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * </p>
         * 
         * @param createTime
         *        The timestamp for when the geofence collection was created in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private String collectionArn;

        private String collectionName;

        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGeofenceCollectionResponse model) {
            super(model);
            collectionArn(model.collectionArn);
            collectionName(model.collectionName);
            createTime(model.createTime);
        }

        public final String getCollectionArn() {
            return collectionArn;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public CreateGeofenceCollectionResponse build() {
            return new CreateGeofenceCollectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
