/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.internal.UserAgentUtils;
import software.amazon.awssdk.services.location.model.ListTrackersRequest;
import software.amazon.awssdk.services.location.model.ListTrackersResponse;
import software.amazon.awssdk.services.location.model.ListTrackersResponseEntry;

public class ListTrackersIterable
implements SdkIterable<ListTrackersResponse> {
    private final LocationClient client;
    private final ListTrackersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrackersIterable(LocationClient client, ListTrackersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrackersResponseFetcher();
    }

    public Iterator<ListTrackersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListTrackersResponseEntry> entries() {
        Function<ListTrackersResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrackersResponseFetcher
    implements SyncPageFetcher<ListTrackersResponse> {
        private ListTrackersResponseFetcher() {
        }

        public boolean hasNextPage(ListTrackersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrackersResponse nextPage(ListTrackersResponse previousPage) {
            if (previousPage == null) {
                return ListTrackersIterable.this.client.listTrackers(ListTrackersIterable.this.firstRequest);
            }
            return ListTrackersIterable.this.client.listTrackers((ListTrackersRequest)((Object)ListTrackersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

