/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrackerResponse extends LocationResponse implements
        ToCopyableBuilder<DescribeTrackerResponse.Builder, DescribeTrackerResponse> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(DescribeTrackerResponse::trackerName)).setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerName").build()).build();

    private static final SdkField<String> TRACKER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerArn").getter(getter(DescribeTrackerResponse::trackerArn)).setter(setter(Builder::trackerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeTrackerResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(DescribeTrackerResponse::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlanDataSource").getter(getter(DescribeTrackerResponse::pricingPlanDataSource))
            .setter(setter(Builder::pricingPlanDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeTrackerResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(DescribeTrackerResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(DescribeTrackerResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DescribeTrackerResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> POSITION_FILTERING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PositionFiltering").getter(getter(DescribeTrackerResponse::positionFilteringAsString))
            .setter(setter(Builder::positionFiltering))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionFiltering").build()).build();

    private static final SdkField<Boolean> EVENT_BRIDGE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EventBridgeEnabled").getter(getter(DescribeTrackerResponse::eventBridgeEnabled))
            .setter(setter(Builder::eventBridgeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeEnabled").build())
            .build();

    private static final SdkField<Boolean> KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KmsKeyEnableGeospatialQueries")
            .getter(getter(DescribeTrackerResponse::kmsKeyEnableGeospatialQueries))
            .setter(setter(Builder::kmsKeyEnableGeospatialQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyEnableGeospatialQueries")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD,
            TRACKER_ARN_FIELD, DESCRIPTION_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, TAGS_FIELD,
            CREATE_TIME_FIELD, UPDATE_TIME_FIELD, KMS_KEY_ID_FIELD, POSITION_FILTERING_FIELD, EVENT_BRIDGE_ENABLED_FIELD,
            KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD));

    private final String trackerName;

    private final String trackerArn;

    private final String description;

    private final String pricingPlan;

    private final String pricingPlanDataSource;

    private final Map<String, String> tags;

    private final Instant createTime;

    private final Instant updateTime;

    private final String kmsKeyId;

    private final String positionFiltering;

    private final Boolean eventBridgeEnabled;

    private final Boolean kmsKeyEnableGeospatialQueries;

    private DescribeTrackerResponse(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.trackerArn = builder.trackerArn;
        this.description = builder.description;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.tags = builder.tags;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.kmsKeyId = builder.kmsKeyId;
        this.positionFiltering = builder.positionFiltering;
        this.eventBridgeEnabled = builder.eventBridgeEnabled;
        this.kmsKeyEnableGeospatialQueries = builder.kmsKeyEnableGeospatialQueries;
    }

    /**
     * <p>
     * The name of the tracker resource.
     * </p>
     * 
     * @return The name of the tracker resource.
     */
    public final String trackerName() {
        return trackerName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all
     * Amazon Web Services.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across
     *         all Amazon Web Services.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code>
     *         </p>
     *         </li>
     */
    public final String trackerArn() {
        return trackerArn;
    }

    /**
     * <p>
     * The optional description for the tracker resource.
     * </p>
     * 
     * @return The optional description for the tracker resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Always returns <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Always returns <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. Always returns RequestBasedUsage.
     */
    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * Always returns <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Always returns <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. Always returns RequestBasedUsage.
     */
    @Deprecated
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * <p>
     * No longer used. Always returns an empty string.
     * </p>
     * 
     * @return No longer used. Always returns an empty string.
     * @deprecated Deprecated. Unused.
     */
    @Deprecated
    public final String pricingPlanDataSource() {
        return pricingPlanDataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the tracker resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the tracker resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The timestamp for when the tracker resource was created in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the tracker resource was created in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The timestamp for when the tracker resource was last updated in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the tracker resource was last updated in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon
     * Web Services KMS customer managed key</a> assigned to the Amazon Location resource.
     * </p>
     * 
     * @return A key identifier for an <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
     *         customer managed key</a> assigned to the Amazon Location resource.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The position filtering method of the tracker resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positionFiltering}
     * will return {@link PositionFiltering#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionFilteringAsString}.
     * </p>
     * 
     * @return The position filtering method of the tracker resource.
     * @see PositionFiltering
     */
    public final PositionFiltering positionFiltering() {
        return PositionFiltering.fromValue(positionFiltering);
    }

    /**
     * <p>
     * The position filtering method of the tracker resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positionFiltering}
     * will return {@link PositionFiltering#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionFilteringAsString}.
     * </p>
     * 
     * @return The position filtering method of the tracker resource.
     * @see PositionFiltering
     */
    public final String positionFilteringAsString() {
        return positionFiltering;
    }

    /**
     * <p>
     * Whether <code>UPDATE</code> events from this tracker in EventBridge are enabled. If set to <code>true</code>
     * these events will be sent to EventBridge.
     * </p>
     * 
     * @return Whether <code>UPDATE</code> events from this tracker in EventBridge are enabled. If set to
     *         <code>true</code> these events will be sent to EventBridge.
     */
    public final Boolean eventBridgeEnabled() {
        return eventBridgeEnabled;
    }

    /**
     * <p>
     * Enables <code>GeospatialQueries</code> for a tracker that uses a <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS customer
     * managed key</a>.
     * </p>
     * <p>
     * This parameter is only used if you are using a KMS customer managed key.
     * </p>
     * <note>
     * <p>
     * If you wish to encrypt your data using your own KMS customer managed key, then the Bounding Polygon Queries
     * feature will be disabled by default. This is because by using this feature, a representation of your device
     * positions will not be encrypted using the your KMS managed key. The exact device position, however; is still
     * encrypted using your managed key.
     * </p>
     * <p>
     * You can choose to opt-in to the Bounding Polygon Quseries feature. This is done by setting the
     * <code>KmsKeyEnableGeospatialQueries</code> parameter to true when creating or updating a Tracker.
     * </p>
     * </note>
     * 
     * @return Enables <code>GeospatialQueries</code> for a tracker that uses a <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
     *         customer managed key</a>.</p>
     *         <p>
     *         This parameter is only used if you are using a KMS customer managed key.
     *         </p>
     *         <note>
     *         <p>
     *         If you wish to encrypt your data using your own KMS customer managed key, then the Bounding Polygon
     *         Queries feature will be disabled by default. This is because by using this feature, a representation of
     *         your device positions will not be encrypted using the your KMS managed key. The exact device position,
     *         however; is still encrypted using your managed key.
     *         </p>
     *         <p>
     *         You can choose to opt-in to the Bounding Polygon Quseries feature. This is done by setting the
     *         <code>KmsKeyEnableGeospatialQueries</code> parameter to true when creating or updating a Tracker.
     *         </p>
     */
    public final Boolean kmsKeyEnableGeospatialQueries() {
        return kmsKeyEnableGeospatialQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(trackerArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(positionFilteringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyEnableGeospatialQueries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrackerResponse)) {
            return false;
        }
        DescribeTrackerResponse other = (DescribeTrackerResponse) obj;
        return Objects.equals(trackerName(), other.trackerName()) && Objects.equals(trackerArn(), other.trackerArn())
                && Objects.equals(description(), other.description())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(pricingPlanDataSource(), other.pricingPlanDataSource()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(updateTime(), other.updateTime()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(positionFilteringAsString(), other.positionFilteringAsString())
                && Objects.equals(eventBridgeEnabled(), other.eventBridgeEnabled())
                && Objects.equals(kmsKeyEnableGeospatialQueries(), other.kmsKeyEnableGeospatialQueries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrackerResponse").add("TrackerName", trackerName()).add("TrackerArn", trackerArn())
                .add("Description", description()).add("PricingPlan", pricingPlanAsString())
                .add("PricingPlanDataSource", pricingPlanDataSource()).add("Tags", hasTags() ? tags() : null)
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("KmsKeyId", kmsKeyId())
                .add("PositionFiltering", positionFilteringAsString()).add("EventBridgeEnabled", eventBridgeEnabled())
                .add("KmsKeyEnableGeospatialQueries", kmsKeyEnableGeospatialQueries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        case "TrackerArn":
            return Optional.ofNullable(clazz.cast(trackerArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "PricingPlanDataSource":
            return Optional.ofNullable(clazz.cast(pricingPlanDataSource()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "PositionFiltering":
            return Optional.ofNullable(clazz.cast(positionFilteringAsString()));
        case "EventBridgeEnabled":
            return Optional.ofNullable(clazz.cast(eventBridgeEnabled()));
        case "KmsKeyEnableGeospatialQueries":
            return Optional.ofNullable(clazz.cast(kmsKeyEnableGeospatialQueries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrackerResponse, T> g) {
        return obj -> g.apply((DescribeTrackerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTrackerResponse> {
        /**
         * <p>
         * The name of the tracker resource.
         * </p>
         * 
         * @param trackerName
         *        The name of the tracker resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all
         * Amazon Web Services.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param trackerArn
         *        The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource
         *        across all Amazon Web Services.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerArn(String trackerArn);

        /**
         * <p>
         * The optional description for the tracker resource.
         * </p>
         * 
         * @param description
         *        The optional description for the tracker resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Always returns <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        Always returns <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. Always returns RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * Always returns <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        Always returns <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. Always returns RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * No longer used. Always returns an empty string.
         * </p>
         * 
         * @param pricingPlanDataSource
         *        No longer used. Always returns an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Deprecated. Unused.
         */
        @Deprecated
        Builder pricingPlanDataSource(String pricingPlanDataSource);

        /**
         * <p>
         * The tags associated with the tracker resource.
         * </p>
         * 
         * @param tags
         *        The tags associated with the tracker resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The timestamp for when the tracker resource was created in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param createTime
         *        The timestamp for when the tracker resource was created in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The timestamp for when the tracker resource was last updated in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param updateTime
         *        The timestamp for when the tracker resource was last updated in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * A key identifier for an <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
         * customer managed key</a> assigned to the Amazon Location resource.
         * </p>
         * 
         * @param kmsKeyId
         *        A key identifier for an <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
         *        customer managed key</a> assigned to the Amazon Location resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The position filtering method of the tracker resource.
         * </p>
         * 
         * @param positionFiltering
         *        The position filtering method of the tracker resource.
         * @see PositionFiltering
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionFiltering
         */
        Builder positionFiltering(String positionFiltering);

        /**
         * <p>
         * The position filtering method of the tracker resource.
         * </p>
         * 
         * @param positionFiltering
         *        The position filtering method of the tracker resource.
         * @see PositionFiltering
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionFiltering
         */
        Builder positionFiltering(PositionFiltering positionFiltering);

        /**
         * <p>
         * Whether <code>UPDATE</code> events from this tracker in EventBridge are enabled. If set to <code>true</code>
         * these events will be sent to EventBridge.
         * </p>
         * 
         * @param eventBridgeEnabled
         *        Whether <code>UPDATE</code> events from this tracker in EventBridge are enabled. If set to
         *        <code>true</code> these events will be sent to EventBridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeEnabled(Boolean eventBridgeEnabled);

        /**
         * <p>
         * Enables <code>GeospatialQueries</code> for a tracker that uses a <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
         * customer managed key</a>.
         * </p>
         * <p>
         * This parameter is only used if you are using a KMS customer managed key.
         * </p>
         * <note>
         * <p>
         * If you wish to encrypt your data using your own KMS customer managed key, then the Bounding Polygon Queries
         * feature will be disabled by default. This is because by using this feature, a representation of your device
         * positions will not be encrypted using the your KMS managed key. The exact device position, however; is still
         * encrypted using your managed key.
         * </p>
         * <p>
         * You can choose to opt-in to the Bounding Polygon Quseries feature. This is done by setting the
         * <code>KmsKeyEnableGeospatialQueries</code> parameter to true when creating or updating a Tracker.
         * </p>
         * </note>
         * 
         * @param kmsKeyEnableGeospatialQueries
         *        Enables <code>GeospatialQueries</code> for a tracker that uses a <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
         *        customer managed key</a>.</p>
         *        <p>
         *        This parameter is only used if you are using a KMS customer managed key.
         *        </p>
         *        <note>
         *        <p>
         *        If you wish to encrypt your data using your own KMS customer managed key, then the Bounding Polygon
         *        Queries feature will be disabled by default. This is because by using this feature, a representation
         *        of your device positions will not be encrypted using the your KMS managed key. The exact device
         *        position, however; is still encrypted using your managed key.
         *        </p>
         *        <p>
         *        You can choose to opt-in to the Bounding Polygon Quseries feature. This is done by setting the
         *        <code>KmsKeyEnableGeospatialQueries</code> parameter to true when creating or updating a Tracker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private String trackerName;

        private String trackerArn;

        private String description;

        private String pricingPlan;

        private String pricingPlanDataSource;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant createTime;

        private Instant updateTime;

        private String kmsKeyId;

        private String positionFiltering;

        private Boolean eventBridgeEnabled;

        private Boolean kmsKeyEnableGeospatialQueries;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrackerResponse model) {
            super(model);
            trackerName(model.trackerName);
            trackerArn(model.trackerArn);
            description(model.description);
            pricingPlan(model.pricingPlan);
            pricingPlanDataSource(model.pricingPlanDataSource);
            tags(model.tags);
            createTime(model.createTime);
            updateTime(model.updateTime);
            kmsKeyId(model.kmsKeyId);
            positionFiltering(model.positionFiltering);
            eventBridgeEnabled(model.eventBridgeEnabled);
            kmsKeyEnableGeospatialQueries(model.kmsKeyEnableGeospatialQueries);
        }

        public final String getTrackerName() {
            return trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final String getTrackerArn() {
            return trackerArn;
        }

        public final void setTrackerArn(String trackerArn) {
            this.trackerArn = trackerArn;
        }

        @Override
        public final Builder trackerArn(String trackerArn) {
            this.trackerArn = trackerArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPositionFiltering() {
            return positionFiltering;
        }

        public final void setPositionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
        }

        @Override
        public final Builder positionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
            return this;
        }

        @Override
        public final Builder positionFiltering(PositionFiltering positionFiltering) {
            this.positionFiltering(positionFiltering == null ? null : positionFiltering.toString());
            return this;
        }

        public final Boolean getEventBridgeEnabled() {
            return eventBridgeEnabled;
        }

        public final void setEventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
        }

        @Override
        public final Builder eventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        public final Boolean getKmsKeyEnableGeospatialQueries() {
            return kmsKeyEnableGeospatialQueries;
        }

        public final void setKmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
        }

        @Override
        public final Builder kmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
            return this;
        }

        @Override
        public DescribeTrackerResponse build() {
            return new DescribeTrackerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
