/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForecastGeofenceEventsRequest extends LocationRequest implements
        ToCopyableBuilder<ForecastGeofenceEventsRequest.Builder, ForecastGeofenceEventsRequest> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionName").getter(getter(ForecastGeofenceEventsRequest::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CollectionName").build()).build();

    private static final SdkField<ForecastGeofenceEventsDeviceState> DEVICE_STATE_FIELD = SdkField
            .<ForecastGeofenceEventsDeviceState> builder(MarshallingType.SDK_POJO).memberName("DeviceState")
            .getter(getter(ForecastGeofenceEventsRequest::deviceState)).setter(setter(Builder::deviceState))
            .constructor(ForecastGeofenceEventsDeviceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceState").build()).build();

    private static final SdkField<Double> TIME_HORIZON_MINUTES_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TimeHorizonMinutes").getter(getter(ForecastGeofenceEventsRequest::timeHorizonMinutes))
            .setter(setter(Builder::timeHorizonMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeHorizonMinutes").build())
            .build();

    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistanceUnit").getter(getter(ForecastGeofenceEventsRequest::distanceUnitAsString))
            .setter(setter(Builder::distanceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()).build();

    private static final SdkField<String> SPEED_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpeedUnit").getter(getter(ForecastGeofenceEventsRequest::speedUnitAsString))
            .setter(setter(Builder::speedUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeedUnit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ForecastGeofenceEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ForecastGeofenceEventsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD,
            DEVICE_STATE_FIELD, TIME_HORIZON_MINUTES_FIELD, DISTANCE_UNIT_FIELD, SPEED_UNIT_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private final String collectionName;

    private final ForecastGeofenceEventsDeviceState deviceState;

    private final Double timeHorizonMinutes;

    private final String distanceUnit;

    private final String speedUnit;

    private final String nextToken;

    private final Integer maxResults;

    private ForecastGeofenceEventsRequest(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.deviceState = builder.deviceState;
        this.timeHorizonMinutes = builder.timeHorizonMinutes;
        this.distanceUnit = builder.distanceUnit;
        this.speedUnit = builder.speedUnit;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name of the geofence collection.
     * </p>
     * 
     * @return The name of the geofence collection.
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * <p>
     * The device's state, including current position and speed.
     * </p>
     * 
     * @return The device's state, including current position and speed.
     */
    public final ForecastGeofenceEventsDeviceState deviceState() {
        return deviceState;
    }

    /**
     * <p>
     * Specifies the time horizon in minutes for the forecasted events.
     * </p>
     * 
     * @return Specifies the time horizon in minutes for the forecasted events.
     */
    public final Double timeHorizonMinutes() {
        return timeHorizonMinutes;
    }

    /**
     * <p>
     * The distance unit used for the <code>NearestDistance</code> property returned in a forecasted event. The
     * measurement system must match for <code>DistanceUnit</code> and <code>SpeedUnit</code>; if
     * <code>Kilometers</code> is specified for <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be
     * <code>KilometersPerHour</code>.
     * </p>
     * <p>
     * Default Value: <code>Kilometers</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit used for the <code>NearestDistance</code> property returned in a forecasted event. The
     *         measurement system must match for <code>DistanceUnit</code> and <code>SpeedUnit</code>; if
     *         <code>Kilometers</code> is specified for <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be
     *         <code>KilometersPerHour</code>. </p>
     *         <p>
     *         Default Value: <code>Kilometers</code>
     * @see DistanceUnit
     */
    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The distance unit used for the <code>NearestDistance</code> property returned in a forecasted event. The
     * measurement system must match for <code>DistanceUnit</code> and <code>SpeedUnit</code>; if
     * <code>Kilometers</code> is specified for <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be
     * <code>KilometersPerHour</code>.
     * </p>
     * <p>
     * Default Value: <code>Kilometers</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit used for the <code>NearestDistance</code> property returned in a forecasted event. The
     *         measurement system must match for <code>DistanceUnit</code> and <code>SpeedUnit</code>; if
     *         <code>Kilometers</code> is specified for <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be
     *         <code>KilometersPerHour</code>. </p>
     *         <p>
     *         Default Value: <code>Kilometers</code>
     * @see DistanceUnit
     */
    public final String distanceUnitAsString() {
        return distanceUnit;
    }

    /**
     * <p>
     * The speed unit for the device captured by the device state. The measurement system must match for
     * <code>DistanceUnit</code> and <code>SpeedUnit</code>; if <code>Kilometers</code> is specified for
     * <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be <code>KilometersPerHour</code>.
     * </p>
     * <p>
     * Default Value: <code>KilometersPerHour</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #speedUnit} will
     * return {@link SpeedUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #speedUnitAsString}.
     * </p>
     * 
     * @return The speed unit for the device captured by the device state. The measurement system must match for
     *         <code>DistanceUnit</code> and <code>SpeedUnit</code>; if <code>Kilometers</code> is specified for
     *         <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be <code>KilometersPerHour</code>.</p>
     *         <p>
     *         Default Value: <code>KilometersPerHour</code>.
     * @see SpeedUnit
     */
    public final SpeedUnit speedUnit() {
        return SpeedUnit.fromValue(speedUnit);
    }

    /**
     * <p>
     * The speed unit for the device captured by the device state. The measurement system must match for
     * <code>DistanceUnit</code> and <code>SpeedUnit</code>; if <code>Kilometers</code> is specified for
     * <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be <code>KilometersPerHour</code>.
     * </p>
     * <p>
     * Default Value: <code>KilometersPerHour</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #speedUnit} will
     * return {@link SpeedUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #speedUnitAsString}.
     * </p>
     * 
     * @return The speed unit for the device captured by the device state. The measurement system must match for
     *         <code>DistanceUnit</code> and <code>SpeedUnit</code>; if <code>Kilometers</code> is specified for
     *         <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be <code>KilometersPerHour</code>.</p>
     *         <p>
     *         Default Value: <code>KilometersPerHour</code>.
     * @see SpeedUnit
     */
    public final String speedUnitAsString() {
        return speedUnit;
    }

    /**
     * <p>
     * The pagination token specifying which page of results to return in the response. If no token is provided, the
     * default page is the first page.
     * </p>
     * <p>
     * Default value: <code>null</code>
     * </p>
     * 
     * @return The pagination token specifying which page of results to return in the response. If no token is provided,
     *         the default page is the first page.</p>
     *         <p>
     *         Default value: <code>null</code>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An optional limit for the number of resources returned in a single call.
     * </p>
     * <p>
     * Default value: <code>20</code>
     * </p>
     * 
     * @return An optional limit for the number of resources returned in a single call.</p>
     *         <p>
     *         Default value: <code>20</code>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceState());
        hashCode = 31 * hashCode + Objects.hashCode(timeHorizonMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(speedUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastGeofenceEventsRequest)) {
            return false;
        }
        ForecastGeofenceEventsRequest other = (ForecastGeofenceEventsRequest) obj;
        return Objects.equals(collectionName(), other.collectionName()) && Objects.equals(deviceState(), other.deviceState())
                && Objects.equals(timeHorizonMinutes(), other.timeHorizonMinutes())
                && Objects.equals(distanceUnitAsString(), other.distanceUnitAsString())
                && Objects.equals(speedUnitAsString(), other.speedUnitAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ForecastGeofenceEventsRequest").add("CollectionName", collectionName())
                .add("DeviceState", deviceState()).add("TimeHorizonMinutes", timeHorizonMinutes())
                .add("DistanceUnit", distanceUnitAsString()).add("SpeedUnit", speedUnitAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "DeviceState":
            return Optional.ofNullable(clazz.cast(deviceState()));
        case "TimeHorizonMinutes":
            return Optional.ofNullable(clazz.cast(timeHorizonMinutes()));
        case "DistanceUnit":
            return Optional.ofNullable(clazz.cast(distanceUnitAsString()));
        case "SpeedUnit":
            return Optional.ofNullable(clazz.cast(speedUnitAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForecastGeofenceEventsRequest, T> g) {
        return obj -> g.apply((ForecastGeofenceEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ForecastGeofenceEventsRequest> {
        /**
         * <p>
         * The name of the geofence collection.
         * </p>
         * 
         * @param collectionName
         *        The name of the geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * The device's state, including current position and speed.
         * </p>
         * 
         * @param deviceState
         *        The device's state, including current position and speed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceState(ForecastGeofenceEventsDeviceState deviceState);

        /**
         * <p>
         * The device's state, including current position and speed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ForecastGeofenceEventsDeviceState.Builder} avoiding the need to create one manually via
         * {@link ForecastGeofenceEventsDeviceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ForecastGeofenceEventsDeviceState.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceState(ForecastGeofenceEventsDeviceState)}.
         * 
         * @param deviceState
         *        a consumer that will call methods on {@link ForecastGeofenceEventsDeviceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceState(ForecastGeofenceEventsDeviceState)
         */
        default Builder deviceState(Consumer<ForecastGeofenceEventsDeviceState.Builder> deviceState) {
            return deviceState(ForecastGeofenceEventsDeviceState.builder().applyMutation(deviceState).build());
        }

        /**
         * <p>
         * Specifies the time horizon in minutes for the forecasted events.
         * </p>
         * 
         * @param timeHorizonMinutes
         *        Specifies the time horizon in minutes for the forecasted events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeHorizonMinutes(Double timeHorizonMinutes);

        /**
         * <p>
         * The distance unit used for the <code>NearestDistance</code> property returned in a forecasted event. The
         * measurement system must match for <code>DistanceUnit</code> and <code>SpeedUnit</code>; if
         * <code>Kilometers</code> is specified for <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be
         * <code>KilometersPerHour</code>.
         * </p>
         * <p>
         * Default Value: <code>Kilometers</code>
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit used for the <code>NearestDistance</code> property returned in a forecasted event.
         *        The measurement system must match for <code>DistanceUnit</code> and <code>SpeedUnit</code>; if
         *        <code>Kilometers</code> is specified for <code>DistanceUnit</code>, then <code>SpeedUnit</code> must
         *        be <code>KilometersPerHour</code>. </p>
         *        <p>
         *        Default Value: <code>Kilometers</code>
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The distance unit used for the <code>NearestDistance</code> property returned in a forecasted event. The
         * measurement system must match for <code>DistanceUnit</code> and <code>SpeedUnit</code>; if
         * <code>Kilometers</code> is specified for <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be
         * <code>KilometersPerHour</code>.
         * </p>
         * <p>
         * Default Value: <code>Kilometers</code>
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit used for the <code>NearestDistance</code> property returned in a forecasted event.
         *        The measurement system must match for <code>DistanceUnit</code> and <code>SpeedUnit</code>; if
         *        <code>Kilometers</code> is specified for <code>DistanceUnit</code>, then <code>SpeedUnit</code> must
         *        be <code>KilometersPerHour</code>. </p>
         *        <p>
         *        Default Value: <code>Kilometers</code>
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);

        /**
         * <p>
         * The speed unit for the device captured by the device state. The measurement system must match for
         * <code>DistanceUnit</code> and <code>SpeedUnit</code>; if <code>Kilometers</code> is specified for
         * <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be <code>KilometersPerHour</code>.
         * </p>
         * <p>
         * Default Value: <code>KilometersPerHour</code>.
         * </p>
         * 
         * @param speedUnit
         *        The speed unit for the device captured by the device state. The measurement system must match for
         *        <code>DistanceUnit</code> and <code>SpeedUnit</code>; if <code>Kilometers</code> is specified for
         *        <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be <code>KilometersPerHour</code>.</p>
         *        <p>
         *        Default Value: <code>KilometersPerHour</code>.
         * @see SpeedUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeedUnit
         */
        Builder speedUnit(String speedUnit);

        /**
         * <p>
         * The speed unit for the device captured by the device state. The measurement system must match for
         * <code>DistanceUnit</code> and <code>SpeedUnit</code>; if <code>Kilometers</code> is specified for
         * <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be <code>KilometersPerHour</code>.
         * </p>
         * <p>
         * Default Value: <code>KilometersPerHour</code>.
         * </p>
         * 
         * @param speedUnit
         *        The speed unit for the device captured by the device state. The measurement system must match for
         *        <code>DistanceUnit</code> and <code>SpeedUnit</code>; if <code>Kilometers</code> is specified for
         *        <code>DistanceUnit</code>, then <code>SpeedUnit</code> must be <code>KilometersPerHour</code>.</p>
         *        <p>
         *        Default Value: <code>KilometersPerHour</code>.
         * @see SpeedUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeedUnit
         */
        Builder speedUnit(SpeedUnit speedUnit);

        /**
         * <p>
         * The pagination token specifying which page of results to return in the response. If no token is provided, the
         * default page is the first page.
         * </p>
         * <p>
         * Default value: <code>null</code>
         * </p>
         * 
         * @param nextToken
         *        The pagination token specifying which page of results to return in the response. If no token is
         *        provided, the default page is the first page.</p>
         *        <p>
         *        Default value: <code>null</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An optional limit for the number of resources returned in a single call.
         * </p>
         * <p>
         * Default value: <code>20</code>
         * </p>
         * 
         * @param maxResults
         *        An optional limit for the number of resources returned in a single call.</p>
         *        <p>
         *        Default value: <code>20</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String collectionName;

        private ForecastGeofenceEventsDeviceState deviceState;

        private Double timeHorizonMinutes;

        private String distanceUnit;

        private String speedUnit;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastGeofenceEventsRequest model) {
            super(model);
            collectionName(model.collectionName);
            deviceState(model.deviceState);
            timeHorizonMinutes(model.timeHorizonMinutes);
            distanceUnit(model.distanceUnit);
            speedUnit(model.speedUnit);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final ForecastGeofenceEventsDeviceState.Builder getDeviceState() {
            return deviceState != null ? deviceState.toBuilder() : null;
        }

        public final void setDeviceState(ForecastGeofenceEventsDeviceState.BuilderImpl deviceState) {
            this.deviceState = deviceState != null ? deviceState.build() : null;
        }

        @Override
        public final Builder deviceState(ForecastGeofenceEventsDeviceState deviceState) {
            this.deviceState = deviceState;
            return this;
        }

        public final Double getTimeHorizonMinutes() {
            return timeHorizonMinutes;
        }

        public final void setTimeHorizonMinutes(Double timeHorizonMinutes) {
            this.timeHorizonMinutes = timeHorizonMinutes;
        }

        @Override
        public final Builder timeHorizonMinutes(Double timeHorizonMinutes) {
            this.timeHorizonMinutes = timeHorizonMinutes;
            return this;
        }

        public final String getDistanceUnit() {
            return distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final String getSpeedUnit() {
            return speedUnit;
        }

        public final void setSpeedUnit(String speedUnit) {
            this.speedUnit = speedUnit;
        }

        @Override
        public final Builder speedUnit(String speedUnit) {
            this.speedUnit = speedUnit;
            return this;
        }

        @Override
        public final Builder speedUnit(SpeedUnit speedUnit) {
            this.speedUnit(speedUnit == null ? null : speedUnit.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ForecastGeofenceEventsRequest build() {
            return new ForecastGeofenceEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
