/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouteCalculatorResponse extends LocationResponse implements
        ToCopyableBuilder<CreateRouteCalculatorResponse.Builder, CreateRouteCalculatorResponse> {
    private static final SdkField<String> CALCULATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculatorName").getter(getter(CreateRouteCalculatorResponse::calculatorName))
            .setter(setter(Builder::calculatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorName").build()).build();

    private static final SdkField<String> CALCULATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculatorArn").getter(getter(CreateRouteCalculatorResponse::calculatorArn))
            .setter(setter(Builder::calculatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorArn").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(CreateRouteCalculatorResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATOR_NAME_FIELD,
            CALCULATOR_ARN_FIELD, CREATE_TIME_FIELD));

    private final String calculatorName;

    private final String calculatorArn;

    private final Instant createTime;

    private CreateRouteCalculatorResponse(BuilderImpl builder) {
        super(builder);
        this.calculatorName = builder.calculatorName;
        this.calculatorArn = builder.calculatorArn;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The name of the route calculator resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For example, <code>ExampleRouteCalculator</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the route calculator resource. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For example, <code>ExampleRouteCalculator</code>.
     *         </p>
     *         </li>
     */
    public final String calculatorName() {
        return calculatorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across
     * all Amazon Web Services.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource
     *         across all Amazon Web Services.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code>
     *         </p>
     *         </li>
     */
    public final String calculatorArn() {
        return calculatorArn;
    }

    /**
     * <p>
     * The timestamp when the route calculator resource was created in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For example, <code>2020–07-2T12:15:20.000Z+01:00</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The timestamp when the route calculator resource was created in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For example, <code>2020–07-2T12:15:20.000Z+01:00</code>
     *         </p>
     *         </li>
     */
    public final Instant createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(calculatorName());
        hashCode = 31 * hashCode + Objects.hashCode(calculatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteCalculatorResponse)) {
            return false;
        }
        CreateRouteCalculatorResponse other = (CreateRouteCalculatorResponse) obj;
        return Objects.equals(calculatorName(), other.calculatorName()) && Objects.equals(calculatorArn(), other.calculatorArn())
                && Objects.equals(createTime(), other.createTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRouteCalculatorResponse").add("CalculatorName", calculatorName())
                .add("CalculatorArn", calculatorArn()).add("CreateTime", createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CalculatorName":
            return Optional.ofNullable(clazz.cast(calculatorName()));
        case "CalculatorArn":
            return Optional.ofNullable(clazz.cast(calculatorArn()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteCalculatorResponse, T> g) {
        return obj -> g.apply((CreateRouteCalculatorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRouteCalculatorResponse> {
        /**
         * <p>
         * The name of the route calculator resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example, <code>ExampleRouteCalculator</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param calculatorName
         *        The name of the route calculator resource. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example, <code>ExampleRouteCalculator</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatorName(String calculatorName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource
         * across all Amazon Web Services.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param calculatorArn
         *        The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a
         *        resource across all Amazon Web Services.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatorArn(String calculatorArn);

        /**
         * <p>
         * The timestamp when the route calculator resource was created in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example, <code>2020–07-2T12:15:20.000Z+01:00</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param createTime
         *        The timestamp when the route calculator resource was created in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example, <code>2020–07-2T12:15:20.000Z+01:00</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private String calculatorName;

        private String calculatorArn;

        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteCalculatorResponse model) {
            super(model);
            calculatorName(model.calculatorName);
            calculatorArn(model.calculatorArn);
            createTime(model.createTime);
        }

        public final String getCalculatorName() {
            return calculatorName;
        }

        public final void setCalculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
        }

        @Override
        public final Builder calculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        public final String getCalculatorArn() {
            return calculatorArn;
        }

        public final void setCalculatorArn(String calculatorArn) {
            this.calculatorArn = calculatorArn;
        }

        @Override
        public final Builder calculatorArn(String calculatorArn) {
            this.calculatorArn = calculatorArn;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public CreateRouteCalculatorResponse build() {
            return new CreateRouteCalculatorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
