/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyDevicePositionRequest extends LocationRequest implements
        ToCopyableBuilder<VerifyDevicePositionRequest.Builder, VerifyDevicePositionRequest> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(VerifyDevicePositionRequest::trackerName))
            .setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()).build();

    private static final SdkField<DeviceState> DEVICE_STATE_FIELD = SdkField.<DeviceState> builder(MarshallingType.SDK_POJO)
            .memberName("DeviceState").getter(getter(VerifyDevicePositionRequest::deviceState))
            .setter(setter(Builder::deviceState)).constructor(DeviceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceState").build()).build();

    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistanceUnit").getter(getter(VerifyDevicePositionRequest::distanceUnitAsString))
            .setter(setter(Builder::distanceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD,
            DEVICE_STATE_FIELD, DISTANCE_UNIT_FIELD));

    private final String trackerName;

    private final DeviceState deviceState;

    private final String distanceUnit;

    private VerifyDevicePositionRequest(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.deviceState = builder.deviceState;
        this.distanceUnit = builder.distanceUnit;
    }

    /**
     * <p>
     * The name of the tracker resource to be associated with verification request.
     * </p>
     * 
     * @return The name of the tracker resource to be associated with verification request.
     */
    public final String trackerName() {
        return trackerName;
    }

    /**
     * <p>
     * The device's state, including position, IP address, cell signals and Wi-Fi access points.
     * </p>
     * 
     * @return The device's state, including position, IP address, cell signals and Wi-Fi access points.
     */
    public final DeviceState deviceState() {
        return deviceState;
    }

    /**
     * <p>
     * The distance unit for the verification request.
     * </p>
     * <p>
     * Default Value: <code>Kilometers</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit for the verification request.</p>
     *         <p>
     *         Default Value: <code>Kilometers</code>
     * @see DistanceUnit
     */
    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The distance unit for the verification request.
     * </p>
     * <p>
     * Default Value: <code>Kilometers</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit for the verification request.</p>
     *         <p>
     *         Default Value: <code>Kilometers</code>
     * @see DistanceUnit
     */
    public final String distanceUnitAsString() {
        return distanceUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceState());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDevicePositionRequest)) {
            return false;
        }
        VerifyDevicePositionRequest other = (VerifyDevicePositionRequest) obj;
        return Objects.equals(trackerName(), other.trackerName()) && Objects.equals(deviceState(), other.deviceState())
                && Objects.equals(distanceUnitAsString(), other.distanceUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyDevicePositionRequest").add("TrackerName", trackerName())
                .add("DeviceState", deviceState()).add("DistanceUnit", distanceUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        case "DeviceState":
            return Optional.ofNullable(clazz.cast(deviceState()));
        case "DistanceUnit":
            return Optional.ofNullable(clazz.cast(distanceUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyDevicePositionRequest, T> g) {
        return obj -> g.apply((VerifyDevicePositionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, VerifyDevicePositionRequest> {
        /**
         * <p>
         * The name of the tracker resource to be associated with verification request.
         * </p>
         * 
         * @param trackerName
         *        The name of the tracker resource to be associated with verification request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        /**
         * <p>
         * The device's state, including position, IP address, cell signals and Wi-Fi access points.
         * </p>
         * 
         * @param deviceState
         *        The device's state, including position, IP address, cell signals and Wi-Fi access points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceState(DeviceState deviceState);

        /**
         * <p>
         * The device's state, including position, IP address, cell signals and Wi-Fi access points.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceState.Builder} avoiding the need to
         * create one manually via {@link DeviceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceState.Builder#build()} is called immediately and its result
         * is passed to {@link #deviceState(DeviceState)}.
         * 
         * @param deviceState
         *        a consumer that will call methods on {@link DeviceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceState(DeviceState)
         */
        default Builder deviceState(Consumer<DeviceState.Builder> deviceState) {
            return deviceState(DeviceState.builder().applyMutation(deviceState).build());
        }

        /**
         * <p>
         * The distance unit for the verification request.
         * </p>
         * <p>
         * Default Value: <code>Kilometers</code>
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit for the verification request.</p>
         *        <p>
         *        Default Value: <code>Kilometers</code>
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The distance unit for the verification request.
         * </p>
         * <p>
         * Default Value: <code>Kilometers</code>
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit for the verification request.</p>
         *        <p>
         *        Default Value: <code>Kilometers</code>
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String trackerName;

        private DeviceState deviceState;

        private String distanceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDevicePositionRequest model) {
            super(model);
            trackerName(model.trackerName);
            deviceState(model.deviceState);
            distanceUnit(model.distanceUnit);
        }

        public final String getTrackerName() {
            return trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final DeviceState.Builder getDeviceState() {
            return deviceState != null ? deviceState.toBuilder() : null;
        }

        public final void setDeviceState(DeviceState.BuilderImpl deviceState) {
            this.deviceState = deviceState != null ? deviceState.build() : null;
        }

        @Override
        public final Builder deviceState(DeviceState deviceState) {
            this.deviceState = deviceState;
            return this;
        }

        public final String getDistanceUnit() {
            return distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyDevicePositionRequest build() {
            return new VerifyDevicePositionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
