/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.GeofenceGeometry;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PropertyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutGeofenceRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, PutGeofenceRequest> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionName").getter(PutGeofenceRequest.getter(PutGeofenceRequest::collectionName)).setter(PutGeofenceRequest.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CollectionName").build()}).build();
    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeofenceId").getter(PutGeofenceRequest.getter(PutGeofenceRequest::geofenceId)).setter(PutGeofenceRequest.setter(Builder::geofenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("GeofenceId").build()}).build();
    private static final SdkField<GeofenceGeometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(PutGeofenceRequest.getter(PutGeofenceRequest::geometry)).setter(PutGeofenceRequest.setter(Builder::geometry)).constructor(GeofenceGeometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final SdkField<Map<String, String>> GEOFENCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("GeofenceProperties").getter(PutGeofenceRequest.getter(PutGeofenceRequest::geofenceProperties)).setter(PutGeofenceRequest.setter(Builder::geofenceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD, GEOFENCE_ID_FIELD, GEOMETRY_FIELD, GEOFENCE_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutGeofenceRequest.memberNameToFieldInitializer();
    private final String collectionName;
    private final String geofenceId;
    private final GeofenceGeometry geometry;
    private final Map<String, String> geofenceProperties;

    private PutGeofenceRequest(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.geofenceId = builder.geofenceId;
        this.geometry = builder.geometry;
        this.geofenceProperties = builder.geofenceProperties;
    }

    public final String collectionName() {
        return this.collectionName;
    }

    public final String geofenceId() {
        return this.geofenceId;
    }

    public final GeofenceGeometry geometry() {
        return this.geometry;
    }

    public final boolean hasGeofenceProperties() {
        return this.geofenceProperties != null && !(this.geofenceProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> geofenceProperties() {
        return this.geofenceProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.geofenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeofenceProperties() ? this.geofenceProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGeofenceRequest)) {
            return false;
        }
        PutGeofenceRequest other = (PutGeofenceRequest)((Object)obj);
        return Objects.equals(this.collectionName(), other.collectionName()) && Objects.equals(this.geofenceId(), other.geofenceId()) && Objects.equals(this.geometry(), other.geometry()) && this.hasGeofenceProperties() == other.hasGeofenceProperties() && Objects.equals(this.geofenceProperties(), other.geofenceProperties());
    }

    public final String toString() {
        return ToString.builder((String)"PutGeofenceRequest").add("CollectionName", (Object)this.collectionName()).add("GeofenceId", (Object)this.geofenceId()).add("Geometry", (Object)this.geometry()).add("GeofenceProperties", (Object)(this.geofenceProperties() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "GeofenceId": {
                return Optional.ofNullable(clazz.cast(this.geofenceId()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
            case "GeofenceProperties": {
                return Optional.ofNullable(clazz.cast(this.geofenceProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionName", COLLECTION_NAME_FIELD);
        map.put("GeofenceId", GEOFENCE_ID_FIELD);
        map.put("Geometry", GEOMETRY_FIELD);
        map.put("GeofenceProperties", GEOFENCE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutGeofenceRequest, T> g) {
        return obj -> g.apply((PutGeofenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String collectionName;
        private String geofenceId;
        private GeofenceGeometry geometry;
        private Map<String, String> geofenceProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutGeofenceRequest model) {
            super(model);
            this.collectionName(model.collectionName);
            this.geofenceId(model.geofenceId);
            this.geometry(model.geometry);
            this.geofenceProperties(model.geofenceProperties);
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final String getGeofenceId() {
            return this.geofenceId;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        @Override
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        public final GeofenceGeometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        public final void setGeometry(GeofenceGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(GeofenceGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final Map<String, String> getGeofenceProperties() {
            if (this.geofenceProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.geofenceProperties;
        }

        public final void setGeofenceProperties(Map<String, String> geofenceProperties) {
            this.geofenceProperties = PropertyMapCopier.copy(geofenceProperties);
        }

        @Override
        public final Builder geofenceProperties(Map<String, String> geofenceProperties) {
            this.geofenceProperties = PropertyMapCopier.copy(geofenceProperties);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutGeofenceRequest build() {
            return new PutGeofenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutGeofenceRequest> {
        public Builder collectionName(String var1);

        public Builder geofenceId(String var1);

        public Builder geometry(GeofenceGeometry var1);

        default public Builder geometry(Consumer<GeofenceGeometry.Builder> geometry) {
            return this.geometry((GeofenceGeometry)((GeofenceGeometry.Builder)GeofenceGeometry.builder().applyMutation(geometry)).build());
        }

        public Builder geofenceProperties(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

