/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteDevicePositionHistoryRequest extends LocationRequest implements
        ToCopyableBuilder<BatchDeleteDevicePositionHistoryRequest.Builder, BatchDeleteDevicePositionHistoryRequest> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(BatchDeleteDevicePositionHistoryRequest::trackerName))
            .setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()).build();

    private static final SdkField<List<String>> DEVICE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeviceIds")
            .getter(getter(BatchDeleteDevicePositionHistoryRequest::deviceIds))
            .setter(setter(Builder::deviceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD,
            DEVICE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trackerName;

    private final List<String> deviceIds;

    private BatchDeleteDevicePositionHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.deviceIds = builder.deviceIds;
    }

    /**
     * <p>
     * The name of the tracker resource to delete the device position history from.
     * </p>
     * 
     * @return The name of the tracker resource to delete the device position history from.
     */
    public final String trackerName() {
        return trackerName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDeviceIds() {
        return deviceIds != null && !(deviceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Devices whose position history you want to delete.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceIds} method.
     * </p>
     * 
     * @return Devices whose position history you want to delete.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code>
     *         </p>
     *         </li>
     */
    public final List<String> deviceIds() {
        return deviceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceIds() ? deviceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDevicePositionHistoryRequest)) {
            return false;
        }
        BatchDeleteDevicePositionHistoryRequest other = (BatchDeleteDevicePositionHistoryRequest) obj;
        return Objects.equals(trackerName(), other.trackerName()) && hasDeviceIds() == other.hasDeviceIds()
                && Objects.equals(deviceIds(), other.deviceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteDevicePositionHistoryRequest").add("TrackerName", trackerName())
                .add("DeviceIds", hasDeviceIds() ? deviceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        case "DeviceIds":
            return Optional.ofNullable(clazz.cast(deviceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrackerName", TRACKER_NAME_FIELD);
        map.put("DeviceIds", DEVICE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDevicePositionHistoryRequest, T> g) {
        return obj -> g.apply((BatchDeleteDevicePositionHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteDevicePositionHistoryRequest> {
        /**
         * <p>
         * The name of the tracker resource to delete the device position history from.
         * </p>
         * 
         * @param trackerName
         *        The name of the tracker resource to delete the device position history from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        /**
         * <p>
         * Devices whose position history you want to delete.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param deviceIds
         *        Devices whose position history you want to delete.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIds(Collection<String> deviceIds);

        /**
         * <p>
         * Devices whose position history you want to delete.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param deviceIds
         *        Devices whose position history you want to delete.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIds(String... deviceIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String trackerName;

        private List<String> deviceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDevicePositionHistoryRequest model) {
            super(model);
            trackerName(model.trackerName);
            deviceIds(model.deviceIds);
        }

        public final String getTrackerName() {
            return trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final Collection<String> getDeviceIds() {
            if (deviceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceIds;
        }

        public final void setDeviceIds(Collection<String> deviceIds) {
            this.deviceIds = BatchDeleteDevicePositionHistoryRequestDeviceIdsListCopier.copy(deviceIds);
        }

        @Override
        public final Builder deviceIds(Collection<String> deviceIds) {
            this.deviceIds = BatchDeleteDevicePositionHistoryRequestDeviceIdsListCopier.copy(deviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceIds(String... deviceIds) {
            deviceIds(Arrays.asList(deviceIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteDevicePositionHistoryRequest build() {
            return new BatchDeleteDevicePositionHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
