/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LTE local identification information (local ID).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LteLocalId implements SdkPojo, Serializable, ToCopyableBuilder<LteLocalId.Builder, LteLocalId> {
    private static final SdkField<Integer> EARFCN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Earfcn").getter(getter(LteLocalId::earfcn)).setter(setter(Builder::earfcn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Earfcn").build()).build();

    private static final SdkField<Integer> PCI_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Pci")
            .getter(getter(LteLocalId::pci)).setter(setter(Builder::pci))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pci").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EARFCN_FIELD, PCI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer earfcn;

    private final Integer pci;

    private LteLocalId(BuilderImpl builder) {
        this.earfcn = builder.earfcn;
        this.pci = builder.pci;
    }

    /**
     * <p>
     * E-UTRA (Evolved Universal Terrestrial Radio Access) absolute radio frequency channel number (EARFCN).
     * </p>
     * 
     * @return E-UTRA (Evolved Universal Terrestrial Radio Access) absolute radio frequency channel number (EARFCN).
     */
    public final Integer earfcn() {
        return earfcn;
    }

    /**
     * <p>
     * Physical Cell ID (PCI).
     * </p>
     * 
     * @return Physical Cell ID (PCI).
     */
    public final Integer pci() {
        return pci;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(earfcn());
        hashCode = 31 * hashCode + Objects.hashCode(pci());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LteLocalId)) {
            return false;
        }
        LteLocalId other = (LteLocalId) obj;
        return Objects.equals(earfcn(), other.earfcn()) && Objects.equals(pci(), other.pci());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LteLocalId").add("Earfcn", earfcn()).add("Pci", pci()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Earfcn":
            return Optional.ofNullable(clazz.cast(earfcn()));
        case "Pci":
            return Optional.ofNullable(clazz.cast(pci()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Earfcn", EARFCN_FIELD);
        map.put("Pci", PCI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LteLocalId, T> g) {
        return obj -> g.apply((LteLocalId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LteLocalId> {
        /**
         * <p>
         * E-UTRA (Evolved Universal Terrestrial Radio Access) absolute radio frequency channel number (EARFCN).
         * </p>
         * 
         * @param earfcn
         *        E-UTRA (Evolved Universal Terrestrial Radio Access) absolute radio frequency channel number (EARFCN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earfcn(Integer earfcn);

        /**
         * <p>
         * Physical Cell ID (PCI).
         * </p>
         * 
         * @param pci
         *        Physical Cell ID (PCI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pci(Integer pci);
    }

    static final class BuilderImpl implements Builder {
        private Integer earfcn;

        private Integer pci;

        private BuilderImpl() {
        }

        private BuilderImpl(LteLocalId model) {
            earfcn(model.earfcn);
            pci(model.pci);
        }

        public final Integer getEarfcn() {
            return earfcn;
        }

        public final void setEarfcn(Integer earfcn) {
            this.earfcn = earfcn;
        }

        @Override
        public final Builder earfcn(Integer earfcn) {
            this.earfcn = earfcn;
            return this;
        }

        public final Integer getPci() {
            return pci;
        }

        public final void setPci(Integer pci) {
            this.pci = pci;
        }

        @Override
        public final Builder pci(Integer pci) {
            this.pci = pci;
            return this;
        }

        @Override
        public LteLocalId build() {
            return new LteLocalId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
