/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LTE network measurements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LteNetworkMeasurements implements SdkPojo, Serializable,
        ToCopyableBuilder<LteNetworkMeasurements.Builder, LteNetworkMeasurements> {
    private static final SdkField<Integer> EARFCN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Earfcn").getter(getter(LteNetworkMeasurements::earfcn)).setter(setter(Builder::earfcn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Earfcn").build()).build();

    private static final SdkField<Integer> CELL_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CellId").getter(getter(LteNetworkMeasurements::cellId)).setter(setter(Builder::cellId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellId").build()).build();

    private static final SdkField<Integer> PCI_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Pci")
            .getter(getter(LteNetworkMeasurements::pci)).setter(setter(Builder::pci))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pci").build()).build();

    private static final SdkField<Integer> RSRP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rsrp")
            .getter(getter(LteNetworkMeasurements::rsrp)).setter(setter(Builder::rsrp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrp").build()).build();

    private static final SdkField<Float> RSRQ_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Rsrq")
            .getter(getter(LteNetworkMeasurements::rsrq)).setter(setter(Builder::rsrq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrq").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EARFCN_FIELD, CELL_ID_FIELD,
            PCI_FIELD, RSRP_FIELD, RSRQ_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer earfcn;

    private final Integer cellId;

    private final Integer pci;

    private final Integer rsrp;

    private final Float rsrq;

    private LteNetworkMeasurements(BuilderImpl builder) {
        this.earfcn = builder.earfcn;
        this.cellId = builder.cellId;
        this.pci = builder.pci;
        this.rsrp = builder.rsrp;
        this.rsrq = builder.rsrq;
    }

    /**
     * <p>
     * E-UTRA (Evolved Universal Terrestrial Radio Access) absolute radio frequency channel number (EARFCN).
     * </p>
     * 
     * @return E-UTRA (Evolved Universal Terrestrial Radio Access) absolute radio frequency channel number (EARFCN).
     */
    public final Integer earfcn() {
        return earfcn;
    }

    /**
     * <p>
     * E-UTRAN Cell Identifier (ECI).
     * </p>
     * 
     * @return E-UTRAN Cell Identifier (ECI).
     */
    public final Integer cellId() {
        return cellId;
    }

    /**
     * <p>
     * Physical Cell ID (PCI).
     * </p>
     * 
     * @return Physical Cell ID (PCI).
     */
    public final Integer pci() {
        return pci;
    }

    /**
     * <p>
     * Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
     * </p>
     * 
     * @return Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
     */
    public final Integer rsrp() {
        return rsrp;
    }

    /**
     * <p>
     * Signal quality of the reference Signal received, measured in decibels (dB).
     * </p>
     * 
     * @return Signal quality of the reference Signal received, measured in decibels (dB).
     */
    public final Float rsrq() {
        return rsrq;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(earfcn());
        hashCode = 31 * hashCode + Objects.hashCode(cellId());
        hashCode = 31 * hashCode + Objects.hashCode(pci());
        hashCode = 31 * hashCode + Objects.hashCode(rsrp());
        hashCode = 31 * hashCode + Objects.hashCode(rsrq());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LteNetworkMeasurements)) {
            return false;
        }
        LteNetworkMeasurements other = (LteNetworkMeasurements) obj;
        return Objects.equals(earfcn(), other.earfcn()) && Objects.equals(cellId(), other.cellId())
                && Objects.equals(pci(), other.pci()) && Objects.equals(rsrp(), other.rsrp())
                && Objects.equals(rsrq(), other.rsrq());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LteNetworkMeasurements").add("Earfcn", earfcn()).add("CellId", cellId()).add("Pci", pci())
                .add("Rsrp", rsrp()).add("Rsrq", rsrq()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Earfcn":
            return Optional.ofNullable(clazz.cast(earfcn()));
        case "CellId":
            return Optional.ofNullable(clazz.cast(cellId()));
        case "Pci":
            return Optional.ofNullable(clazz.cast(pci()));
        case "Rsrp":
            return Optional.ofNullable(clazz.cast(rsrp()));
        case "Rsrq":
            return Optional.ofNullable(clazz.cast(rsrq()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Earfcn", EARFCN_FIELD);
        map.put("CellId", CELL_ID_FIELD);
        map.put("Pci", PCI_FIELD);
        map.put("Rsrp", RSRP_FIELD);
        map.put("Rsrq", RSRQ_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LteNetworkMeasurements, T> g) {
        return obj -> g.apply((LteNetworkMeasurements) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LteNetworkMeasurements> {
        /**
         * <p>
         * E-UTRA (Evolved Universal Terrestrial Radio Access) absolute radio frequency channel number (EARFCN).
         * </p>
         * 
         * @param earfcn
         *        E-UTRA (Evolved Universal Terrestrial Radio Access) absolute radio frequency channel number (EARFCN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earfcn(Integer earfcn);

        /**
         * <p>
         * E-UTRAN Cell Identifier (ECI).
         * </p>
         * 
         * @param cellId
         *        E-UTRAN Cell Identifier (ECI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellId(Integer cellId);

        /**
         * <p>
         * Physical Cell ID (PCI).
         * </p>
         * 
         * @param pci
         *        Physical Cell ID (PCI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pci(Integer pci);

        /**
         * <p>
         * Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
         * </p>
         * 
         * @param rsrp
         *        Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsrp(Integer rsrp);

        /**
         * <p>
         * Signal quality of the reference Signal received, measured in decibels (dB).
         * </p>
         * 
         * @param rsrq
         *        Signal quality of the reference Signal received, measured in decibels (dB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsrq(Float rsrq);
    }

    static final class BuilderImpl implements Builder {
        private Integer earfcn;

        private Integer cellId;

        private Integer pci;

        private Integer rsrp;

        private Float rsrq;

        private BuilderImpl() {
        }

        private BuilderImpl(LteNetworkMeasurements model) {
            earfcn(model.earfcn);
            cellId(model.cellId);
            pci(model.pci);
            rsrp(model.rsrp);
            rsrq(model.rsrq);
        }

        public final Integer getEarfcn() {
            return earfcn;
        }

        public final void setEarfcn(Integer earfcn) {
            this.earfcn = earfcn;
        }

        @Override
        public final Builder earfcn(Integer earfcn) {
            this.earfcn = earfcn;
            return this;
        }

        public final Integer getCellId() {
            return cellId;
        }

        public final void setCellId(Integer cellId) {
            this.cellId = cellId;
        }

        @Override
        public final Builder cellId(Integer cellId) {
            this.cellId = cellId;
            return this;
        }

        public final Integer getPci() {
            return pci;
        }

        public final void setPci(Integer pci) {
            this.pci = pci;
        }

        @Override
        public final Builder pci(Integer pci) {
            this.pci = pci;
            return this;
        }

        public final Integer getRsrp() {
            return rsrp;
        }

        public final void setRsrp(Integer rsrp) {
            this.rsrp = rsrp;
        }

        @Override
        public final Builder rsrp(Integer rsrp) {
            this.rsrp = rsrp;
            return this;
        }

        public final Float getRsrq() {
            return rsrq;
        }

        public final void setRsrq(Float rsrq) {
            this.rsrq = rsrq;
        }

        @Override
        public final Builder rsrq(Float rsrq) {
            this.rsrq = rsrq;
            return this;
        }

        @Override
        public LteNetworkMeasurements build() {
            return new LteNetworkMeasurements(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
